<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$strategie_view = new strategie_view();

// Run the page
$strategie_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$strategie_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$strategie_view->isExport()) { ?>
<script>
var fstrategieview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fstrategieview = currentForm = new ew.Form("fstrategieview", "view");
	loadjs.done("fstrategieview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$strategie_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $strategie_view->ExportOptions->render("body") ?>
<?php $strategie_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $strategie_view->showPageHeader(); ?>
<?php
$strategie_view->showMessage();
?>
<form name="fstrategieview" id="fstrategieview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="strategie">
<input type="hidden" name="modal" value="<?php echo (int)$strategie_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($strategie_view->idstrat->Visible) { // idstrat ?>
	<tr id="r_idstrat">
		<td class="<?php echo $strategie_view->TableLeftColumnClass ?>"><span id="elh_strategie_idstrat"><?php echo $strategie_view->idstrat->caption() ?></span></td>
		<td data-name="idstrat" <?php echo $strategie_view->idstrat->cellAttributes() ?>>
<span id="el_strategie_idstrat">
<span<?php echo $strategie_view->idstrat->viewAttributes() ?>><?php echo $strategie_view->idstrat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($strategie_view->titrestrat->Visible) { // titrestrat ?>
	<tr id="r_titrestrat">
		<td class="<?php echo $strategie_view->TableLeftColumnClass ?>"><span id="elh_strategie_titrestrat"><?php echo $strategie_view->titrestrat->caption() ?></span></td>
		<td data-name="titrestrat" <?php echo $strategie_view->titrestrat->cellAttributes() ?>>
<span id="el_strategie_titrestrat">
<span<?php echo $strategie_view->titrestrat->viewAttributes() ?>><?php echo $strategie_view->titrestrat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($strategie_view->montantstrat->Visible) { // montantstrat ?>
	<tr id="r_montantstrat">
		<td class="<?php echo $strategie_view->TableLeftColumnClass ?>"><span id="elh_strategie_montantstrat"><?php echo $strategie_view->montantstrat->caption() ?></span></td>
		<td data-name="montantstrat" <?php echo $strategie_view->montantstrat->cellAttributes() ?>>
<span id="el_strategie_montantstrat">
<span<?php echo $strategie_view->montantstrat->viewAttributes() ?>><?php echo $strategie_view->montantstrat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($strategie_view->notestrat->Visible) { // notestrat ?>
	<tr id="r_notestrat">
		<td class="<?php echo $strategie_view->TableLeftColumnClass ?>"><span id="elh_strategie_notestrat"><?php echo $strategie_view->notestrat->caption() ?></span></td>
		<td data-name="notestrat" <?php echo $strategie_view->notestrat->cellAttributes() ?>>
<span id="el_strategie_notestrat">
<span<?php echo $strategie_view->notestrat->viewAttributes() ?>><?php echo $strategie_view->notestrat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$strategie_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$strategie_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$strategie_view->terminate();
?>