<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$strategie_list = new strategie_list();

// Run the page
$strategie_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$strategie_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$strategie_list->isExport()) { ?>
<script>
var fstrategielist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fstrategielist = currentForm = new ew.Form("fstrategielist", "list");
	fstrategielist.formKeyCountName = '<?php echo $strategie_list->FormKeyCountName ?>';
	loadjs.done("fstrategielist");
});
var fstrategielistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fstrategielistsrch = currentSearchForm = new ew.Form("fstrategielistsrch");

	// Dynamic selection lists
	// Filters

	fstrategielistsrch.filterList = <?php echo $strategie_list->getFilterList() ?>;
	loadjs.done("fstrategielistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$strategie_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($strategie_list->TotalRecords > 0 && $strategie_list->ExportOptions->visible()) { ?>
<?php $strategie_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($strategie_list->ImportOptions->visible()) { ?>
<?php $strategie_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($strategie_list->SearchOptions->visible()) { ?>
<?php $strategie_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($strategie_list->FilterOptions->visible()) { ?>
<?php $strategie_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$strategie_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$strategie_list->isExport() && !$strategie->CurrentAction) { ?>
<form name="fstrategielistsrch" id="fstrategielistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fstrategielistsrch-search-panel" class="<?php echo $strategie_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="strategie">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $strategie_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($strategie_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($strategie_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $strategie_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($strategie_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($strategie_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($strategie_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($strategie_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $strategie_list->showPageHeader(); ?>
<?php
$strategie_list->showMessage();
?>
<?php if ($strategie_list->TotalRecords > 0 || $strategie->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($strategie_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> strategie">
<form name="fstrategielist" id="fstrategielist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="strategie">
<div id="gmp_strategie" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($strategie_list->TotalRecords > 0 || $strategie_list->isGridEdit()) { ?>
<table id="tbl_strategielist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$strategie->RowType = ROWTYPE_HEADER;

// Render list options
$strategie_list->renderListOptions();

// Render list options (header, left)
$strategie_list->ListOptions->render("header", "left");
?>
<?php if ($strategie_list->idstrat->Visible) { // idstrat ?>
	<?php if ($strategie_list->SortUrl($strategie_list->idstrat) == "") { ?>
		<th data-name="idstrat" class="<?php echo $strategie_list->idstrat->headerCellClass() ?>"><div id="elh_strategie_idstrat" class="strategie_idstrat"><div class="ew-table-header-caption"><?php echo $strategie_list->idstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idstrat" class="<?php echo $strategie_list->idstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $strategie_list->SortUrl($strategie_list->idstrat) ?>', 1);"><div id="elh_strategie_idstrat" class="strategie_idstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $strategie_list->idstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($strategie_list->idstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($strategie_list->idstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($strategie_list->titrestrat->Visible) { // titrestrat ?>
	<?php if ($strategie_list->SortUrl($strategie_list->titrestrat) == "") { ?>
		<th data-name="titrestrat" class="<?php echo $strategie_list->titrestrat->headerCellClass() ?>"><div id="elh_strategie_titrestrat" class="strategie_titrestrat"><div class="ew-table-header-caption"><?php echo $strategie_list->titrestrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titrestrat" class="<?php echo $strategie_list->titrestrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $strategie_list->SortUrl($strategie_list->titrestrat) ?>', 1);"><div id="elh_strategie_titrestrat" class="strategie_titrestrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $strategie_list->titrestrat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($strategie_list->titrestrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($strategie_list->titrestrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($strategie_list->montantstrat->Visible) { // montantstrat ?>
	<?php if ($strategie_list->SortUrl($strategie_list->montantstrat) == "") { ?>
		<th data-name="montantstrat" class="<?php echo $strategie_list->montantstrat->headerCellClass() ?>"><div id="elh_strategie_montantstrat" class="strategie_montantstrat"><div class="ew-table-header-caption"><?php echo $strategie_list->montantstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="montantstrat" class="<?php echo $strategie_list->montantstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $strategie_list->SortUrl($strategie_list->montantstrat) ?>', 1);"><div id="elh_strategie_montantstrat" class="strategie_montantstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $strategie_list->montantstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($strategie_list->montantstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($strategie_list->montantstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$strategie_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($strategie_list->ExportAll && $strategie_list->isExport()) {
	$strategie_list->StopRecord = $strategie_list->TotalRecords;
} else {

	// Set the last record to display
	if ($strategie_list->TotalRecords > $strategie_list->StartRecord + $strategie_list->DisplayRecords - 1)
		$strategie_list->StopRecord = $strategie_list->StartRecord + $strategie_list->DisplayRecords - 1;
	else
		$strategie_list->StopRecord = $strategie_list->TotalRecords;
}
$strategie_list->RecordCount = $strategie_list->StartRecord - 1;
if ($strategie_list->Recordset && !$strategie_list->Recordset->EOF) {
	$strategie_list->Recordset->moveFirst();
	$selectLimit = $strategie_list->UseSelectLimit;
	if (!$selectLimit && $strategie_list->StartRecord > 1)
		$strategie_list->Recordset->move($strategie_list->StartRecord - 1);
} elseif (!$strategie->AllowAddDeleteRow && $strategie_list->StopRecord == 0) {
	$strategie_list->StopRecord = $strategie->GridAddRowCount;
}

// Initialize aggregate
$strategie->RowType = ROWTYPE_AGGREGATEINIT;
$strategie->resetAttributes();
$strategie_list->renderRow();
while ($strategie_list->RecordCount < $strategie_list->StopRecord) {
	$strategie_list->RecordCount++;
	if ($strategie_list->RecordCount >= $strategie_list->StartRecord) {
		$strategie_list->RowCount++;

		// Set up key count
		$strategie_list->KeyCount = $strategie_list->RowIndex;

		// Init row class and style
		$strategie->resetAttributes();
		$strategie->CssClass = "";
		if ($strategie_list->isGridAdd()) {
		} else {
			$strategie_list->loadRowValues($strategie_list->Recordset); // Load row values
		}
		$strategie->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$strategie->RowAttrs->merge(["data-rowindex" => $strategie_list->RowCount, "id" => "r" . $strategie_list->RowCount . "_strategie", "data-rowtype" => $strategie->RowType]);

		// Render row
		$strategie_list->renderRow();

		// Render list options
		$strategie_list->renderListOptions();
?>
	<tr <?php echo $strategie->rowAttributes() ?>>
<?php

// Render list options (body, left)
$strategie_list->ListOptions->render("body", "left", $strategie_list->RowCount);
?>
	<?php if ($strategie_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat" <?php echo $strategie_list->idstrat->cellAttributes() ?>>
<span id="el<?php echo $strategie_list->RowCount ?>_strategie_idstrat">
<span<?php echo $strategie_list->idstrat->viewAttributes() ?>><?php echo $strategie_list->idstrat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($strategie_list->titrestrat->Visible) { // titrestrat ?>
		<td data-name="titrestrat" <?php echo $strategie_list->titrestrat->cellAttributes() ?>>
<span id="el<?php echo $strategie_list->RowCount ?>_strategie_titrestrat">
<span<?php echo $strategie_list->titrestrat->viewAttributes() ?>><?php echo $strategie_list->titrestrat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($strategie_list->montantstrat->Visible) { // montantstrat ?>
		<td data-name="montantstrat" <?php echo $strategie_list->montantstrat->cellAttributes() ?>>
<span id="el<?php echo $strategie_list->RowCount ?>_strategie_montantstrat">
<span<?php echo $strategie_list->montantstrat->viewAttributes() ?>><?php echo $strategie_list->montantstrat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$strategie_list->ListOptions->render("body", "right", $strategie_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$strategie_list->isGridAdd())
		$strategie_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$strategie->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($strategie_list->Recordset)
	$strategie_list->Recordset->Close();
?>
<?php if (!$strategie_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$strategie_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $strategie_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $strategie_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($strategie_list->TotalRecords == 0 && !$strategie->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $strategie_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$strategie_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$strategie_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$strategie_list->terminate();
?>