<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$strategie_edit = new strategie_edit();

// Run the page
$strategie_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$strategie_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fstrategieedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fstrategieedit = currentForm = new ew.Form("fstrategieedit", "edit");

	// Validate form
	fstrategieedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($strategie_edit->idstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $strategie_edit->idstrat->caption(), $strategie_edit->idstrat->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($strategie_edit->titrestrat->Required) { ?>
				elm = this.getElements("x" + infix + "_titrestrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $strategie_edit->titrestrat->caption(), $strategie_edit->titrestrat->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($strategie_edit->montantstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_montantstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $strategie_edit->montantstrat->caption(), $strategie_edit->montantstrat->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_montantstrat");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($strategie_edit->montantstrat->errorMessage()) ?>");
			<?php if ($strategie_edit->notestrat->Required) { ?>
				elm = this.getElements("x" + infix + "_notestrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $strategie_edit->notestrat->caption(), $strategie_edit->notestrat->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fstrategieedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fstrategieedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fstrategieedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $strategie_edit->showPageHeader(); ?>
<?php
$strategie_edit->showMessage();
?>
<form name="fstrategieedit" id="fstrategieedit" class="<?php echo $strategie_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="strategie">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$strategie_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($strategie_edit->idstrat->Visible) { // idstrat ?>
	<div id="r_idstrat" class="form-group row">
		<label id="elh_strategie_idstrat" class="<?php echo $strategie_edit->LeftColumnClass ?>"><?php echo $strategie_edit->idstrat->caption() ?><?php echo $strategie_edit->idstrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $strategie_edit->RightColumnClass ?>"><div <?php echo $strategie_edit->idstrat->cellAttributes() ?>>
<span id="el_strategie_idstrat">
<span<?php echo $strategie_edit->idstrat->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($strategie_edit->idstrat->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="strategie" data-field="x_idstrat" name="x_idstrat" id="x_idstrat" value="<?php echo HtmlEncode($strategie_edit->idstrat->CurrentValue) ?>">
<?php echo $strategie_edit->idstrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($strategie_edit->titrestrat->Visible) { // titrestrat ?>
	<div id="r_titrestrat" class="form-group row">
		<label id="elh_strategie_titrestrat" for="x_titrestrat" class="<?php echo $strategie_edit->LeftColumnClass ?>"><?php echo $strategie_edit->titrestrat->caption() ?><?php echo $strategie_edit->titrestrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $strategie_edit->RightColumnClass ?>"><div <?php echo $strategie_edit->titrestrat->cellAttributes() ?>>
<span id="el_strategie_titrestrat">
<input type="text" data-table="strategie" data-field="x_titrestrat" name="x_titrestrat" id="x_titrestrat" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($strategie_edit->titrestrat->getPlaceHolder()) ?>" value="<?php echo $strategie_edit->titrestrat->EditValue ?>"<?php echo $strategie_edit->titrestrat->editAttributes() ?>>
</span>
<?php echo $strategie_edit->titrestrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($strategie_edit->montantstrat->Visible) { // montantstrat ?>
	<div id="r_montantstrat" class="form-group row">
		<label id="elh_strategie_montantstrat" for="x_montantstrat" class="<?php echo $strategie_edit->LeftColumnClass ?>"><?php echo $strategie_edit->montantstrat->caption() ?><?php echo $strategie_edit->montantstrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $strategie_edit->RightColumnClass ?>"><div <?php echo $strategie_edit->montantstrat->cellAttributes() ?>>
<span id="el_strategie_montantstrat">
<input type="text" data-table="strategie" data-field="x_montantstrat" name="x_montantstrat" id="x_montantstrat" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($strategie_edit->montantstrat->getPlaceHolder()) ?>" value="<?php echo $strategie_edit->montantstrat->EditValue ?>"<?php echo $strategie_edit->montantstrat->editAttributes() ?>>
</span>
<?php echo $strategie_edit->montantstrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($strategie_edit->notestrat->Visible) { // notestrat ?>
	<div id="r_notestrat" class="form-group row">
		<label id="elh_strategie_notestrat" for="x_notestrat" class="<?php echo $strategie_edit->LeftColumnClass ?>"><?php echo $strategie_edit->notestrat->caption() ?><?php echo $strategie_edit->notestrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $strategie_edit->RightColumnClass ?>"><div <?php echo $strategie_edit->notestrat->cellAttributes() ?>>
<span id="el_strategie_notestrat">
<textarea data-table="strategie" data-field="x_notestrat" name="x_notestrat" id="x_notestrat" cols="35" rows="4" placeholder="<?php echo HtmlEncode($strategie_edit->notestrat->getPlaceHolder()) ?>"<?php echo $strategie_edit->notestrat->editAttributes() ?>><?php echo $strategie_edit->notestrat->EditValue ?></textarea>
</span>
<?php echo $strategie_edit->notestrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$strategie_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $strategie_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $strategie_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$strategie_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$strategie_edit->terminate();
?>