<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$strategie_add = new strategie_add();

// Run the page
$strategie_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$strategie_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fstrategieadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fstrategieadd = currentForm = new ew.Form("fstrategieadd", "add");

	// Validate form
	fstrategieadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($strategie_add->titrestrat->Required) { ?>
				elm = this.getElements("x" + infix + "_titrestrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $strategie_add->titrestrat->caption(), $strategie_add->titrestrat->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($strategie_add->montantstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_montantstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $strategie_add->montantstrat->caption(), $strategie_add->montantstrat->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_montantstrat");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($strategie_add->montantstrat->errorMessage()) ?>");
			<?php if ($strategie_add->notestrat->Required) { ?>
				elm = this.getElements("x" + infix + "_notestrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $strategie_add->notestrat->caption(), $strategie_add->notestrat->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fstrategieadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fstrategieadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fstrategieadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $strategie_add->showPageHeader(); ?>
<?php
$strategie_add->showMessage();
?>
<form name="fstrategieadd" id="fstrategieadd" class="<?php echo $strategie_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="strategie">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$strategie_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($strategie_add->titrestrat->Visible) { // titrestrat ?>
	<div id="r_titrestrat" class="form-group row">
		<label id="elh_strategie_titrestrat" for="x_titrestrat" class="<?php echo $strategie_add->LeftColumnClass ?>"><?php echo $strategie_add->titrestrat->caption() ?><?php echo $strategie_add->titrestrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $strategie_add->RightColumnClass ?>"><div <?php echo $strategie_add->titrestrat->cellAttributes() ?>>
<span id="el_strategie_titrestrat">
<input type="text" data-table="strategie" data-field="x_titrestrat" name="x_titrestrat" id="x_titrestrat" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($strategie_add->titrestrat->getPlaceHolder()) ?>" value="<?php echo $strategie_add->titrestrat->EditValue ?>"<?php echo $strategie_add->titrestrat->editAttributes() ?>>
</span>
<?php echo $strategie_add->titrestrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($strategie_add->montantstrat->Visible) { // montantstrat ?>
	<div id="r_montantstrat" class="form-group row">
		<label id="elh_strategie_montantstrat" for="x_montantstrat" class="<?php echo $strategie_add->LeftColumnClass ?>"><?php echo $strategie_add->montantstrat->caption() ?><?php echo $strategie_add->montantstrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $strategie_add->RightColumnClass ?>"><div <?php echo $strategie_add->montantstrat->cellAttributes() ?>>
<span id="el_strategie_montantstrat">
<input type="text" data-table="strategie" data-field="x_montantstrat" name="x_montantstrat" id="x_montantstrat" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($strategie_add->montantstrat->getPlaceHolder()) ?>" value="<?php echo $strategie_add->montantstrat->EditValue ?>"<?php echo $strategie_add->montantstrat->editAttributes() ?>>
</span>
<?php echo $strategie_add->montantstrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($strategie_add->notestrat->Visible) { // notestrat ?>
	<div id="r_notestrat" class="form-group row">
		<label id="elh_strategie_notestrat" for="x_notestrat" class="<?php echo $strategie_add->LeftColumnClass ?>"><?php echo $strategie_add->notestrat->caption() ?><?php echo $strategie_add->notestrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $strategie_add->RightColumnClass ?>"><div <?php echo $strategie_add->notestrat->cellAttributes() ?>>
<span id="el_strategie_notestrat">
<textarea data-table="strategie" data-field="x_notestrat" name="x_notestrat" id="x_notestrat" cols="35" rows="4" placeholder="<?php echo HtmlEncode($strategie_add->notestrat->getPlaceHolder()) ?>"<?php echo $strategie_add->notestrat->editAttributes() ?>><?php echo $strategie_add->notestrat->EditValue ?></textarea>
</span>
<?php echo $strategie_add->notestrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$strategie_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $strategie_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $strategie_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$strategie_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$strategie_add->terminate();
?>