<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_view = new payroll_view();

// Run the page
$payroll_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$payroll_view->isExport()) { ?>
<script>
var fpayrollview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fpayrollview = currentForm = new ew.Form("fpayrollview", "view");
	loadjs.done("fpayrollview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$payroll_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $payroll_view->ExportOptions->render("body") ?>
<?php $payroll_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $payroll_view->showPageHeader(); ?>
<?php
$payroll_view->showMessage();
?>
<form name="fpayrollview" id="fpayrollview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll">
<input type="hidden" name="modal" value="<?php echo (int)$payroll_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($payroll_view->idpayroll->Visible) { // idpayroll ?>
	<tr id="r_idpayroll">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_idpayroll"><?php echo $payroll_view->idpayroll->caption() ?></span></td>
		<td data-name="idpayroll" <?php echo $payroll_view->idpayroll->cellAttributes() ?>>
<span id="el_payroll_idpayroll">
<span<?php echo $payroll_view->idpayroll->viewAttributes() ?>><?php echo $payroll_view->idpayroll->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payroll_view->titrepayroll->Visible) { // titrepayroll ?>
	<tr id="r_titrepayroll">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_titrepayroll"><?php echo $payroll_view->titrepayroll->caption() ?></span></td>
		<td data-name="titrepayroll" <?php echo $payroll_view->titrepayroll->cellAttributes() ?>>
<span id="el_payroll_titrepayroll">
<span<?php echo $payroll_view->titrepayroll->viewAttributes() ?>><?php echo $payroll_view->titrepayroll->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payroll_view->datepayroll->Visible) { // datepayroll ?>
	<tr id="r_datepayroll">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_datepayroll"><?php echo $payroll_view->datepayroll->caption() ?></span></td>
		<td data-name="datepayroll" <?php echo $payroll_view->datepayroll->cellAttributes() ?>>
<span id="el_payroll_datepayroll">
<span<?php echo $payroll_view->datepayroll->viewAttributes() ?>><?php echo $payroll_view->datepayroll->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$payroll_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$payroll_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$payroll_view->terminate();
?>