<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_list = new payroll_list();

// Run the page
$payroll_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$payroll_list->isExport()) { ?>
<script>
var fpayrolllist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fpayrolllist = currentForm = new ew.Form("fpayrolllist", "list");
	fpayrolllist.formKeyCountName = '<?php echo $payroll_list->FormKeyCountName ?>';
	loadjs.done("fpayrolllist");
});
var fpayrolllistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fpayrolllistsrch = currentSearchForm = new ew.Form("fpayrolllistsrch");

	// Dynamic selection lists
	// Filters

	fpayrolllistsrch.filterList = <?php echo $payroll_list->getFilterList() ?>;
	loadjs.done("fpayrolllistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$payroll_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payroll_list->TotalRecords > 0 && $payroll_list->ExportOptions->visible()) { ?>
<?php $payroll_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_list->ImportOptions->visible()) { ?>
<?php $payroll_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_list->SearchOptions->visible()) { ?>
<?php $payroll_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_list->FilterOptions->visible()) { ?>
<?php $payroll_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payroll_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payroll_list->isExport() && !$payroll->CurrentAction) { ?>
<form name="fpayrolllistsrch" id="fpayrolllistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fpayrolllistsrch-search-panel" class="<?php echo $payroll_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payroll">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $payroll_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($payroll_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($payroll_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payroll_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payroll_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payroll_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payroll_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payroll_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $payroll_list->showPageHeader(); ?>
<?php
$payroll_list->showMessage();
?>
<?php if ($payroll_list->TotalRecords > 0 || $payroll->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payroll_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payroll">
<form name="fpayrolllist" id="fpayrolllist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll">
<div id="gmp_payroll" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($payroll_list->TotalRecords > 0 || $payroll_list->isGridEdit()) { ?>
<table id="tbl_payrolllist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payroll->RowType = ROWTYPE_HEADER;

// Render list options
$payroll_list->renderListOptions();

// Render list options (header, left)
$payroll_list->ListOptions->render("header", "left");
?>
<?php if ($payroll_list->idpayroll->Visible) { // idpayroll ?>
	<?php if ($payroll_list->SortUrl($payroll_list->idpayroll) == "") { ?>
		<th data-name="idpayroll" class="<?php echo $payroll_list->idpayroll->headerCellClass() ?>"><div id="elh_payroll_idpayroll" class="payroll_idpayroll"><div class="ew-table-header-caption"><?php echo $payroll_list->idpayroll->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpayroll" class="<?php echo $payroll_list->idpayroll->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $payroll_list->SortUrl($payroll_list->idpayroll) ?>', 1);"><div id="elh_payroll_idpayroll" class="payroll_idpayroll">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_list->idpayroll->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_list->idpayroll->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($payroll_list->idpayroll->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_list->titrepayroll->Visible) { // titrepayroll ?>
	<?php if ($payroll_list->SortUrl($payroll_list->titrepayroll) == "") { ?>
		<th data-name="titrepayroll" class="<?php echo $payroll_list->titrepayroll->headerCellClass() ?>"><div id="elh_payroll_titrepayroll" class="payroll_titrepayroll"><div class="ew-table-header-caption"><?php echo $payroll_list->titrepayroll->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titrepayroll" class="<?php echo $payroll_list->titrepayroll->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $payroll_list->SortUrl($payroll_list->titrepayroll) ?>', 1);"><div id="elh_payroll_titrepayroll" class="payroll_titrepayroll">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_list->titrepayroll->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payroll_list->titrepayroll->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($payroll_list->titrepayroll->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_list->datepayroll->Visible) { // datepayroll ?>
	<?php if ($payroll_list->SortUrl($payroll_list->datepayroll) == "") { ?>
		<th data-name="datepayroll" class="<?php echo $payroll_list->datepayroll->headerCellClass() ?>"><div id="elh_payroll_datepayroll" class="payroll_datepayroll"><div class="ew-table-header-caption"><?php echo $payroll_list->datepayroll->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datepayroll" class="<?php echo $payroll_list->datepayroll->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $payroll_list->SortUrl($payroll_list->datepayroll) ?>', 1);"><div id="elh_payroll_datepayroll" class="payroll_datepayroll">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_list->datepayroll->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_list->datepayroll->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($payroll_list->datepayroll->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payroll_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payroll_list->ExportAll && $payroll_list->isExport()) {
	$payroll_list->StopRecord = $payroll_list->TotalRecords;
} else {

	// Set the last record to display
	if ($payroll_list->TotalRecords > $payroll_list->StartRecord + $payroll_list->DisplayRecords - 1)
		$payroll_list->StopRecord = $payroll_list->StartRecord + $payroll_list->DisplayRecords - 1;
	else
		$payroll_list->StopRecord = $payroll_list->TotalRecords;
}
$payroll_list->RecordCount = $payroll_list->StartRecord - 1;
if ($payroll_list->Recordset && !$payroll_list->Recordset->EOF) {
	$payroll_list->Recordset->moveFirst();
	$selectLimit = $payroll_list->UseSelectLimit;
	if (!$selectLimit && $payroll_list->StartRecord > 1)
		$payroll_list->Recordset->move($payroll_list->StartRecord - 1);
} elseif (!$payroll->AllowAddDeleteRow && $payroll_list->StopRecord == 0) {
	$payroll_list->StopRecord = $payroll->GridAddRowCount;
}

// Initialize aggregate
$payroll->RowType = ROWTYPE_AGGREGATEINIT;
$payroll->resetAttributes();
$payroll_list->renderRow();
while ($payroll_list->RecordCount < $payroll_list->StopRecord) {
	$payroll_list->RecordCount++;
	if ($payroll_list->RecordCount >= $payroll_list->StartRecord) {
		$payroll_list->RowCount++;

		// Set up key count
		$payroll_list->KeyCount = $payroll_list->RowIndex;

		// Init row class and style
		$payroll->resetAttributes();
		$payroll->CssClass = "";
		if ($payroll_list->isGridAdd()) {
		} else {
			$payroll_list->loadRowValues($payroll_list->Recordset); // Load row values
		}
		$payroll->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payroll->RowAttrs->merge(["data-rowindex" => $payroll_list->RowCount, "id" => "r" . $payroll_list->RowCount . "_payroll", "data-rowtype" => $payroll->RowType]);

		// Render row
		$payroll_list->renderRow();

		// Render list options
		$payroll_list->renderListOptions();
?>
	<tr <?php echo $payroll->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payroll_list->ListOptions->render("body", "left", $payroll_list->RowCount);
?>
	<?php if ($payroll_list->idpayroll->Visible) { // idpayroll ?>
		<td data-name="idpayroll" <?php echo $payroll_list->idpayroll->cellAttributes() ?>>
<span id="el<?php echo $payroll_list->RowCount ?>_payroll_idpayroll">
<span<?php echo $payroll_list->idpayroll->viewAttributes() ?>><?php echo $payroll_list->idpayroll->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_list->titrepayroll->Visible) { // titrepayroll ?>
		<td data-name="titrepayroll" <?php echo $payroll_list->titrepayroll->cellAttributes() ?>>
<span id="el<?php echo $payroll_list->RowCount ?>_payroll_titrepayroll">
<span<?php echo $payroll_list->titrepayroll->viewAttributes() ?>><?php echo $payroll_list->titrepayroll->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_list->datepayroll->Visible) { // datepayroll ?>
		<td data-name="datepayroll" <?php echo $payroll_list->datepayroll->cellAttributes() ?>>
<span id="el<?php echo $payroll_list->RowCount ?>_payroll_datepayroll">
<span<?php echo $payroll_list->datepayroll->viewAttributes() ?>><?php echo $payroll_list->datepayroll->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payroll_list->ListOptions->render("body", "right", $payroll_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$payroll_list->isGridAdd())
		$payroll_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$payroll->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payroll_list->Recordset)
	$payroll_list->Recordset->Close();
?>
<?php if (!$payroll_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payroll_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $payroll_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payroll_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payroll_list->TotalRecords == 0 && !$payroll->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payroll_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payroll_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$payroll_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$payroll_list->terminate();
?>