<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_edit = new payroll_edit();

// Run the page
$payroll_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpayrolledit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fpayrolledit = currentForm = new ew.Form("fpayrolledit", "edit");

	// Validate form
	fpayrolledit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($payroll_edit->idpayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payroll_edit->idpayroll->caption(), $payroll_edit->idpayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($payroll_edit->titrepayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_titrepayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payroll_edit->titrepayroll->caption(), $payroll_edit->titrepayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($payroll_edit->datepayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_datepayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payroll_edit->datepayroll->caption(), $payroll_edit->datepayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datepayroll");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($payroll_edit->datepayroll->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fpayrolledit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpayrolledit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fpayrolledit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $payroll_edit->showPageHeader(); ?>
<?php
$payroll_edit->showMessage();
?>
<form name="fpayrolledit" id="fpayrolledit" class="<?php echo $payroll_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$payroll_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($payroll_edit->idpayroll->Visible) { // idpayroll ?>
	<div id="r_idpayroll" class="form-group row">
		<label id="elh_payroll_idpayroll" class="<?php echo $payroll_edit->LeftColumnClass ?>"><?php echo $payroll_edit->idpayroll->caption() ?><?php echo $payroll_edit->idpayroll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payroll_edit->RightColumnClass ?>"><div <?php echo $payroll_edit->idpayroll->cellAttributes() ?>>
<span id="el_payroll_idpayroll">
<span<?php echo $payroll_edit->idpayroll->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($payroll_edit->idpayroll->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="payroll" data-field="x_idpayroll" name="x_idpayroll" id="x_idpayroll" value="<?php echo HtmlEncode($payroll_edit->idpayroll->CurrentValue) ?>">
<?php echo $payroll_edit->idpayroll->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payroll_edit->titrepayroll->Visible) { // titrepayroll ?>
	<div id="r_titrepayroll" class="form-group row">
		<label id="elh_payroll_titrepayroll" for="x_titrepayroll" class="<?php echo $payroll_edit->LeftColumnClass ?>"><?php echo $payroll_edit->titrepayroll->caption() ?><?php echo $payroll_edit->titrepayroll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payroll_edit->RightColumnClass ?>"><div <?php echo $payroll_edit->titrepayroll->cellAttributes() ?>>
<span id="el_payroll_titrepayroll">
<input type="text" data-table="payroll" data-field="x_titrepayroll" name="x_titrepayroll" id="x_titrepayroll" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($payroll_edit->titrepayroll->getPlaceHolder()) ?>" value="<?php echo $payroll_edit->titrepayroll->EditValue ?>"<?php echo $payroll_edit->titrepayroll->editAttributes() ?>>
</span>
<?php echo $payroll_edit->titrepayroll->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payroll_edit->datepayroll->Visible) { // datepayroll ?>
	<div id="r_datepayroll" class="form-group row">
		<label id="elh_payroll_datepayroll" for="x_datepayroll" class="<?php echo $payroll_edit->LeftColumnClass ?>"><?php echo $payroll_edit->datepayroll->caption() ?><?php echo $payroll_edit->datepayroll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payroll_edit->RightColumnClass ?>"><div <?php echo $payroll_edit->datepayroll->cellAttributes() ?>>
<span id="el_payroll_datepayroll">
<input type="text" data-table="payroll" data-field="x_datepayroll" name="x_datepayroll" id="x_datepayroll" maxlength="10" placeholder="<?php echo HtmlEncode($payroll_edit->datepayroll->getPlaceHolder()) ?>" value="<?php echo $payroll_edit->datepayroll->EditValue ?>"<?php echo $payroll_edit->datepayroll->editAttributes() ?>>
<?php if (!$payroll_edit->datepayroll->ReadOnly && !$payroll_edit->datepayroll->Disabled && !isset($payroll_edit->datepayroll->EditAttrs["readonly"]) && !isset($payroll_edit->datepayroll->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayrolledit", "datetimepicker"], function() {
	ew.createDateTimePicker("fpayrolledit", "x_datepayroll", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $payroll_edit->datepayroll->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payroll_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payroll_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payroll_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payroll_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$payroll_edit->terminate();
?>