<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_delete = new payroll_delete();

// Run the page
$payroll_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_delete->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpayrolldelete, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "delete";
	fpayrolldelete = currentForm = new ew.Form("fpayrolldelete", "delete");
	loadjs.done("fpayrolldelete");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $payroll_delete->showPageHeader(); ?>
<?php
$payroll_delete->showMessage();
?>
<form name="fpayrolldelete" id="fpayrolldelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($payroll_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($payroll_delete->idpayroll->Visible) { // idpayroll ?>
		<th class="<?php echo $payroll_delete->idpayroll->headerCellClass() ?>"><span id="elh_payroll_idpayroll" class="payroll_idpayroll"><?php echo $payroll_delete->idpayroll->caption() ?></span></th>
<?php } ?>
<?php if ($payroll_delete->titrepayroll->Visible) { // titrepayroll ?>
		<th class="<?php echo $payroll_delete->titrepayroll->headerCellClass() ?>"><span id="elh_payroll_titrepayroll" class="payroll_titrepayroll"><?php echo $payroll_delete->titrepayroll->caption() ?></span></th>
<?php } ?>
<?php if ($payroll_delete->datepayroll->Visible) { // datepayroll ?>
		<th class="<?php echo $payroll_delete->datepayroll->headerCellClass() ?>"><span id="elh_payroll_datepayroll" class="payroll_datepayroll"><?php echo $payroll_delete->datepayroll->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$payroll_delete->RecordCount = 0;
$i = 0;
while (!$payroll_delete->Recordset->EOF) {
	$payroll_delete->RecordCount++;
	$payroll_delete->RowCount++;

	// Set row properties
	$payroll->resetAttributes();
	$payroll->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$payroll_delete->loadRowValues($payroll_delete->Recordset);

	// Render row
	$payroll_delete->renderRow();
?>
	<tr <?php echo $payroll->rowAttributes() ?>>
<?php if ($payroll_delete->idpayroll->Visible) { // idpayroll ?>
		<td <?php echo $payroll_delete->idpayroll->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_idpayroll" class="payroll_idpayroll">
<span<?php echo $payroll_delete->idpayroll->viewAttributes() ?>><?php echo $payroll_delete->idpayroll->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payroll_delete->titrepayroll->Visible) { // titrepayroll ?>
		<td <?php echo $payroll_delete->titrepayroll->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_titrepayroll" class="payroll_titrepayroll">
<span<?php echo $payroll_delete->titrepayroll->viewAttributes() ?>><?php echo $payroll_delete->titrepayroll->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payroll_delete->datepayroll->Visible) { // datepayroll ?>
		<td <?php echo $payroll_delete->datepayroll->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_datepayroll" class="payroll_datepayroll">
<span<?php echo $payroll_delete->datepayroll->viewAttributes() ?>><?php echo $payroll_delete->datepayroll->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$payroll_delete->Recordset->moveNext();
}
$payroll_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payroll_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$payroll_delete->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$payroll_delete->terminate();
?>