<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employe_view = new employe_view();

// Run the page
$employe_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employe_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$employe_view->isExport()) { ?>
<script>
var femployeview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	femployeview = currentForm = new ew.Form("femployeview", "view");
	loadjs.done("femployeview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$employe_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $employe_view->ExportOptions->render("body") ?>
<?php $employe_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $employe_view->showPageHeader(); ?>
<?php
$employe_view->showMessage();
?>
<form name="femployeview" id="femployeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employe">
<input type="hidden" name="modal" value="<?php echo (int)$employe_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($employe_view->idemp->Visible) { // idemp ?>
	<tr id="r_idemp">
		<td class="<?php echo $employe_view->TableLeftColumnClass ?>"><span id="elh_employe_idemp"><?php echo $employe_view->idemp->caption() ?></span></td>
		<td data-name="idemp" <?php echo $employe_view->idemp->cellAttributes() ?>>
<span id="el_employe_idemp">
<span<?php echo $employe_view->idemp->viewAttributes() ?>><?php echo $employe_view->idemp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employe_view->nom->Visible) { // nom ?>
	<tr id="r_nom">
		<td class="<?php echo $employe_view->TableLeftColumnClass ?>"><span id="elh_employe_nom"><?php echo $employe_view->nom->caption() ?></span></td>
		<td data-name="nom" <?php echo $employe_view->nom->cellAttributes() ?>>
<span id="el_employe_nom">
<span<?php echo $employe_view->nom->viewAttributes() ?>><?php echo $employe_view->nom->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employe_view->salaire->Visible) { // salaire ?>
	<tr id="r_salaire">
		<td class="<?php echo $employe_view->TableLeftColumnClass ?>"><span id="elh_employe_salaire"><?php echo $employe_view->salaire->caption() ?></span></td>
		<td data-name="salaire" <?php echo $employe_view->salaire->cellAttributes() ?>>
<span id="el_employe_salaire">
<span<?php echo $employe_view->salaire->viewAttributes() ?>><?php echo $employe_view->salaire->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php
	if (in_array("appliquer", explode(",", $employe->getCurrentDetailTable())) && $appliquer->DetailView) {
?>
<?php if ($employe->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("appliquer", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $employe_view->appliquer_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "appliquergrid.php" ?>
<?php } ?>
</form>
<?php
$employe_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$employe_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$employe_view->terminate();
?>