<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employe_list = new employe_list();

// Run the page
$employe_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employe_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$employe_list->isExport()) { ?>
<script>
var femployelist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	femployelist = currentForm = new ew.Form("femployelist", "list");
	femployelist.formKeyCountName = '<?php echo $employe_list->FormKeyCountName ?>';
	loadjs.done("femployelist");
});
var femployelistsrch;
loadjs.ready("head", function() {

	// Form object for search
	femployelistsrch = currentSearchForm = new ew.Form("femployelistsrch");

	// Dynamic selection lists
	// Filters

	femployelistsrch.filterList = <?php echo $employe_list->getFilterList() ?>;
	loadjs.done("femployelistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$employe_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($employe_list->TotalRecords > 0 && $employe_list->ExportOptions->visible()) { ?>
<?php $employe_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($employe_list->ImportOptions->visible()) { ?>
<?php $employe_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($employe_list->SearchOptions->visible()) { ?>
<?php $employe_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($employe_list->FilterOptions->visible()) { ?>
<?php $employe_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$employe_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$employe_list->isExport() && !$employe->CurrentAction) { ?>
<form name="femployelistsrch" id="femployelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="femployelistsrch-search-panel" class="<?php echo $employe_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="employe">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $employe_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($employe_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($employe_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $employe_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($employe_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($employe_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($employe_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($employe_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $employe_list->showPageHeader(); ?>
<?php
$employe_list->showMessage();
?>
<?php if ($employe_list->TotalRecords > 0 || $employe->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($employe_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> employe">
<form name="femployelist" id="femployelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employe">
<div id="gmp_employe" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($employe_list->TotalRecords > 0 || $employe_list->isGridEdit()) { ?>
<table id="tbl_employelist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$employe->RowType = ROWTYPE_HEADER;

// Render list options
$employe_list->renderListOptions();

// Render list options (header, left)
$employe_list->ListOptions->render("header", "left");
?>
<?php if ($employe_list->idemp->Visible) { // idemp ?>
	<?php if ($employe_list->SortUrl($employe_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $employe_list->idemp->headerCellClass() ?>"><div id="elh_employe_idemp" class="employe_idemp"><div class="ew-table-header-caption"><?php echo $employe_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $employe_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employe_list->SortUrl($employe_list->idemp) ?>', 1);"><div id="elh_employe_idemp" class="employe_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employe_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($employe_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employe_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employe_list->nom->Visible) { // nom ?>
	<?php if ($employe_list->SortUrl($employe_list->nom) == "") { ?>
		<th data-name="nom" class="<?php echo $employe_list->nom->headerCellClass() ?>"><div id="elh_employe_nom" class="employe_nom"><div class="ew-table-header-caption"><?php echo $employe_list->nom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nom" class="<?php echo $employe_list->nom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employe_list->SortUrl($employe_list->nom) ?>', 1);"><div id="elh_employe_nom" class="employe_nom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employe_list->nom->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employe_list->nom->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employe_list->nom->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employe_list->salaire->Visible) { // salaire ?>
	<?php if ($employe_list->SortUrl($employe_list->salaire) == "") { ?>
		<th data-name="salaire" class="<?php echo $employe_list->salaire->headerCellClass() ?>"><div id="elh_employe_salaire" class="employe_salaire"><div class="ew-table-header-caption"><?php echo $employe_list->salaire->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="salaire" class="<?php echo $employe_list->salaire->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employe_list->SortUrl($employe_list->salaire) ?>', 1);"><div id="elh_employe_salaire" class="employe_salaire">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employe_list->salaire->caption() ?></span><span class="ew-table-header-sort"><?php if ($employe_list->salaire->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employe_list->salaire->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$employe_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($employe_list->ExportAll && $employe_list->isExport()) {
	$employe_list->StopRecord = $employe_list->TotalRecords;
} else {

	// Set the last record to display
	if ($employe_list->TotalRecords > $employe_list->StartRecord + $employe_list->DisplayRecords - 1)
		$employe_list->StopRecord = $employe_list->StartRecord + $employe_list->DisplayRecords - 1;
	else
		$employe_list->StopRecord = $employe_list->TotalRecords;
}
$employe_list->RecordCount = $employe_list->StartRecord - 1;
if ($employe_list->Recordset && !$employe_list->Recordset->EOF) {
	$employe_list->Recordset->moveFirst();
	$selectLimit = $employe_list->UseSelectLimit;
	if (!$selectLimit && $employe_list->StartRecord > 1)
		$employe_list->Recordset->move($employe_list->StartRecord - 1);
} elseif (!$employe->AllowAddDeleteRow && $employe_list->StopRecord == 0) {
	$employe_list->StopRecord = $employe->GridAddRowCount;
}

// Initialize aggregate
$employe->RowType = ROWTYPE_AGGREGATEINIT;
$employe->resetAttributes();
$employe_list->renderRow();
while ($employe_list->RecordCount < $employe_list->StopRecord) {
	$employe_list->RecordCount++;
	if ($employe_list->RecordCount >= $employe_list->StartRecord) {
		$employe_list->RowCount++;

		// Set up key count
		$employe_list->KeyCount = $employe_list->RowIndex;

		// Init row class and style
		$employe->resetAttributes();
		$employe->CssClass = "";
		if ($employe_list->isGridAdd()) {
		} else {
			$employe_list->loadRowValues($employe_list->Recordset); // Load row values
		}
		$employe->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$employe->RowAttrs->merge(["data-rowindex" => $employe_list->RowCount, "id" => "r" . $employe_list->RowCount . "_employe", "data-rowtype" => $employe->RowType]);

		// Render row
		$employe_list->renderRow();

		// Render list options
		$employe_list->renderListOptions();
?>
	<tr <?php echo $employe->rowAttributes() ?>>
<?php

// Render list options (body, left)
$employe_list->ListOptions->render("body", "left", $employe_list->RowCount);
?>
	<?php if ($employe_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $employe_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $employe_list->RowCount ?>_employe_idemp">
<span<?php echo $employe_list->idemp->viewAttributes() ?>><?php echo $employe_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employe_list->nom->Visible) { // nom ?>
		<td data-name="nom" <?php echo $employe_list->nom->cellAttributes() ?>>
<span id="el<?php echo $employe_list->RowCount ?>_employe_nom">
<span<?php echo $employe_list->nom->viewAttributes() ?>><?php echo $employe_list->nom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employe_list->salaire->Visible) { // salaire ?>
		<td data-name="salaire" <?php echo $employe_list->salaire->cellAttributes() ?>>
<span id="el<?php echo $employe_list->RowCount ?>_employe_salaire">
<span<?php echo $employe_list->salaire->viewAttributes() ?>><?php echo $employe_list->salaire->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$employe_list->ListOptions->render("body", "right", $employe_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$employe_list->isGridAdd())
		$employe_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$employe->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($employe_list->Recordset)
	$employe_list->Recordset->Close();
?>
<?php if (!$employe_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$employe_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $employe_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $employe_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($employe_list->TotalRecords == 0 && !$employe->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $employe_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$employe_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$employe_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

	/*
	$(document).ready(function() {
		<?php if (isset($_SESSION["Redirect_Edit"]) && $_SESSION["Redirect_Edit"] == "Yes") { ?>
		<?php $_SESSION["Redirect_Edit"] = ""; ?>
		ew_ModalDialogShow({lnk:this, url:'employeedit.php?idemp=<?php echo $_SESSION["Field_Kode"] ?>', caption:'Edit'});
		<?php } ?>
	});
	*/
});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$employe_list->terminate();
?>