<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employe_edit = new employe_edit();

// Run the page
$employe_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employe_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var femployeedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	femployeedit = currentForm = new ew.Form("femployeedit", "edit");

	// Validate form
	femployeedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($employe_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employe_edit->idemp->caption(), $employe_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employe_edit->nom->Required) { ?>
				elm = this.getElements("x" + infix + "_nom");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employe_edit->nom->caption(), $employe_edit->nom->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employe_edit->salaire->Required) { ?>
				elm = this.getElements("x" + infix + "_salaire");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employe_edit->salaire->caption(), $employe_edit->salaire->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_salaire");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employe_edit->salaire->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	femployeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	femployeedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("femployeedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $employe_edit->showPageHeader(); ?>
<?php
$employe_edit->showMessage();
?>
<form name="femployeedit" id="femployeedit" class="<?php echo $employe_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employe">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$employe_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($employe_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_employe_idemp" class="<?php echo $employe_edit->LeftColumnClass ?>"><?php echo $employe_edit->idemp->caption() ?><?php echo $employe_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employe_edit->RightColumnClass ?>"><div <?php echo $employe_edit->idemp->cellAttributes() ?>>
<span id="el_employe_idemp">
<span<?php echo $employe_edit->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($employe_edit->idemp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="employe" data-field="x_idemp" name="x_idemp" id="x_idemp" value="<?php echo HtmlEncode($employe_edit->idemp->CurrentValue) ?>">
<?php echo $employe_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employe_edit->nom->Visible) { // nom ?>
	<div id="r_nom" class="form-group row">
		<label id="elh_employe_nom" for="x_nom" class="<?php echo $employe_edit->LeftColumnClass ?>"><?php echo $employe_edit->nom->caption() ?><?php echo $employe_edit->nom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employe_edit->RightColumnClass ?>"><div <?php echo $employe_edit->nom->cellAttributes() ?>>
<span id="el_employe_nom">
<input type="text" data-table="employe" data-field="x_nom" name="x_nom" id="x_nom" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employe_edit->nom->getPlaceHolder()) ?>" value="<?php echo $employe_edit->nom->EditValue ?>"<?php echo $employe_edit->nom->editAttributes() ?>>
</span>
<?php echo $employe_edit->nom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employe_edit->salaire->Visible) { // salaire ?>
	<div id="r_salaire" class="form-group row">
		<label id="elh_employe_salaire" for="x_salaire" class="<?php echo $employe_edit->LeftColumnClass ?>"><?php echo $employe_edit->salaire->caption() ?><?php echo $employe_edit->salaire->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employe_edit->RightColumnClass ?>"><div <?php echo $employe_edit->salaire->cellAttributes() ?>>
<span id="el_employe_salaire">
<input type="text" data-table="employe" data-field="x_salaire" name="x_salaire" id="x_salaire" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($employe_edit->salaire->getPlaceHolder()) ?>" value="<?php echo $employe_edit->salaire->EditValue ?>"<?php echo $employe_edit->salaire->editAttributes() ?>>
</span>
<?php echo $employe_edit->salaire->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("appliquer", explode(",", $employe->getCurrentDetailTable())) && $appliquer->DetailEdit) {
?>
<?php if ($employe->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("appliquer", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "appliquergrid.php" ?>
<?php } ?>
<?php if (!$employe_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $employe_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $employe_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$employe_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$employe_edit->terminate();
?>