<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employe_add = new employe_add();

// Run the page
$employe_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employe_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var femployeadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	femployeadd = currentForm = new ew.Form("femployeadd", "add");

	// Validate form
	femployeadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($employe_add->nom->Required) { ?>
				elm = this.getElements("x" + infix + "_nom");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employe_add->nom->caption(), $employe_add->nom->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employe_add->salaire->Required) { ?>
				elm = this.getElements("x" + infix + "_salaire");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employe_add->salaire->caption(), $employe_add->salaire->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_salaire");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employe_add->salaire->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	femployeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	femployeadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("femployeadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $employe_add->showPageHeader(); ?>
<?php
$employe_add->showMessage();
?>
<form name="femployeadd" id="femployeadd" class="<?php echo $employe_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employe">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$employe_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($employe_add->nom->Visible) { // nom ?>
	<div id="r_nom" class="form-group row">
		<label id="elh_employe_nom" for="x_nom" class="<?php echo $employe_add->LeftColumnClass ?>"><?php echo $employe_add->nom->caption() ?><?php echo $employe_add->nom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employe_add->RightColumnClass ?>"><div <?php echo $employe_add->nom->cellAttributes() ?>>
<span id="el_employe_nom">
<input type="text" data-table="employe" data-field="x_nom" name="x_nom" id="x_nom" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employe_add->nom->getPlaceHolder()) ?>" value="<?php echo $employe_add->nom->EditValue ?>"<?php echo $employe_add->nom->editAttributes() ?>>
</span>
<?php echo $employe_add->nom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employe_add->salaire->Visible) { // salaire ?>
	<div id="r_salaire" class="form-group row">
		<label id="elh_employe_salaire" for="x_salaire" class="<?php echo $employe_add->LeftColumnClass ?>"><?php echo $employe_add->salaire->caption() ?><?php echo $employe_add->salaire->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employe_add->RightColumnClass ?>"><div <?php echo $employe_add->salaire->cellAttributes() ?>>
<span id="el_employe_salaire">
<input type="text" data-table="employe" data-field="x_salaire" name="x_salaire" id="x_salaire" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($employe_add->salaire->getPlaceHolder()) ?>" value="<?php echo $employe_add->salaire->EditValue ?>"<?php echo $employe_add->salaire->editAttributes() ?>>
</span>
<?php echo $employe_add->salaire->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("appliquer", explode(",", $employe->getCurrentDetailTable())) && $appliquer->DetailAdd) {
?>
<?php if ($employe->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("appliquer", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "appliquergrid.php" ?>
<?php } ?>
<?php if (!$employe_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $employe_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $employe_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$employe_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$employe_add->terminate();
?>