<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_view = new detailpayroll_view();

// Run the page
$detailpayroll_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<script>
var fdetailpayrollview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fdetailpayrollview = currentForm = new ew.Form("fdetailpayrollview", "view");
	loadjs.done("fdetailpayrollview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $detailpayroll_view->ExportOptions->render("body") ?>
<?php $detailpayroll_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $detailpayroll_view->showPageHeader(); ?>
<?php
$detailpayroll_view->showMessage();
?>
<form name="fdetailpayrollview" id="fdetailpayrollview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<input type="hidden" name="modal" value="<?php echo (int)$detailpayroll_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($detailpayroll_view->idemp->Visible) { // idemp ?>
	<tr id="r_idemp">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_idemp"><?php echo $detailpayroll_view->idemp->caption() ?></span></td>
		<td data-name="idemp" <?php echo $detailpayroll_view->idemp->cellAttributes() ?>>
<span id="el_detailpayroll_idemp">
<span<?php echo $detailpayroll_view->idemp->viewAttributes() ?>><?php echo $detailpayroll_view->idemp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->idpayroll->Visible) { // idpayroll ?>
	<tr id="r_idpayroll">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_idpayroll"><?php echo $detailpayroll_view->idpayroll->caption() ?></span></td>
		<td data-name="idpayroll" <?php echo $detailpayroll_view->idpayroll->cellAttributes() ?>>
<span id="el_detailpayroll_idpayroll">
<span<?php echo $detailpayroll_view->idpayroll->viewAttributes() ?>><?php echo $detailpayroll_view->idpayroll->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->idstrat->Visible) { // idstrat ?>
	<tr id="r_idstrat">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_idstrat"><?php echo $detailpayroll_view->idstrat->caption() ?></span></td>
		<td data-name="idstrat" <?php echo $detailpayroll_view->idstrat->cellAttributes() ?>>
<span id="el_detailpayroll_idstrat">
<span<?php echo $detailpayroll_view->idstrat->viewAttributes() ?>><?php echo $detailpayroll_view->idstrat->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->psalaire->Visible) { // psalaire ?>
	<tr id="r_psalaire">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_psalaire"><?php echo $detailpayroll_view->psalaire->caption() ?></span></td>
		<td data-name="psalaire" <?php echo $detailpayroll_view->psalaire->cellAttributes() ?>>
<span id="el_detailpayroll_psalaire">
<span<?php echo $detailpayroll_view->psalaire->viewAttributes() ?>><?php echo $detailpayroll_view->psalaire->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$detailpayroll_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_view->terminate();
?>