<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_list = new detailpayroll_list();

// Run the page
$detailpayroll_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<script>
var fdetailpayrolllist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fdetailpayrolllist = currentForm = new ew.Form("fdetailpayrolllist", "list");
	fdetailpayrolllist.formKeyCountName = '<?php echo $detailpayroll_list->FormKeyCountName ?>';
	loadjs.done("fdetailpayrolllist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($detailpayroll_list->TotalRecords > 0 && $detailpayroll_list->ExportOptions->visible()) { ?>
<?php $detailpayroll_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($detailpayroll_list->ImportOptions->visible()) { ?>
<?php $detailpayroll_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$detailpayroll_list->renderOtherOptions();
?>
<?php $detailpayroll_list->showPageHeader(); ?>
<?php
$detailpayroll_list->showMessage();
?>
<?php if ($detailpayroll_list->TotalRecords > 0 || $detailpayroll->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($detailpayroll_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> detailpayroll">
<form name="fdetailpayrolllist" id="fdetailpayrolllist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<div id="gmp_detailpayroll" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($detailpayroll_list->TotalRecords > 0 || $detailpayroll_list->isGridEdit()) { ?>
<table id="tbl_detailpayrolllist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$detailpayroll->RowType = ROWTYPE_HEADER;

// Render list options
$detailpayroll_list->renderListOptions();

// Render list options (header, left)
$detailpayroll_list->ListOptions->render("header", "left");
?>
<?php if ($detailpayroll_list->idemp->Visible) { // idemp ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $detailpayroll_list->idemp->headerCellClass() ?>"><div id="elh_detailpayroll_idemp" class="detailpayroll_idemp"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $detailpayroll_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->idemp) ?>', 1);"><div id="elh_detailpayroll_idemp" class="detailpayroll_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->idpayroll->Visible) { // idpayroll ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->idpayroll) == "") { ?>
		<th data-name="idpayroll" class="<?php echo $detailpayroll_list->idpayroll->headerCellClass() ?>"><div id="elh_detailpayroll_idpayroll" class="detailpayroll_idpayroll"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->idpayroll->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpayroll" class="<?php echo $detailpayroll_list->idpayroll->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->idpayroll) ?>', 1);"><div id="elh_detailpayroll_idpayroll" class="detailpayroll_idpayroll">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->idpayroll->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->idpayroll->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->idpayroll->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->idstrat->Visible) { // idstrat ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->idstrat) == "") { ?>
		<th data-name="idstrat" class="<?php echo $detailpayroll_list->idstrat->headerCellClass() ?>"><div id="elh_detailpayroll_idstrat" class="detailpayroll_idstrat"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->idstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idstrat" class="<?php echo $detailpayroll_list->idstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->idstrat) ?>', 1);"><div id="elh_detailpayroll_idstrat" class="detailpayroll_idstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->idstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->idstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->idstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->psalaire->Visible) { // psalaire ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->psalaire) == "") { ?>
		<th data-name="psalaire" class="<?php echo $detailpayroll_list->psalaire->headerCellClass() ?>"><div id="elh_detailpayroll_psalaire" class="detailpayroll_psalaire"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->psalaire->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="psalaire" class="<?php echo $detailpayroll_list->psalaire->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->psalaire) ?>', 1);"><div id="elh_detailpayroll_psalaire" class="detailpayroll_psalaire">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->psalaire->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->psalaire->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->psalaire->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$detailpayroll_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($detailpayroll_list->ExportAll && $detailpayroll_list->isExport()) {
	$detailpayroll_list->StopRecord = $detailpayroll_list->TotalRecords;
} else {

	// Set the last record to display
	if ($detailpayroll_list->TotalRecords > $detailpayroll_list->StartRecord + $detailpayroll_list->DisplayRecords - 1)
		$detailpayroll_list->StopRecord = $detailpayroll_list->StartRecord + $detailpayroll_list->DisplayRecords - 1;
	else
		$detailpayroll_list->StopRecord = $detailpayroll_list->TotalRecords;
}
$detailpayroll_list->RecordCount = $detailpayroll_list->StartRecord - 1;
if ($detailpayroll_list->Recordset && !$detailpayroll_list->Recordset->EOF) {
	$detailpayroll_list->Recordset->moveFirst();
	$selectLimit = $detailpayroll_list->UseSelectLimit;
	if (!$selectLimit && $detailpayroll_list->StartRecord > 1)
		$detailpayroll_list->Recordset->move($detailpayroll_list->StartRecord - 1);
} elseif (!$detailpayroll->AllowAddDeleteRow && $detailpayroll_list->StopRecord == 0) {
	$detailpayroll_list->StopRecord = $detailpayroll->GridAddRowCount;
}

// Initialize aggregate
$detailpayroll->RowType = ROWTYPE_AGGREGATEINIT;
$detailpayroll->resetAttributes();
$detailpayroll_list->renderRow();
while ($detailpayroll_list->RecordCount < $detailpayroll_list->StopRecord) {
	$detailpayroll_list->RecordCount++;
	if ($detailpayroll_list->RecordCount >= $detailpayroll_list->StartRecord) {
		$detailpayroll_list->RowCount++;

		// Set up key count
		$detailpayroll_list->KeyCount = $detailpayroll_list->RowIndex;

		// Init row class and style
		$detailpayroll->resetAttributes();
		$detailpayroll->CssClass = "";
		if ($detailpayroll_list->isGridAdd()) {
		} else {
			$detailpayroll_list->loadRowValues($detailpayroll_list->Recordset); // Load row values
		}
		$detailpayroll->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$detailpayroll->RowAttrs->merge(["data-rowindex" => $detailpayroll_list->RowCount, "id" => "r" . $detailpayroll_list->RowCount . "_detailpayroll", "data-rowtype" => $detailpayroll->RowType]);

		// Render row
		$detailpayroll_list->renderRow();

		// Render list options
		$detailpayroll_list->renderListOptions();
?>
	<tr <?php echo $detailpayroll->rowAttributes() ?>>
<?php

// Render list options (body, left)
$detailpayroll_list->ListOptions->render("body", "left", $detailpayroll_list->RowCount);
?>
	<?php if ($detailpayroll_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $detailpayroll_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_idemp">
<span<?php echo $detailpayroll_list->idemp->viewAttributes() ?>><?php echo $detailpayroll_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->idpayroll->Visible) { // idpayroll ?>
		<td data-name="idpayroll" <?php echo $detailpayroll_list->idpayroll->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_idpayroll">
<span<?php echo $detailpayroll_list->idpayroll->viewAttributes() ?>><?php echo $detailpayroll_list->idpayroll->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat" <?php echo $detailpayroll_list->idstrat->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_idstrat">
<span<?php echo $detailpayroll_list->idstrat->viewAttributes() ?>><?php echo $detailpayroll_list->idstrat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->psalaire->Visible) { // psalaire ?>
		<td data-name="psalaire" <?php echo $detailpayroll_list->psalaire->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_psalaire">
<span<?php echo $detailpayroll_list->psalaire->viewAttributes() ?>><?php echo $detailpayroll_list->psalaire->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$detailpayroll_list->ListOptions->render("body", "right", $detailpayroll_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$detailpayroll_list->isGridAdd())
		$detailpayroll_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$detailpayroll->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($detailpayroll_list->Recordset)
	$detailpayroll_list->Recordset->Close();
?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$detailpayroll_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $detailpayroll_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $detailpayroll_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($detailpayroll_list->TotalRecords == 0 && !$detailpayroll->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $detailpayroll_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$detailpayroll_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_list->terminate();
?>