<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_edit = new detailpayroll_edit();

// Run the page
$detailpayroll_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdetailpayrolledit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fdetailpayrolledit = currentForm = new ew.Form("fdetailpayrolledit", "edit");

	// Validate form
	fdetailpayrolledit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($detailpayroll_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->idemp->caption(), $detailpayroll_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_edit->idemp->errorMessage()) ?>");
			<?php if ($detailpayroll_edit->idpayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->idpayroll->caption(), $detailpayroll_edit->idpayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_edit->idpayroll->errorMessage()) ?>");
			<?php if ($detailpayroll_edit->idstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->idstrat->caption(), $detailpayroll_edit->idstrat->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_edit->idstrat->errorMessage()) ?>");
			<?php if ($detailpayroll_edit->psalaire->Required) { ?>
				elm = this.getElements("x" + infix + "_psalaire");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->psalaire->caption(), $detailpayroll_edit->psalaire->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_psalaire");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_edit->psalaire->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdetailpayrolledit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdetailpayrolledit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fdetailpayrolledit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $detailpayroll_edit->showPageHeader(); ?>
<?php
$detailpayroll_edit->showMessage();
?>
<form name="fdetailpayrolledit" id="fdetailpayrolledit" class="<?php echo $detailpayroll_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$detailpayroll_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($detailpayroll_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_detailpayroll_idemp" for="x_idemp" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->idemp->caption() ?><?php echo $detailpayroll_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->idemp->cellAttributes() ?>>
<input type="text" data-table="detailpayroll" data-field="x_idemp" name="x_idemp" id="x_idemp" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($detailpayroll_edit->idemp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_edit->idemp->EditValue ?>"<?php echo $detailpayroll_edit->idemp->editAttributes() ?>>
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="o_idemp" id="o_idemp" value="<?php echo HtmlEncode($detailpayroll_edit->idemp->OldValue != null ? $detailpayroll_edit->idemp->OldValue : $detailpayroll_edit->idemp->CurrentValue) ?>">
<?php echo $detailpayroll_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_edit->idpayroll->Visible) { // idpayroll ?>
	<div id="r_idpayroll" class="form-group row">
		<label id="elh_detailpayroll_idpayroll" for="x_idpayroll" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->idpayroll->caption() ?><?php echo $detailpayroll_edit->idpayroll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->idpayroll->cellAttributes() ?>>
<input type="text" data-table="detailpayroll" data-field="x_idpayroll" name="x_idpayroll" id="x_idpayroll" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($detailpayroll_edit->idpayroll->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_edit->idpayroll->EditValue ?>"<?php echo $detailpayroll_edit->idpayroll->editAttributes() ?>>
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="o_idpayroll" id="o_idpayroll" value="<?php echo HtmlEncode($detailpayroll_edit->idpayroll->OldValue != null ? $detailpayroll_edit->idpayroll->OldValue : $detailpayroll_edit->idpayroll->CurrentValue) ?>">
<?php echo $detailpayroll_edit->idpayroll->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_edit->idstrat->Visible) { // idstrat ?>
	<div id="r_idstrat" class="form-group row">
		<label id="elh_detailpayroll_idstrat" for="x_idstrat" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->idstrat->caption() ?><?php echo $detailpayroll_edit->idstrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->idstrat->cellAttributes() ?>>
<input type="text" data-table="detailpayroll" data-field="x_idstrat" name="x_idstrat" id="x_idstrat" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($detailpayroll_edit->idstrat->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_edit->idstrat->EditValue ?>"<?php echo $detailpayroll_edit->idstrat->editAttributes() ?>>
<input type="hidden" data-table="detailpayroll" data-field="x_idstrat" name="o_idstrat" id="o_idstrat" value="<?php echo HtmlEncode($detailpayroll_edit->idstrat->OldValue != null ? $detailpayroll_edit->idstrat->OldValue : $detailpayroll_edit->idstrat->CurrentValue) ?>">
<?php echo $detailpayroll_edit->idstrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_edit->psalaire->Visible) { // psalaire ?>
	<div id="r_psalaire" class="form-group row">
		<label id="elh_detailpayroll_psalaire" for="x_psalaire" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->psalaire->caption() ?><?php echo $detailpayroll_edit->psalaire->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->psalaire->cellAttributes() ?>>
<span id="el_detailpayroll_psalaire">
<input type="text" data-table="detailpayroll" data-field="x_psalaire" name="x_psalaire" id="x_psalaire" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($detailpayroll_edit->psalaire->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_edit->psalaire->EditValue ?>"<?php echo $detailpayroll_edit->psalaire->editAttributes() ?>>
</span>
<?php echo $detailpayroll_edit->psalaire->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$detailpayroll_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $detailpayroll_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $detailpayroll_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$detailpayroll_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_edit->terminate();
?>