<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_add = new detailpayroll_add();

// Run the page
$detailpayroll_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdetailpayrolladd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fdetailpayrolladd = currentForm = new ew.Form("fdetailpayrolladd", "add");

	// Validate form
	fdetailpayrolladd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($detailpayroll_add->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_add->idemp->caption(), $detailpayroll_add->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_add->idemp->errorMessage()) ?>");
			<?php if ($detailpayroll_add->idpayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_add->idpayroll->caption(), $detailpayroll_add->idpayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_add->idpayroll->errorMessage()) ?>");
			<?php if ($detailpayroll_add->idstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_add->idstrat->caption(), $detailpayroll_add->idstrat->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_add->idstrat->errorMessage()) ?>");
			<?php if ($detailpayroll_add->psalaire->Required) { ?>
				elm = this.getElements("x" + infix + "_psalaire");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_add->psalaire->caption(), $detailpayroll_add->psalaire->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_psalaire");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_add->psalaire->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdetailpayrolladd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdetailpayrolladd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fdetailpayrolladd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $detailpayroll_add->showPageHeader(); ?>
<?php
$detailpayroll_add->showMessage();
?>
<form name="fdetailpayrolladd" id="fdetailpayrolladd" class="<?php echo $detailpayroll_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$detailpayroll_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($detailpayroll_add->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_detailpayroll_idemp" for="x_idemp" class="<?php echo $detailpayroll_add->LeftColumnClass ?>"><?php echo $detailpayroll_add->idemp->caption() ?><?php echo $detailpayroll_add->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_add->RightColumnClass ?>"><div <?php echo $detailpayroll_add->idemp->cellAttributes() ?>>
<span id="el_detailpayroll_idemp">
<input type="text" data-table="detailpayroll" data-field="x_idemp" name="x_idemp" id="x_idemp" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($detailpayroll_add->idemp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_add->idemp->EditValue ?>"<?php echo $detailpayroll_add->idemp->editAttributes() ?>>
</span>
<?php echo $detailpayroll_add->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_add->idpayroll->Visible) { // idpayroll ?>
	<div id="r_idpayroll" class="form-group row">
		<label id="elh_detailpayroll_idpayroll" for="x_idpayroll" class="<?php echo $detailpayroll_add->LeftColumnClass ?>"><?php echo $detailpayroll_add->idpayroll->caption() ?><?php echo $detailpayroll_add->idpayroll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_add->RightColumnClass ?>"><div <?php echo $detailpayroll_add->idpayroll->cellAttributes() ?>>
<span id="el_detailpayroll_idpayroll">
<input type="text" data-table="detailpayroll" data-field="x_idpayroll" name="x_idpayroll" id="x_idpayroll" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($detailpayroll_add->idpayroll->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_add->idpayroll->EditValue ?>"<?php echo $detailpayroll_add->idpayroll->editAttributes() ?>>
</span>
<?php echo $detailpayroll_add->idpayroll->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_add->idstrat->Visible) { // idstrat ?>
	<div id="r_idstrat" class="form-group row">
		<label id="elh_detailpayroll_idstrat" for="x_idstrat" class="<?php echo $detailpayroll_add->LeftColumnClass ?>"><?php echo $detailpayroll_add->idstrat->caption() ?><?php echo $detailpayroll_add->idstrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_add->RightColumnClass ?>"><div <?php echo $detailpayroll_add->idstrat->cellAttributes() ?>>
<span id="el_detailpayroll_idstrat">
<input type="text" data-table="detailpayroll" data-field="x_idstrat" name="x_idstrat" id="x_idstrat" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($detailpayroll_add->idstrat->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_add->idstrat->EditValue ?>"<?php echo $detailpayroll_add->idstrat->editAttributes() ?>>
</span>
<?php echo $detailpayroll_add->idstrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_add->psalaire->Visible) { // psalaire ?>
	<div id="r_psalaire" class="form-group row">
		<label id="elh_detailpayroll_psalaire" for="x_psalaire" class="<?php echo $detailpayroll_add->LeftColumnClass ?>"><?php echo $detailpayroll_add->psalaire->caption() ?><?php echo $detailpayroll_add->psalaire->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_add->RightColumnClass ?>"><div <?php echo $detailpayroll_add->psalaire->cellAttributes() ?>>
<span id="el_detailpayroll_psalaire">
<input type="text" data-table="detailpayroll" data-field="x_psalaire" name="x_psalaire" id="x_psalaire" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($detailpayroll_add->psalaire->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_add->psalaire->EditValue ?>"<?php echo $detailpayroll_add->psalaire->editAttributes() ?>>
</span>
<?php echo $detailpayroll_add->psalaire->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$detailpayroll_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $detailpayroll_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $detailpayroll_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$detailpayroll_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_add->terminate();
?>