<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$appliquer_list = new appliquer_list();

// Run the page
$appliquer_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$appliquer_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$appliquer_list->isExport()) { ?>
<script>
var fappliquerlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fappliquerlist = currentForm = new ew.Form("fappliquerlist", "list");
	fappliquerlist.formKeyCountName = '<?php echo $appliquer_list->FormKeyCountName ?>';

	// Validate form
	fappliquerlist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($appliquer_list->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_list->idemp->caption(), $appliquer_list->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($appliquer_list->idstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_list->idstrat->caption(), $appliquer_list->idstrat->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fappliquerlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fappliquerlist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fappliquerlist.lists["x_idemp"] = <?php echo $appliquer_list->idemp->Lookup->toClientList($appliquer_list) ?>;
	fappliquerlist.lists["x_idemp"].options = <?php echo JsonEncode($appliquer_list->idemp->lookupOptions()) ?>;
	fappliquerlist.lists["x_idstrat"] = <?php echo $appliquer_list->idstrat->Lookup->toClientList($appliquer_list) ?>;
	fappliquerlist.lists["x_idstrat"].options = <?php echo JsonEncode($appliquer_list->idstrat->lookupOptions()) ?>;
	loadjs.done("fappliquerlist");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$appliquer_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($appliquer_list->TotalRecords > 0 && $appliquer_list->ExportOptions->visible()) { ?>
<?php $appliquer_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($appliquer_list->ImportOptions->visible()) { ?>
<?php $appliquer_list->ImportOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$appliquer_list->isExport() || Config("EXPORT_MASTER_RECORD") && $appliquer_list->isExport("print")) { ?>
<?php
if ($appliquer_list->DbMasterFilter != "" && $appliquer->getCurrentMasterTable() == "employe") {
	if ($appliquer_list->MasterRecordExists) {
		include_once "employemaster.php";
	}
}
?>
<?php } ?>
<?php
$appliquer_list->renderOtherOptions();
?>
<?php $appliquer_list->showPageHeader(); ?>
<?php
$appliquer_list->showMessage();
?>
<?php if ($appliquer_list->TotalRecords > 0 || $appliquer->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($appliquer_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> appliquer">
<form name="fappliquerlist" id="fappliquerlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="appliquer">
<?php if ($appliquer->getCurrentMasterTable() == "employe" && $appliquer->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employe">
<input type="hidden" name="fk_idemp" value="<?php echo $appliquer_list->idemp->getSessionValue() ?>">
<?php } ?>
<div id="gmp_appliquer" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($appliquer_list->TotalRecords > 0 || $appliquer_list->isAdd() || $appliquer_list->isCopy() || $appliquer_list->isGridEdit()) { ?>
<table id="tbl_appliquerlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$appliquer->RowType = ROWTYPE_HEADER;

// Render list options
$appliquer_list->renderListOptions();

// Render list options (header, left)
$appliquer_list->ListOptions->render("header", "left");
?>
<?php if ($appliquer_list->idemp->Visible) { // idemp ?>
	<?php if ($appliquer_list->SortUrl($appliquer_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $appliquer_list->idemp->headerCellClass() ?>"><div id="elh_appliquer_idemp" class="appliquer_idemp"><div class="ew-table-header-caption"><?php echo $appliquer_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $appliquer_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $appliquer_list->SortUrl($appliquer_list->idemp) ?>', 1);"><div id="elh_appliquer_idemp" class="appliquer_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $appliquer_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($appliquer_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($appliquer_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($appliquer_list->idstrat->Visible) { // idstrat ?>
	<?php if ($appliquer_list->SortUrl($appliquer_list->idstrat) == "") { ?>
		<th data-name="idstrat" class="<?php echo $appliquer_list->idstrat->headerCellClass() ?>"><div id="elh_appliquer_idstrat" class="appliquer_idstrat"><div class="ew-table-header-caption"><?php echo $appliquer_list->idstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idstrat" class="<?php echo $appliquer_list->idstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $appliquer_list->SortUrl($appliquer_list->idstrat) ?>', 1);"><div id="elh_appliquer_idstrat" class="appliquer_idstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $appliquer_list->idstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($appliquer_list->idstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($appliquer_list->idstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$appliquer_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
	if ($appliquer_list->isAdd() || $appliquer_list->isCopy()) {
		$appliquer_list->RowIndex = 0;
		$appliquer_list->KeyCount = $appliquer_list->RowIndex;
		if ($appliquer_list->isAdd())
			$appliquer_list->loadRowValues();
		if ($appliquer->EventCancelled) // Insert failed
			$appliquer_list->restoreFormValues(); // Restore form values

		// Set row properties
		$appliquer->resetAttributes();
		$appliquer->RowAttrs->merge(["data-rowindex" => 0, "id" => "r0_appliquer", "data-rowtype" => ROWTYPE_ADD]);
		$appliquer->RowType = ROWTYPE_ADD;

		// Render row
		$appliquer_list->renderRow();

		// Render list options
		$appliquer_list->renderListOptions();
		$appliquer_list->StartRowCount = 0;
?>
	<tr <?php echo $appliquer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$appliquer_list->ListOptions->render("body", "left", $appliquer_list->RowCount);
?>
	<?php if ($appliquer_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<?php if ($appliquer_list->idemp->getSessionValue() != "") { ?>
<span id="el<?php echo $appliquer_list->RowCount ?>_appliquer_idemp" class="form-group appliquer_idemp">
<span<?php echo $appliquer_list->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($appliquer_list->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $appliquer_list->RowIndex ?>_idemp" name="x<?php echo $appliquer_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($appliquer_list->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $appliquer_list->RowCount ?>_appliquer_idemp" class="form-group appliquer_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer" data-field="x_idemp" data-value-separator="<?php echo $appliquer_list->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_list->RowIndex ?>_idemp" name="x<?php echo $appliquer_list->RowIndex ?>_idemp"<?php echo $appliquer_list->idemp->editAttributes() ?>>
			<?php echo $appliquer_list->idemp->selectOptionListHtml("x{$appliquer_list->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $appliquer_list->idemp->Lookup->getParamTag($appliquer_list, "p_x" . $appliquer_list->RowIndex . "_idemp") ?>
</span>
<?php } ?>
<input type="hidden" data-table="appliquer" data-field="x_idemp" name="o<?php echo $appliquer_list->RowIndex ?>_idemp" id="o<?php echo $appliquer_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($appliquer_list->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($appliquer_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat">
<span id="el<?php echo $appliquer_list->RowCount ?>_appliquer_idstrat" class="form-group appliquer_idstrat">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer" data-field="x_idstrat" data-value-separator="<?php echo $appliquer_list->idstrat->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_list->RowIndex ?>_idstrat" name="x<?php echo $appliquer_list->RowIndex ?>_idstrat"<?php echo $appliquer_list->idstrat->editAttributes() ?>>
			<?php echo $appliquer_list->idstrat->selectOptionListHtml("x{$appliquer_list->RowIndex}_idstrat") ?>
		</select>
</div>
<?php echo $appliquer_list->idstrat->Lookup->getParamTag($appliquer_list, "p_x" . $appliquer_list->RowIndex . "_idstrat") ?>
</span>
<input type="hidden" data-table="appliquer" data-field="x_idstrat" name="o<?php echo $appliquer_list->RowIndex ?>_idstrat" id="o<?php echo $appliquer_list->RowIndex ?>_idstrat" value="<?php echo HtmlEncode($appliquer_list->idstrat->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$appliquer_list->ListOptions->render("body", "right", $appliquer_list->RowCount);
?>
<script>
loadjs.ready(["fappliquerlist", "load"], function() {
	fappliquerlist.updateLists(<?php echo $appliquer_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
<?php
if ($appliquer_list->ExportAll && $appliquer_list->isExport()) {
	$appliquer_list->StopRecord = $appliquer_list->TotalRecords;
} else {

	// Set the last record to display
	if ($appliquer_list->TotalRecords > $appliquer_list->StartRecord + $appliquer_list->DisplayRecords - 1)
		$appliquer_list->StopRecord = $appliquer_list->StartRecord + $appliquer_list->DisplayRecords - 1;
	else
		$appliquer_list->StopRecord = $appliquer_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($appliquer->isConfirm() || $appliquer_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($appliquer_list->FormKeyCountName) && ($appliquer_list->isGridAdd() || $appliquer_list->isGridEdit() || $appliquer->isConfirm())) {
		$appliquer_list->KeyCount = $CurrentForm->getValue($appliquer_list->FormKeyCountName);
		$appliquer_list->StopRecord = $appliquer_list->StartRecord + $appliquer_list->KeyCount - 1;
	}
}
$appliquer_list->RecordCount = $appliquer_list->StartRecord - 1;
if ($appliquer_list->Recordset && !$appliquer_list->Recordset->EOF) {
	$appliquer_list->Recordset->moveFirst();
	$selectLimit = $appliquer_list->UseSelectLimit;
	if (!$selectLimit && $appliquer_list->StartRecord > 1)
		$appliquer_list->Recordset->move($appliquer_list->StartRecord - 1);
} elseif (!$appliquer->AllowAddDeleteRow && $appliquer_list->StopRecord == 0) {
	$appliquer_list->StopRecord = $appliquer->GridAddRowCount;
}

// Initialize aggregate
$appliquer->RowType = ROWTYPE_AGGREGATEINIT;
$appliquer->resetAttributes();
$appliquer_list->renderRow();
while ($appliquer_list->RecordCount < $appliquer_list->StopRecord) {
	$appliquer_list->RecordCount++;
	if ($appliquer_list->RecordCount >= $appliquer_list->StartRecord) {
		$appliquer_list->RowCount++;

		// Set up key count
		$appliquer_list->KeyCount = $appliquer_list->RowIndex;

		// Init row class and style
		$appliquer->resetAttributes();
		$appliquer->CssClass = "";
		if ($appliquer_list->isGridAdd()) {
			$appliquer_list->loadRowValues(); // Load default values
		} else {
			$appliquer_list->loadRowValues($appliquer_list->Recordset); // Load row values
		}
		$appliquer->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$appliquer->RowAttrs->merge(["data-rowindex" => $appliquer_list->RowCount, "id" => "r" . $appliquer_list->RowCount . "_appliquer", "data-rowtype" => $appliquer->RowType]);

		// Render row
		$appliquer_list->renderRow();

		// Render list options
		$appliquer_list->renderListOptions();
?>
	<tr <?php echo $appliquer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$appliquer_list->ListOptions->render("body", "left", $appliquer_list->RowCount);
?>
	<?php if ($appliquer_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $appliquer_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $appliquer_list->RowCount ?>_appliquer_idemp">
<span<?php echo $appliquer_list->idemp->viewAttributes() ?>><?php echo $appliquer_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($appliquer_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat" <?php echo $appliquer_list->idstrat->cellAttributes() ?>>
<span id="el<?php echo $appliquer_list->RowCount ?>_appliquer_idstrat">
<span<?php echo $appliquer_list->idstrat->viewAttributes() ?>><?php
$sql="select * from strategie where strategie.idstrat=".$appliquer->idstrat->CurrentValue;
$var=ExecuteRow($sql);
?>
<span class="text-info"><?php echo $var[1] ?></span>
 <small class="text-muted">(<?php echo $var[2] ?>)</small></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$appliquer_list->ListOptions->render("body", "right", $appliquer_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$appliquer_list->isGridAdd())
		$appliquer_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($appliquer_list->isAdd() || $appliquer_list->isCopy()) { ?>
<input type="hidden" name="<?php echo $appliquer_list->FormKeyCountName ?>" id="<?php echo $appliquer_list->FormKeyCountName ?>" value="<?php echo $appliquer_list->KeyCount ?>">
<?php } ?>
<?php if (!$appliquer->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($appliquer_list->Recordset)
	$appliquer_list->Recordset->Close();
?>
<?php if (!$appliquer_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$appliquer_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $appliquer_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $appliquer_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($appliquer_list->TotalRecords == 0 && !$appliquer->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $appliquer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$appliquer_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$appliquer_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$appliquer_list->terminate();
?>