<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$appliquer_edit = new appliquer_edit();

// Run the page
$appliquer_edit->run();

// Setup login status
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$appliquer_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fappliqueredit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fappliqueredit = currentForm = new ew.Form("fappliqueredit", "edit");

	// Validate form
	fappliqueredit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($appliquer_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_edit->idemp->caption(), $appliquer_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($appliquer_edit->idstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_edit->idstrat->caption(), $appliquer_edit->idstrat->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fappliqueredit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fappliqueredit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fappliqueredit.lists["x_idemp"] = <?php echo $appliquer_edit->idemp->Lookup->toClientList($appliquer_edit) ?>;
	fappliqueredit.lists["x_idemp"].options = <?php echo JsonEncode($appliquer_edit->idemp->lookupOptions()) ?>;
	fappliqueredit.lists["x_idstrat"] = <?php echo $appliquer_edit->idstrat->Lookup->toClientList($appliquer_edit) ?>;
	fappliqueredit.lists["x_idstrat"].options = <?php echo JsonEncode($appliquer_edit->idstrat->lookupOptions()) ?>;
	loadjs.done("fappliqueredit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $appliquer_edit->showPageHeader(); ?>
<?php
$appliquer_edit->showMessage();
?>
<form name="fappliqueredit" id="fappliqueredit" class="<?php echo $appliquer_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="appliquer">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$appliquer_edit->IsModal ?>">
<?php if ($appliquer->getCurrentMasterTable() == "employe") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employe">
<input type="hidden" name="fk_idemp" value="<?php echo $appliquer_edit->idemp->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($appliquer_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_appliquer_idemp" for="x_idemp" class="<?php echo $appliquer_edit->LeftColumnClass ?>"><?php echo $appliquer_edit->idemp->caption() ?><?php echo $appliquer_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $appliquer_edit->RightColumnClass ?>"><div <?php echo $appliquer_edit->idemp->cellAttributes() ?>>
<?php if ($appliquer_edit->idemp->getSessionValue() != "") { ?>

<span id="el_appliquer_idemp">
<span<?php echo $appliquer_edit->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($appliquer_edit->idemp->EditValue)) ?>"></span>
</span>

<input type="hidden" id="x_idemp" name="x_idemp" value="<?php echo HtmlEncode($appliquer_edit->idemp->CurrentValue) ?>">
<?php } else { ?>

<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer" data-field="x_idemp" data-value-separator="<?php echo $appliquer_edit->idemp->displayValueSeparatorAttribute() ?>" id="x_idemp" name="x_idemp"<?php echo $appliquer_edit->idemp->editAttributes() ?>>
			<?php echo $appliquer_edit->idemp->selectOptionListHtml("x_idemp") ?>
		</select>
</div>
<?php echo $appliquer_edit->idemp->Lookup->getParamTag($appliquer_edit, "p_x_idemp") ?>

<?php } ?>

<input type="hidden" data-table="appliquer" data-field="x_idemp" name="o_idemp" id="o_idemp" value="<?php echo HtmlEncode($appliquer_edit->idemp->OldValue != null ? $appliquer_edit->idemp->OldValue : $appliquer_edit->idemp->CurrentValue) ?>">
<?php echo $appliquer_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($appliquer_edit->idstrat->Visible) { // idstrat ?>
	<div id="r_idstrat" class="form-group row">
		<label id="elh_appliquer_idstrat" for="x_idstrat" class="<?php echo $appliquer_edit->LeftColumnClass ?>"><?php echo $appliquer_edit->idstrat->caption() ?><?php echo $appliquer_edit->idstrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $appliquer_edit->RightColumnClass ?>"><div <?php echo $appliquer_edit->idstrat->cellAttributes() ?>>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer" data-field="x_idstrat" data-value-separator="<?php echo $appliquer_edit->idstrat->displayValueSeparatorAttribute() ?>" id="x_idstrat" name="x_idstrat"<?php echo $appliquer_edit->idstrat->editAttributes() ?>>
			<?php echo $appliquer_edit->idstrat->selectOptionListHtml("x_idstrat") ?>
		</select>
</div>
<?php echo $appliquer_edit->idstrat->Lookup->getParamTag($appliquer_edit, "p_x_idstrat") ?>
<input type="hidden" data-table="appliquer" data-field="x_idstrat" name="o_idstrat" id="o_idstrat" value="<?php echo HtmlEncode($appliquer_edit->idstrat->OldValue != null ? $appliquer_edit->idstrat->OldValue : $appliquer_edit->idstrat->CurrentValue) ?>">
<?php echo $appliquer_edit->idstrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$appliquer_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $appliquer_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $appliquer_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$appliquer_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$appliquer_edit->terminate();
?>