<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$appliquer_add = new appliquer_add();

// Run the page
$appliquer_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$appliquer_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fappliqueradd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fappliqueradd = currentForm = new ew.Form("fappliqueradd", "add");

	// Validate form
	fappliqueradd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($appliquer_add->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_add->idemp->caption(), $appliquer_add->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($appliquer_add->idstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_add->idstrat->caption(), $appliquer_add->idstrat->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fappliqueradd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fappliqueradd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fappliqueradd.lists["x_idemp"] = <?php echo $appliquer_add->idemp->Lookup->toClientList($appliquer_add) ?>;
	fappliqueradd.lists["x_idemp"].options = <?php echo JsonEncode($appliquer_add->idemp->lookupOptions()) ?>;
	fappliqueradd.lists["x_idstrat"] = <?php echo $appliquer_add->idstrat->Lookup->toClientList($appliquer_add) ?>;
	fappliqueradd.lists["x_idstrat"].options = <?php echo JsonEncode($appliquer_add->idstrat->lookupOptions()) ?>;
	loadjs.done("fappliqueradd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $appliquer_add->showPageHeader(); ?>
<?php
$appliquer_add->showMessage();
?>
<form name="fappliqueradd" id="fappliqueradd" class="<?php echo $appliquer_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="appliquer">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$appliquer_add->IsModal ?>">
<?php if ($appliquer->getCurrentMasterTable() == "employe") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employe">
<input type="hidden" name="fk_idemp" value="<?php echo $appliquer_add->idemp->getSessionValue() ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($appliquer_add->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_appliquer_idemp" for="x_idemp" class="<?php echo $appliquer_add->LeftColumnClass ?>"><?php echo $appliquer_add->idemp->caption() ?><?php echo $appliquer_add->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $appliquer_add->RightColumnClass ?>"><div <?php echo $appliquer_add->idemp->cellAttributes() ?>>
<?php if ($appliquer_add->idemp->getSessionValue() != "") { ?>
<span id="el_appliquer_idemp">
<span<?php echo $appliquer_add->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($appliquer_add->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_idemp" name="x_idemp" value="<?php echo HtmlEncode($appliquer_add->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el_appliquer_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer" data-field="x_idemp" data-value-separator="<?php echo $appliquer_add->idemp->displayValueSeparatorAttribute() ?>" id="x_idemp" name="x_idemp"<?php echo $appliquer_add->idemp->editAttributes() ?>>
			<?php echo $appliquer_add->idemp->selectOptionListHtml("x_idemp") ?>
		</select>
</div>
<?php echo $appliquer_add->idemp->Lookup->getParamTag($appliquer_add, "p_x_idemp") ?>
</span>
<?php } ?>
<?php echo $appliquer_add->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($appliquer_add->idstrat->Visible) { // idstrat ?>
	<div id="r_idstrat" class="form-group row">
		<label id="elh_appliquer_idstrat" for="x_idstrat" class="<?php echo $appliquer_add->LeftColumnClass ?>"><?php echo $appliquer_add->idstrat->caption() ?><?php echo $appliquer_add->idstrat->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $appliquer_add->RightColumnClass ?>"><div <?php echo $appliquer_add->idstrat->cellAttributes() ?>>
<span id="el_appliquer_idstrat">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer" data-field="x_idstrat" data-value-separator="<?php echo $appliquer_add->idstrat->displayValueSeparatorAttribute() ?>" id="x_idstrat" name="x_idstrat"<?php echo $appliquer_add->idstrat->editAttributes() ?>>
			<?php echo $appliquer_add->idstrat->selectOptionListHtml("x_idstrat") ?>
		</select>
</div>
<?php echo $appliquer_add->idstrat->Lookup->getParamTag($appliquer_add, "p_x_idstrat") ?>
</span>
<?php echo $appliquer_add->idstrat->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$appliquer_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $appliquer_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $appliquer_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$appliquer_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$appliquer_add->terminate();
?>