<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$appliquer_strategie_list = new appliquer_strategie_list();

// Run the page
$appliquer_strategie_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$appliquer_strategie_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$appliquer_strategie_list->isExport()) { ?>
<script>
var fappliquer_strategielist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fappliquer_strategielist = currentForm = new ew.Form("fappliquer_strategielist", "list");
	fappliquer_strategielist.formKeyCountName = '<?php echo $appliquer_strategie_list->FormKeyCountName ?>';

	// Validate form
	fappliquer_strategielist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "F")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($appliquer_strategie_list->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_strategie_list->idemp->caption(), $appliquer_strategie_list->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($appliquer_strategie_list->idstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_idstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_strategie_list->idstrat->caption(), $appliquer_strategie_list->idstrat->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($appliquer_strategie_list->titrestrat->Required) { ?>
				elm = this.getElements("x" + infix + "_titrestrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_strategie_list->titrestrat->caption(), $appliquer_strategie_list->titrestrat->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($appliquer_strategie_list->montantstrat->Required) { ?>
				elm = this.getElements("x" + infix + "_montantstrat");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $appliquer_strategie_list->montantstrat->caption(), $appliquer_strategie_list->montantstrat->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_montantstrat");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($appliquer_strategie_list->montantstrat->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	fappliquer_strategielist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "idstrat", false)) return false;
		if (ew.valueChanged(fobj, infix, "titrestrat", false)) return false;
		if (ew.valueChanged(fobj, infix, "montantstrat", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fappliquer_strategielist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fappliquer_strategielist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fappliquer_strategielist.lists["x_idemp"] = <?php echo $appliquer_strategie_list->idemp->Lookup->toClientList($appliquer_strategie_list) ?>;
	fappliquer_strategielist.lists["x_idemp"].options = <?php echo JsonEncode($appliquer_strategie_list->idemp->lookupOptions()) ?>;
	fappliquer_strategielist.lists["x_idstrat"] = <?php echo $appliquer_strategie_list->idstrat->Lookup->toClientList($appliquer_strategie_list) ?>;
	fappliquer_strategielist.lists["x_idstrat"].options = <?php echo JsonEncode($appliquer_strategie_list->idstrat->lookupOptions()) ?>;
	loadjs.done("fappliquer_strategielist");
});
var fappliquer_strategielistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fappliquer_strategielistsrch = currentSearchForm = new ew.Form("fappliquer_strategielistsrch");

	// Dynamic selection lists
	// Filters

	fappliquer_strategielistsrch.filterList = <?php echo $appliquer_strategie_list->getFilterList() ?>;
	loadjs.done("fappliquer_strategielistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$appliquer_strategie_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($appliquer_strategie_list->TotalRecords > 0 && $appliquer_strategie_list->ExportOptions->visible()) { ?>
<?php $appliquer_strategie_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($appliquer_strategie_list->ImportOptions->visible()) { ?>
<?php $appliquer_strategie_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($appliquer_strategie_list->SearchOptions->visible()) { ?>
<?php $appliquer_strategie_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($appliquer_strategie_list->FilterOptions->visible()) { ?>
<?php $appliquer_strategie_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$appliquer_strategie_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$appliquer_strategie_list->isExport() && !$appliquer_strategie->CurrentAction) { ?>
<form name="fappliquer_strategielistsrch" id="fappliquer_strategielistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fappliquer_strategielistsrch-search-panel" class="<?php echo $appliquer_strategie_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="appliquer_strategie">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $appliquer_strategie_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($appliquer_strategie_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($appliquer_strategie_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $appliquer_strategie_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($appliquer_strategie_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($appliquer_strategie_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($appliquer_strategie_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($appliquer_strategie_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $appliquer_strategie_list->showPageHeader(); ?>
<?php
$appliquer_strategie_list->showMessage();
?>
<?php if ($appliquer_strategie_list->TotalRecords > 0 || $appliquer_strategie->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($appliquer_strategie_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> appliquer_strategie">
<form name="fappliquer_strategielist" id="fappliquer_strategielist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="appliquer_strategie">
<div id="gmp_appliquer_strategie" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($appliquer_strategie_list->TotalRecords > 0 || $appliquer_strategie_list->isAdd() || $appliquer_strategie_list->isCopy() || $appliquer_strategie_list->isGridEdit()) { ?>
<table id="tbl_appliquer_strategielist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$appliquer_strategie->RowType = ROWTYPE_HEADER;

// Render list options
$appliquer_strategie_list->renderListOptions();

// Render list options (header, left)
$appliquer_strategie_list->ListOptions->render("header", "left");
?>
<?php if ($appliquer_strategie_list->idemp->Visible) { // idemp ?>
	<?php if ($appliquer_strategie_list->SortUrl($appliquer_strategie_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $appliquer_strategie_list->idemp->headerCellClass() ?>"><div id="elh_appliquer_strategie_idemp" class="appliquer_strategie_idemp"><div class="ew-table-header-caption"><?php echo $appliquer_strategie_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $appliquer_strategie_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $appliquer_strategie_list->SortUrl($appliquer_strategie_list->idemp) ?>', 1);"><div id="elh_appliquer_strategie_idemp" class="appliquer_strategie_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $appliquer_strategie_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($appliquer_strategie_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($appliquer_strategie_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($appliquer_strategie_list->idstrat->Visible) { // idstrat ?>
	<?php if ($appliquer_strategie_list->SortUrl($appliquer_strategie_list->idstrat) == "") { ?>
		<th data-name="idstrat" class="<?php echo $appliquer_strategie_list->idstrat->headerCellClass() ?>"><div id="elh_appliquer_strategie_idstrat" class="appliquer_strategie_idstrat"><div class="ew-table-header-caption"><?php echo $appliquer_strategie_list->idstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idstrat" class="<?php echo $appliquer_strategie_list->idstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $appliquer_strategie_list->SortUrl($appliquer_strategie_list->idstrat) ?>', 1);"><div id="elh_appliquer_strategie_idstrat" class="appliquer_strategie_idstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $appliquer_strategie_list->idstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($appliquer_strategie_list->idstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($appliquer_strategie_list->idstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($appliquer_strategie_list->titrestrat->Visible) { // titrestrat ?>
	<?php if ($appliquer_strategie_list->SortUrl($appliquer_strategie_list->titrestrat) == "") { ?>
		<th data-name="titrestrat" class="<?php echo $appliquer_strategie_list->titrestrat->headerCellClass() ?>"><div id="elh_appliquer_strategie_titrestrat" class="appliquer_strategie_titrestrat"><div class="ew-table-header-caption"><?php echo $appliquer_strategie_list->titrestrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titrestrat" class="<?php echo $appliquer_strategie_list->titrestrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $appliquer_strategie_list->SortUrl($appliquer_strategie_list->titrestrat) ?>', 1);"><div id="elh_appliquer_strategie_titrestrat" class="appliquer_strategie_titrestrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $appliquer_strategie_list->titrestrat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($appliquer_strategie_list->titrestrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($appliquer_strategie_list->titrestrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($appliquer_strategie_list->montantstrat->Visible) { // montantstrat ?>
	<?php if ($appliquer_strategie_list->SortUrl($appliquer_strategie_list->montantstrat) == "") { ?>
		<th data-name="montantstrat" class="<?php echo $appliquer_strategie_list->montantstrat->headerCellClass() ?>"><div id="elh_appliquer_strategie_montantstrat" class="appliquer_strategie_montantstrat"><div class="ew-table-header-caption"><?php echo $appliquer_strategie_list->montantstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="montantstrat" class="<?php echo $appliquer_strategie_list->montantstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $appliquer_strategie_list->SortUrl($appliquer_strategie_list->montantstrat) ?>', 1);"><div id="elh_appliquer_strategie_montantstrat" class="appliquer_strategie_montantstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $appliquer_strategie_list->montantstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($appliquer_strategie_list->montantstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($appliquer_strategie_list->montantstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$appliquer_strategie_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
	if ($appliquer_strategie_list->isAdd() || $appliquer_strategie_list->isCopy()) {
		$appliquer_strategie_list->RowIndex = 0;
		$appliquer_strategie_list->KeyCount = $appliquer_strategie_list->RowIndex;
		if ($appliquer_strategie_list->isAdd())
			$appliquer_strategie_list->loadRowValues();
		if ($appliquer_strategie->EventCancelled) // Insert failed
			$appliquer_strategie_list->restoreFormValues(); // Restore form values

		// Set row properties
		$appliquer_strategie->resetAttributes();
		$appliquer_strategie->RowAttrs->merge(["data-rowindex" => 0, "id" => "r0_appliquer_strategie", "data-rowtype" => ROWTYPE_ADD]);
		$appliquer_strategie->RowType = ROWTYPE_ADD;

		// Render row
		$appliquer_strategie_list->renderRow();

		// Render list options
		$appliquer_strategie_list->renderListOptions();
		$appliquer_strategie_list->StartRowCount = 0;
?>
	<tr <?php echo $appliquer_strategie->rowAttributes() ?>>
<?php

// Render list options (body, left)
$appliquer_strategie_list->ListOptions->render("body", "left", $appliquer_strategie_list->RowCount);
?>
	<?php if ($appliquer_strategie_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_idemp" class="form-group appliquer_strategie_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idemp" data-value-separator="<?php echo $appliquer_strategie_list->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp"<?php echo $appliquer_strategie_list->idemp->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idemp->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idemp->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idemp") ?>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idemp" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($appliquer_strategie_list->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat">
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_idstrat" class="form-group appliquer_strategie_idstrat">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idstrat" data-value-separator="<?php echo $appliquer_strategie_list->idstrat->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat"<?php echo $appliquer_strategie_list->idstrat->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idstrat->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idstrat") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idstrat->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idstrat") ?>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idstrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" value="<?php echo HtmlEncode($appliquer_strategie_list->idstrat->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->titrestrat->Visible) { // titrestrat ?>
		<td data-name="titrestrat">
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_titrestrat" class="form-group appliquer_strategie_titrestrat">
<input type="text" data-table="appliquer_strategie" data-field="x_titrestrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->titrestrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->titrestrat->EditValue ?>"<?php echo $appliquer_strategie_list->titrestrat->editAttributes() ?>>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_titrestrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" value="<?php echo HtmlEncode($appliquer_strategie_list->titrestrat->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->montantstrat->Visible) { // montantstrat ?>
		<td data-name="montantstrat">
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_montantstrat" class="form-group appliquer_strategie_montantstrat">
<input type="text" data-table="appliquer_strategie" data-field="x_montantstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->montantstrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->montantstrat->EditValue ?>"<?php echo $appliquer_strategie_list->montantstrat->editAttributes() ?>>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_montantstrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" value="<?php echo HtmlEncode($appliquer_strategie_list->montantstrat->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$appliquer_strategie_list->ListOptions->render("body", "right", $appliquer_strategie_list->RowCount);
?>
<script>
loadjs.ready(["fappliquer_strategielist", "load"], function() {
	fappliquer_strategielist.updateLists(<?php echo $appliquer_strategie_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
<?php
if ($appliquer_strategie_list->ExportAll && $appliquer_strategie_list->isExport()) {
	$appliquer_strategie_list->StopRecord = $appliquer_strategie_list->TotalRecords;
} else {

	// Set the last record to display
	if ($appliquer_strategie_list->TotalRecords > $appliquer_strategie_list->StartRecord + $appliquer_strategie_list->DisplayRecords - 1)
		$appliquer_strategie_list->StopRecord = $appliquer_strategie_list->StartRecord + $appliquer_strategie_list->DisplayRecords - 1;
	else
		$appliquer_strategie_list->StopRecord = $appliquer_strategie_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($appliquer_strategie->isConfirm() || $appliquer_strategie_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($appliquer_strategie_list->FormKeyCountName) && ($appliquer_strategie_list->isGridAdd() || $appliquer_strategie_list->isGridEdit() || $appliquer_strategie->isConfirm())) {
		$appliquer_strategie_list->KeyCount = $CurrentForm->getValue($appliquer_strategie_list->FormKeyCountName);
		$appliquer_strategie_list->StopRecord = $appliquer_strategie_list->StartRecord + $appliquer_strategie_list->KeyCount - 1;
	}
}
$appliquer_strategie_list->RecordCount = $appliquer_strategie_list->StartRecord - 1;
if ($appliquer_strategie_list->Recordset && !$appliquer_strategie_list->Recordset->EOF) {
	$appliquer_strategie_list->Recordset->moveFirst();
	$selectLimit = $appliquer_strategie_list->UseSelectLimit;
	if (!$selectLimit && $appliquer_strategie_list->StartRecord > 1)
		$appliquer_strategie_list->Recordset->move($appliquer_strategie_list->StartRecord - 1);
} elseif (!$appliquer_strategie->AllowAddDeleteRow && $appliquer_strategie_list->StopRecord == 0) {
	$appliquer_strategie_list->StopRecord = $appliquer_strategie->GridAddRowCount;
}

// Initialize aggregate
$appliquer_strategie->RowType = ROWTYPE_AGGREGATEINIT;
$appliquer_strategie->resetAttributes();
$appliquer_strategie_list->renderRow();
if ($appliquer_strategie_list->isGridAdd())
	$appliquer_strategie_list->RowIndex = 0;
if ($appliquer_strategie_list->isGridEdit())
	$appliquer_strategie_list->RowIndex = 0;
while ($appliquer_strategie_list->RecordCount < $appliquer_strategie_list->StopRecord) {
	$appliquer_strategie_list->RecordCount++;
	if ($appliquer_strategie_list->RecordCount >= $appliquer_strategie_list->StartRecord) {
		$appliquer_strategie_list->RowCount++;
		if ($appliquer_strategie_list->isGridAdd() || $appliquer_strategie_list->isGridEdit() || $appliquer_strategie->isConfirm()) {
			$appliquer_strategie_list->RowIndex++;
			$CurrentForm->Index = $appliquer_strategie_list->RowIndex;
			if ($CurrentForm->hasValue($appliquer_strategie_list->FormActionName) && ($appliquer_strategie->isConfirm() || $appliquer_strategie_list->EventCancelled))
				$appliquer_strategie_list->RowAction = strval($CurrentForm->getValue($appliquer_strategie_list->FormActionName));
			elseif ($appliquer_strategie_list->isGridAdd())
				$appliquer_strategie_list->RowAction = "insert";
			else
				$appliquer_strategie_list->RowAction = "";
		}

		// Set up key count
		$appliquer_strategie_list->KeyCount = $appliquer_strategie_list->RowIndex;

		// Init row class and style
		$appliquer_strategie->resetAttributes();
		$appliquer_strategie->CssClass = "";
		if ($appliquer_strategie_list->isGridAdd()) {
			$appliquer_strategie_list->loadRowValues(); // Load default values
		} else {
			$appliquer_strategie_list->loadRowValues($appliquer_strategie_list->Recordset); // Load row values
		}
		$appliquer_strategie->RowType = ROWTYPE_VIEW; // Render view
		if ($appliquer_strategie_list->isGridAdd()) // Grid add
			$appliquer_strategie->RowType = ROWTYPE_ADD; // Render add
		if ($appliquer_strategie_list->isGridAdd() && $appliquer_strategie->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$appliquer_strategie_list->restoreCurrentRowFormValues($appliquer_strategie_list->RowIndex); // Restore form values
		if ($appliquer_strategie_list->isGridEdit()) { // Grid edit
			if ($appliquer_strategie->EventCancelled)
				$appliquer_strategie_list->restoreCurrentRowFormValues($appliquer_strategie_list->RowIndex); // Restore form values
			if ($appliquer_strategie_list->RowAction == "insert")
				$appliquer_strategie->RowType = ROWTYPE_ADD; // Render add
			else
				$appliquer_strategie->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($appliquer_strategie_list->isGridEdit() && ($appliquer_strategie->RowType == ROWTYPE_EDIT || $appliquer_strategie->RowType == ROWTYPE_ADD) && $appliquer_strategie->EventCancelled) // Update failed
			$appliquer_strategie_list->restoreCurrentRowFormValues($appliquer_strategie_list->RowIndex); // Restore form values
		if ($appliquer_strategie->RowType == ROWTYPE_EDIT) // Edit row
			$appliquer_strategie_list->EditRowCount++;

		// Set up row id / data-rowindex
		$appliquer_strategie->RowAttrs->merge(["data-rowindex" => $appliquer_strategie_list->RowCount, "id" => "r" . $appliquer_strategie_list->RowCount . "_appliquer_strategie", "data-rowtype" => $appliquer_strategie->RowType]);

		// Render row
		$appliquer_strategie_list->renderRow();

		// Render list options
		$appliquer_strategie_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($appliquer_strategie_list->RowAction != "delete" && $appliquer_strategie_list->RowAction != "insertdelete" && !($appliquer_strategie_list->RowAction == "insert" && $appliquer_strategie->isConfirm() && $appliquer_strategie_list->emptyRow())) {
?>
	<tr <?php echo $appliquer_strategie->rowAttributes() ?>>
<?php

// Render list options (body, left)
$appliquer_strategie_list->ListOptions->render("body", "left", $appliquer_strategie_list->RowCount);
?>
	<?php if ($appliquer_strategie_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $appliquer_strategie_list->idemp->cellAttributes() ?>>
<?php if ($appliquer_strategie->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_idemp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idemp" data-value-separator="<?php echo $appliquer_strategie_list->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp"<?php echo $appliquer_strategie_list->idemp->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idemp->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idemp->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idemp") ?>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idemp" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($appliquer_strategie_list->idemp->OldValue) ?>">
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idemp" data-value-separator="<?php echo $appliquer_strategie_list->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp"<?php echo $appliquer_strategie_list->idemp->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idemp->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idemp->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idemp") ?>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idemp" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($appliquer_strategie_list->idemp->OldValue != null ? $appliquer_strategie_list->idemp->OldValue : $appliquer_strategie_list->idemp->CurrentValue) ?>">
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_idemp">
<span<?php echo $appliquer_strategie_list->idemp->viewAttributes() ?>><?php echo $appliquer_strategie_list->idemp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat" <?php echo $appliquer_strategie_list->idstrat->cellAttributes() ?>>
<?php if ($appliquer_strategie->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_idstrat" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idstrat" data-value-separator="<?php echo $appliquer_strategie_list->idstrat->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat"<?php echo $appliquer_strategie_list->idstrat->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idstrat->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idstrat") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idstrat->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idstrat") ?>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idstrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" value="<?php echo HtmlEncode($appliquer_strategie_list->idstrat->OldValue) ?>">
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_EDIT) { // Edit record ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idstrat" data-value-separator="<?php echo $appliquer_strategie_list->idstrat->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat"<?php echo $appliquer_strategie_list->idstrat->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idstrat->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idstrat") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idstrat->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idstrat") ?>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idstrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" value="<?php echo HtmlEncode($appliquer_strategie_list->idstrat->OldValue != null ? $appliquer_strategie_list->idstrat->OldValue : $appliquer_strategie_list->idstrat->CurrentValue) ?>">
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_idstrat">
<span<?php echo $appliquer_strategie_list->idstrat->viewAttributes() ?>><span class="text-info"><?php echo $appliquer_strategie->titrestrat->ViewValue ?></span>
 <small class="text-muted">(<?php echo $appliquer_strategie->montantstrat->ViewValue ?>)</small></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->titrestrat->Visible) { // titrestrat ?>
		<td data-name="titrestrat" <?php echo $appliquer_strategie_list->titrestrat->cellAttributes() ?>>
<?php if ($appliquer_strategie->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_titrestrat" class="form-group">
<input type="text" data-table="appliquer_strategie" data-field="x_titrestrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->titrestrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->titrestrat->EditValue ?>"<?php echo $appliquer_strategie_list->titrestrat->editAttributes() ?>>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_titrestrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" value="<?php echo HtmlEncode($appliquer_strategie_list->titrestrat->OldValue) ?>">
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_titrestrat" class="form-group">
<input type="text" data-table="appliquer_strategie" data-field="x_titrestrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->titrestrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->titrestrat->EditValue ?>"<?php echo $appliquer_strategie_list->titrestrat->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_titrestrat">
<span<?php echo $appliquer_strategie_list->titrestrat->viewAttributes() ?>><?php echo $appliquer_strategie_list->titrestrat->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->montantstrat->Visible) { // montantstrat ?>
		<td data-name="montantstrat" <?php echo $appliquer_strategie_list->montantstrat->cellAttributes() ?>>
<?php if ($appliquer_strategie->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_montantstrat" class="form-group">
<input type="text" data-table="appliquer_strategie" data-field="x_montantstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->montantstrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->montantstrat->EditValue ?>"<?php echo $appliquer_strategie_list->montantstrat->editAttributes() ?>>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_montantstrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" value="<?php echo HtmlEncode($appliquer_strategie_list->montantstrat->OldValue) ?>">
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_montantstrat" class="form-group">
<input type="text" data-table="appliquer_strategie" data-field="x_montantstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->montantstrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->montantstrat->EditValue ?>"<?php echo $appliquer_strategie_list->montantstrat->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($appliquer_strategie->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $appliquer_strategie_list->RowCount ?>_appliquer_strategie_montantstrat">
<span<?php echo $appliquer_strategie_list->montantstrat->viewAttributes() ?>><?php echo $appliquer_strategie_list->montantstrat->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$appliquer_strategie_list->ListOptions->render("body", "right", $appliquer_strategie_list->RowCount);
?>
	</tr>
<?php if ($appliquer_strategie->RowType == ROWTYPE_ADD || $appliquer_strategie->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fappliquer_strategielist", "load"], function() {
	fappliquer_strategielist.updateLists(<?php echo $appliquer_strategie_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$appliquer_strategie_list->isGridAdd())
		if (!$appliquer_strategie_list->Recordset->EOF)
			$appliquer_strategie_list->Recordset->moveNext();
}
?>
<?php
	if ($appliquer_strategie_list->isGridAdd() || $appliquer_strategie_list->isGridEdit()) {
		$appliquer_strategie_list->RowIndex = '$rowindex$';
		$appliquer_strategie_list->loadRowValues();

		// Set row properties
		$appliquer_strategie->resetAttributes();
		$appliquer_strategie->RowAttrs->merge(["data-rowindex" => $appliquer_strategie_list->RowIndex, "id" => "r0_appliquer_strategie", "data-rowtype" => ROWTYPE_ADD]);
		$appliquer_strategie->RowAttrs->appendClass("ew-template");
		$appliquer_strategie->RowType = ROWTYPE_ADD;

		// Render row
		$appliquer_strategie_list->renderRow();

		// Render list options
		$appliquer_strategie_list->renderListOptions();
		$appliquer_strategie_list->StartRowCount = 0;
?>
	<tr <?php echo $appliquer_strategie->rowAttributes() ?>>
<?php

// Render list options (body, left)
$appliquer_strategie_list->ListOptions->render("body", "left", $appliquer_strategie_list->RowIndex);
?>
	<?php if ($appliquer_strategie_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<span id="el$rowindex$_appliquer_strategie_idemp" class="form-group appliquer_strategie_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idemp" data-value-separator="<?php echo $appliquer_strategie_list->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idemp"<?php echo $appliquer_strategie_list->idemp->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idemp->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idemp->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idemp") ?>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idemp" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($appliquer_strategie_list->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat">
<span id="el$rowindex$_appliquer_strategie_idstrat" class="form-group appliquer_strategie_idstrat">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="appliquer_strategie" data-field="x_idstrat" data-value-separator="<?php echo $appliquer_strategie_list->idstrat->displayValueSeparatorAttribute() ?>" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat"<?php echo $appliquer_strategie_list->idstrat->editAttributes() ?>>
			<?php echo $appliquer_strategie_list->idstrat->selectOptionListHtml("x{$appliquer_strategie_list->RowIndex}_idstrat") ?>
		</select>
</div>
<?php echo $appliquer_strategie_list->idstrat->Lookup->getParamTag($appliquer_strategie_list, "p_x" . $appliquer_strategie_list->RowIndex . "_idstrat") ?>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_idstrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_idstrat" value="<?php echo HtmlEncode($appliquer_strategie_list->idstrat->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->titrestrat->Visible) { // titrestrat ?>
		<td data-name="titrestrat">
<span id="el$rowindex$_appliquer_strategie_titrestrat" class="form-group appliquer_strategie_titrestrat">
<input type="text" data-table="appliquer_strategie" data-field="x_titrestrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->titrestrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->titrestrat->EditValue ?>"<?php echo $appliquer_strategie_list->titrestrat->editAttributes() ?>>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_titrestrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_titrestrat" value="<?php echo HtmlEncode($appliquer_strategie_list->titrestrat->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($appliquer_strategie_list->montantstrat->Visible) { // montantstrat ?>
		<td data-name="montantstrat">
<span id="el$rowindex$_appliquer_strategie_montantstrat" class="form-group appliquer_strategie_montantstrat">
<input type="text" data-table="appliquer_strategie" data-field="x_montantstrat" name="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" id="x<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($appliquer_strategie_list->montantstrat->getPlaceHolder()) ?>" value="<?php echo $appliquer_strategie_list->montantstrat->EditValue ?>"<?php echo $appliquer_strategie_list->montantstrat->editAttributes() ?>>
</span>
<input type="hidden" data-table="appliquer_strategie" data-field="x_montantstrat" name="o<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" id="o<?php echo $appliquer_strategie_list->RowIndex ?>_montantstrat" value="<?php echo HtmlEncode($appliquer_strategie_list->montantstrat->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$appliquer_strategie_list->ListOptions->render("body", "right", $appliquer_strategie_list->RowIndex);
?>
<script>
loadjs.ready(["fappliquer_strategielist", "load"], function() {
	fappliquer_strategielist.updateLists(<?php echo $appliquer_strategie_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($appliquer_strategie_list->isAdd() || $appliquer_strategie_list->isCopy()) { ?>
<input type="hidden" name="<?php echo $appliquer_strategie_list->FormKeyCountName ?>" id="<?php echo $appliquer_strategie_list->FormKeyCountName ?>" value="<?php echo $appliquer_strategie_list->KeyCount ?>">
<?php } ?>
<?php if ($appliquer_strategie_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $appliquer_strategie_list->FormKeyCountName ?>" id="<?php echo $appliquer_strategie_list->FormKeyCountName ?>" value="<?php echo $appliquer_strategie_list->KeyCount ?>">
<?php echo $appliquer_strategie_list->MultiSelectKey ?>
<?php } ?>
<?php if ($appliquer_strategie_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $appliquer_strategie_list->FormKeyCountName ?>" id="<?php echo $appliquer_strategie_list->FormKeyCountName ?>" value="<?php echo $appliquer_strategie_list->KeyCount ?>">
<?php echo $appliquer_strategie_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$appliquer_strategie->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($appliquer_strategie_list->Recordset)
	$appliquer_strategie_list->Recordset->Close();
?>
<?php if (!$appliquer_strategie_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$appliquer_strategie_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $appliquer_strategie_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $appliquer_strategie_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($appliquer_strategie_list->TotalRecords == 0 && !$appliquer_strategie->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $appliquer_strategie_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$appliquer_strategie_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$appliquer_strategie_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$appliquer_strategie_list->terminate();
?>