<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$Report1_summary = new Report1_summary();

// Run the page
$Report1_summary->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$Report1_summary->Page_Render();
?>
<?php if (!$DashboardReport) { ?>
<?php include_once "header.php"; ?>
<?php } ?>
<?php if (!$Report1_summary->isExport() && !$Report1_summary->DrillDown && !$DashboardReport) { ?>
<script>
var fsummary, currentPageID;
loadjs.ready("head", function() {

	// Form object for search
	fsummary = currentForm = new ew.Form("fsummary", "summary");
	currentPageID = ew.PAGE_ID = "summary";

	// Validate function for search
	fsummary.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fsummary.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fsummary.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fsummary.lists["x_idemp"] = <?php echo $Report1_summary->idemp->Lookup->toClientList($Report1_summary) ?>;
	fsummary.lists["x_idemp"].options = <?php echo JsonEncode($Report1_summary->idemp->lookupOptions()) ?>;

	// Filters
	fsummary.filterList = <?php echo $Report1_summary->getFilterList() ?>;
	loadjs.done("fsummary");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<a id="top"></a>
<?php if ((!$Report1_summary->isExport() || $Report1_summary->isExport("print")) && !$DashboardReport) { ?>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php } ?>
<?php if ($Report1_summary->ShowCurrentFilter) { ?>
<?php $Report1_summary->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Report1_summary->DrillDownInPanel) {
	$Report1_summary->ExportOptions->render("body");
	$Report1_summary->SearchOptions->render("body");
	$Report1_summary->FilterOptions->render("body");
}
?>
</div>
<?php $Report1_summary->showPageHeader(); ?>
<?php
$Report1_summary->showMessage();
?>
<?php if ((!$Report1_summary->isExport() || $Report1_summary->isExport("print")) && !$DashboardReport) { ?>
<div class="row">
<?php } ?>
<?php if ((!$Report1_summary->isExport() || $Report1_summary->isExport("print")) && !$DashboardReport) { ?>
<!-- Center Container -->
<div id="ew-center" class="<?php echo $Report1_summary->CenterContentClass ?>">
<?php } ?>
<!-- Summary report (begin) -->
<div id="report_summary">
<?php if (!$Report1_summary->isExport() && !$Report1_summary->DrillDown && !$DashboardReport) { ?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$Report1_summary->isExport() && !$Report1->CurrentAction) { ?>
<form name="fsummary" id="fsummary" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fsummary-search-panel" class="<?php echo $Report1_summary->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="Report1">
	<div class="ew-extended-search">
<?php

// Render search row
$Report1->RowType = ROWTYPE_SEARCH;
$Report1->resetAttributes();
$Report1_summary->renderRow();
?>
<?php if ($Report1_summary->idemp->Visible) { // idemp ?>
	<?php
		$Report1_summary->SearchColumnCount++;
		if (($Report1_summary->SearchColumnCount - 1) % $Report1_summary->SearchFieldsPerRow == 0) {
			$Report1_summary->SearchRowCount++;
	?>
<div id="xsr_<?php echo $Report1_summary->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_idemp" class="ew-cell form-group">
		<label for="x_idemp" class="ew-search-caption ew-label"><?php echo $Report1_summary->idemp->caption() ?></label>
		<span id="el_Report1_idemp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="Report1" data-field="x_idemp" data-value-separator="<?php echo $Report1_summary->idemp->displayValueSeparatorAttribute() ?>" id="x_idemp" name="x_idemp"<?php echo $Report1_summary->idemp->editAttributes() ?>>
			<?php echo $Report1_summary->idemp->selectOptionListHtml("x_idemp") ?>
		</select>
</div>
<?php echo $Report1_summary->idemp->Lookup->getParamTag($Report1_summary, "p_x_idemp") ?>
</span>
	</div>
	<?php if ($Report1_summary->SearchColumnCount % $Report1_summary->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($Report1_summary->SearchColumnCount % $Report1_summary->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $Report1_summary->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php } ?>
<?php
while ($Report1_summary->GroupCount <= count($Report1_summary->GroupRecords) && $Report1_summary->GroupCount <= $Report1_summary->DisplayGroups) {
?>
<?php

	// Show header
	if ($Report1_summary->ShowHeader) {
?>
<?php if ($Report1_summary->GroupCount > 1) { ?>
</tbody>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if (!$Report1_summary->isExport() && !($Report1_summary->DrillDown && $Report1_summary->TotalGroups > 0)) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $Report1_summary->Pager->render() ?>
</form>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?php echo $Report1_summary->PageBreakContent ?>
<?php } ?>
<div class="<?php if (!$Report1_summary->isExport("word") && !$Report1_summary->isExport("excel")) { ?>card ew-card <?php } ?>ew-grid"<?php echo $Report1_summary->ReportTableStyle ?>>
<!-- Report grid (begin) -->
<div id="gmp_Report1" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="<?php echo $Report1_summary->ReportTableClass ?>">
<thead>
	<!-- Table header -->
	<tr class="ew-table-header">
<?php if ($Report1_summary->idemp->Visible) { ?>
	<?php if ($Report1_summary->idemp->ShowGroupHeaderAsRow) { ?>
	<th data-name="idemp">&nbsp;</th>
	<?php } else { ?>
		<?php if ($Report1_summary->sortUrl($Report1_summary->idemp) == "") { ?>
	<th data-name="idemp" class="<?php echo $Report1_summary->idemp->headerCellClass() ?>"><div class="Report1_idemp"><div class="ew-table-header-caption"><?php echo $Report1_summary->idemp->caption() ?></div></div></th>
		<?php } else { ?>
	<th data-name="idemp" class="<?php echo $Report1_summary->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->idemp) ?>', 1);"><div class="Report1_idemp">
		<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Report1_summary->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($Report1_summary->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
	</div></div></th>
		<?php } ?>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->nom->Visible) { ?>
	<?php if ($Report1_summary->nom->ShowGroupHeaderAsRow) { ?>
	<th data-name="nom">&nbsp;</th>
	<?php } else { ?>
		<?php if ($Report1_summary->sortUrl($Report1_summary->nom) == "") { ?>
	<th data-name="nom" class="<?php echo $Report1_summary->nom->headerCellClass() ?>"><div class="Report1_nom"><div class="ew-table-header-caption"><?php echo $Report1_summary->nom->caption() ?></div></div></th>
		<?php } else { ?>
	<th data-name="nom" class="<?php echo $Report1_summary->nom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->nom) ?>', 1);"><div class="Report1_nom">
		<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Report1_summary->nom->caption() ?></span><span class="ew-table-header-sort"><?php if ($Report1_summary->nom->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->nom->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
	</div></div></th>
		<?php } ?>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->salaire->Visible) { ?>
	<?php if ($Report1_summary->salaire->ShowGroupHeaderAsRow) { ?>
	<th data-name="salaire">&nbsp;</th>
	<?php } else { ?>
		<?php if ($Report1_summary->sortUrl($Report1_summary->salaire) == "") { ?>
	<th data-name="salaire" class="<?php echo $Report1_summary->salaire->headerCellClass() ?>"><div class="Report1_salaire"><div class="ew-table-header-caption"><?php echo $Report1_summary->salaire->caption() ?></div></div></th>
		<?php } else { ?>
	<th data-name="salaire" class="<?php echo $Report1_summary->salaire->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->salaire) ?>', 1);"><div class="Report1_salaire">
		<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Report1_summary->salaire->caption() ?></span><span class="ew-table-header-sort"><?php if ($Report1_summary->salaire->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->salaire->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
	</div></div></th>
		<?php } ?>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->idstrat->Visible) { ?>
	<?php if ($Report1_summary->sortUrl($Report1_summary->idstrat) == "") { ?>
	<th data-name="idstrat" class="<?php echo $Report1_summary->idstrat->headerCellClass() ?>"><div class="Report1_idstrat"><div class="ew-table-header-caption"><?php echo $Report1_summary->idstrat->caption() ?></div></div></th>
	<?php } else { ?>
	<th data-name="idstrat" class="<?php echo $Report1_summary->idstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->idstrat) ?>', 1);"><div class="Report1_idstrat">
		<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Report1_summary->idstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($Report1_summary->idstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->idstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->titrestrat->Visible) { ?>
	<?php if ($Report1_summary->sortUrl($Report1_summary->titrestrat) == "") { ?>
	<th data-name="titrestrat" class="<?php echo $Report1_summary->titrestrat->headerCellClass() ?>"><div class="Report1_titrestrat"><div class="ew-table-header-caption"><?php echo $Report1_summary->titrestrat->caption() ?></div></div></th>
	<?php } else { ?>
	<th data-name="titrestrat" class="<?php echo $Report1_summary->titrestrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->titrestrat) ?>', 1);"><div class="Report1_titrestrat">
		<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Report1_summary->titrestrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($Report1_summary->titrestrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->titrestrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->montantstrat->Visible) { ?>
	<?php if ($Report1_summary->sortUrl($Report1_summary->montantstrat) == "") { ?>
	<th data-name="montantstrat" class="<?php echo $Report1_summary->montantstrat->headerCellClass() ?>"><div class="Report1_montantstrat"><div class="ew-table-header-caption"><?php echo $Report1_summary->montantstrat->caption() ?></div></div></th>
	<?php } else { ?>
	<th data-name="montantstrat" class="<?php echo $Report1_summary->montantstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->montantstrat) ?>', 1);"><div class="Report1_montantstrat">
		<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Report1_summary->montantstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($Report1_summary->montantstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->montantstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->notestrat->Visible) { ?>
	<?php if ($Report1_summary->sortUrl($Report1_summary->notestrat) == "") { ?>
	<th data-name="notestrat" class="<?php echo $Report1_summary->notestrat->headerCellClass() ?>"><div class="Report1_notestrat"><div class="ew-table-header-caption"><?php echo $Report1_summary->notestrat->caption() ?></div></div></th>
	<?php } else { ?>
	<th data-name="notestrat" class="<?php echo $Report1_summary->notestrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->notestrat) ?>', 1);"><div class="Report1_notestrat">
		<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $Report1_summary->notestrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($Report1_summary->notestrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->notestrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
	</div></div></th>
	<?php } ?>
<?php } ?>
	</tr>
</thead>
<tbody>
<?php
		if ($Report1_summary->TotalGroups == 0)
			break; // Show header only
		$Report1_summary->ShowHeader = FALSE;
	} // End show header
?>
<?php

	// Build detail SQL
	$where = DetailFilterSql($Report1_summary->idemp, $Report1_summary->getSqlFirstGroupField(), $Report1_summary->idemp->groupValue(), $Report1_summary->Dbid);
	if ($Report1_summary->PageFirstGroupFilter != "") $Report1_summary->PageFirstGroupFilter .= " OR ";
	$Report1_summary->PageFirstGroupFilter .= $where;
	if ($Report1_summary->Filter != "")
		$where = "($Report1_summary->Filter) AND ($where)";
	$sql = BuildReportSql($Report1_summary->getSqlSelect(), $Report1_summary->getSqlWhere(), $Report1_summary->getSqlGroupBy(), $Report1_summary->getSqlHaving(), $Report1_summary->getSqlOrderBy(), $where, $Report1_summary->Sort);
	$rs = $Report1_summary->getRecordset($sql);
	$Report1_summary->DetailRecords = $rs ? $rs->getRows() : [];
	$Report1_summary->DetailRecordCount = count($Report1_summary->DetailRecords);

	// Load detail records
	$Report1_summary->idemp->Records = &$Report1_summary->DetailRecords;
	$Report1_summary->idemp->LevelBreak = TRUE; // Set field level break
		$Report1_summary->GroupCounter[1] = $Report1_summary->GroupCount;
		$Report1_summary->idemp->getCnt($Report1_summary->idemp->Records); // Get record count
?>
<?php if ($Report1_summary->idemp->Visible && $Report1_summary->idemp->ShowGroupHeaderAsRow) { ?>
<?php

		// Render header row
		$Report1_summary->resetAttributes();
		$Report1_summary->RowType = ROWTYPE_TOTAL;
		$Report1_summary->RowTotalType = ROWTOTAL_GROUP;
		$Report1_summary->RowTotalSubType = ROWTOTAL_HEADER;
		$Report1_summary->RowGroupLevel = 1;
		$Report1_summary->renderRow();
?>
	<tr<?php echo $Report1_summary->rowAttributes(); ?>>
<?php if ($Report1_summary->idemp->Visible) { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes(); ?>><span class="ew-group-toggle icon-collapse"></span></td>
<?php } ?>
		<td data-field="idemp" colspan="<?php echo ($Page->GroupColumnCount + $Page->DetailColumnCount - 1) ?>"<?php echo $Report1_summary->idemp->cellAttributes() ?>>
<?php if ($Report1_summary->sortUrl($Report1_summary->idemp) == "") { ?>
		<span class="ew-summary-caption Report1_idemp"><span class="ew-table-header-caption"><?php echo $Report1_summary->idemp->caption() ?></span></span>
<?php } else { ?>
		<span class="ew-table-header-btn ew-pointer ew-summary-caption Report1_idemp" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->idemp) ?>', 1);">
			<span class="ew-table-header-caption"><?php echo $Report1_summary->idemp->caption() ?></span>
			<span class="ew-table-header-sort"><?php if ($Report1_summary->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span>
		</span>
<?php } ?>
		<?php echo $Language->phrase("SummaryColon") ?><span<?php echo $Report1_summary->idemp->viewAttributes() ?>><?php echo $Report1_summary->idemp->GroupViewValue ?></span>
		<span class="ew-summary-count">(<span class="ew-aggregate-caption"><?php echo $Language->phrase("RptCnt") ?></span><?php echo $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?php echo FormatNumber($Report1_summary->idemp->Count, 0); ?></span>)</span>
		</td>
	</tr>
<?php } ?>
<?php
	$Report1_summary->nom->getDistinctValues($Report1_summary->idemp->Records);
	$Report1_summary->setGroupCount(count($Report1_summary->nom->DistinctValues), $Report1_summary->GroupCounter[1]);
	$Report1_summary->GroupCounter[2] = 0; // Init group count index
	foreach ($Report1_summary->nom->DistinctValues as $nom) { // Load records for this distinct value
		$Report1_summary->nom->setGroupValue($nom); // Set group value
		$Report1_summary->nom->getDistinctRecords($Report1_summary->idemp->Records, $Report1_summary->nom->groupValue());
		$Report1_summary->nom->LevelBreak = TRUE; // Set field level break
		$Report1_summary->GroupCounter[2]++;
		$Report1_summary->nom->getCnt($Report1_summary->nom->Records); // Get record count
?>
<?php if ($Report1_summary->nom->Visible && $Report1_summary->nom->ShowGroupHeaderAsRow) { ?>
<?php

		// Render header row
		$Report1_summary->nom->setDbValue($nom); // Set current value for nom
		$Report1_summary->resetAttributes();
		$Report1_summary->RowType = ROWTYPE_TOTAL;
		$Report1_summary->RowTotalType = ROWTOTAL_GROUP;
		$Report1_summary->RowTotalSubType = ROWTOTAL_HEADER;
		$Report1_summary->RowGroupLevel = 2;
		$Report1_summary->renderRow();
?>
	<tr<?php echo $Report1_summary->rowAttributes(); ?>>
<?php if ($Report1_summary->idemp->Visible) { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes(); ?>></td>
<?php } ?>
<?php if ($Report1_summary->nom->Visible) { ?>
		<td data-field="nom"<?php echo $Report1_summary->nom->cellAttributes(); ?>><span class="ew-group-toggle icon-collapse"></span></td>
<?php } ?>
		<td data-field="nom" colspan="<?php echo ($Page->GroupColumnCount + $Page->DetailColumnCount - 2) ?>"<?php echo $Report1_summary->nom->cellAttributes() ?>>
<?php if ($Report1_summary->sortUrl($Report1_summary->nom) == "") { ?>
		<span class="ew-summary-caption Report1_nom"><span class="ew-table-header-caption"><?php echo $Report1_summary->nom->caption() ?></span></span>
<?php } else { ?>
		<span class="ew-table-header-btn ew-pointer ew-summary-caption Report1_nom" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->nom) ?>', 1);">
			<span class="ew-table-header-caption"><?php echo $Report1_summary->nom->caption() ?></span>
			<span class="ew-table-header-sort"><?php if ($Report1_summary->nom->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->nom->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span>
		</span>
<?php } ?>
		<?php echo $Language->phrase("SummaryColon") ?><span<?php echo $Report1_summary->nom->viewAttributes() ?>><?php echo $Report1_summary->nom->GroupViewValue ?></span>
		<span class="ew-summary-count">(<span class="ew-aggregate-caption"><?php echo $Language->phrase("RptCnt") ?></span><?php echo $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?php echo FormatNumber($Report1_summary->nom->Count, 0); ?></span>)</span>
		</td>
	</tr>
<?php } ?>
<?php
	$Report1_summary->salaire->getDistinctValues($Report1_summary->nom->Records);
	$Report1_summary->setGroupCount(count($Report1_summary->salaire->DistinctValues), $Report1_summary->GroupCounter[1], $Report1_summary->GroupCounter[2]);
	$Report1_summary->GroupCounter[3] = 0; // Init group count index
	foreach ($Report1_summary->salaire->DistinctValues as $salaire) { // Load records for this distinct value
		$Report1_summary->salaire->setGroupValue($salaire); // Set group value
		$Report1_summary->salaire->getDistinctRecords($Report1_summary->nom->Records, $Report1_summary->salaire->groupValue());
		$Report1_summary->salaire->LevelBreak = TRUE; // Set field level break
		$Report1_summary->GroupCounter[3]++;
		$Report1_summary->salaire->getCnt($Report1_summary->salaire->Records); // Get record count
		$Report1_summary->setGroupCount($Report1_summary->salaire->Count, $Report1_summary->GroupCounter[1], $Report1_summary->GroupCounter[2], $Report1_summary->GroupCounter[3]);
?>
<?php if ($Report1_summary->salaire->Visible && $Report1_summary->salaire->ShowGroupHeaderAsRow) { ?>
<?php

		// Render header row
		$Report1_summary->salaire->setDbValue($salaire); // Set current value for salaire
		$Report1_summary->resetAttributes();
		$Report1_summary->RowType = ROWTYPE_TOTAL;
		$Report1_summary->RowTotalType = ROWTOTAL_GROUP;
		$Report1_summary->RowTotalSubType = ROWTOTAL_HEADER;
		$Report1_summary->RowGroupLevel = 3;
		$Report1_summary->renderRow();
?>
	<tr<?php echo $Report1_summary->rowAttributes(); ?>>
<?php if ($Report1_summary->idemp->Visible) { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes(); ?>></td>
<?php } ?>
<?php if ($Report1_summary->nom->Visible) { ?>
		<td data-field="nom"<?php echo $Report1_summary->nom->cellAttributes(); ?>></td>
<?php } ?>
<?php if ($Report1_summary->salaire->Visible) { ?>
		<td data-field="salaire"<?php echo $Report1_summary->salaire->cellAttributes(); ?>><span class="ew-group-toggle icon-collapse"></span></td>
<?php } ?>
		<td data-field="salaire" colspan="<?php echo ($Page->GroupColumnCount + $Page->DetailColumnCount - 3) ?>"<?php echo $Report1_summary->salaire->cellAttributes() ?>>
<?php if ($Report1_summary->sortUrl($Report1_summary->salaire) == "") { ?>
		<span class="ew-summary-caption Report1_salaire"><span class="ew-table-header-caption"><?php echo $Report1_summary->salaire->caption() ?></span></span>
<?php } else { ?>
		<span class="ew-table-header-btn ew-pointer ew-summary-caption Report1_salaire" onclick="ew.sort(event, '<?php echo $Report1_summary->sortUrl($Report1_summary->salaire) ?>', 1);">
			<span class="ew-table-header-caption"><?php echo $Report1_summary->salaire->caption() ?></span>
			<span class="ew-table-header-sort"><?php if ($Report1_summary->salaire->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($Report1_summary->salaire->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span>
		</span>
<?php } ?>
		<?php echo $Language->phrase("SummaryColon") ?><span<?php echo $Report1_summary->salaire->viewAttributes() ?>><?php echo $Report1_summary->salaire->GroupViewValue ?></span>
		<span class="ew-summary-count">(<span class="ew-aggregate-caption"><?php echo $Language->phrase("RptCnt") ?></span><?php echo $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?php echo FormatNumber($Report1_summary->salaire->Count, 0); ?></span>)</span>
		</td>
	</tr>
<?php } ?>
<?php
	$Report1_summary->RecordCount = 0; // Reset record count
	foreach ($Report1_summary->salaire->Records as $record) {
		$Report1_summary->RecordCount++;
		$Report1_summary->RecordIndex++;
		$Report1_summary->loadRowValues($record);
?>
<?php

		// Render detail row
		$Report1_summary->resetAttributes();
		$Report1_summary->RowType = ROWTYPE_DETAIL;
		$Report1_summary->renderRow();
?>
	<tr<?php echo $Report1_summary->rowAttributes(); ?>>
<?php if ($Report1_summary->idemp->Visible) { ?>
	<?php if ($Report1_summary->idemp->ShowGroupHeaderAsRow) { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes(); ?>>&nbsp;</td>
	<?php } else { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes(); ?>><span<?php echo $Report1_summary->idemp->viewAttributes() ?>><?php echo $Report1_summary->idemp->GroupViewValue ?></span></td>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->nom->Visible) { ?>
	<?php if ($Report1_summary->nom->ShowGroupHeaderAsRow) { ?>
		<td data-field="nom"<?php echo $Report1_summary->nom->cellAttributes(); ?>>&nbsp;</td>
	<?php } else { ?>
		<td data-field="nom"<?php echo $Report1_summary->nom->cellAttributes(); ?>><span<?php echo $Report1_summary->nom->viewAttributes() ?>><?php echo $Report1_summary->nom->GroupViewValue ?></span></td>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->salaire->Visible) { ?>
	<?php if ($Report1_summary->salaire->ShowGroupHeaderAsRow) { ?>
		<td data-field="salaire"<?php echo $Report1_summary->salaire->cellAttributes(); ?>>&nbsp;</td>
	<?php } else { ?>
		<td data-field="salaire"<?php echo $Report1_summary->salaire->cellAttributes(); ?>><span<?php echo $Report1_summary->salaire->viewAttributes() ?>><?php echo $Report1_summary->salaire->GroupViewValue ?></span></td>
	<?php } ?>
<?php } ?>
<?php if ($Report1_summary->idstrat->Visible) { ?>
		<td data-field="idstrat"<?php echo $Report1_summary->idstrat->cellAttributes() ?>>
<span<?php echo $Report1_summary->idstrat->viewAttributes() ?>><?php echo $Report1_summary->idstrat->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Report1_summary->titrestrat->Visible) { ?>
		<td data-field="titrestrat"<?php echo $Report1_summary->titrestrat->cellAttributes() ?>>
<span<?php echo $Report1_summary->titrestrat->viewAttributes() ?>><?php echo $Report1_summary->titrestrat->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Report1_summary->montantstrat->Visible) { ?>
		<td data-field="montantstrat"<?php echo $Report1_summary->montantstrat->cellAttributes() ?>>
<span<?php echo $Report1_summary->montantstrat->viewAttributes() ?>><?php echo $Report1_summary->montantstrat->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Report1_summary->notestrat->Visible) { ?>
		<td data-field="notestrat"<?php echo $Report1_summary->notestrat->cellAttributes() ?>>
<span<?php echo $Report1_summary->notestrat->viewAttributes() ?>><?php echo $Report1_summary->notestrat->getViewValue() ?></span>
</td>
<?php } ?>
	</tr>
<?php
	}
?>
<?php if ($Report1_summary->TotalGroups > 0) { ?>
<?php
	$Report1_summary->montantstrat->getSum($Report1_summary->salaire->Records); // Get Sum
	$Report1_summary->resetAttributes();
	$Report1_summary->RowType = ROWTYPE_TOTAL;
	$Report1_summary->RowTotalType = ROWTOTAL_GROUP;
	$Report1_summary->RowTotalSubType = ROWTOTAL_FOOTER;
	$Report1_summary->RowGroupLevel = 3;
	$Report1_summary->renderRow();
?>
<?php if ($Report1_summary->salaire->ShowCompactSummaryFooter) { ?>
	<tr<?php echo $Report1_summary->rowAttributes(); ?>>
<?php if ($Report1_summary->idemp->Visible) { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes() ?>>
	<?php if ($Report1_summary->idemp->ShowGroupHeaderAsRow) { ?>
		&nbsp;
	<?php } elseif ($Report1_summary->RowGroupLevel != 1) { ?>
		&nbsp;
	<?php } else { ?>
		<span class="ew-summary-count"><span class="ew-aggregate-caption"><?php echo $Language->phrase("RptCnt") ?></span><?php echo $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?php echo FormatNumber($Report1_summary->idemp->Count, 0); ?></span></span>
	<?php } ?>
		</td>
<?php } ?>
<?php if ($Report1_summary->nom->Visible) { ?>
		<td data-field="nom"<?php echo $Report1_summary->nom->cellAttributes() ?>>
	<?php if ($Report1_summary->nom->ShowGroupHeaderAsRow) { ?>
		&nbsp;
	<?php } elseif ($Report1_summary->RowGroupLevel != 2) { ?>
		&nbsp;
	<?php } else { ?>
		<span class="ew-summary-count"><span class="ew-aggregate-caption"><?php echo $Language->phrase("RptCnt") ?></span><?php echo $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?php echo FormatNumber($Report1_summary->nom->Count, 0); ?></span></span>
	<?php } ?>
		</td>
<?php } ?>
<?php if ($Report1_summary->salaire->Visible) { ?>
		<td data-field="salaire"<?php echo $Report1_summary->salaire->cellAttributes() ?>>
	<?php if ($Report1_summary->salaire->ShowGroupHeaderAsRow) { ?>
		&nbsp;
	<?php } elseif ($Report1_summary->RowGroupLevel != 3) { ?>
		&nbsp;
	<?php } else { ?>
		<span class="ew-summary-count"><span class="ew-aggregate-caption"><?php echo $Language->phrase("RptCnt") ?></span><?php echo $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><?php echo FormatNumber($Report1_summary->salaire->Count, 0); ?></span></span>
	<?php } ?>
		</td>
<?php } ?>
<?php if ($Report1_summary->idstrat->Visible) { ?>
		<td data-field="idstrat"<?php echo $Report1_summary->salaire->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Report1_summary->titrestrat->Visible) { ?>
		<td data-field="titrestrat"<?php echo $Report1_summary->salaire->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Report1_summary->montantstrat->Visible) { ?>
		<td data-field="montantstrat"<?php echo $Report1_summary->salaire->cellAttributes() ?>><span class="ew-aggregate-caption"><?php echo $Language->phrase("RptSum") ?></span><?php echo $Language->phrase("AggregateEqual") ?><span class="ew-aggregate-value"><span<?php echo $Report1_summary->montantstrat->viewAttributes() ?>><?php echo $Report1_summary->montantstrat->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Report1_summary->notestrat->Visible) { ?>
		<td data-field="notestrat"<?php echo $Report1_summary->salaire->cellAttributes() ?>></td>
<?php } ?>
	</tr>
<?php } else { ?>
	<tr<?php echo $Report1_summary->rowAttributes(); ?>>
<?php if ($Report1_summary->idemp->Visible) { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Report1_summary->nom->Visible) { ?>
		<td data-field="nom"<?php echo $Report1_summary->nom->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Report1_summary->SubGroupColumnCount + $Report1_summary->DetailColumnCount - 1 > 0) { ?>
		<td colspan="<?php echo ($Report1_summary->SubGroupColumnCount + $Report1_summary->DetailColumnCount - 1) ?>"<?php echo $Report1_summary->salaire->cellAttributes() ?>><?php echo str_replace(["%v", "%c"], [$Report1_summary->salaire->GroupViewValue, $Report1_summary->salaire->caption()], $Language->phrase("RptSumHead")) ?> <span class="ew-dir-ltr">(<?php echo FormatNumber($Report1_summary->salaire->Count, 0); ?><?php echo $Language->phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
	</tr>
	<tr<?php echo $Report1_summary->rowAttributes(); ?>>
<?php if ($Report1_summary->idemp->Visible) { ?>
		<td data-field="idemp"<?php echo $Report1_summary->idemp->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Report1_summary->nom->Visible) { ?>
		<td data-field="nom"<?php echo $Report1_summary->nom->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Report1_summary->GroupColumnCount > 0) { ?>
		<td colspan="<?php echo ($Report1_summary->GroupColumnCount - 2) ?>"<?php echo $Report1_summary->salaire->cellAttributes() ?>><?php echo $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Report1_summary->idstrat->Visible) { ?>
		<td data-field="idstrat"<?php echo $Report1_summary->salaire->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Report1_summary->titrestrat->Visible) { ?>
		<td data-field="titrestrat"<?php echo $Report1_summary->salaire->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
<?php if ($Report1_summary->montantstrat->Visible) { ?>
		<td data-field="montantstrat"<?php echo $Report1_summary->montantstrat->cellAttributes() ?>>
<span<?php echo $Report1_summary->montantstrat->viewAttributes() ?>><?php echo $Report1_summary->montantstrat->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Report1_summary->notestrat->Visible) { ?>
		<td data-field="notestrat"<?php echo $Report1_summary->salaire->cellAttributes() ?>>&nbsp;</td>
<?php } ?>
	</tr>
<?php } ?>
<?php } ?>
<?php
	} // End group level 2
	} // End group level 1
?>
<?php

	// Next group
	$Report1_summary->loadGroupRowValues();

	// Show header if page break
	if ($Report1_summary->isExport())
		$Report1_summary->ShowHeader = ($Report1_summary->ExportPageBreakCount == 0) ? FALSE : ($Report1_summary->GroupCount % $Report1_summary->ExportPageBreakCount == 0);

	// Page_Breaking server event
	if ($Report1_summary->ShowHeader)
		$Report1_summary->Page_Breaking($Report1_summary->ShowHeader, $Report1_summary->PageBreakContent);
	$Report1_summary->GroupCount++;
} // End while
?>
<?php if ($Report1_summary->TotalGroups > 0) { ?>
</tbody>
<tfoot>
</tfoot>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if (!$Report1_summary->isExport() && !($Report1_summary->DrillDown && $Report1_summary->TotalGroups > 0)) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $Report1_summary->Pager->render() ?>
</form>
<div class="clearfix"></div>
</div>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
</div>
<!-- /#report-summary -->
<!-- Summary report (end) -->
<?php if ((!$Report1_summary->isExport() || $Report1_summary->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /#ew-center -->
<?php } ?>
<?php if ((!$Report1_summary->isExport() || $Report1_summary->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /.row -->
<?php } ?>
<?php if ((!$Report1_summary->isExport() || $Report1_summary->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /.ew-report -->
<?php } ?>
<?php
$Report1_summary->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$Report1_summary->isExport() && !$Report1_summary->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php if (!$DashboardReport) { ?>
<?php include_once "footer.php"; ?>
<?php } ?>
<?php
$Report1_summary->terminate();
?>