<?php
namespace PHPMaker2020\payrollv1;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start();

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$CustomView1_list = new CustomView1_list();

// Run the page
$CustomView1_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$CustomView1_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$CustomView1_list->isExport()) { ?>
<script>
var fCustomView1list, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fCustomView1list = currentForm = new ew.Form("fCustomView1list", "list");
	fCustomView1list.formKeyCountName = '<?php echo $CustomView1_list->FormKeyCountName ?>';
	loadjs.done("fCustomView1list");
});
var fCustomView1listsrch;
loadjs.ready("head", function() {

	// Form object for search
	fCustomView1listsrch = currentSearchForm = new ew.Form("fCustomView1listsrch");

	// Dynamic selection lists
	// Filters

	fCustomView1listsrch.filterList = <?php echo $CustomView1_list->getFilterList() ?>;
	loadjs.done("fCustomView1listsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$CustomView1_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($CustomView1_list->TotalRecords > 0 && $CustomView1_list->ExportOptions->visible()) { ?>
<?php $CustomView1_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($CustomView1_list->ImportOptions->visible()) { ?>
<?php $CustomView1_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($CustomView1_list->SearchOptions->visible()) { ?>
<?php $CustomView1_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($CustomView1_list->FilterOptions->visible()) { ?>
<?php $CustomView1_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$CustomView1_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$CustomView1_list->isExport() && !$CustomView1->CurrentAction) { ?>
<form name="fCustomView1listsrch" id="fCustomView1listsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fCustomView1listsrch-search-panel" class="<?php echo $CustomView1_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="CustomView1">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $CustomView1_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($CustomView1_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($CustomView1_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $CustomView1_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($CustomView1_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($CustomView1_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($CustomView1_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($CustomView1_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $CustomView1_list->showPageHeader(); ?>
<?php
$CustomView1_list->showMessage();
?>
<?php if ($CustomView1_list->TotalRecords > 0 || $CustomView1->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($CustomView1_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> CustomView1">
<form name="fCustomView1list" id="fCustomView1list" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="CustomView1">
<div id="gmp_CustomView1" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($CustomView1_list->TotalRecords > 0 || $CustomView1_list->isGridEdit()) { ?>
<table id="tbl_CustomView1list" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$CustomView1->RowType = ROWTYPE_HEADER;

// Render list options
$CustomView1_list->renderListOptions();

// Render list options (header, left)
$CustomView1_list->ListOptions->render("header", "left");
?>
<?php if ($CustomView1_list->idemp->Visible) { // idemp ?>
	<?php if ($CustomView1_list->SortUrl($CustomView1_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $CustomView1_list->idemp->headerCellClass() ?>"><div id="elh_CustomView1_idemp" class="CustomView1_idemp"><div class="ew-table-header-caption"><?php echo $CustomView1_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $CustomView1_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $CustomView1_list->SortUrl($CustomView1_list->idemp) ?>', 1);"><div id="elh_CustomView1_idemp" class="CustomView1_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $CustomView1_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($CustomView1_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($CustomView1_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($CustomView1_list->nom->Visible) { // nom ?>
	<?php if ($CustomView1_list->SortUrl($CustomView1_list->nom) == "") { ?>
		<th data-name="nom" class="<?php echo $CustomView1_list->nom->headerCellClass() ?>"><div id="elh_CustomView1_nom" class="CustomView1_nom"><div class="ew-table-header-caption"><?php echo $CustomView1_list->nom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nom" class="<?php echo $CustomView1_list->nom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $CustomView1_list->SortUrl($CustomView1_list->nom) ?>', 1);"><div id="elh_CustomView1_nom" class="CustomView1_nom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $CustomView1_list->nom->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($CustomView1_list->nom->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($CustomView1_list->nom->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($CustomView1_list->salaire->Visible) { // salaire ?>
	<?php if ($CustomView1_list->SortUrl($CustomView1_list->salaire) == "") { ?>
		<th data-name="salaire" class="<?php echo $CustomView1_list->salaire->headerCellClass() ?>"><div id="elh_CustomView1_salaire" class="CustomView1_salaire"><div class="ew-table-header-caption"><?php echo $CustomView1_list->salaire->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="salaire" class="<?php echo $CustomView1_list->salaire->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $CustomView1_list->SortUrl($CustomView1_list->salaire) ?>', 1);"><div id="elh_CustomView1_salaire" class="CustomView1_salaire">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $CustomView1_list->salaire->caption() ?></span><span class="ew-table-header-sort"><?php if ($CustomView1_list->salaire->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($CustomView1_list->salaire->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($CustomView1_list->idstrat->Visible) { // idstrat ?>
	<?php if ($CustomView1_list->SortUrl($CustomView1_list->idstrat) == "") { ?>
		<th data-name="idstrat" class="<?php echo $CustomView1_list->idstrat->headerCellClass() ?>"><div id="elh_CustomView1_idstrat" class="CustomView1_idstrat"><div class="ew-table-header-caption"><?php echo $CustomView1_list->idstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idstrat" class="<?php echo $CustomView1_list->idstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $CustomView1_list->SortUrl($CustomView1_list->idstrat) ?>', 1);"><div id="elh_CustomView1_idstrat" class="CustomView1_idstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $CustomView1_list->idstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($CustomView1_list->idstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($CustomView1_list->idstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($CustomView1_list->titrestrat->Visible) { // titrestrat ?>
	<?php if ($CustomView1_list->SortUrl($CustomView1_list->titrestrat) == "") { ?>
		<th data-name="titrestrat" class="<?php echo $CustomView1_list->titrestrat->headerCellClass() ?>"><div id="elh_CustomView1_titrestrat" class="CustomView1_titrestrat"><div class="ew-table-header-caption"><?php echo $CustomView1_list->titrestrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titrestrat" class="<?php echo $CustomView1_list->titrestrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $CustomView1_list->SortUrl($CustomView1_list->titrestrat) ?>', 1);"><div id="elh_CustomView1_titrestrat" class="CustomView1_titrestrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $CustomView1_list->titrestrat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($CustomView1_list->titrestrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($CustomView1_list->titrestrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($CustomView1_list->montantstrat->Visible) { // montantstrat ?>
	<?php if ($CustomView1_list->SortUrl($CustomView1_list->montantstrat) == "") { ?>
		<th data-name="montantstrat" class="<?php echo $CustomView1_list->montantstrat->headerCellClass() ?>"><div id="elh_CustomView1_montantstrat" class="CustomView1_montantstrat"><div class="ew-table-header-caption"><?php echo $CustomView1_list->montantstrat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="montantstrat" class="<?php echo $CustomView1_list->montantstrat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $CustomView1_list->SortUrl($CustomView1_list->montantstrat) ?>', 1);"><div id="elh_CustomView1_montantstrat" class="CustomView1_montantstrat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $CustomView1_list->montantstrat->caption() ?></span><span class="ew-table-header-sort"><?php if ($CustomView1_list->montantstrat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($CustomView1_list->montantstrat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$CustomView1_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($CustomView1_list->ExportAll && $CustomView1_list->isExport()) {
	$CustomView1_list->StopRecord = $CustomView1_list->TotalRecords;
} else {

	// Set the last record to display
	if ($CustomView1_list->TotalRecords > $CustomView1_list->StartRecord + $CustomView1_list->DisplayRecords - 1)
		$CustomView1_list->StopRecord = $CustomView1_list->StartRecord + $CustomView1_list->DisplayRecords - 1;
	else
		$CustomView1_list->StopRecord = $CustomView1_list->TotalRecords;
}
$CustomView1_list->RecordCount = $CustomView1_list->StartRecord - 1;
if ($CustomView1_list->Recordset && !$CustomView1_list->Recordset->EOF) {
	$CustomView1_list->Recordset->moveFirst();
	$selectLimit = $CustomView1_list->UseSelectLimit;
	if (!$selectLimit && $CustomView1_list->StartRecord > 1)
		$CustomView1_list->Recordset->move($CustomView1_list->StartRecord - 1);
} elseif (!$CustomView1->AllowAddDeleteRow && $CustomView1_list->StopRecord == 0) {
	$CustomView1_list->StopRecord = $CustomView1->GridAddRowCount;
}

// Initialize aggregate
$CustomView1->RowType = ROWTYPE_AGGREGATEINIT;
$CustomView1->resetAttributes();
$CustomView1_list->renderRow();
while ($CustomView1_list->RecordCount < $CustomView1_list->StopRecord) {
	$CustomView1_list->RecordCount++;
	if ($CustomView1_list->RecordCount >= $CustomView1_list->StartRecord) {
		$CustomView1_list->RowCount++;

		// Set up key count
		$CustomView1_list->KeyCount = $CustomView1_list->RowIndex;

		// Init row class and style
		$CustomView1->resetAttributes();
		$CustomView1->CssClass = "";
		if ($CustomView1_list->isGridAdd()) {
		} else {
			$CustomView1_list->loadRowValues($CustomView1_list->Recordset); // Load row values
		}
		$CustomView1->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$CustomView1->RowAttrs->merge(["data-rowindex" => $CustomView1_list->RowCount, "id" => "r" . $CustomView1_list->RowCount . "_CustomView1", "data-rowtype" => $CustomView1->RowType]);

		// Render row
		$CustomView1_list->renderRow();

		// Render list options
		$CustomView1_list->renderListOptions();
?>
	<tr <?php echo $CustomView1->rowAttributes() ?>>
<?php

// Render list options (body, left)
$CustomView1_list->ListOptions->render("body", "left", $CustomView1_list->RowCount);
?>
	<?php if ($CustomView1_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $CustomView1_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $CustomView1_list->RowCount ?>_CustomView1_idemp">
<span<?php echo $CustomView1_list->idemp->viewAttributes() ?>><?php echo $CustomView1_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CustomView1_list->nom->Visible) { // nom ?>
		<td data-name="nom" <?php echo $CustomView1_list->nom->cellAttributes() ?>>
<span id="el<?php echo $CustomView1_list->RowCount ?>_CustomView1_nom">
<span<?php echo $CustomView1_list->nom->viewAttributes() ?>><?php echo $CustomView1_list->nom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CustomView1_list->salaire->Visible) { // salaire ?>
		<td data-name="salaire" <?php echo $CustomView1_list->salaire->cellAttributes() ?>>
<span id="el<?php echo $CustomView1_list->RowCount ?>_CustomView1_salaire">
<span<?php echo $CustomView1_list->salaire->viewAttributes() ?>><?php echo $CustomView1_list->salaire->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CustomView1_list->idstrat->Visible) { // idstrat ?>
		<td data-name="idstrat" <?php echo $CustomView1_list->idstrat->cellAttributes() ?>>
<span id="el<?php echo $CustomView1_list->RowCount ?>_CustomView1_idstrat">
<span<?php echo $CustomView1_list->idstrat->viewAttributes() ?>><?php echo $CustomView1_list->idstrat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CustomView1_list->titrestrat->Visible) { // titrestrat ?>
		<td data-name="titrestrat" <?php echo $CustomView1_list->titrestrat->cellAttributes() ?>>
<span id="el<?php echo $CustomView1_list->RowCount ?>_CustomView1_titrestrat">
<span<?php echo $CustomView1_list->titrestrat->viewAttributes() ?>><?php echo $CustomView1_list->titrestrat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($CustomView1_list->montantstrat->Visible) { // montantstrat ?>
		<td data-name="montantstrat" <?php echo $CustomView1_list->montantstrat->cellAttributes() ?>>
<span id="el<?php echo $CustomView1_list->RowCount ?>_CustomView1_montantstrat">
<span<?php echo $CustomView1_list->montantstrat->viewAttributes() ?>><?php echo $CustomView1_list->montantstrat->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$CustomView1_list->ListOptions->render("body", "right", $CustomView1_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$CustomView1_list->isGridAdd())
		$CustomView1_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$CustomView1->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($CustomView1_list->Recordset)
	$CustomView1_list->Recordset->Close();
?>
<?php if (!$CustomView1_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$CustomView1_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $CustomView1_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $CustomView1_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($CustomView1_list->TotalRecords == 0 && !$CustomView1->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $CustomView1_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$CustomView1_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$CustomView1_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$CustomView1_list->terminate();
?>