 
<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
		<div class="row">
			<div class="col-lg-12 col-md-11">
				 <div class="card">
					<div class="header">
						<h4 class="title">Expense Reports</h4>
					</div>
					<div class="content">
						<div class="row">
							<form action="" method="POST" id="form">
							<div class="col-lg-3">
							 <label>Category</label>
							 <select id="category" class="form-control" name="category" required>
							 <option value="">Select a Category</option>
							 </select>
							</div>
							<div class="col-lg-3">
							 <label>Sub Category</label>
							 <select id="subcategory" class="form-control" name="subcategory">
							 </select>
							</div>
							<div class="col-lg-3">
							<label for="date" class="control-label"> 
									From Date</label>
									<div  class="input-group date" data-date-format="mm-dd-yyyy">
										<input id="fromdate" name="fromdate" class="form-control" type="text" value=""/>
										<span class="input-group-addon" style="border: 1px solid #cecece;"><i class="fa fa-calendar"></i></span>
									</div>
							</div>
							<div class="col-lg-3">
							<label for="date" class="control-label"> 
									To Date</label>
									<div  class="input-group date" data-date-format="mm-dd-yyyy">
										<input id="todate" name="todate" class="form-control" type="text" value=""/>
										<span class="input-group-addon" style="border: 1px solid #cecece;"><i class="fa fa-calendar"></i></span>
									</div>
							</div>
						</div>							
						<div class="row">
								<div class="col-lg-2">
									<button type="submit" class="form-control btn btn-sm btn-fill btn-info"><i class="ti-search"></i> Search</button>
								</div>
						</div>
							</form>
						
					</div>
				 </div>
			</div> 
		</div>
		
        <div class="row">

            <div class="col-lg-12 col-md-11">
                <div class="card">
                    <div class="header">
						<h4 class="title">Expense Reports</h4>
                    </div>
                    <div class="content">
					
						<table id="data" class="table table-striped table-bordered"  cellspacing="0" width="100%">
							<thead>
								<tr>

									<th>Name</th>
									<th>Category</th>
									<th>Sub Category</th>
									<th>Account</th>
									<th>Amount</th>
									<th>Date</th>									
								</tr>
							</thead>
							<tfoot>
								<tr>

									<th>Name</th>
									<th>Category</th>
									<th>Sub Category</th>
									<th>Account</th>
									<th>Amount</th>
									<th>Date</th>	
								</tr>
							</tfoot>
							<tbody>
							
							</tbody>
						</table>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
			<div class="col-lg-6">
				<div class="card">
					<div class="header">
						<div class="pull-left">
							<h5><b>12 Monthly Expense Chart</b></h5>
						</div>
						<div class="pull-right">
							<div class="text-danger">
								<b><span>$3.259,12</span></b><br/>
								<small>in This Year</small>
							</div>
						</div>
					</div>
					<div class="content">
					<input type="hidden" class="currency"/>
							<canvas id="chart1"></canvas>
					</div>
				</div>
			</div>
			<div class="col-lg-6">
				<div class="card">
					<div class="header">
						<h5><b>Expense by Category</b></h5>
					</div>
					<div class="content">
							<canvas id="chart2"></canvas>
					</div>
				</div>
			</div>
		</div>
    </div>
</div>	


<script>


$(document).ready(function() {
	$.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
	});
	


	//get currency
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$(".currency").val(objs[0].currency);
        },
    });
   
	//get income category
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('expensecategory/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.categoryid);
                var name = decodeURIComponent(record.name);
				//alert(name);
                $("#form #category").append($("<option></option>")
                    .attr("value",id)
                    .text(name));                 
            });
        },
    });
	
	//get income sub category
	$("#form #category").change(function(e){
		var id = $(this).val();
		$.ajax({
        type: "POST",
        url: "<?php echo e(url('expensecategory/subgetdatabycat')); ?>",
        dataType: "json",
        data: {id:id},
        success: function (html) {
			var objs = html.message;
			var options;
			if (objs.length === 0) {
				$('#subcategory').empty();
			}
			$.each(objs, function(index, object) {
					options += '<option value="' + object.subcategoryid + '">' + object.name + '</option>';
				});
				$('#form #subcategory').html(options);
			},
		});
	});
	
	//get data
    var table = $('#data').DataTable( {
			
			processing: true,
			serverSide: true,
			bFilter : false,
            ajax: {
				url : "<?php echo e(url('reports/gettransactions')); ?>",
				data: function (d) {
					d.type 		= '2';
					d.category = $('select[name=category]').val();
					//d.category = 'Salary';
					d.subcategory = $('select[name=subcategory]').val();
					d.fromdate = $('input[name=fromdate]').val();
					d.todate = $('input[name=todate]').val();
				},
			},
			columns: [
				{ data: 'name', name:'name'},
				{ data: 'category', name:'category'},
				{ data: 'subcategory', name:'subcategory'},
				{ data: 'account', name:'account'},				
				{ data: 'amount', name:'amount'},		
				{ data: 'transactiondate', name:'transactiondate'}
			],
			dom: 'Bfrtip',

			buttons: [
				{
					extend: 'copy',
					text:   'Copy <i class="fa fa-files-o"></i>',
					title: 'Expense Report',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5]
					}
				}, 
				{
					extend:'csv',
					text:   'CSV <i class="fa fa-file-excel-o"></i>',
					title: 'Expense Report',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5 ]
					}
				},
				{
					extend:'pdf',
					text:   'PDF <i class="fa fa-file-pdf-o"></i>',
					title: 'Expense Report',
					className: 'btn btn-sm btn-fill btn-info ',
					orientation:'landscape',
					exportOptions: {
						columns: [0, 1, 2, 3, 4, 5]
					},
					customize : function(doc){
						doc.styles.tableHeader.alignment = 'left';
						doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
					}
				},
				{
					extend:'print',
					title: 'Expense Report',
					text:   'Print <i class="fa fa-print"></i>',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5 ]
					}
				}
			]
    } );
	//do search
	$('#form').on('submit', function(e) {
        table.draw();
        e.preventDefault();
    });
	
	//income graph
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/incomevsexpense')); ?>",
        dataType: "json",
        data: "{}",
        success: function (data) {
			var cchart1 = document.getElementById("chart1");
			var chart1 = new Chart(cchart1, {
				type: 'line',
				legendPosition: 'bottom',
				data: {
					labels: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
					datasets: [
					{
						label: 'Expense',
						data: [data.ejan, data.efeb, data.emar, data.eapr, data.emay, data.ejun, data.ejun, data.ejun, data.ejul, data.eags, data.esep, data.eokt, data.enov, data.edes],
						backgroundColor: 'rgba(255, 99, 132, 0.2)',
						borderColor:	'rgba(255,99,132,1)',
						borderWidth: 1
					}
					]
				},
				options: {
					 pieceLabel: {
					  // render 'label', 'value', 'percentage' or custom function, default is 'percentage'
					  render: 'label'
					 }, 
					legend: {
						   position: 'bottom',
						},
					tooltips: {
							mode: 'index',
							intersect: false,
							callbacks: {
								label: function(tooltipItem, data) {
									return $('.currency').val()+tooltipItem.yLabel.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
								},
							}
						},
					hover: {
							mode: 'nearest',
							intersect: true
						},
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true,
								callback: function(value, index, values) {
								  if(parseInt(value) >= 1000){
									return  $('.currency').val()+value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
								  } else {
									return $('.currency').val() + value;
								  }
								}
							}
						}]
					}
				}
			});
			
        },
    });
	
	//incomebycategory
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/expensebycategory')); ?>",
        dataType: "json",
        success: function (data) {
			var label = [];
			var amount = [];
			var color = [];
			
			for(var i in data) {
				label.push(data[i].category);
				amount.push(data[i].amount);
				color.push(data[i].color);
			}
			
			var cchart2 = document.getElementById("chart2");
			var chart2 = new Chart(cchart2, {
				type: 'bar',
				legendPosition: 'bottom',
				data: {
					labels: label,
					datasets: [
					{
						label: 'Category',
						data: amount,
						backgroundColor: 'rgba(255, 99, 132, 0.2)',
						borderColor:	'rgba(255,99,132,1)',
						borderWidth: 1
					}
					]
				},
				options: {
					legend: {
						   position: 'bottom',
					},
					tooltips: {
					  callbacks: {
						title: function(tooltipItem, data) {
						  return data['labels'][tooltipItem[0]['index']];
						},
						label: function(tooltipItem, data) {
						  return $('.currency').val()+data['datasets'][0]['data'][tooltipItem['index']].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
						}
					  },
					}
				}
			});
		}
	});	
		
} );

	$('#fromdate').datepicker({
            autoclose: true,
            dateFormat: "yy-mm-dd",
            todayHighlight: true
        });	
	$('#todate').datepicker({
            autoclose: true,
            dateFormat: "yy-mm-dd",
            todayHighlight: true
        });	

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>