<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
		<div class="row">
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big icon-warning text-center">
                                    <i class="ti-user"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div class="numbers">
                                    <p>Total Users</p>
                                    <span id="totalusers"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big icon-success text-center">
                                    <i class="ti-bolt"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div class="numbers">
                                    <p>Active Users</p>
                                    <span id="activeuser"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big icon-danger text-center">
                                    <i class="ti-pulse"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div class="numbers">
                                    <p>Inactive Users</p>
                                    <span id="inactiveuser"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                           
                        </div>
                    </div>
                </div>
            </div>

        </div>
		
        <div class="row">
			<!--add data-->
      
            <div class="col-lg-12 col-md-11">
                <div class="card">
                    <div class="header">
						<div class="row">
							<div class="col-lg-6">
							<h4 class="title">Users List</h4>
							</div>
							<div class="col-lg-6">
							<div class="pull-right"><a href="#'" data-toggle="modal" data-target="#add" class="btn btn-sm btn-fill btn-info"><i class="ti-plus"></i> Add New User</a></div>
							</div>
						</div>
						
                    </div>
                    <div class="content">
					<div id="message2" style="display:none" class="alert alert-success">Data has been added sucessfully</div>
					<div id="message3" style="display:none" class="alert alert-success">Data has been deleted sucessfully</div>
					<div id="message4" style="display:none" class="alert alert-success">Data has been updated sucessfully</div>
						<table id="data" class="table table-striped table-bordered" cellspacing="0" width="100%">
							<thead>
								<tr>
									<th>User ID</th>
									<th>Name</th>
									<th>Email</th>
									<th>Role</th>
									<th>Phone</th>
									<th>Status</th>
									<th>Action</th>
								</tr>
							</thead>
							<tfoot>
								<tr>
									<th>User ID</th>
									<th>Name</th>
									<th>Email</th>
									<th>Role</th>
									<th>Phone</th>
									<th>Status</th>
									<th>Action</th>
								</tr>
							</tfoot>
							<tbody>
							
							</tbody>
						</table>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>	
  <!--delete data -->
 <div class="modal fade" id="delete" role="dialog">
    <div class="modal-dialog modal-sm">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Delete Data</h4>
        </div>
        <div class="modal-body">
		<form action="" method="POST">
          <p>Are you sure to delete this data?</p>
		  <input type="hidden" value="" name="iddelete" id="iddelete"/>
		  </form>
        </div>
        <div class="modal-footer">
		   <input type="submit" class="btn btn-primary" id="dodelete" value="Delete"/>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
<!--add new data -->
<div id="add" class="modal fade" role="dialog">
        <div class="modal-dialog">
          <div class="modal-content">
            <form action="" method="post" id="form">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Add New User</h4>
              </div>
			  <div id="message" style="display:none;" class="alert alert-warning">All field is required</div>
              <div class="modal-body">
			  <div class="row">
				<div class="col-lg-6">
					<div class="form-group">
					  <label>Full Name</label>
					  <input type="text" class="form-control" name="name"  id="name" placeholder="Name">
					</div>
					<div class="form-group">
					  <label>Email</label>
					  <input type="email"  class="form-control" name="email" id="email"  placeholder="Email">
					</div>
					<div class="form-group">
					  <label>Password</label>
					  <input type="password"  class="form-control" name="password" id="password"  placeholder="Password">
					</div>
				</div>
				<div class="col-lg-6">
					<div class="form-group">
					  <label>Phone Number</label>
					  <input type="text"  class="form-control" name="phones" id="phones"  placeholder="Phone Number">
					</div>
					<div class="form-group">
					  <label>Role</label>
					  <select name="role" id="role" class="form-control" required>
					  <option value="Administrator">Administrator</option>
					  <option value="Staff">Staff</option>
					  </select>
					</div>
					<div class="form-group">
					  <label>Status</label>
					  <select name="status" id="status" class="form-control" required>
					  <option value="Active">Active</option>
					  <option value="Inactive">Inactive</option>
					  </select>
					</div>
				</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<p><b>Module Permissions</b></p>
						<div class="col-lg-6">
							<div class="maincheckbox">
							</div>
						</div>
					</div>
				</div>
              <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="save"/>Save</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              </div>
            </form>
          </div>
        </div>
      </div>
</div>	  
 <!--edit data -->
<div id="edit" class="modal fade" role="dialog">
        <div class="modal-dialog">
          <div class="modal-content">
            <form action="" method="post" id="form">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit User</h4>
              </div>
			  <div id="message" style="display:none;" class="alert alert-warning">All field is required</div>
              <div class="modal-body">
				<div class="row">
				<div class="col-lg-6">
					<div class="form-group">
					  <label>Full Name</label>
					  <input type="text" class="form-control" name="editname"  id="editname" placeholder="Name">
					</div>
					<div class="form-group">
					  <label>Email</label>
					  <input type="email"  class="form-control" name="editemail" id="editemail"  placeholder="Email">
					</div>
					<div class="form-group">
					  <label>Password</label>
					  <input type="password"  class="form-control" name="editpassword" id="editpassword"  placeholder="Password">
					  <p class="text-help">Note: if you populate this field, password will be changed.</p>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="form-group">
					  <label>Phone Number</label>
					  <input type="text"  class="form-control" name="editphone" id="editphone"  placeholder="Phone Number">
					</div>
					<div class="form-group">
					  <label>Role</label>
					  <select name="editrole" id="editrole" class="form-control" required>
					  <option value="Administrator">Administrator</option>
					  <option value="Staff">Staff</option>
					  </select>
					</div>
					<div class="form-group">
					  <label>Status</label>
					  <select name="editstatus" id="editstatus" class="form-control" required>
					  <option value="Active">Active</option>
					  <option value="Inactive">Inactive</option>
					  </select>
					</div>
				</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<p><b>Module Permissions</b></p>
						<div class="col-lg-6">
							<div class="maincheckbox2">
							</div>
						</div>
					</div>
				</div>
              </div>
              <div class="modal-footer">
				<input type="hidden" value="" name="id" id="idedit"/>
                <input type="submit" class="btn btn-primary" id="saveedit" value="Save"/>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              </div>
            </form>
          </div>
        </div>
      </div> 

</div>	  
<script>


$(document).ready(function() {
	$.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
	});
   
	//counting users
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/totalusers')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html;
			$("#totalusers").html(objs.totaluser);
			
			$("#activeuser").html(objs.activeuser[0].user_count);
			
			if(objs.inactiveuser.length > 0){
				$("#inactiveuser").html(objs.inactiveuser[0].user_count);
			}else{
				$("#inactiveuser").html('0');
			}
			
        },
    });
	
	//get role/menu access
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getrole')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html;
			var options='';
			var options2='';
			$.each(objs, function(index, object) {
					options += '<div class="checkbox">'+
						  '<label><input type="checkbox" id="chk'+object.roleid+'" class="access" name="access[]" id="access" value="' + object.roleid + '">'+object.name+'</label>'+
							'</div>';
				});
				$('.maincheckbox').html(options);
				
			$.each(objs, function(index, object) {
					options2 += '<div class="checkbox">'+
						  '<label><input type="checkbox" id="echk'+object.roleid+'" class="access" name="access[]" id="access" value="' + object.roleid + '">'+object.name+'</label>'+
							'</div>';
				});
				$('.maincheckbox2').html(options2);	
        },
    });
   
   
	//populate data to table
    $('#data').DataTable( {
			
			processing: true,
			serverSide: true,
            ajax: "<?php echo e(url('settings/getuser')); ?>",
			columns: [
				{ data: 'userid', orderable: false, searchable: false, visible: false},
				{ data: 'name'},
				{data: 'email'},
				{ data: 'role'},
				{ data: 'phone'},
				{ data: 'status'},
				{data: 'action',  orderable: false, searchable: false}
			],
			dom: 'Bfrtipl',
			buttons: [
				{
					extend: 'copy',
					text:   'Copy <i class="fa fa-files-o"></i>',
					title: 'Users List',
					className: 'btn btn-sm btn-fill btn-info',
					exportOptions: {
						columns: [ 1, 2, 3, 4, 5 ]
					}
				}, 
				{
					extend:'csv',
					text:   'CSV <i class="fa fa-file-excel-o"></i>',
					title: 'Users List',
					className: 'btn btn-sm btn-fill btn-info',
					exportOptions: {
						columns: [ 1, 2, 3, 4, 5 ]
					}
				},
				{
					extend:'pdf',
					text:   'PDF <i class="fa fa-file-pdf-o"></i>',
					title: 'Users List',
					orientation:'landscape',
					className: 'btn btn-sm btn-fill btn-info',
					exportOptions: {
						columns: [ 1, 2, 3, 4, 5 ]
					},
					customize : function(doc){
						doc.styles.tableHeader.alignment = 'left';
						doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
					}
				},
				{
					extend:'print',
					className: 'btn btn-sm btn-fill btn-info',
					title: 'Users List',
					text:   'Print <i class="fa fa-print"></i>',
					exportOptions: {
						columns: [ 1, 2, 3, 4, 5 ]
					}
				}
			]
    } );
	
	//dosave
	$("#save").click(function(e){
		
		var name=$("#name").val();
		var email=$("#email").val();
		var password=$("#password").val();
		var phone=$("#phones").val();
		var role=$("#role").val();
		var status=$("#status").val();
		//var dataroles  =  'datarole[]';
		var dataroles   = []; 	
		$("input:checked").each(function() {
		   dataroles.push($(this).val());
		});
		
		if(name =='' || email =='' || role =='' || status =='' || password==''){
			$("#message").css({'display':"block"});
			return false;
		}
		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('settings/saveuser')); ?>",
            data: {name:name,password:password,email:email,phone:phone,role:role,status:status,dataroles},
            dataType: "JSON",
            success: function(data) {
				//$("#message").html(data);
				$("#message2").css({'display':"block"});
				$('#add').modal('hide');
				window.setTimeout(function(){location.reload()},2000)
            }
		});
		
		/*$.ajax({
			type: "POST",
            url: "<?php echo e(url('settings/insertrole')); ?>",
            data: datarole,
            dataType: "JSON",
            success: function(data) {
				//$("#message").html(data);
				$("#message2").css({'display':"block"});
				$('#add').modal('hide');
				window.setTimeout(function(){location.reload()},2000)
            }
		});*/
	});
	//dosave edit
	$("#saveedit").click(function(e){
		
		var name = $("#editname").val();
		var email = $("#editemail").val();
		var phone = $("#editphone").val();
		var status = $("#editstatus").val();
		var role = $("#editrole").val();
		var password = $("#editpassword").val();
		var id=$("#idedit").val();
		var dataroles   = []; 	
		$("input:checked").each(function() {
		   dataroles.push($(this).val());
		});
		if(name =='' || email =='' || role =='' || status ==''){
			$("#message").css({'display':"block"});
			return false;
		}
		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('settings/saveprofilebyadmin')); ?>",
            data: {id:id,name:name,email:email,phone:phone,password:password,status:status,role:role,dataroles},
            dataType: "JSON",
            success: function(data) {
				//$("#message").html(data);
				$("#message4").css({'display':"block"});
				$('#edit').modal('hide');
				window.setTimeout(function(){location.reload()},2000)
            }
		});
	});
	
} );
	//delete function
	$("#dodelete").click(function(e){
		
		var id=$("#iddelete").val();

		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('settings/deleteuser')); ?>",
            data: {iddelete:id},
            dataType: "JSON",
            success: function(data) {
				//$("#message").html(data);
				$("#message3").css({'display':"block"});
				$('#delete').modal('hide');
				window.setTimeout(function(){location.reload()},2000)
            }
		});
	});
	

		//for get id to modal

		$('#delete').on('show.bs.modal', function(e) {
            var $modal = $(this),
            id = $(e.relatedTarget).attr('customdata');
            $("#iddelete").val(id);
        });
		
		//for get id to modal edit

		$('#edit').on('show.bs.modal', function(e) {
            var $modal = $(this),
            id = $(e.relatedTarget).attr('customdata');
            
			$.ajax({
				type: "POST",
				url: "<?php echo e(url('settings/getuseredit')); ?>",
				data: {id:id},
				dataType: "JSON",
				success: function(data) {
					var objs =data.role;
					$("#idedit").val(id);
					$("#editname").val(data.user[0].name);
					$("#editemail").val(data.user[0].email);
					$("#editphone").val(data.user[0].phone);
					$("#editstatus").val(data.user[0].status);
					$("#editrole").val(data.user[0].role);
					$.each(objs, function(index, object) {						
							$('#echk'+object.roleid).each(function(){
								if(this.value = object.roleid) {
									$('#echk'+object.roleid).prop( "checked", true );
								}
							});
					});
				}
			});
		
		
        });
		

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>