<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Money Pro Management</title>

	  <!-- Bootstrap core CSS     -->
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet" />

    <!--  Paper Dashboard core CSS    -->
    <link href="<?php echo e(asset('css/paper-dashboard.css')); ?>" rel="stylesheet"/>
	
	<!--  Datatables    -->
	<link href="<?php echo e(asset('plugin/datatables/css/dataTables.bootstrap.css')); ?>" rel="stylesheet"/>

    <!--  Fonts and icons     -->
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css" rel="stylesheet">
    <link href='https://fonts.googleapis.com/css?family=Muli:400,300' rel='stylesheet' type='text/css'>
    <link href="<?php echo e(asset('css/themify-icons.css')); ?>"  rel="stylesheet">
	<link href="<?php echo e(asset('plugin/datatables/css/buttons.dataTables.min.css')); ?>"  rel="stylesheet">
	<link href="<?php echo e(asset('plugin/datatables/css/buttons.bootstrap.min.css')); ?>"  rel="stylesheet">
	<link href="<?php echo e(asset('css/datepicker.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('plugin/morris/morris.css')); ?>"  rel="stylesheet">
	<link href="<?php echo e(asset('plugin/fullcalendar/fullcalendar.css')); ?>"  rel="stylesheet">
	<!-- Scripts -->

    <script src="<?php echo e(asset('js/jquery.js')); ?>"></script>
	<script src="<?php echo e(asset('js/jquery-ui.min.js')); ?>"></script>
	<script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/fullcalendar/lib/moment.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/fullcalendar/fullcalendar.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/jquery.dataTables.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/dataTables.bootstrap.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/dataTables.buttons.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/buttons.html5.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/buttons.print.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/buttons.bootstrap.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/pdfmake.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/datatables/js/vfs_fonts.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/chartjs/chart.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/morris/morris.min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/jscolor/jscolor.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/morris/raphael-min.js')); ?>"></script>
	<script src="<?php echo e(asset('plugin/chartjs/Chart.PieceLabel.js')); ?>"></script>




</head>
<body>
 
        
<div class="sidebar">	
<div class=" sidebar-wrapper">
    <div class="logo">
                <img class="logoimg" src="" style="width:200px"/>
        </a>
    </div>
    <ul class="nav">
            <li class="<?php echo e(Request::is( 'home') ? 'active' : ''); ?>">
                <a href="<?php echo e(URL::to( 'home')); ?>" >
                    <i class="ti-panel"></i>
					<p>Dashboard</p>
                </a>
            </li>
			 <li class="<?php echo e(Request::is( 'transaction') ? 'active' : ''); ?>">
                 <a href="<?php echo e(URL::to( 'transaction')); ?>" >
                    <i class="ti-direction-alt"></i>
					<p>Transactions</p>
                </a>
            </li>
			 <li class="<?php echo e(Request::is( 'income') ? 'active' : ''); ?>">
                 <a href="<?php echo e(URL::to( 'income')); ?>" >
                    <i class="ti-stats-up"></i>
					<p>Income</p>
                </a>
            </li>
			 <li class="<?php echo e(Request::is( 'expense') ? 'active' : ''); ?>">
                 <a href="<?php echo e(URL::to( 'expense')); ?>" >
                    <i class="ti-stats-down"></i>
					<p>Expense</p>
                </a>
            </li>
			 <li class="<?php echo e(Request::is( 'account') ? 'active' : ''); ?>">
                <a href="<?php echo e(URL::to( 'account')); ?>" >
                    <i class="ti-wallet"></i>
					<p>Accounts</p>
                </a>
            </li>
			 <li class="<?php echo e(Request::is( 'budget') ? 'active' : ''); ?>">
                 <a href="<?php echo e(URL::to( 'budget')); ?>" >
                    <i class="ti-package"></i>
					<p>Track Budget </p>
                </a>
            </li>
			 <li class="<?php echo e(Request::is( 'goals') ? 'active' : ''); ?>">
                <a href="<?php echo e(URL::to( 'goals')); ?>" >
                    <i class="ti-cup"></i>
					<p>Set Goals</p>
                </a>
            </li>
			<li class="<?php echo e(Request::is( 'calendar') ? 'active' : ''); ?>">
                <a href="<?php echo e(URL::to( 'calendar')); ?>" >
                    <i class="ti-calendar"></i>
					<p>Calendar</p>
                </a>
            </li>
			 <li class="<?php echo e(Request::is( 'reports/allreports') ? 'active' : ''); ?>">
                <a href="<?php echo e(URL::to( 'reports/allreports')); ?>" >
                    <i class="ti-pie-chart"></i>
					<p>Reports</p>
                </a>
            </li>
			 <li>
                 <a data-toggle="collapse" href="#category" class="<?php echo e(Request::is( 'incomecategory') || Request::is( 'expensecategory') ? '' : 'collapsed'); ?>" aria-expanded="<?php echo e(Request::is( 'incomecategory') || Request::is( 'expensecategory') ? 'true' : 'false'); ?>">
                    <i class="ti-flag-alt"></i>
                    <p>Category<b class="caret"></b></p>
                </a>
				<div class="<?php echo e(Request::is( 'incomecategory') || Request::is( 'expensecategory') ? 'collapse in' : 'collapse'); ?>" id="category" aria-expanded="<?php echo e(Request::is( 'incomecategory') || Request::is( 'expensecategory') ? 'true' : 'false'); ?>" style="<?php echo e(Request::is( 'incomecategory') || Request::is( 'expensecategory') ? '' : 'height: 0px;'); ?>">
                    <ul class="nav">
                          <li class="<?php echo e(Request::is( 'incomecategory') ? 'active' : ''); ?>">
                            <a href="<?php echo e(URL::to( 'incomecategory')); ?>" >
                                <span class="sidebar-mini"><i class="ti-angle-right"></i></span>
                                <span class="sidebar-normal">Income Categories</span>
                            </a>
                        </li>
						<li class="<?php echo e(Request::is( 'expensecategory') ? 'active' : ''); ?>">
                           <a href="<?php echo e(URL::to( 'expensecategory')); ?>" >
                                <span class="sidebar-mini"><i class="ti-angle-right"></i></span>
                                <span class="sidebar-normal">Expense Categories</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>


			 <li>
                 <a data-toggle="collapse" href="#settings" class="<?php echo e(Request::is( 'settings/profile') || Request::is( 'settings/allusers') || Request::is( 'settings/application') ? '' : 'collapsed'); ?>" aria-expanded="<?php echo e(Request::is( 'settings/profile') || Request::is( 'settings/allusers') || Request::is( 'settings/application') ? 'true' : 'false'); ?>">
                    <i class="ti-settings"></i>
                    <p>Settings<b class="caret"></b></p>
                </a>
				<div class="<?php echo e(Request::is( 'settings/profile') || Request::is( 'settings/allusers') || Request::is( 'settings/application') ? 'collapse in' : 'collapse'); ?>" id="settings" aria-expanded="<?php echo e(Request::is( 'settings/profile') || Request::is( 'settings/allusers') || Request::is( 'settings/application') ? 'true' : 'false'); ?>" style="<?php echo e(Request::is( 'settings/profile') || Request::is( 'settings/allusers') || Request::is( 'settings/application') ? '' : 'height: 0px;'); ?>">
                    <ul class="nav">
                        <li class="<?php echo e(Request::is( 'settings/profile') ? 'active' : ''); ?>">
                            <a href="<?php echo e(URL::to( 'settings/profile')); ?>" >
                                <span class="sidebar-mini"><i class="ti-angle-right"></i></span>
                                <span class="sidebar-normal">Profile Settings</span>
                            </a>
                        </li>
						<li class="<?php echo e(Request::is( 'settings/allusers') ? 'active' : ''); ?>">
                            <a href="<?php echo e(URL::to( 'settings/allusers')); ?>" >
                                <span class="sidebar-mini"><i class="ti-angle-right"></i></span>
                                <span class="sidebar-normal">User Role</span>
                            </a>
                        </li>
						 <li>
                           <li class="<?php echo e(Request::is( 'settings/application') ? 'active' : ''); ?>">
                            <a href="<?php echo e(URL::to( 'settings/application')); ?>" >
                                <span class="sidebar-mini"><i class="ti-angle-right"></i></span>
                                <span class="sidebar-normal">Application Settings</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
    </ul>
</div>
</div>
<div class="main-panel">
<nav class="navbar navbar-default">
    <div class="container-fluid">
        <div class="navbar-header">
            <button class="navbar-toggle" type="button">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar bar1"></span>
                <span class="icon-bar bar2"></span>
                <span class="icon-bar bar3"></span>
            </button>
            <a class="navbar-brand" href="#"></a>
        </div>
        <div class="collapse navbar-collapse">
            <ul class="nav navbar-nav navbar-right">
				<li>
                    <a href="#">
                        <i class="ti-user"></i>
                        <p>Welcome, <?php echo e(Auth::user()->name); ?></p>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(URL::to( 'settings/profile')); ?>">
                        <i class="ti-settings"></i>
                        <p>Profile Setting</p>
                    </a>
                </li>
				<li>
                    <a href="<?php echo e(URL::to( 'logout')); ?>">
                        <i class="ti-back-right"></i>
                        <p>Logout</p>
                    </a>
                </li>
            </ul>

        </div>
    </div>
</nav>

        <?php echo $__env->yieldContent('content'); ?>
<footer class="footer">
    <div class="container-fluid">
        
        <div class="copyright pull-right">
            © 2017, made with <i class="fa fa-heart heart"></i> by <span id="company"></span></a>
        </div>
    </div>
</footer>
</div>

    
</body>
</html>
<script>
$(document).ready(function() {
$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$("#company").html(objs[0].company);
			$("#city").val(objs[0].city);
			$("#currency").val(objs[0].currency);
			$("#phone").val(objs[0].phone);
			$("#address").val(objs[0].address);
			$("#website").val(objs[0].website);
			$(".logoimg").attr("src",html.logo);

        },
    });
});	
</script>
