<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
 <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Money Pro Management</title>

	  <!-- Bootstrap core CSS     -->
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet" />
	<link href="<?php echo e(asset('css/login.css')); ?>" rel="stylesheet" />

    <!--  Paper Dashboard core CSS    -->
    <link href="<?php echo e(asset('css/paper-dashboard.css')); ?>" rel="stylesheet"/>
	<script src="<?php echo e(asset('js/jquery.js')); ?>"></script>
	<script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>

<body class="login-background">
<div class="container">
    <div class="row">
        <div class="col-md-6 col-md-offset-3" style="margin-top:15%">
            <div class="panel panel-default">
				<img src="../upload/line.png"/>
               <div class="header">
						<div class="row">
							<div class="col-lg-12">
							<h3 class="title text-center">Login</h3>
							</div>
						</div>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" method="POST" action="<?php echo e(url('login')); ?>">
                        <?php echo e(csrf_field()); ?>


                        <div class="form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                           
                            <div class="col-md-9 col-md-offset-2">
							
                                <?php if($errors->has('email')): ?>
                                    <span class="help-block text-danger">
                                        <strong><?php echo e($errors->first('email')); ?></strong>
                                    </span>
                                <?php endif; ?>
								 <label for="email" class="control-label">Email</label>
                                <input id="email" type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" required autofocus>

                            </div>
                        </div>

                        <div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
                           

                            <div class="col-md-9 col-md-offset-2">
								  <?php if($errors->has('password')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('password')); ?></strong>
                                    </span>
                                <?php endif; ?>
								 <label for="password" class="control-label">Password</label>
                                <input id="password" type="password" class="form-control" name="password" required>

                              
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-6 col-md-offset-2">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>> Remember Me
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-md-8 col-md-offset-2">
                                <button type="submit" class="btn btn-fill btn-primary">
                                    Login
                                </button>

                                <a class="btn btn-link" href="<?php echo e(url('password/request')); ?>">
                                    Forgot Your Password?
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
