 
<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
		<div class="row">
			<div class="col-lg-12 col-md-11">
				 <div class="card">
					<div class="header">
						<h4 class="title">Account Transaction Reports</h4>
					</div>
					<div class="content">
						<div class="row">
							<form action="" method="POST" id="form">
							<div class="col-lg-3">
							 <label>Account</label>
							 <select id="account" class="form-control" name="account" required>
							 <option value="">Select an Account</option>
							 </select>
							</div>
							
							<div class="col-lg-3">
							<label for="date" class="control-label"> 
									From Date</label>
									<div  class="input-group date" data-date-format="mm-dd-yyyy">
										<input id="fromdate" name="fromdate" class="form-control" type="text" value=""/>
										<span class="input-group-addon" style="border: 1px solid #cecece;"><i class="fa fa-calendar"></i></span>
									</div>
							</div>
							<div class="col-lg-3">
							<label for="date" class="control-label"> 
									To Date</label>
									<div  class="input-group date" data-date-format="mm-dd-yyyy">
										<input id="todate" name="todate" class="form-control" type="text" value=""/>
										<span class="input-group-addon" style="border: 1px solid #cecece;"><i class="fa fa-calendar"></i></span>
									</div>
							</div>
							<div class="col-lg-2">
									<label>.</label> 
									<button type="submit" class="form-control btn btn-sm btn-fill btn-info"><i class="ti-search"></i> Search</button>
								</div>
						</div>							

								

							</form>
						
					</div>
				 </div>
			</div> 
		</div>
		
        <div class="row">

            <div class="col-lg-12 col-md-11">
                <div class="card">
                    <div class="header">
						<h4 class="title">Account Transaction Reports</h4>
                    </div>
                    <div class="content">
					
						<table id="data" class="table table-striped table-bordered"  cellspacing="0" width="100%">
							<thead>
								<tr>
									<th>Name</th>
									<th>Category</th>
									<th>Sub Category</th>
									<th>Reference</th>
									<th>Description</th>
									<th>Date</th>	
									<th>Income</th>
									<th>Expense</th>										
								</tr>
							</thead>
							<tfoot>
								<tr>
									<th>Name</th>
									<th>Category</th>
									<th>Sub Category</th>
									<th>Reference</th>
									<th>Description</th>
									<th>Date</th>
									<th>Income</th>
									<th>Expense</th>
								</tr>
							</tfoot>
							<tbody>
							
							</tbody>
						</table>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
			<div class="col-lg-12">
				<div class="card">
					<div class="header">
						<div class="pull-left">
							<h5><b>Account Chart</b></h5>
						</div>
						<div class="pull-right">
							<div class="text-danger">
								<b><span></span></b><br/>
								<small></small>
							</div>
						</div>
					</div>
					<div class="content">
					<input type="hidden" class="currency"/>
							<canvas id="accountbalance"></canvas>
					</div>
				</div>
			</div>
		</div>
    </div>
</div>	


<script>


$(document).ready(function() {
	$.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
	});
	


	//get currency
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$(".currency").val(objs[0].currency);
        },
    });
   
	//get account
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('account/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var options;
			var objs = html.data;
			$.each(objs, function(index, object) {
					options += '<option value="' + object.accountid + '">' + object.name + '</option>';
				});
				$('#form #account').html(options);
        },
    });
	
	
	
	//get data
    var table = $('#data').DataTable( {
			
			processing: true,
			serverSide: true,
			bFilter : false,
            ajax: {
				url : "<?php echo e(url('reports/getaccounttransaction')); ?>",
				data: function (d) {
					d.account = $('select[name=account]').val();
					d.fromdate = $('input[name=fromdate]').val();
					d.todate = $('input[name=todate]').val();
				},
			},
			columns: [
				{ data: 'name', name:'name'},
				{ data: 'category', name:'category'},
				{ data: 'subcategory', name:'subcategory'},
				{ data: 'reference', name:'reference'},				
				{ data: 'description', name:'description'},		
				{ data: 'transactiondate', name:'transactiondate'},
				{ data: 'income', name:'income'},
				{ data: 'expense', name:'expense'}
			],
			dom: 'Bfrtip',

			buttons: [
				{
					extend: 'copy',
					text:   'Copy <i class="fa fa-files-o"></i>',
					title: 'Account Transaction Report',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5, 6, 7]
					}
				}, 
				{
					extend:'csv',
					text:   'CSV <i class="fa fa-file-excel-o"></i>',
					title: 'Account Transaction Report',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5, 6, 7 ]
					}
				},
				{
					extend:'pdf',
					text:   'PDF <i class="fa fa-file-pdf-o"></i>',
					title: 'Account Transaction Report',
					className: 'btn btn-sm btn-fill btn-info ',
					orientation:'landscape',
					exportOptions: {
						columns: [0, 1, 2, 3, 4, 5, 6, 7]
					},
					customize : function(doc){
						doc.styles.tableHeader.alignment = 'left';
						doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
					}
				},
				{
					extend:'print',
					title: 'Account Transaction Report',
					text:   'Print <i class="fa fa-print"></i>',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5, 6, 7 ]
					}
				}
			]
    } );
	//do search
	$('#form').on('submit', function(e) {
        table.draw();
        e.preventDefault();
    });
	
	//accountbalance
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/accountbalance')); ?>",
        dataType: "json",
        success: function (data) {
			var label = [];
			var amount = [];			
			for(var i in data) {
				label.push(data[i].name);
				amount.push(data[i].balance);
			}
			
			var caccountbalance = document.getElementById("accountbalance");
			var accountbalance = new Chart(caccountbalance, {
				type: 'bar',
				legendPosition: 'bottom',
				data: {
					labels: label,
					datasets: [
					{
						label: 'Account',
						data: amount,
						backgroundColor: '#A5DFDF',
						borderColor: '#A5DFDF',
						borderWidth: 1
					}
					]
				},
				options: {
					legend: {
						   position: 'bottom',
					},
					tooltips: {
					  callbacks: {
						title: function(tooltipItem, data) {
						  return data['labels'][tooltipItem[0]['index']];
						},
						label: function(tooltipItem, data) {
						  return $('.currency').val()+data['datasets'][0]['data'][tooltipItem['index']].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
						}
					  },
					}
				}
			});
		}
	});	
	
		
} );

	$('#fromdate').datepicker({
            autoclose: true,
            dateFormat: "yy-mm-dd",
            todayHighlight: true
        });	
	$('#todate').datepicker({
            autoclose: true,
            dateFormat: "yy-mm-dd",
            todayHighlight: true
        });	

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>