<?php $__env->startSection('content'); ?>
<div class="content">
		<div class="row">
			
			<div class="col-lg-3 col-sm-6">
				<div class="card background-blue color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big icon-warning text-center">
                                    <i class="ti-stats-up"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div class="numbers">
                                    <p>Income</p>
                                    <span class="currency"></span><span class="incomethismonth"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            <div class="stats">
                                <i class="ti-reload color-white"></i> <span class="color-white">This Month <span>(<?php echo date("F")?>)</span></span>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
			<div class="col-lg-3 col-sm-6">
				<div class="card background-red color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big icon-warning text-center">
                                    <i class="ti-stats-down"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div class="numbers">
                                    <p>Expense</p>
                                    <span class="currency"></span><span class="expensemonth"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            <div class="stats">
                                <i class="ti-reload color-white"></i> <span class="color-white">This Month <span>(<?php echo date("F")?>)</span></span>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
			<div class="col-lg-3 col-sm-6">
				<div class="card background-blue color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big icon-warning text-center">
                                    <i class="ti-stats-up"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div class="numbers">
                                    <p>Income</p>
                                    <span class="currency"></span><span class="incomeday"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            <div class="stats color-white">
                                <i class="ti-reload color-white"></i> <span class="color-white">Today <span>(<?php echo date("d M Y")?>)</span></span>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
			<div class="col-lg-3 col-sm-6">
				<div class="card background-red color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big icon-warning text-center">
                                    <i class="ti-stats-down"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div class="numbers">
                                    <p>Expense</p>
                                    <span class="currency"></span><span class="expenseday"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            <div class="stats">
                                <i class="ti-reload color-white"></i> <span class="color-white">Today <span>(<?php echo date("d M Y")?>)</span></span>
                            </div>
                        </div>
                    </div>
                </div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-7">
                <div class="card">
                    <div class="header">
                        <h4 class="title">Income Vs Expense <?php echo date("Y");?><h4>
                        <p class="category">Monitoring Income and Expense this month</p>
						<input type="hidden" class="currency"/>
                    </div>
                    <div class="content">
                        <canvas id="incomevsexpense" height="100"></canvas>
                        <div class="footer">
                            <hr>
                            <div class="stats">  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			<div class="col-md-5">
                <div class="card">
                    <div class="header">
                        <h4 class="title">Account Balances <?php echo date("Y");?><h4>
                        <p class="category">Monitoring Account Balances this month</p>
                    </div>
                    <div class="content">
                        <canvas id="accountbalance" height="100"></canvas>
                        <div class="footer">
                            <hr>
                            <div class="stats">  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		</div>
		<div class="row">
			<div class="col-md-4">
                <div class="card">
                    <div class="header">
                        <h5 class="title">Expense by Category (<?php echo date("F Y");?>)<h5>
                        <p class="category">Monitoring Expense this month</p>
						<input type="hidden" class="currency"/>
                    </div>
                    <div class="content">
                        <canvas id="expensebycategory" height="200"></canvas>
                        <div class="footer">
                            <hr>
                            <div class="stats">  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			<div class="col-md-4">
                <div class="card">
                    <div class="header">
                        <h5 class="title">Income by Category (<?php echo date("F Y");?>)<h5>
                        <p class="category">Monitoring Income this month</p>
                    </div>	
                    <div class="content">
                        <canvas id="incomebycategory" height="200"></canvas>
                        <div class="footer">
                            <hr>
                            <div class="stats">  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			<div class="col-md-4">
			
                <div class="card">
                    <div class="header">
                        <h5 class="title">Budget (<?php echo date("F Y");?>)<h5>
                        <p class="category">Monitoring Budget this month</p>
                    </div>
					
                    <div class="content">
							 <canvas id="budgethismonth" height="200"></canvas>
						<div class="footer">
						<hr>
							<div class="stats">  
								<i class="ti-plus"></i>
							<a href ="<?php echo e(url('budget/index')); ?>" class="text-primary">More</a>
                            </div>
						</div>	
                    </div>
                </div>
            </div>
		</div>
		<div class="row">
			<div class="col-md-6">
                <div class="card">
                    <div class="header">
                        <h5 class="title">Latest Income<h5>
                        <p class="category">Monitoring latest Income this month</p>
                    </div>	
                    <div class="content">
						<div class="table-responsive">
							<table id="dataincome" class="table table-striped" cellspacing="0" width="100%">
								<thead>
									<tr>
										<th>Name</th>
										<th>Account</th>
										<th>Amount</th>
										<th>Date</th>									
									</tr>
								</thead>
								<tfoot>
									<tr>
										<th>Name</th>
										<th>Account</th>
										<th>Amount</th>
										<th>Date</th>	
									</tr>
								</tfoot>
								<tbody>
								
								</tbody>
							</table>
						</div>	
                        <div class="footer">
                            <hr>
                            <div class="stats">  
								<i class="ti-plus"></i>
								<a href ="<?php echo e(url('income/index')); ?>" class="text-primary">More</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			<div class="col-md-6">
                <div class="card">
                    <div class="header">
                        <h5 class="title">Latest Expense<h5>
                        <p class="category">Monitoring latest Expense this month</p>
                    </div>	
                    <div class="content">
                        <div class="table-responsive">
							<table id="dataexpense" class="table table-striped" cellspacing="0" width="100%">
								<thead>
									<tr>
										<th>Name</th>
										<th>Account</th>
										<th>Amount</th>
										<th>Date</th>									
									</tr>
								</thead>
								<tfoot>
									<tr>
										<th>Name</th>
										<th>Account</th>
										<th>Amount</th>
										<th>Date</th>	
									</tr>
								</tfoot>
								<tbody>
								
								</tbody>
							</table>
						</div>	
                        <div class="footer">
                            <hr>
                            <div class="stats">  
								<i class="ti-plus"></i>
								<a href ="<?php echo e(url('expense/index')); ?>" class="text-primary">More</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		</div>
		<div class="row">
			<div class="col-md-8">
                <div class="card">
                    <div class="header">
                        <h5 class="title">Calendar<h5>
                        <p class="category">Monitoring latest Income/Expense this month</p>
                    </div>	
                    <div class="content">
                       <div id="mycalendar"></div>
                        <div class="footer">
                            <hr>
                            <div class="stats">  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			<div class="col-md-4">
                <div class="card">
                    <div class="header">
                        <h5 class="title">Goals Summary<h5>
                        <p class="category">Monitoring Latest Goals</p>
                    </div>	
                    <div class="content">
                       <div class="goalsprogress"></div>
                        <div class="footer">
                            <hr>
                            <div class="stats">  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		</div>

</div>	  
<script>


$(document).ready(function() {
	$.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
	});
	
	//random color
	function getRandomColor() {
        var letters = '0123456789ABCDEF'.split('');
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }
	
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/budgetlist')); ?>",
        dataType: "json",
        success: function (data) {
			/*jQuery.each( dt, function( i, val ) {
				$(".progresscat").append('<b>'+dt[i].name+'</b><br/>'+dt[i].remaining+'<br/><br/>');
			});*/
			var label = [];
			var amount = [];
			var color = [];
			
			for(var i in data) {
				label.push(data[i].name);
				amount.push(data[i].amount);
				color.push(data[i].color);
			}
			
			var cbudget = document.getElementById("budgethismonth");
			var budgethismonth = new Chart(cbudget, {
				type: 'doughnut',
				legendPosition: 'bottom',
				data: {
					labels: label,
					datasets: [
					{
						label: 'Category',
						data: amount,
						backgroundColor: color,
						borderColor: color,
						borderWidth: 1
					}
					]
				},
				options: {
					legend: {
						   position: 'bottom',
					},
					tooltips: {
					  callbacks: {
						title: function(tooltipItem, data) {
						  return data['labels'][tooltipItem[0]['index']];
						},
						label: function(tooltipItem, data) {
						  return $('.currency').val()+data['datasets'][0]['data'][tooltipItem['index']].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
						},
						afterLabel: function(tooltipItem, data) {
						  var dataset = data['datasets'][0];
						  var percent = Math.round((dataset['data'][tooltipItem['index']] / dataset["_meta"][0]['total']) * 100)
						  return '(' + percent + '%)';
						}
					  },
					}
				}
			});	
			
		}
	});
	
	//load calendar
	 $('#mycalendar').fullCalendar({
		allDayDefault: true,
		header:{
			left: 'title',
			right: 'prev,next today,month'
		},
		eventSources: [
			
			{
			  url: "<?php echo e(url('income/getdatacalendar')); ?>",
			  color: '#82B1FF',
			  textColor: 'white'
			},
			{
			  url: "<?php echo e(url('expense/getdatacalendar')); ?>",
			  color: '#F44336',
			  textColor: 'white'
			}
		],
		eventRender: function(event, element) {
		
			element.find(".fc-content").remove();
			element.find(".fc-event-time").remove();
			var new_description =   
				event.title + '<br/>'
				+  event.amount + '<br/>';
				element.append(new_description);
		}
    });
	
	
	//accountbalance
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/accountbalance')); ?>",
        dataType: "json",
        success: function (data) {
			var label = [];
			var amount = [];
			var color = [];
			for(var i in data) {
				label.push(data[i].name);
				amount.push(data[i].balance);
				color.push(getRandomColor());
			}
			
			var caccountbalance = document.getElementById("accountbalance");
			var accountbalance = new Chart(caccountbalance, {
				type: 'bar',
				legendPosition: 'bottom',
				data: {
					labels: label,
					datasets: [
					{
						label: 'Account',
						data: amount,
						backgroundColor: color,
						borderColor: color,
						borderWidth: 1
					}
					]
				},
				options: {
					legend: {
						   position: 'bottom',
					},
					tooltips: {
					  callbacks: {
						title: function(tooltipItem, data) {
						  return data['labels'][tooltipItem[0]['index']];
						},
						label: function(tooltipItem, data) {
						  return $('.currency').val()+data['datasets'][0]['data'][tooltipItem['index']].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
						}
					  },
					}
				}
			});
		}
	});	
	
	
	//expensecategory
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/expensebycategory')); ?>",
        dataType: "json",
        success: function (data) {
			var label = [];
			var amount = [];
			var color = [];
			
			for(var i in data) {
				label.push(data[i].category);
				amount.push(data[i].amount);
				color.push(data[i].color);
			}
			
			var cexpensecategory = document.getElementById("expensebycategory");
			var expensecategory = new Chart(cexpensecategory, {
				type: 'doughnut',
				legendPosition: 'bottom',
				data: {
					labels: label,
					datasets: [
					{
						label: 'Category',
						data: amount,
						backgroundColor: color,
						borderColor: color,
						borderWidth: 1
					}
					]
				},
				options: {
					legend: {
						   position: 'bottom',
					},
					tooltips: {
					  callbacks: {
						title: function(tooltipItem, data) {
						  return data['labels'][tooltipItem[0]['index']];
						},
						label: function(tooltipItem, data) {
						  return $('.currency').val()+data['datasets'][0]['data'][tooltipItem['index']].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
						},
						afterLabel: function(tooltipItem, data) {
						  var dataset = data['datasets'][0];
						  //var percent = Math.round((dataset['data'][tooltipItem['index']] / dataset["_meta"][0]['total']) * 100)
						  //return '(' + percent + '%)';
						}
					  },
					}
				}
			});
		}
	});	
	
	//incomecategory
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/incomebycategory')); ?>",
        dataType: "json",
        success: function (data) {
			var label = [];
			var amount = [];
			var color = [];
			
			for(var i in data) {
				label.push(data[i].category);
				amount.push(data[i].amount);
				color.push(data[i].color);
			}
			
			var cincomebycategory = document.getElementById("incomebycategory");
			var incomebycategory = new Chart(cincomebycategory, {
				type: 'doughnut',
				legendPosition: 'bottom',
				data: {
					labels: label,
					datasets: [
					{
						label: 'Category',
						data: amount,
						backgroundColor: color,
						borderColor: color,
						borderWidth: 1
					}
					]
				},
				options: {
					legend: {
						   position: 'bottom',
					},
					tooltips: {
					  callbacks: {
						title: function(tooltipItem, data) {
						  return data['labels'][tooltipItem[0]['index']];
						},
						label: function(tooltipItem, data) {
						  return $('.currency').val()+data['datasets'][0]['data'][tooltipItem['index']].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
						},
						afterLabel: function(tooltipItem, data) {
						  var dataset = data['datasets'][0];
						  console.log(dataset);
						  //var percent = Math.round((dataset['data'][tooltipItem['index']] / dataset["_meta"][0]['total']) * 100)
						  //return '(' + dataset + '%)';
						}
					  },
					}
				}
			});
		}
	});	
	//incomevsexpense
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/incomevsexpense')); ?>",
        dataType: "json",
        data: "{}",
        success: function (data) {
			var cincomevsexpense = document.getElementById("incomevsexpense");
			var incomevsexpense = new Chart(cincomevsexpense, {
				type: 'line',
				legendPosition: 'bottom',
				data: {
					labels: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
					datasets: [
					{
						label: 'Income',
						data: [data.ijan, data.ifeb, data.imar, data.iapr, data.imay, data.ijun, data.ijun, data.ijun, data.ijul, data.iags, data.isep, data.iokt, data.inov, data.ides],
						backgroundColor: 'rgba(54, 162, 235, 0.2)',
						borderColor: 'rgba(54, 162, 235, 0.2)',
						borderWidth: 1
					},{
						label: 'Expense',
						data: [data.ejan, data.efeb, data.emar, data.eapr, data.emay, data.ejun, data.ejun, data.ejun, data.ejul, data.eags, data.esep, data.eokt, data.enov, data.edes],
						backgroundColor: 'rgba(255, 99, 132, 0.2)',
						borderColor:	'rgba(255,99,132,1)',
						borderWidth: 1
					}
					]
				},
				options: {
					 pieceLabel: {
					  // render 'label', 'value', 'percentage' or custom function, default is 'percentage'
					  render: 'label'
					 }, 
					legend: {
						   position: 'bottom',
						},
					tooltips: {
							mode: 'index',
							intersect: false,
							callbacks: {
								label: function(tooltipItem, data) {
									return $('.currency').val()+tooltipItem.yLabel.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
								},
							}
						},
					hover: {
							mode: 'nearest',
							intersect: true
						},
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true,
								callback: function(value, index, values) {
								  if(parseInt(value) >= 1000){
									return  $('.currency').val()+value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
								  } else {
									return $('.currency').val() + value;
								  }
								}
							}
						}]
					}
				}
			});
			
        },
    });

	//load calendar
	 $('#mycalendar').fullCalendar({
		allDayDefault: true,
		header:{
			left: 'title',
			right: 'prev,next today,month'
		},
		eventSources: [
			
			{
			  url: "<?php echo e(url('income/getdatacalendar')); ?>",
			  color: '#82B1FF',
			  textColor: 'white'
			},
			{
			  url: "<?php echo e(url('expense/getdatacalendar')); ?>",
			  color: '#F44336',
			  textColor: 'white'
			}
		],
		eventRender: function(event, element) {
		
			element.find(".fc-content").remove();
			element.find(".fc-event-time").remove();
			var new_description =   
				event.title + '<br/>'
				+  event.amount + '<br/>';
				element.append(new_description);
		}
    });
	
	//latest income 
	//get data
    $('#dataincome').DataTable( {
			
			processing: true,
			serverSide: true,
			bFilter:false,
			paging: false,
			bInfo: false ,
            ajax: "<?php echo e(url('home/latestincome')); ?>",
			columns: [
				{ data: 'name'},		
				{ data: 'account'},		
				{ data: 'amount'},
				{ data: 'transactiondate'}
			]
			
    } );
	
	//latest expense 
	//get data
    $('#dataexpense').DataTable( {
			
			processing: true,
			serverSide: true,
			bFilter:false,
			paging: false,
			bInfo: false ,
            ajax: "<?php echo e(url('home/latestexpense')); ?>",
			columns: [
				{ data: 'name'},		
				{ data: 'account'},		
				{ data: 'amount'},
				{ data: 'transactiondate'}
			]
			
    } );
   
	
	
	
	//latest goals
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('goals/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (data) {
			var dt = data.data;
			jQuery.each( dt, function( i, val ) {
				$(".goalsprogress").append('<b>'+dt[i].name+'</b><br/>'+dt[i].remaining+'<br/><br/>');
			});
        },
    });
	
	//get currency
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$(".currency").val(objs[0].currency);
			
        },
    });
	
	//income total
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('income/gettotal')); ?>",
        dataType: "json",
        data: "{}",
        success: function (data) {
			$(".incomeday").html(data.day);
			$(".incomethismonth").html(data.month);
			
        },
    });
	
	//expense total
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('expense/gettotal')); ?>",
        dataType: "json",
        data: "{}",
        success: function (data) {
			$(".expenseday").html(data.day);
			$(".expensemonth").html(data.month);
			
        },
    });
	
	//expense total
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$(".currency").val(objs[0].currency);
			$(".currency").html(objs[0].currency);
			
        },
    });
} );



</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>