 
<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
		<div class="row">
			<div class="col-lg-12 col-md-11">
				 <div class="card">
					<div class="header">
						<h4 class="title">Income Monthly Report (<?php echo date("Y");?>)</h4>
					</div>
					<div class="content">
						<table id="monthlyreportsincome" class="table table-striped table-bordered"  cellspacing="0" width="100%">
							<thead style="font-size:10px;background:#e3f1f4">
                                <tr>
                                    <th class="bold"><b>Category</b></th>
                                    <th class="bold"><b>Jan</b></th>  
									<th class="bold"><b>Feb</b></th>  
									<th class="bold"><b>Mar</b></th>  
									<th class="bold"><b>Apr</b></th>  
									<th class="bold"><b>May</b></th>  
									<th class="bold"><b>Jun</b></th>  
									<th class="bold"><b>Jul</b></th>  
									<th class="bold"><b>Aug</b></th>  
									<th class="bold"><b>Sep</b></th>  
									<th class="bold"><b>Oct</b></th>  
									<th class="bold"><b>Nov</b></th>  
									<th class="bold"><b>Dec</b></th>                                        
									<th class="bold"><b>Total</b></th>   
								</tr>
                            </thead>
							
							<tbody style="font-size:12px;">
							
							</tbody>
						</table>
						
					</div>
				 </div>
			</div> 
		</div>

    </div>
</div>	


<script>


$(document).ready(function() {
	$.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
	});
	


	//get currency
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$(".currency").val(objs[0].currency);
        },
    });
   
	//get account
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('account/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var options;
			var objs = html.data;
			$.each(objs, function(index, object) {
					options += '<option value="' + object.accountid + '">' + object.name + '</option>';
				});
				$('#form #account').html(options);
        },
    });
	
	
	
	//get data
    var table = $('#monthlyreportsincome').DataTable( {
			
			processing: true,
			serverSide: true,
			bFilter : false,
            ajax: {
				url : "<?php echo e(url('reports/getincomemonthly')); ?>",
				
			},
			columns: [
				{ data: 'category', name:'category'},
				{ data: 'ijan', name:'ijan'},
				{ data: 'ifeb', name:'ifeb'},
				{ data: 'imar', name:'imar'},				
				{ data: 'iapr', name:'iapr'},		
				{ data: 'imay', name:'imay'},
				{ data: 'ijun', name:'ijun'},
				{ data: 'ijul', name:'ijul'},
				{ data: 'iags', name:'iags'},
				{ data: 'isep', name:'isep'},
				{ data: 'iokt', name:'iokt'},
				{ data: 'inov', name:'inov'},
				{ data: 'idec', name:'idec'},
				{ data: 'total', name:'total'}
			],
			dom: 'Bfrtip',

			buttons: [
				{
					extend: 'copy',
					text:   'Copy <i class="fa fa-files-o"></i>',
					title: 'Income Monthly Report',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
					}
				}, 
				{
					extend:'csv',
					text:   'CSV <i class="fa fa-file-excel-o"></i>',
					title: 'Income Monthly Report',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
					}
				},
				{
					extend:'pdf',
					text:   'PDF <i class="fa fa-file-pdf-o"></i>',
					title: 'Income Monthly Report',
					className: 'btn btn-sm btn-fill btn-info ',
					orientation:'landscape',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
					},
					customize : function(doc){
						doc.styles.tableHeader.alignment = 'left';
						doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
					}
				},
				{
					extend:'print',
					title: 'Income Monthly Report',
					text:   'Print <i class="fa fa-print"></i>',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
					}
				}
			]
    } );
	//do search
	$('#form').on('submit', function(e) {
        table.draw();
        e.preventDefault();
    });
	
	//accountbalance
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('home/accountbalance')); ?>",
        dataType: "json",
        success: function (data) {
			var label = [];
			var amount = [];			
			for(var i in data) {
				label.push(data[i].name);
				amount.push(data[i].balance);
			}
			
			var caccountbalance = document.getElementById("accountbalance");
			var accountbalance = new Chart(caccountbalance, {
				type: 'bar',
				legendPosition: 'bottom',
				data: {
					labels: label,
					datasets: [
					{
						label: 'Account',
						data: amount,
						backgroundColor: '#A5DFDF',
						borderColor: '#A5DFDF',
						borderWidth: 1
					}
					]
				},
				options: {
					legend: {
						   position: 'bottom',
					},
					tooltips: {
					  callbacks: {
						title: function(tooltipItem, data) {
						  return data['labels'][tooltipItem[0]['index']];
						},
						label: function(tooltipItem, data) {
						  return $('.currency').val()+data['datasets'][0]['data'][tooltipItem['index']].toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
						}
					  },
					}
				}
			});
		}
	});	
	
		
} );

	$('#fromdate').datepicker({
            autoclose: true,
            dateFormat: "yy-mm-dd",
            todayHighlight: true
        });	
	$('#todate').datepicker({
            autoclose: true,
            dateFormat: "yy-mm-dd",
            todayHighlight: true
        });	

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>