<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
	
        <div class="row">

            <div class="col-lg-12 col-md-11">
                <div class="card">
                    <div class="header">
						<div class="row">
							<div class="col-lg-6">
							<h4 class="title">Budget List</h4>
							</div>
							<div class="col-lg-6">
							<div class="pull-right"><a href="#'" data-toggle="modal" data-target="#add" class="btn btn-sm btn-fill btn-info"><i class="ti-plus"></i> Add Budget</a></div>
							</div>
						</div>
                    </div>
                    <div class="content">
					<div id="message2" style="display:none" class="alert alert-success">Data has been added sucessfully</div>
					<div id="message3" style="display:none" class="alert alert-success">Data has been deleted sucessfully</div>
					<div id="message4" style="display:none" class="alert alert-success">Data has been updated sucessfully</div>
						<table id="data" class="table table-striped table-bordered" cellspacing="0" width="100%">
							<thead>
								<tr>
									<th></th>
									<th>Budget ID</th>
									<th>Original</th>
									<th>Category</th>
									<th>Sub Category</th>
									<th>Amount</th>									
									<th>Month</th>
									<th>Action</th>
								</tr>
							</thead>
							<tfoot>
								<tr>
									<th></th>
									<th>Budget ID</th>
									<th>Original</th>
									<th>Category</th>
									<th>Sub Category</th>
									<th>Amount</th>									
									<th>Month</th>
									<th>Action</th>
								</tr>
							</tfoot>
							<tbody>
							
							</tbody>
						</table>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>	

<!--delete data -->
 <div class="modal fade" id="delete" role="dialog">
    <div class="modal-dialog modal-sm">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Delete Data</h4>
        </div>
        <div class="modal-body">
		<form action="" method="POST">
          <p>Are you sure to delete this data?</p>
		  <input type="hidden" value="" name="iddelete" id="iddelete"/>
		  </form>
        </div>
        <div class="modal-footer">
		   <input type="submit" class="btn btn-primary" id="dodelete" value="Delete"/>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
 <!--edit data -->
<div id="edit" class="modal fade" role="dialog">
        <div class="modal-dialog">
          <div class="modal-content">
            <form action="" method="post" id="form">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Budget</h4>
              </div>
			  <div id="message" style="display:none;" class="alert alert-warning">All field is required</div>
			  <div id="messageerror" style="display:none;" class="alert alert-warning"></div>
              <div class="modal-body">
               <div class="row">
					 <div class="form-group col-lg-6">
					  <label><small class="req text-danger">* </small>Month</label>
					    <select disabled id="editmonths" class="form-control">
							<option value="01">January</option>
							<option value="02">February</option>
							<option value="03">March</option>
							<option value="04">April</option>
							<option value="05">May</option>
							<option value="06">June</option>
							<option value="07">July</option>
							<option value="08">August</option>
							<option value="09">September</option>
							<option value="10">October</option>
							<option value="11">November</option>
							<option value="12">December</option>
						</select>
						
					</div>
					<div class="form-group col-lg-6">
					  <label><small class="req text-danger">* </small>Year</label>
					    <select disabled id="edityears" class="form-control">
						<?php
						   for($i = date("Y"); $i < date("Y")+10; $i++){
							 echo "<option value=$i>" . $i . "</option>";
						   }
						?>
						</select>
					</div>
				</div>
                <div class="row">
					<div class="form-group col-lg-6">
					<label><small class="req text-danger">* </small>Budget Category</label>
						<select disabled id="editcategory" class="form-control">
							<option value="">Select a Category</option>
							<optgroup label="Income" id="income">							
							</optgroup>
							<optgroup label="Expense" id="expense">							
							</optgroup>
						</select>
					</div>
					<div class="form-group col-lg-6">
						<label><small class="req text-danger">* </small>Budget Sub Category</label>
							<select disabled id="editsubcategory" class="form-control"></select>
					</div>
				</div>
				<div class="form-group">
                  <label><small class="req text-danger">* </small>Amount</label>
					<div class="input-group">
						<span class="input-group-addon currency" style="border: 1px solid #cecece;"></span>                                
						<input class="form-control number"  placeholder="Amount" id="editamount" name="editamount" type="text" placeholder="Amount">
					</div>
                </div>
              </div>
              <div class="modal-footer">
				<input type="hidden" value="" name="id" id="idedit"/>
                <input type="submit" class="btn btn-primary" id="saveedit" value="Save"/>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              </div>
            </form>
          </div>
        </div>
      </div> 
  
</div>	

<!--add new data -->
<div id="add" class="modal fade" role="dialog">
        <div class="modal-dialog">
          <div class="modal-content">
            <form action="" method="post" id="form">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Add New Budget</h4>
              </div>
			  <div id="message" style="display:none;" class="alert alert-warning">All field is required</div>
			  <div id="exist" style="display:none;" class="alert alert-warning">Error! Budget already registered</div>
              <div class="modal-body">
			    <div class="row">
					 <div class="form-group col-lg-6">
					  <label><small class="req text-danger">* </small>Month</label>
					    <select id="months" class="form-control">
							<option value="01">January</option>
							<option value="02">February</option>
							<option value="03">March</option>
							<option value="04">April</option>
							<option value="05">May</option>
							<option value="06">June</option>
							<option value="07">July</option>
							<option value="08">August</option>
							<option value="09">September</option>
							<option value="10">October</option>
							<option value="11">November</option>
							<option value="12">December</option>
						</select>
						
					</div>
					<div class="form-group col-lg-6">
					  <label><small class="req text-danger">* </small>Year</label>
					    <select id="years" class="form-control">
						<?php
						   for($i = date("Y"); $i < date("Y")+10; $i++){
							 echo "<option value=$i>" . $i . "</option>";
						   }
						?>
						</select>
					</div>
				</div>
                <div class="row">
					<div class="form-group col-lg-6">
					<label><small class="req text-danger">* </small>Budget Category</label>
						<select id="category" class="form-control">
							<option value="">Select a Category</option>
							<optgroup label="Income" id="income">							
							</optgroup>
							<optgroup label="Expense" id="expense">							
							</optgroup>
						</select>
					</div>
					<div class="form-group col-lg-6">
						<label><small class="req text-danger">* </small>Budget Sub Category</label>
							<select id="subcategory" class="form-control"></select>
					</div>
				</div>
				<div class="form-group">
                  <label><small class="req text-danger">* </small>Amount</label>
					<div class="input-group">
						<span class="input-group-addon currency" style="border: 1px solid #cecece;"></span>                                
						<input class="form-control number"  placeholder="Amount" id="amount" name="amount" type="text" placeholder="Amount">
					</div>
                </div>
              </div>
              <div class="modal-footer">
				
                <input type="submit" class="btn btn-primary" id="save" value="Save"/>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              </div>
            </form>
          </div>
        </div>
      </div>  
<script>


$(document).ready(function() {
	$.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
	});
	

	//get income category
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('incomecategory/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.categoryid);
                var name = decodeURIComponent(record.name);
				//alert(name);
                $("#category #income").append($("<option></option>")
                    .attr("value",id)
                    .text(name));  
				$("#editcategory #income").append($("<option></option>")
                    .attr("value",id)
                    .text(name));     		
            });
        },
    });
	
	//get expense category
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('expensecategory/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.categoryid);
                var name = decodeURIComponent(record.name);
				//alert(name);
                $("#category #expense").append($("<option></option>")
                    .attr("value",id)
                    .text(name));
				$("#editcategory #expense").append($("<option></option>")
                    .attr("value",id)
                    .text(name));		
            });
        },
    });
	
	//get  sub category
	$("select#category.form-control").change(function(){
		var id = $(this).val();
		$.ajax({
        type: "POST",
        url: "<?php echo e(url('incomecategory/subgetdatabycat')); ?>",
        dataType: "json",
        data: {id:id},
        success: function (html) {
			var objs = html.message;
			if (objs.length === 0) {
				$('#subcategory').empty();
			}
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.subcategoryid);
                var name = decodeURIComponent(record.name);
					$('#subcategory').empty();
					$("#subcategory").append($("<option></option>")
						.attr("value",id)
						.text(name));

				});
			},
		});
	});
	
	//get  sub category
	$("select#editcategory.form-control").change(function(){
		var id = $(this).val();
		$.ajax({
        type: "POST",
        url: "<?php echo e(url('incomecategory/subgetdatabycat')); ?>",
        dataType: "json",
        data: {id:id},
        success: function (html) {
			var objs = html.message;
			if (objs.length === 0) {
				$('#editsubcategory').empty();
			}
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.subcategoryid);
                var name = decodeURIComponent(record.name);
					$('#editsubcategory').empty();
					$("#editsubcategory").append($("<option></option>")
						.attr("value",id)
						.text(name));

				});
			},
		});
	});
	

	//get currency
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$(".currency").html(objs[0].currency);
        },
    });
   

		
	//dosave
	$("#save").click(function(e){
		var months=$("#months").val();
		var years=$("#years").val();
		var subcategory=$("#subcategory").val();
		var amount=$("#amount").val();
		
		if(months =='' || years =='' || subcategory=='' || amount==''){
			$("#message").css({'display':"block"});
			return false;
		}
		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('budget/save')); ?>",
            data: {months:months,years:years,subcategory:subcategory,amount:amount},
            dataType: "JSON",
            success: function(data) {
				console.log(data);
				if(data.message=='0'){
					$("#exist").css({'display':"block"});
					//return false;
				}
				if(data.message=='1'){
					$("#message2").css({'display':"block"});
					$('#add').modal('hide');
					window.setTimeout(function(){location.reload()},2000)
				}
            }
		});
	});	
	//get data
    $('#data').DataTable( {
			
			processing: true,
			serverSide: true,
            ajax: "<?php echo e(url('budget/getdata')); ?>",
			columns: [
				{
                "class":          "details-control",
                "orderable":      false,
				"searchable":      false,
                "data":           null,
                "defaultContent": ""
				},
				{ data: 'budgetid', orderable: false, searchable: false, visible: false},
				{ data: 'originalamount', orderable: false, searchable: false, visible: false},
				{ data: 'category'},
				{ data: 'subcategory'},
				{ data: 'amount'},
				{ data: 'fromdate'},
				{data: 'action',  orderable: false, searchable: false}
			],
			dom: 'Bfrtipl',
			buttons: [
				{
					extend: 'copy',
					text:   'Copy <i class="fa fa-files-o"></i>',
					title: 'Budget List',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 3, 4, 5, 6 ]
					}
				}, 
				{
					extend:'csv',
					text:   'CSV <i class="fa fa-file-excel-o"></i>',
					title: 'Budget List',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 3, 4, 5, 6 ]
					}
				},
				{
					extend:'pdf',
					text:   'PDF <i class="fa fa-file-pdf-o"></i>',
					title: 'Budget List',
					orientation:'landscape',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [3, 4, 5, 6 ]
					},
					customize : function(doc){
						doc.styles.tableHeader.alignment = 'left';
						doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
					}
				},
				{
					extend:'print',
					text:   'Print <i class="fa fa-print"></i>',
					className: 'btn btn-sm btn-fill btn-info ',
					exportOptions: {
						columns: [ 3, 4, 5, 6 ]
					}
				}
			]
    } );
	
	
	function format ( d ) {
	return '<div class="col-lg-6"><table cellpadding="10" cellspacing="0" border="0"  class="table-hover" style="padding-left:50px;">'+
			'<div class="">'+
				'<h4 style="font-weight: 500;color: #c7cbd5;">Budget Remaining</h4>'+
			'</div>'+
			'<h3 style="font-weight: 500;" class="text-left">'+
				'<span class="money-area"><span style="font-weight:bold;" id="currencybudget"></span><span  style="font-weight:bold;" id="remainingbudget"></span></span>'+
			'</h3>'+
			'<div class="row">'+
					'<div class="col-xs-6">'+
						'<small class="text-uppercase text-bold text-primary">Planned</small>'+
							'<h5>'+d.amount+'</h5>'+
					'</div>'+
					'<div class="col-xs-6">'+
						'<small class="text-uppercase text-bold text-success">Actual</small>'+
							'<h5><span id="actualbudget"></span></h5>'+
					'</div>'+
			'</div>'+
			'<small>Created by: <b>'+d.user+'</b></small>'+
    '</table></div><div class="col-lg-4 pull-right"><div id="chart"></div></div>';
	
   
}
	
	// Array to track the ids of the details displayed rows
    var detailRows = [];
 
    $('#data tbody').on( 'click', 'tr td.details-control', function () {
        var tr = $(this).closest('tr');
		var table = $('#data').DataTable();
        var row = table.row( tr );
        var idx = $.inArray( tr.attr('id'), detailRows );
 
        if ( row.child.isShown() ) {
            tr.removeClass( 'details' );
            row.child.hide();
 
            // Remove from the 'open' array
            detailRows.splice( idx, 1 );
        }
        else {
            tr.addClass( 'details' );
            row.child( format( row.data() ) ).show();
			var id = row.data().categoryid;
			var date = row.data().fromdate;
			//start search by id expense/income category detail
			$.ajax({
				type: "POST",
				url: "<?php echo e(url('budget/gettransactionbydate')); ?>",
				data: {id:id,date:date},
				dataType: "JSON",
				success: function(data) {
					var remaining = row.data().originalamount - data.totalamount;
					$("#currencybudget").html(data.currency);
					$("#actualbudget").html(data.amountcurrency);
					$("#remainingbudget").html( remaining.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ","));
					Morris.Donut({
					  element: 'chart',
					  data: [
						{label: "Planned", value: row.data().originalamount},
						{label: "Actual", value: data.totalamount}
					  ],
					  colors: ['#00E676','#82B1FF']
					});
					
				}
			});
			
 
            // Add to the 'open' array
            if ( idx === -1 ) {
                detailRows.push( tr.attr('id') );
            }
        }
    } );
 
    // On each draw, loop over the `detailRows` array and show any child rows
    $('#data').on( 'draw', function () {
        $.each( detailRows, function ( i, id ) {
            $('#'+id+' td.details-control').trigger( 'click' );
        } );
    } );
	
	//dosave edit
	$("#saveedit").click(function(e){
		
		var id=$("#idedit").val();
		var months=$("#editmonths").val();
		var years=$("#edityears").val();
		var subcategory=$("#editsubcategory").val();
		var amount=$("#editamount").val();
		
		if(months =='' || years =='' || subcategory=='' || amount==''){
			$("#message").css({'display':"block"});
			return false;
		}

		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('budget/edit')); ?>",
            data: {id:id,months:months,years:years,subcategory:subcategory,amount:amount},
             success: function(data) {
				console.log(data);
				$("#message2").css({'display':"block"});
				window.setTimeout(function(){location.reload()},2000)
            }
		});
	});
	
} );
	//delete function
	$("#dodelete").click(function(e){
		
		var id=$("#iddelete").val();

		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('budget/delete')); ?>",
            data: {iddelete:id},
            dataType: "JSON",
            success: function(data) {
				$("#message3").css({'display':"block"});
				$('#delete').modal('hide');
				//$('#data').DataTable().ajax.reload();
				window.setTimeout(function(){location.reload()},2000)
            }
		});
	});
	

		//for get id to modal

		$('#delete').on('show.bs.modal', function(e) {
            var $modal = $(this),
            id = $(e.relatedTarget).attr('customdata');
            $("#iddelete").val(id);
        });
		
		//for get id to modal edit

		$('#edit').on('show.bs.modal', function(e) {
            var $modal = $(this),
            id = $(e.relatedTarget).attr('customdata');
            
			$.ajax({
				type: "POST",
				url: "<?php echo e(url('budget/getedit')); ?>",
				data: {id:id},
				dataType: "JSON",
				success: function(data) {
					console.log(data);
					$("#expensename").val(data.message[0].name);
					$("#editamount").val(data.message[0].amount);
					$("#editmonths").val(data.months);
					$("#edityears").val(data.years);
					$("#editcategory").val(data.message[0].realcategoryid);
					$('#editcategory').trigger("change");
					$("#idedit").val(id);
				}
			});
		
		
        });
		
//for balance support number only
$('.number').keypress(function(event) {
		var $this = $(this);
		if ((event.which != 46 || $this.val().indexOf('.') != -1) &&
		   ((event.which < 48 || event.which > 57) &&
		   (event.which != 0 && event.which != 8))) {
			   event.preventDefault();
		}

		var text = $(this).val();
		if ((event.which == 46) && (text.indexOf('.') == -1)) {
			setTimeout(function() {
				if ($this.val().substring($this.val().indexOf('.')).length > 3) {
					$this.val($this.val().substring(0, $this.val().indexOf('.') + 3));
				}
			}, 1);
		}

		if ((text.indexOf('.') != -1) &&
			(text.substring(text.indexOf('.')).length > 2) &&
			(event.which != 0 && event.which != 8) &&
			($(this)[0].selectionStart >= text.length - 2)) {
				event.preventDefault();
		}      
	});

	$('.number').bind("paste", function(e) {
	var text = e.originalEvent.clipboardData.getData('Text');
	if ($.isNumeric(text)) {
		if ((text.substring(text.indexOf('.')).length > 3) && (text.indexOf('.') > -1)) {
			e.preventDefault();
			$(this).val(text.substring(0, text.indexOf('.') + 3));
	   }
	}
	else {
			e.preventDefault();
		 }
	});
	

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>