<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
	
        <div class="row">
			<div class="col-lg-3 col-sm-6">
                <div class="card background-blue-sky color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-4">
                                <div class="icon-big color-white text-center">
                                    <i class="ti-stats-up"></i>
                                </div>
                            </div>
                            <div class="col-xs-8">
                                <div style="font-size:22px;">
                                    <p>Overall </p>
                                    <span class="currency"></span><span id="overall"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            
                        </div>
                    </div>
                </div>
            </div>
			
			<div class="col-lg-3 col-sm-6">
                <div class="card background-blue-sky color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-4">
                                <div class="icon-big color-white text-center">
                                    <i class="ti-stats-up"></i>
                                </div>
                            </div>
                            <div class="col-xs-8">
                                <div style="font-size:22px;">
                                    <p>This Month</p>
                                    <span class="currency"></span><span id="month"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            
                        </div>
                    </div>
                </div>
            </div>
			
			<div class="col-lg-3 col-sm-6">
                <div class="card background-blue-sky color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big color-white text-center">
                                    <i class="ti-stats-up"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div style="font-size:22px;">
                                    <p>This Week</p>
                                    <span class="currency"></span><span id="week"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            
                        </div>
                    </div>
                </div>
            </div>
			
			<div class="col-lg-3 col-sm-6">
                <div class="card background-blue-sky color-white">
                    <div class="content">
                        <div class="row">
                            <div class="col-xs-5">
                                <div class="icon-big color-white text-center">
                                    <i class="ti-stats-up"></i>
                                </div>
                            </div>
                            <div class="col-xs-7">
                                <div style="font-size:22px;">
                                    <p>Today</p>
                                    <span class="currency"></span><span id="today"></span>
                                </div>
                            </div>
                        </div>
                        <div class="footer">
                            <hr>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-11">
                <div class="card">
                    <div class="header">
						<div class="row">
							<div class="col-lg-6">
							<h4 class="title">Income List</h4>
							</div>
							<div class="col-lg-6">
							<div class="pull-right"><a href="<?php echo e(url('transaction/index')); ?>" class="btn btn-sm btn-fill btn-info"><i class="ti-plus"></i> Add New Income</a></div>
							</div>
						</div>
						
                    </div>
                    <div class="content">
					<div id="message2" style="display:none" class="alert alert-success">Data has been added sucessfully</div>
					<div id="message3" style="display:none" class="alert alert-success">Data has been deleted sucessfully</div>
					<div id="message4" style="display:none" class="alert alert-success">Data has been updated sucessfully</div>
						<table id="data" class="table table-striped table-bordered" cellspacing="0" width="100%">
							<thead>
								<tr>
									<th></th>
									<th>Transaction ID</th>
									<th>Name</th>
									<th>Amount</th>
									<th>Date</th>
									<th>Category</th>
									<th>Account</th>
									<th>Sub Category</th>
									<th>Reference</th>
									<th>Description</th>
									<th>Action</th>
								</tr>
							</thead>
							<tfoot>
								<tr>
									<th></th>
									<th>Transaction ID</th>
									<th>Name</th>
									<th>Amount</th>
									<th>Date</th>
									<th>Category</th>
									<th>Account</th>
									<th>Sub Category</th>
									<th>Reference</th>
									<th>Description</th>
									<th>Action</th>
								</tr>
							</tfoot>
							<tbody>
							
							</tbody>
						</table>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>	

<!--delete data -->
 <div class="modal fade" id="delete" role="dialog">
    <div class="modal-dialog modal-sm">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Delete Data</h4>
        </div>
        <div class="modal-body">
		<form action="" method="POST">
          <p>Are you sure to delete this data?</p>
		  <input type="hidden" value="" name="iddelete" id="iddelete"/>
		  </form>
        </div>
        <div class="modal-footer">
		   <input type="submit" class="btn btn-primary" id="dodelete" value="Delete"/>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
 <!--edit data -->
<div id="edit" class="modal fade" role="dialog">
        <div class="modal-dialog">
          <div class="modal-content">
            <form action="" method="post" id="form">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Edit Income</h4>
              </div>
			  <div id="message" style="display:none;" class="alert alert-warning">All field is required</div>
			  <div id="messageerror" style="display:none;" class="alert alert-warning"></div>
              <div class="modal-body">
               <div class="row">
								<div class="col-lg-12">
									<div class="form-group">
									  <label><small class="req text-danger">* </small>Name</label>
									  <input type="text" class="form-control" name="name"  id="incomename" placeholder="Name">
									 </div>
								</div>
							</div>
							<div class="row">
								<div class="col-lg-6">
									<div class="form-group">
										<label for="incomeamount" class="control-label"><small class="req text-danger">* </small>Amount</label> 
										<div class="input-group">
											<span class="input-group-addon" id="currency" style="border: 1px solid #cecece;"></span>                                      
											<input class="form-control number" required="" placeholder="Amount" id="incomeamount" name="incomeamount" type="text" placeholder="Amount">
										</div>
									</div>
								</div>
								<div class="col-lg-6">
									<div class="form-group">
									  <label>Reference</label>
									  <input type="text" class="form-control" name="incomereference"  id="incomereference" placeholder="Reference">
									</div>
								</div>
							</div>				
							<div class="row">	
								<div class="form-group col-lg-6" id="incomedate">
									<label for="date" class="control-label"> 
									<small class="req text-danger">* </small>Income Date</label>
									<div  class="input-group date" data-date-format="mm-dd-yyyy">
										<input id="idate" class="form-control" type="text" value="<?php echo date("Y-m-d");?>"/>
										<span class="input-group-addon" style="border: 1px solid #cecece;"><i class="fa fa-calendar"></i></span>
									</div>
								</div>
								<div class="form-group col-lg-6">
								  <label><small class="req text-danger">* </small>Account</label>
								  <select id="incomeaccount" class="form-control"></select>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-lg-6">
								  <label><small class="req text-danger">* </small>Income Category</label>
								  <select id="incomecategory" class="form-control">
								  <option value="">Select a Category</option>
								  </select>
								</div>
								<div class="form-group col-lg-6">
								  <label><small class="req text-danger">* </small>Income Sub Category</label>
								  <select id="incomesubcategory" class="form-control"></select>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-lg-12">
								  <label>Note</label>
								  <textarea id="incomenote" class="form-control" placeholder="Note"></textarea>
								</div>
							</div>
							<div class="row">
								<div class="form-group col-lg-12">
								  <label>Attach Receipt</label>
								  <input type="file" name="incomefile"  class="form-control" id="incomefile"/>
								</div>
							</div>
              </div>
              <div class="modal-footer">
				<input type="hidden" value="" name="id" id="idedit"/>
                <input type="submit" class="btn btn-primary" id="saveedit" value="Save"/>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              </div>
            </form>
          </div>
        </div>
      </div> 
  
</div>	  
<script>


$(document).ready(function() {
	$.ajaxSetup({
       headers: {
           'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
	});
	
	//get income category
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('incomecategory/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.categoryid);
                var name = decodeURIComponent(record.name);
				//alert(name);
                $("#incomecategory").append($("<option></option>")
                    .attr("value",id)
                    .text(name));                 
            });
        },
    });
	
	//get income sub category
	$("#incomecategory").change(function(e){
		var id = $(this).val();
		$.ajax({
        type: "POST",
        url: "<?php echo e(url('incomecategory/subgetdatabycat')); ?>",
        dataType: "json",
        data: {id:id},
        success: function (html) {
			var objs = html.message;
			if (objs.length === 0) {
				$('#incomesubcategory').empty();
			}
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.subcategoryid);
                var name = decodeURIComponent(record.name);
				//alert(name);

					$('#incomesubcategory').empty();
					$("#incomesubcategory").append($("<option></option>")
						.attr("value",id)
						.text(name));

				});
			},
		});
	});
	
	//get account
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('account/getdata')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			jQuery.each(objs, function (index, record) {
                var id = decodeURIComponent(record.accountid);
                var name = decodeURIComponent(record.name);
				//alert(name);
                $("#incomeaccount").append($("<option></option>")
                    .attr("value",id)
                    .text(name));
				$("#expenseaccount").append($("<option></option>")
                    .attr("value",id)
                    .text(name)); 		
            });
        },
    });
	//get currency
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('settings/getapplication')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html.data;
			$(".currency").html(objs[0].currency);
			$("#currency").html(objs[0].currency);
        },
    });
   
	//get income
	
	$.ajax({
        type: "GET",
        url: "<?php echo e(url('income/gettotal')); ?>",
        dataType: "json",
        data: "{}",
        success: function (html) {
			var objs = html;
			console.log(objs.day[0].totalday);
			$("#overall").html(objs.totalbalance);
			$("#month").html(objs.month);
			$("#today").html(objs.day);
			$("#week").html(objs.week);
			
			
        },
    });
	
	//get data
    $('#data').DataTable( {
			
			processing: true,
			serverSide: true,
            ajax: "<?php echo e(url('income/getdata')); ?>",
			columns: [
				{
                "class":          "details-control",
                "orderable":      false,
				"searchable":      false,
                "data":           null,
                "defaultContent": ""
				},
				{ data: 'transactionid', orderable: false, searchable: false, visible: false},
				{ data: 'name'},
				{ data: 'amount'},
				{ data: 'transactiondate'},
				{ data: 'category'},
				{ data: 'account'},
				{ data: 'subcategory', orderable: false, searchable: false, visible: false},
				{ data: 'reference', orderable: false, searchable: false, visible: false},
				{ data: 'description', orderable: false, searchable: false, visible: false},
				{data: 'action',  orderable: false, searchable: false}
			],
			dom: 'Bfrtipl',
			buttons: [
				{
					extend: 'copy',
					text:   'Copy <i class="fa fa-files-o"></i>',
					title: 'Income List',
					exportOptions: {
						columns: [ 2, 3, 4, 5, 6, 7, 8, 9  ]
					}
				}, 
				{
					extend:'csv',
					text:   'CSV <i class="fa fa-file-excel-o"></i>',
					title: 'Income List',
					exportOptions: {
						columns: [   2, 3, 4, 5, 6, 7, 8, 9 ]
					}
				},
				{
					extend:'pdf',
					text:   'PDF <i class="fa fa-file-pdf-o"></i>',
					title: 'Income List',
					orientation:'landscape',
					exportOptions: {
						columns: [   2, 3, 4, 5, 6, 7, 8, 9 ]
					},
					customize : function(doc){
						doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
					}
				},
				{
					extend:'print',
					text:   'Print <i class="fa fa-print"></i>',
					exportOptions: {
						columns: [  2, 3, 4, 5, 6, 7, 8, 9 ]
					}
				}
			]
    } );
	
	
	function format ( d ) {
	return '<table cellpadding="10" cellspacing="0" border="0"  class="table-hover" style="padding-left:50px;">'+
       
		'<tr class="info" height="30">'+
            '<td width="300">Reference:</td>'+
            '<td>'+d.reference+'</td>'+
        '</tr >'+
		'<tr class="info" height="30">'+
            '<td>Category:</td>'+
            '<td>'+d.category+'</td>'+
        '</tr>'+
		'<tr class="info" height="30">'+
            '<td>Sub Category:</td>'+
            '<td>'+d.subcategory+'</td>'+
        '</tr>'+
		'<tr class="info" height="30">'+
            '<td>Note:</td>'+
            '<td>'+d.description+'</td>'+
        '</tr>'+
		'<tr class="info" height="30">'+
            '<td><small><i>Created by:</i></small></td>'+
            '<td><small><i>'+d.user+'</i></small></td>'+
        '</tr>'+
    '</table>';
	
   
}
	
	// Array to track the ids of the details displayed rows
    var detailRows = [];
 
    $('#data tbody').on( 'click', 'tr td.details-control', function () {
        var tr = $(this).closest('tr');
		var table = $('#data').DataTable();
        var row = table.row( tr );
        var idx = $.inArray( tr.attr('id'), detailRows );
 
        if ( row.child.isShown() ) {
            tr.removeClass( 'details' );
            row.child.hide();
 
            // Remove from the 'open' array
            detailRows.splice( idx, 1 );
        }
        else {
            tr.addClass( 'details' );
            row.child( format( row.data() ) ).show();
 
            // Add to the 'open' array
            if ( idx === -1 ) {
                detailRows.push( tr.attr('id') );
            }
        }
    } );
 
    // On each draw, loop over the `detailRows` array and show any child rows
    $('#data').on( 'draw', function () {
        $.each( detailRows, function ( i, id ) {
            $('#'+id+' td.details-control').trigger( 'click' );
        } );
    } );
	
	//dosave edit
	$("#saveedit").click(function(e){
		
		var form = new FormData();
		var id=$("#idedit").val();
		var name=$("#incomename").val();
		var amount=$("#incomeamount").val();
		var reference=$("#incomereference").val();
		var account=$("#incomeaccount").val();
		var category=$("#incomecategory").val();
		var subcategory=$("#incomesubcategory").val();
		var date=$("#idate").val();
		var note=$("#incomenote").val();
		var file  = $('#incomefile')[0].files[0];
		
		form.append('id', id);
		form.append('incomename', name);
		form.append('incomeamount', amount);
		form.append('incomereference', reference);
		form.append('incomeaccount', account);
		form.append('incomecategory', category);
		form.append('incomesubcategory', subcategory);
		form.append('incomenote', note);
		form.append('incomedate', date);
		form.append('incomefile', file);
		if(name =='' || amount =='' || account =='' || category =='' || subcategory =='' || date =='' ){
			$("#message").css({'display':"block"});
			return false;
		}
		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('income/edit')); ?>",
            data: form,
			contentType: 'multipart/form-data',
			processData: false,
            contentType: false,
             success: function(data) {
				console.log(data);
				$("#message2").css({'display':"block"});
				window.setTimeout(function(){location.reload()},2000)
            },
			error: function (error) {
				var errordata = error.responseJSON.incomefile[1];
				$("#messageerror").css({'display':"block"});
				$("#messageerror").html(errordata);
			}
		});
	});
	
} );
	//delete function
	$("#dodelete").click(function(e){
		
		var id=$("#iddelete").val();

		e.preventDefault();
		$.ajax({
			type: "POST",
            url: "<?php echo e(url('income/delete')); ?>",
            data: {iddelete:id},
            dataType: "JSON",
            success: function(data) {
				//$("#message").html(data);
				$("#message3").css({'display':"block"});
				$('#delete').modal('hide');
				window.setTimeout(function(){location.reload()},2000)
            }
		});
	});
	

		//for get id to modal

		$('#delete').on('show.bs.modal', function(e) {
            var $modal = $(this),
            id = $(e.relatedTarget).attr('customdata');
            $("#iddelete").val(id);
        });
		
		//for get id to modal edit

		$('#edit').on('show.bs.modal', function(e) {
            var $modal = $(this),
            id = $(e.relatedTarget).attr('customdata');
            
			$.ajax({
				type: "POST",
				url: "<?php echo e(url('income/getedit')); ?>",
				data: {id:id},
				dataType: "JSON",
				success: function(data) {
					console.log(data);
					$("#incomename").val(data.message[0].name);
					$("#incomeamount").val(data.message[0].amount);
					$("#incomereference").val(data.message[0].reference);
					$("#incomeaccount").val(data.message[0].accountid);
					$("#incomecategory").val(data.message[0].categoryid2);
					$('#incomecategory').trigger("change");
					//$("#incomesubcategory").val(data.message[0].categoryid);
					$("#idate").val(data.message[0].transactiondate);
					$("#incomenote").val(data.message[0].description);
					$("#idedit").val(id);
				}
			});
		
		
        });
		
//for balance support number only
$('.number').keypress(function(event) {
		var $this = $(this);
		if ((event.which != 46 || $this.val().indexOf('.') != -1) &&
		   ((event.which < 48 || event.which > 57) &&
		   (event.which != 0 && event.which != 8))) {
			   event.preventDefault();
		}

		var text = $(this).val();
		if ((event.which == 46) && (text.indexOf('.') == -1)) {
			setTimeout(function() {
				if ($this.val().substring($this.val().indexOf('.')).length > 3) {
					$this.val($this.val().substring(0, $this.val().indexOf('.') + 3));
				}
			}, 1);
		}

		if ((text.indexOf('.') != -1) &&
			(text.substring(text.indexOf('.')).length > 2) &&
			(event.which != 0 && event.which != 8) &&
			($(this)[0].selectionStart >= text.length - 2)) {
				event.preventDefault();
		}      
	});

	$('.number').bind("paste", function(e) {
	var text = e.originalEvent.clipboardData.getData('Text');
	if ($.isNumeric(text)) {
		if ((text.substring(text.indexOf('.')).length > 3) && (text.indexOf('.') > -1)) {
			e.preventDefault();
			$(this).val(text.substring(0, text.indexOf('.') + 3));
	   }
	}
	else {
			e.preventDefault();
		 }
	});
	
$('#idate').datepicker({
            autoclose: true,
            dateFormat: "yy-mm-dd",
            todayHighlight: true
        });		
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>