<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$type_view = new type_view();

// Run the page
$type_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$type_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$type_view->isExport()) { ?>
<script>
var ftypeview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	ftypeview = currentForm = new ew.Form("ftypeview", "view");
	loadjs.done("ftypeview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$type_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $type_view->ExportOptions->render("body") ?>
<?php $type_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $type_view->showPageHeader(); ?>
<?php
$type_view->showMessage();
?>
<?php if (!$type_view->IsModal) { ?>
<?php if (!$type_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $type_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="ftypeview" id="ftypeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="type">
<input type="hidden" name="modal" value="<?php echo (int)$type_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($type_view->idtype->Visible) { // idtype ?>
	<tr id="r_idtype">
		<td class="<?php echo $type_view->TableLeftColumnClass ?>"><span id="elh_type_idtype"><?php echo $type_view->idtype->caption() ?></span></td>
		<td data-name="idtype" <?php echo $type_view->idtype->cellAttributes() ?>>
<span id="el_type_idtype">
<span<?php echo $type_view->idtype->viewAttributes() ?>><?php echo $type_view->idtype->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($type_view->ident->Visible) { // ident ?>
	<tr id="r_ident">
		<td class="<?php echo $type_view->TableLeftColumnClass ?>"><span id="elh_type_ident"><?php echo $type_view->ident->caption() ?></span></td>
		<td data-name="ident" <?php echo $type_view->ident->cellAttributes() ?>>
<span id="el_type_ident">
<span<?php echo $type_view->ident->viewAttributes() ?>><?php echo $type_view->ident->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($type_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $type_view->TableLeftColumnClass ?>"><span id="elh_type_descrip"><?php echo $type_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $type_view->descrip->cellAttributes() ?>>
<span id="el_type_descrip">
<span<?php echo $type_view->descrip->viewAttributes() ?>><?php echo $type_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$type_view->IsModal) { ?>
<?php if (!$type_view->isExport()) { ?>
<?php echo $type_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$type_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$type_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$type_view->terminate();
?>