<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$type_list = new type_list();

// Run the page
$type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$type_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$type_list->isExport()) { ?>
<script>
var ftypelist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftypelist = currentForm = new ew.Form("ftypelist", "list");
	ftypelist.formKeyCountName = '<?php echo $type_list->FormKeyCountName ?>';
	loadjs.done("ftypelist");
});
var ftypelistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftypelistsrch = currentSearchForm = new ew.Form("ftypelistsrch");

	// Dynamic selection lists
	// Filters

	ftypelistsrch.filterList = <?php echo $type_list->getFilterList() ?>;
	loadjs.done("ftypelistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$type_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($type_list->TotalRecords > 0 && $type_list->ExportOptions->visible()) { ?>
<?php $type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($type_list->ImportOptions->visible()) { ?>
<?php $type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($type_list->SearchOptions->visible()) { ?>
<?php $type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($type_list->FilterOptions->visible()) { ?>
<?php $type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$type_list->isExport() && !$type->CurrentAction) { ?>
<form name="ftypelistsrch" id="ftypelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftypelistsrch-search-panel" class="<?php echo $type_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="type">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $type_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($type_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($type_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($type_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($type_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $type_list->showPageHeader(); ?>
<?php
$type_list->showMessage();
?>
<?php if ($type_list->TotalRecords > 0 || $type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> type">
<?php if (!$type_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$type_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $type_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftypelist" id="ftypelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="type">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_type" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($type_list->TotalRecords > 0 || $type_list->isGridEdit()) { ?>
<table id="tbl_typelist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$type->RowType = ROWTYPE_HEADER;

// Render list options
$type_list->renderListOptions();

// Render list options (header, left)
$type_list->ListOptions->render("header", "left");
?>
<?php if ($type_list->idtype->Visible) { // idtype ?>
	<?php if ($type_list->SortUrl($type_list->idtype) == "") { ?>
		<th data-name="idtype" class="<?php echo $type_list->idtype->headerCellClass() ?>"><div id="elh_type_idtype" class="type_idtype"><div class="ew-table-header-caption"><?php echo $type_list->idtype->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idtype" class="<?php echo $type_list->idtype->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $type_list->SortUrl($type_list->idtype) ?>', 1);"><div id="elh_type_idtype" class="type_idtype">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $type_list->idtype->caption() ?></span><span class="ew-table-header-sort"><?php if ($type_list->idtype->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($type_list->idtype->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($type_list->ident->Visible) { // ident ?>
	<?php if ($type_list->SortUrl($type_list->ident) == "") { ?>
		<th data-name="ident" class="<?php echo $type_list->ident->headerCellClass() ?>"><div id="elh_type_ident" class="type_ident"><div class="ew-table-header-caption"><?php echo $type_list->ident->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ident" class="<?php echo $type_list->ident->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $type_list->SortUrl($type_list->ident) ?>', 1);"><div id="elh_type_ident" class="type_ident">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $type_list->ident->caption() ?></span><span class="ew-table-header-sort"><?php if ($type_list->ident->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($type_list->ident->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($type_list->descrip->Visible) { // descrip ?>
	<?php if ($type_list->SortUrl($type_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $type_list->descrip->headerCellClass() ?>"><div id="elh_type_descrip" class="type_descrip"><div class="ew-table-header-caption"><?php echo $type_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $type_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $type_list->SortUrl($type_list->descrip) ?>', 1);"><div id="elh_type_descrip" class="type_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $type_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($type_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($type_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($type_list->ExportAll && $type_list->isExport()) {
	$type_list->StopRecord = $type_list->TotalRecords;
} else {

	// Set the last record to display
	if ($type_list->TotalRecords > $type_list->StartRecord + $type_list->DisplayRecords - 1)
		$type_list->StopRecord = $type_list->StartRecord + $type_list->DisplayRecords - 1;
	else
		$type_list->StopRecord = $type_list->TotalRecords;
}
$type_list->RecordCount = $type_list->StartRecord - 1;
if ($type_list->Recordset && !$type_list->Recordset->EOF) {
	$type_list->Recordset->moveFirst();
	$selectLimit = $type_list->UseSelectLimit;
	if (!$selectLimit && $type_list->StartRecord > 1)
		$type_list->Recordset->move($type_list->StartRecord - 1);
} elseif (!$type->AllowAddDeleteRow && $type_list->StopRecord == 0) {
	$type_list->StopRecord = $type->GridAddRowCount;
}

// Initialize aggregate
$type->RowType = ROWTYPE_AGGREGATEINIT;
$type->resetAttributes();
$type_list->renderRow();
while ($type_list->RecordCount < $type_list->StopRecord) {
	$type_list->RecordCount++;
	if ($type_list->RecordCount >= $type_list->StartRecord) {
		$type_list->RowCount++;

		// Set up key count
		$type_list->KeyCount = $type_list->RowIndex;

		// Init row class and style
		$type->resetAttributes();
		$type->CssClass = "";
		if ($type_list->isGridAdd()) {
		} else {
			$type_list->loadRowValues($type_list->Recordset); // Load row values
		}
		$type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$type->RowAttrs->merge(["data-rowindex" => $type_list->RowCount, "id" => "r" . $type_list->RowCount . "_type", "data-rowtype" => $type->RowType]);

		// Render row
		$type_list->renderRow();

		// Render list options
		$type_list->renderListOptions();
?>
	<tr <?php echo $type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$type_list->ListOptions->render("body", "left", $type_list->RowCount);
?>
	<?php if ($type_list->idtype->Visible) { // idtype ?>
		<td data-name="idtype" <?php echo $type_list->idtype->cellAttributes() ?>>
<span id="el<?php echo $type_list->RowCount ?>_type_idtype">
<span<?php echo $type_list->idtype->viewAttributes() ?>><?php echo $type_list->idtype->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($type_list->ident->Visible) { // ident ?>
		<td data-name="ident" <?php echo $type_list->ident->cellAttributes() ?>>
<span id="el<?php echo $type_list->RowCount ?>_type_ident">
<span<?php echo $type_list->ident->viewAttributes() ?>><?php echo $type_list->ident->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($type_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $type_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $type_list->RowCount ?>_type_descrip">
<span<?php echo $type_list->descrip->viewAttributes() ?>><?php echo $type_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$type_list->ListOptions->render("body", "right", $type_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$type_list->isGridAdd())
		$type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($type_list->Recordset)
	$type_list->Recordset->Close();
?>
<?php if (!$type_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$type_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $type_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($type_list->TotalRecords == 0 && !$type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$type_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$type_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$type_list->terminate();
?>