<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$type_edit = new type_edit();

// Run the page
$type_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$type_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var ftypeedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	ftypeedit = currentForm = new ew.Form("ftypeedit", "edit");

	// Validate form
	ftypeedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($type_edit->idtype->Required) { ?>
				elm = this.getElements("x" + infix + "_idtype");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $type_edit->idtype->caption(), $type_edit->idtype->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($type_edit->ident->Required) { ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $type_edit->ident->caption(), $type_edit->ident->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($type_edit->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $type_edit->descrip->caption(), $type_edit->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftypeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftypeedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("ftypeedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $type_edit->showPageHeader(); ?>
<?php
$type_edit->showMessage();
?>
<form name="ftypeedit" id="ftypeedit" class="<?php echo $type_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="type">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$type_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($type_edit->idtype->Visible) { // idtype ?>
	<div id="r_idtype" class="form-group row">
		<label id="elh_type_idtype" class="<?php echo $type_edit->LeftColumnClass ?>"><?php echo $type_edit->idtype->caption() ?><?php echo $type_edit->idtype->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $type_edit->RightColumnClass ?>"><div <?php echo $type_edit->idtype->cellAttributes() ?>>
<span id="el_type_idtype">
<span<?php echo $type_edit->idtype->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($type_edit->idtype->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="type" data-field="x_idtype" name="x_idtype" id="x_idtype" value="<?php echo HtmlEncode($type_edit->idtype->CurrentValue) ?>">
<?php echo $type_edit->idtype->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($type_edit->ident->Visible) { // ident ?>
	<div id="r_ident" class="form-group row">
		<label id="elh_type_ident" for="x_ident" class="<?php echo $type_edit->LeftColumnClass ?>"><?php echo $type_edit->ident->caption() ?><?php echo $type_edit->ident->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $type_edit->RightColumnClass ?>"><div <?php echo $type_edit->ident->cellAttributes() ?>>
<span id="el_type_ident">
<input type="text" data-table="type" data-field="x_ident" name="x_ident" id="x_ident" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($type_edit->ident->getPlaceHolder()) ?>" value="<?php echo $type_edit->ident->EditValue ?>"<?php echo $type_edit->ident->editAttributes() ?>>
</span>
<?php echo $type_edit->ident->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($type_edit->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_type_descrip" for="x_descrip" class="<?php echo $type_edit->LeftColumnClass ?>"><?php echo $type_edit->descrip->caption() ?><?php echo $type_edit->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $type_edit->RightColumnClass ?>"><div <?php echo $type_edit->descrip->cellAttributes() ?>>
<span id="el_type_descrip">
<input type="text" data-table="type" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($type_edit->descrip->getPlaceHolder()) ?>" value="<?php echo $type_edit->descrip->EditValue ?>"<?php echo $type_edit->descrip->editAttributes() ?>>
</span>
<?php echo $type_edit->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$type_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $type_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $type_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$type_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$type_edit->terminate();
?>