<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tabemp4_view = new tabemp4_view();

// Run the page
$tabemp4_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tabemp4_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tabemp4_view->isExport()) { ?>
<script>
var ftabemp4view, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	ftabemp4view = currentForm = new ew.Form("ftabemp4view", "view");
	loadjs.done("ftabemp4view");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tabemp4_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $tabemp4_view->ExportOptions->render("body") ?>
<?php $tabemp4_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $tabemp4_view->showPageHeader(); ?>
<?php
$tabemp4_view->showMessage();
?>
<?php if (!$tabemp4_view->IsModal) { ?>
<?php if (!$tabemp4_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tabemp4_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="ftabemp4view" id="ftabemp4view" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tabemp4">
<input type="hidden" name="modal" value="<?php echo (int)$tabemp4_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($tabemp4_view->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_id"><?php echo $tabemp4_view->id->caption() ?></span></td>
		<td data-name="id" <?php echo $tabemp4_view->id->cellAttributes() ?>>
<span id="el_tabemp4_id">
<span<?php echo $tabemp4_view->id->viewAttributes() ?>><?php echo $tabemp4_view->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->RN->Visible) { // RN ?>
	<tr id="r_RN">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_RN"><?php echo $tabemp4_view->RN->caption() ?></span></td>
		<td data-name="RN" <?php echo $tabemp4_view->RN->cellAttributes() ?>>
<span id="el_tabemp4_RN">
<span<?php echo $tabemp4_view->RN->viewAttributes() ?>><?php echo $tabemp4_view->RN->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->NO_EMP->Visible) { // NO_EMP ?>
	<tr id="r_NO_EMP">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_NO_EMP"><?php echo $tabemp4_view->NO_EMP->caption() ?></span></td>
		<td data-name="NO_EMP" <?php echo $tabemp4_view->NO_EMP->cellAttributes() ?>>
<span id="el_tabemp4_NO_EMP">
<span<?php echo $tabemp4_view->NO_EMP->viewAttributes() ?>><?php echo $tabemp4_view->NO_EMP->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->NOM_EMP->Visible) { // NOM_EMP ?>
	<tr id="r_NOM_EMP">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_NOM_EMP"><?php echo $tabemp4_view->NOM_EMP->caption() ?></span></td>
		<td data-name="NOM_EMP" <?php echo $tabemp4_view->NOM_EMP->cellAttributes() ?>>
<span id="el_tabemp4_NOM_EMP">
<span<?php echo $tabemp4_view->NOM_EMP->viewAttributes() ?>><?php echo $tabemp4_view->NOM_EMP->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->SEXE->Visible) { // SEXE ?>
	<tr id="r_SEXE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_SEXE"><?php echo $tabemp4_view->SEXE->caption() ?></span></td>
		<td data-name="SEXE" <?php echo $tabemp4_view->SEXE->cellAttributes() ?>>
<span id="el_tabemp4_SEXE">
<span<?php echo $tabemp4_view->SEXE->viewAttributes() ?>><?php echo $tabemp4_view->SEXE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ETAT_C->Visible) { // ETAT_C ?>
	<tr id="r_ETAT_C">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ETAT_C"><?php echo $tabemp4_view->ETAT_C->caption() ?></span></td>
		<td data-name="ETAT_C" <?php echo $tabemp4_view->ETAT_C->cellAttributes() ?>>
<span id="el_tabemp4_ETAT_C">
<span<?php echo $tabemp4_view->ETAT_C->viewAttributes() ?>><?php echo $tabemp4_view->ETAT_C->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->DEPEND->Visible) { // DEPEND ?>
	<tr id="r_DEPEND">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_DEPEND"><?php echo $tabemp4_view->DEPEND->caption() ?></span></td>
		<td data-name="DEPEND" <?php echo $tabemp4_view->DEPEND->cellAttributes() ?>>
<span id="el_tabemp4_DEPEND">
<span<?php echo $tabemp4_view->DEPEND->viewAttributes() ?>><?php echo $tabemp4_view->DEPEND->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->DTE_NAIS->Visible) { // DTE_NAIS ?>
	<tr id="r_DTE_NAIS">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_DTE_NAIS"><?php echo $tabemp4_view->DTE_NAIS->caption() ?></span></td>
		<td data-name="DTE_NAIS" <?php echo $tabemp4_view->DTE_NAIS->cellAttributes() ?>>
<span id="el_tabemp4_DTE_NAIS">
<span<?php echo $tabemp4_view->DTE_NAIS->viewAttributes() ?>><?php echo $tabemp4_view->DTE_NAIS->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->LIEU_NAIS->Visible) { // LIEU_NAIS ?>
	<tr id="r_LIEU_NAIS">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_LIEU_NAIS"><?php echo $tabemp4_view->LIEU_NAIS->caption() ?></span></td>
		<td data-name="LIEU_NAIS" <?php echo $tabemp4_view->LIEU_NAIS->cellAttributes() ?>>
<span id="el_tabemp4_LIEU_NAIS">
<span<?php echo $tabemp4_view->LIEU_NAIS->viewAttributes() ?>><?php echo $tabemp4_view->LIEU_NAIS->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->NATION->Visible) { // NATION ?>
	<tr id="r_NATION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_NATION"><?php echo $tabemp4_view->NATION->caption() ?></span></td>
		<td data-name="NATION" <?php echo $tabemp4_view->NATION->cellAttributes() ?>>
<span id="el_tabemp4_NATION">
<span<?php echo $tabemp4_view->NATION->viewAttributes() ?>><?php echo $tabemp4_view->NATION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ADRESSE->Visible) { // ADRESSE ?>
	<tr id="r_ADRESSE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ADRESSE"><?php echo $tabemp4_view->ADRESSE->caption() ?></span></td>
		<td data-name="ADRESSE" <?php echo $tabemp4_view->ADRESSE->cellAttributes() ?>>
<span id="el_tabemp4_ADRESSE">
<span<?php echo $tabemp4_view->ADRESSE->viewAttributes() ?>><?php echo $tabemp4_view->ADRESSE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->VILLE->Visible) { // VILLE ?>
	<tr id="r_VILLE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_VILLE"><?php echo $tabemp4_view->VILLE->caption() ?></span></td>
		<td data-name="VILLE" <?php echo $tabemp4_view->VILLE->cellAttributes() ?>>
<span id="el_tabemp4_VILLE">
<span<?php echo $tabemp4_view->VILLE->viewAttributes() ?>><?php echo $tabemp4_view->VILLE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PAYS->Visible) { // PAYS ?>
	<tr id="r_PAYS">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PAYS"><?php echo $tabemp4_view->PAYS->caption() ?></span></td>
		<td data-name="PAYS" <?php echo $tabemp4_view->PAYS->cellAttributes() ?>>
<span id="el_tabemp4_PAYS">
<span<?php echo $tabemp4_view->PAYS->viewAttributes() ?>><?php echo $tabemp4_view->PAYS->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->BOX->Visible) { // BOX ?>
	<tr id="r_BOX">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_BOX"><?php echo $tabemp4_view->BOX->caption() ?></span></td>
		<td data-name="BOX" <?php echo $tabemp4_view->BOX->cellAttributes() ?>>
<span id="el_tabemp4_BOX">
<span<?php echo $tabemp4_view->BOX->viewAttributes() ?>><?php echo $tabemp4_view->BOX->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PHONE->Visible) { // PHONE ?>
	<tr id="r_PHONE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PHONE"><?php echo $tabemp4_view->PHONE->caption() ?></span></td>
		<td data-name="PHONE" <?php echo $tabemp4_view->PHONE->cellAttributes() ?>>
<span id="el_tabemp4_PHONE">
<span<?php echo $tabemp4_view->PHONE->viewAttributes() ?>><?php echo $tabemp4_view->PHONE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->REFERENCE->Visible) { // REFERENCE ?>
	<tr id="r_REFERENCE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_REFERENCE"><?php echo $tabemp4_view->REFERENCE->caption() ?></span></td>
		<td data-name="REFERENCE" <?php echo $tabemp4_view->REFERENCE->cellAttributes() ?>>
<span id="el_tabemp4_REFERENCE">
<span<?php echo $tabemp4_view->REFERENCE->viewAttributes() ?>><?php echo $tabemp4_view->REFERENCE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->QUALIF->Visible) { // QUALIF ?>
	<tr id="r_QUALIF">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_QUALIF"><?php echo $tabemp4_view->QUALIF->caption() ?></span></td>
		<td data-name="QUALIF" <?php echo $tabemp4_view->QUALIF->cellAttributes() ?>>
<span id="el_tabemp4_QUALIF">
<span<?php echo $tabemp4_view->QUALIF->viewAttributes() ?>><?php echo $tabemp4_view->QUALIF->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->URGENCE->Visible) { // URGENCE ?>
	<tr id="r_URGENCE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_URGENCE"><?php echo $tabemp4_view->URGENCE->caption() ?></span></td>
		<td data-name="URGENCE" <?php echo $tabemp4_view->URGENCE->cellAttributes() ?>>
<span id="el_tabemp4_URGENCE">
<span<?php echo $tabemp4_view->URGENCE->viewAttributes() ?>><?php echo $tabemp4_view->URGENCE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PHONE_URG->Visible) { // PHONE_URG ?>
	<tr id="r_PHONE_URG">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PHONE_URG"><?php echo $tabemp4_view->PHONE_URG->caption() ?></span></td>
		<td data-name="PHONE_URG" <?php echo $tabemp4_view->PHONE_URG->cellAttributes() ?>>
<span id="el_tabemp4_PHONE_URG">
<span<?php echo $tabemp4_view->PHONE_URG->viewAttributes() ?>><?php echo $tabemp4_view->PHONE_URG->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->DATE_EMP->Visible) { // DATE_EMP ?>
	<tr id="r_DATE_EMP">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_DATE_EMP"><?php echo $tabemp4_view->DATE_EMP->caption() ?></span></td>
		<td data-name="DATE_EMP" <?php echo $tabemp4_view->DATE_EMP->cellAttributes() ?>>
<span id="el_tabemp4_DATE_EMP">
<span<?php echo $tabemp4_view->DATE_EMP->viewAttributes() ?>><?php echo $tabemp4_view->DATE_EMP->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->SERVICE->Visible) { // SERVICE ?>
	<tr id="r_SERVICE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_SERVICE"><?php echo $tabemp4_view->SERVICE->caption() ?></span></td>
		<td data-name="SERVICE" <?php echo $tabemp4_view->SERVICE->cellAttributes() ?>>
<span id="el_tabemp4_SERVICE">
<span<?php echo $tabemp4_view->SERVICE->viewAttributes() ?>><?php echo $tabemp4_view->SERVICE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->DEPT->Visible) { // DEPT ?>
	<tr id="r_DEPT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_DEPT"><?php echo $tabemp4_view->DEPT->caption() ?></span></td>
		<td data-name="DEPT" <?php echo $tabemp4_view->DEPT->cellAttributes() ?>>
<span id="el_tabemp4_DEPT">
<span<?php echo $tabemp4_view->DEPT->viewAttributes() ?>><?php echo $tabemp4_view->DEPT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->SECTION->Visible) { // SECTION ?>
	<tr id="r_SECTION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_SECTION"><?php echo $tabemp4_view->SECTION->caption() ?></span></td>
		<td data-name="SECTION" <?php echo $tabemp4_view->SECTION->cellAttributes() ?>>
<span id="el_tabemp4_SECTION">
<span<?php echo $tabemp4_view->SECTION->viewAttributes() ?>><?php echo $tabemp4_view->SECTION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->CATEGORIE->Visible) { // CATEGORIE ?>
	<tr id="r_CATEGORIE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_CATEGORIE"><?php echo $tabemp4_view->CATEGORIE->caption() ?></span></td>
		<td data-name="CATEGORIE" <?php echo $tabemp4_view->CATEGORIE->cellAttributes() ?>>
<span id="el_tabemp4_CATEGORIE">
<span<?php echo $tabemp4_view->CATEGORIE->viewAttributes() ?>><?php echo $tabemp4_view->CATEGORIE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->FONCTION->Visible) { // FONCTION ?>
	<tr id="r_FONCTION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_FONCTION"><?php echo $tabemp4_view->FONCTION->caption() ?></span></td>
		<td data-name="FONCTION" <?php echo $tabemp4_view->FONCTION->cellAttributes() ?>>
<span id="el_tabemp4_FONCTION">
<span<?php echo $tabemp4_view->FONCTION->viewAttributes() ?>><?php echo $tabemp4_view->FONCTION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->STATUT->Visible) { // STATUT ?>
	<tr id="r_STATUT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_STATUT"><?php echo $tabemp4_view->STATUT->caption() ?></span></td>
		<td data-name="STATUT" <?php echo $tabemp4_view->STATUT->cellAttributes() ?>>
<span id="el_tabemp4_STATUT">
<span<?php echo $tabemp4_view->STATUT->viewAttributes() ?>><?php echo $tabemp4_view->STATUT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->STA_DEBUT->Visible) { // STA_DEBUT ?>
	<tr id="r_STA_DEBUT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_STA_DEBUT"><?php echo $tabemp4_view->STA_DEBUT->caption() ?></span></td>
		<td data-name="STA_DEBUT" <?php echo $tabemp4_view->STA_DEBUT->cellAttributes() ?>>
<span id="el_tabemp4_STA_DEBUT">
<span<?php echo $tabemp4_view->STA_DEBUT->viewAttributes() ?>><?php echo $tabemp4_view->STA_DEBUT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->STA_FIN->Visible) { // STA_FIN ?>
	<tr id="r_STA_FIN">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_STA_FIN"><?php echo $tabemp4_view->STA_FIN->caption() ?></span></td>
		<td data-name="STA_FIN" <?php echo $tabemp4_view->STA_FIN->cellAttributes() ?>>
<span id="el_tabemp4_STA_FIN">
<span<?php echo $tabemp4_view->STA_FIN->viewAttributes() ?>><?php echo $tabemp4_view->STA_FIN->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->STA_MOTIF->Visible) { // STA_MOTIF ?>
	<tr id="r_STA_MOTIF">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_STA_MOTIF"><?php echo $tabemp4_view->STA_MOTIF->caption() ?></span></td>
		<td data-name="STA_MOTIF" <?php echo $tabemp4_view->STA_MOTIF->cellAttributes() ?>>
<span id="el_tabemp4_STA_MOTIF">
<span<?php echo $tabemp4_view->STA_MOTIF->viewAttributes() ?>><?php echo $tabemp4_view->STA_MOTIF->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->NO_NIF->Visible) { // NO_NIF ?>
	<tr id="r_NO_NIF">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_NO_NIF"><?php echo $tabemp4_view->NO_NIF->caption() ?></span></td>
		<td data-name="NO_NIF" <?php echo $tabemp4_view->NO_NIF->cellAttributes() ?>>
<span id="el_tabemp4_NO_NIF">
<span<?php echo $tabemp4_view->NO_NIF->viewAttributes() ?>><?php echo $tabemp4_view->NO_NIF->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->NO_ONA->Visible) { // NO_ONA ?>
	<tr id="r_NO_ONA">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_NO_ONA"><?php echo $tabemp4_view->NO_ONA->caption() ?></span></td>
		<td data-name="NO_ONA" <?php echo $tabemp4_view->NO_ONA->cellAttributes() ?>>
<span id="el_tabemp4_NO_ONA">
<span<?php echo $tabemp4_view->NO_ONA->viewAttributes() ?>><?php echo $tabemp4_view->NO_ONA->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->LIV_TRAV->Visible) { // LIV_TRAV ?>
	<tr id="r_LIV_TRAV">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_LIV_TRAV"><?php echo $tabemp4_view->LIV_TRAV->caption() ?></span></td>
		<td data-name="LIV_TRAV" <?php echo $tabemp4_view->LIV_TRAV->cellAttributes() ?>>
<span id="el_tabemp4_LIV_TRAV">
<span<?php echo $tabemp4_view->LIV_TRAV->viewAttributes() ?>><?php echo $tabemp4_view->LIV_TRAV->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->MT_SALAIRE->Visible) { // MT_SALAIRE ?>
	<tr id="r_MT_SALAIRE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_MT_SALAIRE"><?php echo $tabemp4_view->MT_SALAIRE->caption() ?></span></td>
		<td data-name="MT_SALAIRE" <?php echo $tabemp4_view->MT_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_MT_SALAIRE">
<span<?php echo $tabemp4_view->MT_SALAIRE->viewAttributes() ?>><?php echo $tabemp4_view->MT_SALAIRE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->MT_FRAIS->Visible) { // MT_FRAIS ?>
	<tr id="r_MT_FRAIS">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_MT_FRAIS"><?php echo $tabemp4_view->MT_FRAIS->caption() ?></span></td>
		<td data-name="MT_FRAIS" <?php echo $tabemp4_view->MT_FRAIS->cellAttributes() ?>>
<span id="el_tabemp4_MT_FRAIS">
<span<?php echo $tabemp4_view->MT_FRAIS->viewAttributes() ?>><?php echo $tabemp4_view->MT_FRAIS->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->MT_AUTRES->Visible) { // MT_AUTRES ?>
	<tr id="r_MT_AUTRES">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_MT_AUTRES"><?php echo $tabemp4_view->MT_AUTRES->caption() ?></span></td>
		<td data-name="MT_AUTRES" <?php echo $tabemp4_view->MT_AUTRES->cellAttributes() ?>>
<span id="el_tabemp4_MT_AUTRES">
<span<?php echo $tabemp4_view->MT_AUTRES->viewAttributes() ?>><?php echo $tabemp4_view->MT_AUTRES->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->MODE->Visible) { // MODE ?>
	<tr id="r_MODE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_MODE"><?php echo $tabemp4_view->MODE->caption() ?></span></td>
		<td data-name="MODE" <?php echo $tabemp4_view->MODE->cellAttributes() ?>>
<span id="el_tabemp4_MODE">
<span<?php echo $tabemp4_view->MODE->viewAttributes() ?>><?php echo $tabemp4_view->MODE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->TYPE->Visible) { // TYPE ?>
	<tr id="r_TYPE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_TYPE"><?php echo $tabemp4_view->TYPE->caption() ?></span></td>
		<td data-name="TYPE" <?php echo $tabemp4_view->TYPE->cellAttributes() ?>>
<span id="el_tabemp4_TYPE">
<span<?php echo $tabemp4_view->TYPE->viewAttributes() ?>><?php echo $tabemp4_view->TYPE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->MT_IMPOT->Visible) { // MT_IMPOT ?>
	<tr id="r_MT_IMPOT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_MT_IMPOT"><?php echo $tabemp4_view->MT_IMPOT->caption() ?></span></td>
		<td data-name="MT_IMPOT" <?php echo $tabemp4_view->MT_IMPOT->cellAttributes() ?>>
<span id="el_tabemp4_MT_IMPOT">
<span<?php echo $tabemp4_view->MT_IMPOT->viewAttributes() ?>><?php echo $tabemp4_view->MT_IMPOT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_IMPOT->Visible) { // PER_IMPOT ?>
	<tr id="r_PER_IMPOT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_IMPOT"><?php echo $tabemp4_view->PER_IMPOT->caption() ?></span></td>
		<td data-name="PER_IMPOT" <?php echo $tabemp4_view->PER_IMPOT->cellAttributes() ?>>
<span id="el_tabemp4_PER_IMPOT">
<span<?php echo $tabemp4_view->PER_IMPOT->viewAttributes() ?>><?php echo $tabemp4_view->PER_IMPOT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PRET_ONA->Visible) { // PRET_ONA ?>
	<tr id="r_PRET_ONA">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PRET_ONA"><?php echo $tabemp4_view->PRET_ONA->caption() ?></span></td>
		<td data-name="PRET_ONA" <?php echo $tabemp4_view->PRET_ONA->cellAttributes() ?>>
<span id="el_tabemp4_PRET_ONA">
<span<?php echo $tabemp4_view->PRET_ONA->viewAttributes() ?>><?php echo $tabemp4_view->PRET_ONA->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_ONA->Visible) { // PER_ONA ?>
	<tr id="r_PER_ONA">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_ONA"><?php echo $tabemp4_view->PER_ONA->caption() ?></span></td>
		<td data-name="PER_ONA" <?php echo $tabemp4_view->PER_ONA->cellAttributes() ?>>
<span id="el_tabemp4_PER_ONA">
<span<?php echo $tabemp4_view->PER_ONA->viewAttributes() ?>><?php echo $tabemp4_view->PER_ONA->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->RET_ASSUR->Visible) { // RET_ASSUR ?>
	<tr id="r_RET_ASSUR">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_RET_ASSUR"><?php echo $tabemp4_view->RET_ASSUR->caption() ?></span></td>
		<td data-name="RET_ASSUR" <?php echo $tabemp4_view->RET_ASSUR->cellAttributes() ?>>
<span id="el_tabemp4_RET_ASSUR">
<span<?php echo $tabemp4_view->RET_ASSUR->viewAttributes() ?>><?php echo $tabemp4_view->RET_ASSUR->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_ASSUR->Visible) { // PER_ASSUR ?>
	<tr id="r_PER_ASSUR">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_ASSUR"><?php echo $tabemp4_view->PER_ASSUR->caption() ?></span></td>
		<td data-name="PER_ASSUR" <?php echo $tabemp4_view->PER_ASSUR->cellAttributes() ?>>
<span id="el_tabemp4_PER_ASSUR">
<span<?php echo $tabemp4_view->PER_ASSUR->viewAttributes() ?>><?php echo $tabemp4_view->PER_ASSUR->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PRET_SALAIRE->Visible) { // PRET_SALAIRE ?>
	<tr id="r_PRET_SALAIRE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PRET_SALAIRE"><?php echo $tabemp4_view->PRET_SALAIRE->caption() ?></span></td>
		<td data-name="PRET_SALAIRE" <?php echo $tabemp4_view->PRET_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_PRET_SALAIRE">
<span<?php echo $tabemp4_view->PRET_SALAIRE->viewAttributes() ?>><?php echo $tabemp4_view->PRET_SALAIRE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_SALAIRE->Visible) { // PER_SALAIRE ?>
	<tr id="r_PER_SALAIRE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_SALAIRE"><?php echo $tabemp4_view->PER_SALAIRE->caption() ?></span></td>
		<td data-name="PER_SALAIRE" <?php echo $tabemp4_view->PER_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_PER_SALAIRE">
<span<?php echo $tabemp4_view->PER_SALAIRE->viewAttributes() ?>><?php echo $tabemp4_view->PER_SALAIRE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->RET_PENSION->Visible) { // RET_PENSION ?>
	<tr id="r_RET_PENSION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_RET_PENSION"><?php echo $tabemp4_view->RET_PENSION->caption() ?></span></td>
		<td data-name="RET_PENSION" <?php echo $tabemp4_view->RET_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_RET_PENSION">
<span<?php echo $tabemp4_view->RET_PENSION->viewAttributes() ?>><?php echo $tabemp4_view->RET_PENSION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_RETPENSION->Visible) { // PER_RETPENSION ?>
	<tr id="r_PER_RETPENSION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_RETPENSION"><?php echo $tabemp4_view->PER_RETPENSION->caption() ?></span></td>
		<td data-name="PER_RETPENSION" <?php echo $tabemp4_view->PER_RETPENSION->cellAttributes() ?>>
<span id="el_tabemp4_PER_RETPENSION">
<span<?php echo $tabemp4_view->PER_RETPENSION->viewAttributes() ?>><?php echo $tabemp4_view->PER_RETPENSION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PRET_BANQUE->Visible) { // PRET_BANQUE ?>
	<tr id="r_PRET_BANQUE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PRET_BANQUE"><?php echo $tabemp4_view->PRET_BANQUE->caption() ?></span></td>
		<td data-name="PRET_BANQUE" <?php echo $tabemp4_view->PRET_BANQUE->cellAttributes() ?>>
<span id="el_tabemp4_PRET_BANQUE">
<span<?php echo $tabemp4_view->PRET_BANQUE->viewAttributes() ?>><?php echo $tabemp4_view->PRET_BANQUE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_BANQUE->Visible) { // PER_BANQUE ?>
	<tr id="r_PER_BANQUE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_BANQUE"><?php echo $tabemp4_view->PER_BANQUE->caption() ?></span></td>
		<td data-name="PER_BANQUE" <?php echo $tabemp4_view->PER_BANQUE->cellAttributes() ?>>
<span id="el_tabemp4_PER_BANQUE">
<span<?php echo $tabemp4_view->PER_BANQUE->viewAttributes() ?>><?php echo $tabemp4_view->PER_BANQUE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->RET_AVANC->Visible) { // RET_AVANC ?>
	<tr id="r_RET_AVANC">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_RET_AVANC"><?php echo $tabemp4_view->RET_AVANC->caption() ?></span></td>
		<td data-name="RET_AVANC" <?php echo $tabemp4_view->RET_AVANC->cellAttributes() ?>>
<span id="el_tabemp4_RET_AVANC">
<span<?php echo $tabemp4_view->RET_AVANC->viewAttributes() ?>><?php echo $tabemp4_view->RET_AVANC->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_AVANCE->Visible) { // PER_AVANCE ?>
	<tr id="r_PER_AVANCE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_AVANCE"><?php echo $tabemp4_view->PER_AVANCE->caption() ?></span></td>
		<td data-name="PER_AVANCE" <?php echo $tabemp4_view->PER_AVANCE->cellAttributes() ?>>
<span id="el_tabemp4_PER_AVANCE">
<span<?php echo $tabemp4_view->PER_AVANCE->viewAttributes() ?>><?php echo $tabemp4_view->PER_AVANCE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PRET_PENSION->Visible) { // PRET_PENSION ?>
	<tr id="r_PRET_PENSION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PRET_PENSION"><?php echo $tabemp4_view->PRET_PENSION->caption() ?></span></td>
		<td data-name="PRET_PENSION" <?php echo $tabemp4_view->PRET_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_PRET_PENSION">
<span<?php echo $tabemp4_view->PRET_PENSION->viewAttributes() ?>><?php echo $tabemp4_view->PRET_PENSION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_PENSION->Visible) { // PER_PENSION ?>
	<tr id="r_PER_PENSION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_PENSION"><?php echo $tabemp4_view->PER_PENSION->caption() ?></span></td>
		<td data-name="PER_PENSION" <?php echo $tabemp4_view->PER_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_PER_PENSION">
<span<?php echo $tabemp4_view->PER_PENSION->viewAttributes() ?>><?php echo $tabemp4_view->PER_PENSION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->RET_CAFET->Visible) { // RET_CAFET ?>
	<tr id="r_RET_CAFET">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_RET_CAFET"><?php echo $tabemp4_view->RET_CAFET->caption() ?></span></td>
		<td data-name="RET_CAFET" <?php echo $tabemp4_view->RET_CAFET->cellAttributes() ?>>
<span id="el_tabemp4_RET_CAFET">
<span<?php echo $tabemp4_view->RET_CAFET->viewAttributes() ?>><?php echo $tabemp4_view->RET_CAFET->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_CAFET->Visible) { // PER_CAFET ?>
	<tr id="r_PER_CAFET">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_CAFET"><?php echo $tabemp4_view->PER_CAFET->caption() ?></span></td>
		<td data-name="PER_CAFET" <?php echo $tabemp4_view->PER_CAFET->cellAttributes() ?>>
<span id="el_tabemp4_PER_CAFET">
<span<?php echo $tabemp4_view->PER_CAFET->viewAttributes() ?>><?php echo $tabemp4_view->PER_CAFET->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->RET_CITE->Visible) { // RET_CITE ?>
	<tr id="r_RET_CITE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_RET_CITE"><?php echo $tabemp4_view->RET_CITE->caption() ?></span></td>
		<td data-name="RET_CITE" <?php echo $tabemp4_view->RET_CITE->cellAttributes() ?>>
<span id="el_tabemp4_RET_CITE">
<span<?php echo $tabemp4_view->RET_CITE->viewAttributes() ?>><?php echo $tabemp4_view->RET_CITE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_CITE->Visible) { // PER_CITE ?>
	<tr id="r_PER_CITE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_CITE"><?php echo $tabemp4_view->PER_CITE->caption() ?></span></td>
		<td data-name="PER_CITE" <?php echo $tabemp4_view->PER_CITE->cellAttributes() ?>>
<span id="el_tabemp4_PER_CITE">
<span<?php echo $tabemp4_view->PER_CITE->viewAttributes() ?>><?php echo $tabemp4_view->PER_CITE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->RET_AUTRE->Visible) { // RET_AUTRE ?>
	<tr id="r_RET_AUTRE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_RET_AUTRE"><?php echo $tabemp4_view->RET_AUTRE->caption() ?></span></td>
		<td data-name="RET_AUTRE" <?php echo $tabemp4_view->RET_AUTRE->cellAttributes() ?>>
<span id="el_tabemp4_RET_AUTRE">
<span<?php echo $tabemp4_view->RET_AUTRE->viewAttributes() ?>><?php echo $tabemp4_view->RET_AUTRE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->PER_AUTRE->Visible) { // PER_AUTRE ?>
	<tr id="r_PER_AUTRE">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_PER_AUTRE"><?php echo $tabemp4_view->PER_AUTRE->caption() ?></span></td>
		<td data-name="PER_AUTRE" <?php echo $tabemp4_view->PER_AUTRE->cellAttributes() ?>>
<span id="el_tabemp4_PER_AUTRE">
<span<?php echo $tabemp4_view->PER_AUTRE->viewAttributes() ?>><?php echo $tabemp4_view->PER_AUTRE->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACQ_NB_CON->Visible) { // ACQ_NB_CON ?>
	<tr id="r_ACQ_NB_CON">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACQ_NB_CON"><?php echo $tabemp4_view->ACQ_NB_CON->caption() ?></span></td>
		<td data-name="ACQ_NB_CON" <?php echo $tabemp4_view->ACQ_NB_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACQ_NB_CON">
<span<?php echo $tabemp4_view->ACQ_NB_CON->viewAttributes() ?>><?php echo $tabemp4_view->ACQ_NB_CON->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_MT_BRUT->Visible) { // ACC_MT_BRUT ?>
	<tr id="r_ACC_MT_BRUT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_MT_BRUT"><?php echo $tabemp4_view->ACC_MT_BRUT->caption() ?></span></td>
		<td data-name="ACC_MT_BRUT" <?php echo $tabemp4_view->ACC_MT_BRUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_BRUT">
<span<?php echo $tabemp4_view->ACC_MT_BRUT->viewAttributes() ?>><?php echo $tabemp4_view->ACC_MT_BRUT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_CON->Visible) { // ACC_NB_CON ?>
	<tr id="r_ACC_NB_CON">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_CON"><?php echo $tabemp4_view->ACC_NB_CON->caption() ?></span></td>
		<td data-name="ACC_NB_CON" <?php echo $tabemp4_view->ACC_NB_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_CON">
<span<?php echo $tabemp4_view->ACC_NB_CON->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_CON->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_PCON->Visible) { // ACC_NB_PCON ?>
	<tr id="r_ACC_NB_PCON">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_PCON"><?php echo $tabemp4_view->ACC_NB_PCON->caption() ?></span></td>
		<td data-name="ACC_NB_PCON" <?php echo $tabemp4_view->ACC_NB_PCON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_PCON">
<span<?php echo $tabemp4_view->ACC_NB_PCON->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_PCON->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_MT_OVT->Visible) { // ACC_MT_OVT ?>
	<tr id="r_ACC_MT_OVT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_MT_OVT"><?php echo $tabemp4_view->ACC_MT_OVT->caption() ?></span></td>
		<td data-name="ACC_MT_OVT" <?php echo $tabemp4_view->ACC_MT_OVT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_OVT">
<span<?php echo $tabemp4_view->ACC_MT_OVT->viewAttributes() ?>><?php echo $tabemp4_view->ACC_MT_OVT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACQ_NB_MAL->Visible) { // ACQ_NB_MAL ?>
	<tr id="r_ACQ_NB_MAL">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACQ_NB_MAL"><?php echo $tabemp4_view->ACQ_NB_MAL->caption() ?></span></td>
		<td data-name="ACQ_NB_MAL" <?php echo $tabemp4_view->ACQ_NB_MAL->cellAttributes() ?>>
<span id="el_tabemp4_ACQ_NB_MAL">
<span<?php echo $tabemp4_view->ACQ_NB_MAL->viewAttributes() ?>><?php echo $tabemp4_view->ACQ_NB_MAL->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_MAL->Visible) { // ACC_NB_MAL ?>
	<tr id="r_ACC_NB_MAL">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_MAL"><?php echo $tabemp4_view->ACC_NB_MAL->caption() ?></span></td>
		<td data-name="ACC_NB_MAL" <?php echo $tabemp4_view->ACC_NB_MAL->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_MAL">
<span<?php echo $tabemp4_view->ACC_NB_MAL->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_MAL->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_MT_CON->Visible) { // ACC_MT_CON ?>
	<tr id="r_ACC_MT_CON">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_MT_CON"><?php echo $tabemp4_view->ACC_MT_CON->caption() ?></span></td>
		<td data-name="ACC_MT_CON" <?php echo $tabemp4_view->ACC_MT_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_CON">
<span<?php echo $tabemp4_view->ACC_MT_CON->viewAttributes() ?>><?php echo $tabemp4_view->ACC_MT_CON->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_MAT->Visible) { // ACC_NB_MAT ?>
	<tr id="r_ACC_NB_MAT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_MAT"><?php echo $tabemp4_view->ACC_NB_MAT->caption() ?></span></td>
		<td data-name="ACC_NB_MAT" <?php echo $tabemp4_view->ACC_NB_MAT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_MAT">
<span<?php echo $tabemp4_view->ACC_NB_MAT->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_MAT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_MT_BONI->Visible) { // ACC_MT_BONI ?>
	<tr id="r_ACC_MT_BONI">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_MT_BONI"><?php echo $tabemp4_view->ACC_MT_BONI->caption() ?></span></td>
		<td data-name="ACC_MT_BONI" <?php echo $tabemp4_view->ACC_MT_BONI->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_BONI">
<span<?php echo $tabemp4_view->ACC_MT_BONI->viewAttributes() ?>><?php echo $tabemp4_view->ACC_MT_BONI->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_PER->Visible) { // ACC_NB_PER ?>
	<tr id="r_ACC_NB_PER">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_PER"><?php echo $tabemp4_view->ACC_NB_PER->caption() ?></span></td>
		<td data-name="ACC_NB_PER" <?php echo $tabemp4_view->ACC_NB_PER->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_PER">
<span<?php echo $tabemp4_view->ACC_NB_PER->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_PER->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_MT_AUT->Visible) { // ACC_MT_AUT ?>
	<tr id="r_ACC_MT_AUT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_MT_AUT"><?php echo $tabemp4_view->ACC_MT_AUT->caption() ?></span></td>
		<td data-name="ACC_MT_AUT" <?php echo $tabemp4_view->ACC_MT_AUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_AUT">
<span<?php echo $tabemp4_view->ACC_MT_AUT->viewAttributes() ?>><?php echo $tabemp4_view->ACC_MT_AUT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_COM->Visible) { // ACC_NB_COM ?>
	<tr id="r_ACC_NB_COM">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_COM"><?php echo $tabemp4_view->ACC_NB_COM->caption() ?></span></td>
		<td data-name="ACC_NB_COM" <?php echo $tabemp4_view->ACC_NB_COM->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_COM">
<span<?php echo $tabemp4_view->ACC_NB_COM->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_COM->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_BAL_SAL->Visible) { // ACC_BAL_SAL ?>
	<tr id="r_ACC_BAL_SAL">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_BAL_SAL"><?php echo $tabemp4_view->ACC_BAL_SAL->caption() ?></span></td>
		<td data-name="ACC_BAL_SAL" <?php echo $tabemp4_view->ACC_BAL_SAL->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_SAL">
<span<?php echo $tabemp4_view->ACC_BAL_SAL->viewAttributes() ?>><?php echo $tabemp4_view->ACC_BAL_SAL->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_BAL_BAN->Visible) { // ACC_BAL_BAN ?>
	<tr id="r_ACC_BAL_BAN">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_BAL_BAN"><?php echo $tabemp4_view->ACC_BAL_BAN->caption() ?></span></td>
		<td data-name="ACC_BAL_BAN" <?php echo $tabemp4_view->ACC_BAL_BAN->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_BAN">
<span<?php echo $tabemp4_view->ACC_BAL_BAN->viewAttributes() ?>><?php echo $tabemp4_view->ACC_BAL_BAN->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_SUS->Visible) { // ACC_NB_SUS ?>
	<tr id="r_ACC_NB_SUS">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_SUS"><?php echo $tabemp4_view->ACC_NB_SUS->caption() ?></span></td>
		<td data-name="ACC_NB_SUS" <?php echo $tabemp4_view->ACC_NB_SUS->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_SUS">
<span<?php echo $tabemp4_view->ACC_NB_SUS->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_SUS->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_BAL_ONA->Visible) { // ACC_BAL_ONA ?>
	<tr id="r_ACC_BAL_ONA">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_BAL_ONA"><?php echo $tabemp4_view->ACC_BAL_ONA->caption() ?></span></td>
		<td data-name="ACC_BAL_ONA" <?php echo $tabemp4_view->ACC_BAL_ONA->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_ONA">
<span<?php echo $tabemp4_view->ACC_BAL_ONA->viewAttributes() ?>><?php echo $tabemp4_view->ACC_BAL_ONA->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_BAL_PENSION->Visible) { // ACC_BAL_PENSION ?>
	<tr id="r_ACC_BAL_PENSION">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_BAL_PENSION"><?php echo $tabemp4_view->ACC_BAL_PENSION->caption() ?></span></td>
		<td data-name="ACC_BAL_PENSION" <?php echo $tabemp4_view->ACC_BAL_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_PENSION">
<span<?php echo $tabemp4_view->ACC_BAL_PENSION->viewAttributes() ?>><?php echo $tabemp4_view->ACC_BAL_PENSION->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_ABS->Visible) { // ACC_NB_ABS ?>
	<tr id="r_ACC_NB_ABS">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_ABS"><?php echo $tabemp4_view->ACC_NB_ABS->caption() ?></span></td>
		<td data-name="ACC_NB_ABS" <?php echo $tabemp4_view->ACC_NB_ABS->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_ABS">
<span<?php echo $tabemp4_view->ACC_NB_ABS->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_ABS->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_MT_QZ->Visible) { // ACC_MT_QZ ?>
	<tr id="r_ACC_MT_QZ">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_MT_QZ"><?php echo $tabemp4_view->ACC_MT_QZ->caption() ?></span></td>
		<td data-name="ACC_MT_QZ" <?php echo $tabemp4_view->ACC_MT_QZ->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_QZ">
<span<?php echo $tabemp4_view->ACC_MT_QZ->viewAttributes() ?>><?php echo $tabemp4_view->ACC_MT_QZ->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_TRA->Visible) { // ACC_NB_TRA ?>
	<tr id="r_ACC_NB_TRA">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_TRA"><?php echo $tabemp4_view->ACC_NB_TRA->caption() ?></span></td>
		<td data-name="ACC_NB_TRA" <?php echo $tabemp4_view->ACC_NB_TRA->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_TRA">
<span<?php echo $tabemp4_view->ACC_NB_TRA->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_TRA->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_MT_AJST->Visible) { // ACC_MT_AJST ?>
	<tr id="r_ACC_MT_AJST">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_MT_AJST"><?php echo $tabemp4_view->ACC_MT_AJST->caption() ?></span></td>
		<td data-name="ACC_MT_AJST" <?php echo $tabemp4_view->ACC_MT_AJST->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_AJST">
<span<?php echo $tabemp4_view->ACC_MT_AJST->viewAttributes() ?>><?php echo $tabemp4_view->ACC_MT_AJST->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_NB_TRA_ACT->Visible) { // ACC_NB_TRA_ACT ?>
	<tr id="r_ACC_NB_TRA_ACT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_NB_TRA_ACT"><?php echo $tabemp4_view->ACC_NB_TRA_ACT->caption() ?></span></td>
		<td data-name="ACC_NB_TRA_ACT" <?php echo $tabemp4_view->ACC_NB_TRA_ACT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_TRA_ACT">
<span<?php echo $tabemp4_view->ACC_NB_TRA_ACT->viewAttributes() ?>><?php echo $tabemp4_view->ACC_NB_TRA_ACT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC1_MT_BRUT->Visible) { // ACC1_MT_BRUT ?>
	<tr id="r_ACC1_MT_BRUT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC1_MT_BRUT"><?php echo $tabemp4_view->ACC1_MT_BRUT->caption() ?></span></td>
		<td data-name="ACC1_MT_BRUT" <?php echo $tabemp4_view->ACC1_MT_BRUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC1_MT_BRUT">
<span<?php echo $tabemp4_view->ACC1_MT_BRUT->viewAttributes() ?>><?php echo $tabemp4_view->ACC1_MT_BRUT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tabemp4_view->ACC_RENDEMENT->Visible) { // ACC_RENDEMENT ?>
	<tr id="r_ACC_RENDEMENT">
		<td class="<?php echo $tabemp4_view->TableLeftColumnClass ?>"><span id="elh_tabemp4_ACC_RENDEMENT"><?php echo $tabemp4_view->ACC_RENDEMENT->caption() ?></span></td>
		<td data-name="ACC_RENDEMENT" <?php echo $tabemp4_view->ACC_RENDEMENT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_RENDEMENT">
<span<?php echo $tabemp4_view->ACC_RENDEMENT->viewAttributes() ?>><?php echo $tabemp4_view->ACC_RENDEMENT->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$tabemp4_view->IsModal) { ?>
<?php if (!$tabemp4_view->isExport()) { ?>
<?php echo $tabemp4_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$tabemp4_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tabemp4_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tabemp4_view->terminate();
?>