<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tabemp4_update = new tabemp4_update();

// Run the page
$tabemp4_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tabemp4_update->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var ftabemp4update, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "update";
	ftabemp4update = currentForm = new ew.Form("ftabemp4update", "update");

	// Validate form
	ftabemp4update.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		if (!ew.updateSelected(fobj)) {
			ew.alert(ew.language.phrase("NoFieldSelected"));
			return false;
		}
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tabemp4_update->id->Required) { ?>
				elm = this.getElements("x" + infix + "_id");
				uelm = this.getElements("u" + infix + "_id");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->id->caption(), $tabemp4_update->id->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_id");
				uelm = this.getElements("u" + infix + "_id");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->id->errorMessage()) ?>");
			<?php if ($tabemp4_update->RN->Required) { ?>
				elm = this.getElements("x" + infix + "_RN");
				uelm = this.getElements("u" + infix + "_RN");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->RN->caption(), $tabemp4_update->RN->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_RN");
				uelm = this.getElements("u" + infix + "_RN");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->RN->errorMessage()) ?>");
			<?php if ($tabemp4_update->NO_EMP->Required) { ?>
				elm = this.getElements("x" + infix + "_NO_EMP");
				uelm = this.getElements("u" + infix + "_NO_EMP");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->NO_EMP->caption(), $tabemp4_update->NO_EMP->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_NO_EMP");
				uelm = this.getElements("u" + infix + "_NO_EMP");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->NO_EMP->errorMessage()) ?>");
			<?php if ($tabemp4_update->NOM_EMP->Required) { ?>
				elm = this.getElements("x" + infix + "_NOM_EMP");
				uelm = this.getElements("u" + infix + "_NOM_EMP");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->NOM_EMP->caption(), $tabemp4_update->NOM_EMP->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->SEXE->Required) { ?>
				elm = this.getElements("x" + infix + "_SEXE");
				uelm = this.getElements("u" + infix + "_SEXE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->SEXE->caption(), $tabemp4_update->SEXE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->ETAT_C->Required) { ?>
				elm = this.getElements("x" + infix + "_ETAT_C");
				uelm = this.getElements("u" + infix + "_ETAT_C");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ETAT_C->caption(), $tabemp4_update->ETAT_C->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->DEPEND->Required) { ?>
				elm = this.getElements("x" + infix + "_DEPEND");
				uelm = this.getElements("u" + infix + "_DEPEND");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->DEPEND->caption(), $tabemp4_update->DEPEND->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_DEPEND");
				uelm = this.getElements("u" + infix + "_DEPEND");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->DEPEND->errorMessage()) ?>");
			<?php if ($tabemp4_update->DTE_NAIS->Required) { ?>
				elm = this.getElements("x" + infix + "_DTE_NAIS");
				uelm = this.getElements("u" + infix + "_DTE_NAIS");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->DTE_NAIS->caption(), $tabemp4_update->DTE_NAIS->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_DTE_NAIS");
				uelm = this.getElements("u" + infix + "_DTE_NAIS");
				if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->DTE_NAIS->errorMessage()) ?>");
			<?php if ($tabemp4_update->LIEU_NAIS->Required) { ?>
				elm = this.getElements("x" + infix + "_LIEU_NAIS");
				uelm = this.getElements("u" + infix + "_LIEU_NAIS");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->LIEU_NAIS->caption(), $tabemp4_update->LIEU_NAIS->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->NATION->Required) { ?>
				elm = this.getElements("x" + infix + "_NATION");
				uelm = this.getElements("u" + infix + "_NATION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->NATION->caption(), $tabemp4_update->NATION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->ADRESSE->Required) { ?>
				elm = this.getElements("x" + infix + "_ADRESSE");
				uelm = this.getElements("u" + infix + "_ADRESSE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ADRESSE->caption(), $tabemp4_update->ADRESSE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->VILLE->Required) { ?>
				elm = this.getElements("x" + infix + "_VILLE");
				uelm = this.getElements("u" + infix + "_VILLE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->VILLE->caption(), $tabemp4_update->VILLE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->PAYS->Required) { ?>
				elm = this.getElements("x" + infix + "_PAYS");
				uelm = this.getElements("u" + infix + "_PAYS");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PAYS->caption(), $tabemp4_update->PAYS->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->BOX->Required) { ?>
				elm = this.getElements("x" + infix + "_BOX");
				uelm = this.getElements("u" + infix + "_BOX");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->BOX->caption(), $tabemp4_update->BOX->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->PHONE->Required) { ?>
				elm = this.getElements("x" + infix + "_PHONE");
				uelm = this.getElements("u" + infix + "_PHONE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PHONE->caption(), $tabemp4_update->PHONE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->REFERENCE->Required) { ?>
				elm = this.getElements("x" + infix + "_REFERENCE");
				uelm = this.getElements("u" + infix + "_REFERENCE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->REFERENCE->caption(), $tabemp4_update->REFERENCE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->QUALIF->Required) { ?>
				elm = this.getElements("x" + infix + "_QUALIF");
				uelm = this.getElements("u" + infix + "_QUALIF");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->QUALIF->caption(), $tabemp4_update->QUALIF->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->URGENCE->Required) { ?>
				elm = this.getElements("x" + infix + "_URGENCE");
				uelm = this.getElements("u" + infix + "_URGENCE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->URGENCE->caption(), $tabemp4_update->URGENCE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->PHONE_URG->Required) { ?>
				elm = this.getElements("x" + infix + "_PHONE_URG");
				uelm = this.getElements("u" + infix + "_PHONE_URG");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PHONE_URG->caption(), $tabemp4_update->PHONE_URG->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->DATE_EMP->Required) { ?>
				elm = this.getElements("x" + infix + "_DATE_EMP");
				uelm = this.getElements("u" + infix + "_DATE_EMP");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->DATE_EMP->caption(), $tabemp4_update->DATE_EMP->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_DATE_EMP");
				uelm = this.getElements("u" + infix + "_DATE_EMP");
				if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->DATE_EMP->errorMessage()) ?>");
			<?php if ($tabemp4_update->SERVICE->Required) { ?>
				elm = this.getElements("x" + infix + "_SERVICE");
				uelm = this.getElements("u" + infix + "_SERVICE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->SERVICE->caption(), $tabemp4_update->SERVICE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->DEPT->Required) { ?>
				elm = this.getElements("x" + infix + "_DEPT");
				uelm = this.getElements("u" + infix + "_DEPT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->DEPT->caption(), $tabemp4_update->DEPT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_DEPT");
				uelm = this.getElements("u" + infix + "_DEPT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->DEPT->errorMessage()) ?>");
			<?php if ($tabemp4_update->SECTION->Required) { ?>
				elm = this.getElements("x" + infix + "_SECTION");
				uelm = this.getElements("u" + infix + "_SECTION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->SECTION->caption(), $tabemp4_update->SECTION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->CATEGORIE->Required) { ?>
				elm = this.getElements("x" + infix + "_CATEGORIE");
				uelm = this.getElements("u" + infix + "_CATEGORIE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->CATEGORIE->caption(), $tabemp4_update->CATEGORIE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->FONCTION->Required) { ?>
				elm = this.getElements("x" + infix + "_FONCTION");
				uelm = this.getElements("u" + infix + "_FONCTION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->FONCTION->caption(), $tabemp4_update->FONCTION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->STATUT->Required) { ?>
				elm = this.getElements("x" + infix + "_STATUT");
				uelm = this.getElements("u" + infix + "_STATUT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->STATUT->caption(), $tabemp4_update->STATUT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->STA_DEBUT->Required) { ?>
				elm = this.getElements("x" + infix + "_STA_DEBUT");
				uelm = this.getElements("u" + infix + "_STA_DEBUT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->STA_DEBUT->caption(), $tabemp4_update->STA_DEBUT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_STA_DEBUT");
				uelm = this.getElements("u" + infix + "_STA_DEBUT");
				if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->STA_DEBUT->errorMessage()) ?>");
			<?php if ($tabemp4_update->STA_FIN->Required) { ?>
				elm = this.getElements("x" + infix + "_STA_FIN");
				uelm = this.getElements("u" + infix + "_STA_FIN");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->STA_FIN->caption(), $tabemp4_update->STA_FIN->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_STA_FIN");
				uelm = this.getElements("u" + infix + "_STA_FIN");
				if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->STA_FIN->errorMessage()) ?>");
			<?php if ($tabemp4_update->STA_MOTIF->Required) { ?>
				elm = this.getElements("x" + infix + "_STA_MOTIF");
				uelm = this.getElements("u" + infix + "_STA_MOTIF");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->STA_MOTIF->caption(), $tabemp4_update->STA_MOTIF->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->NO_NIF->Required) { ?>
				elm = this.getElements("x" + infix + "_NO_NIF");
				uelm = this.getElements("u" + infix + "_NO_NIF");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->NO_NIF->caption(), $tabemp4_update->NO_NIF->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_NO_NIF");
				uelm = this.getElements("u" + infix + "_NO_NIF");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->NO_NIF->errorMessage()) ?>");
			<?php if ($tabemp4_update->NO_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_NO_ONA");
				uelm = this.getElements("u" + infix + "_NO_ONA");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->NO_ONA->caption(), $tabemp4_update->NO_ONA->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->LIV_TRAV->Required) { ?>
				elm = this.getElements("x" + infix + "_LIV_TRAV");
				uelm = this.getElements("u" + infix + "_LIV_TRAV");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->LIV_TRAV->caption(), $tabemp4_update->LIV_TRAV->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->MT_SALAIRE->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_SALAIRE");
				uelm = this.getElements("u" + infix + "_MT_SALAIRE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->MT_SALAIRE->caption(), $tabemp4_update->MT_SALAIRE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_SALAIRE");
				uelm = this.getElements("u" + infix + "_MT_SALAIRE");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->MT_SALAIRE->errorMessage()) ?>");
			<?php if ($tabemp4_update->MT_FRAIS->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_FRAIS");
				uelm = this.getElements("u" + infix + "_MT_FRAIS");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->MT_FRAIS->caption(), $tabemp4_update->MT_FRAIS->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_FRAIS");
				uelm = this.getElements("u" + infix + "_MT_FRAIS");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->MT_FRAIS->errorMessage()) ?>");
			<?php if ($tabemp4_update->MT_AUTRES->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_AUTRES");
				uelm = this.getElements("u" + infix + "_MT_AUTRES");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->MT_AUTRES->caption(), $tabemp4_update->MT_AUTRES->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_AUTRES");
				uelm = this.getElements("u" + infix + "_MT_AUTRES");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->MT_AUTRES->errorMessage()) ?>");
			<?php if ($tabemp4_update->MODE->Required) { ?>
				elm = this.getElements("x" + infix + "_MODE");
				uelm = this.getElements("u" + infix + "_MODE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->MODE->caption(), $tabemp4_update->MODE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->TYPE->Required) { ?>
				elm = this.getElements("x" + infix + "_TYPE");
				uelm = this.getElements("u" + infix + "_TYPE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->TYPE->caption(), $tabemp4_update->TYPE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->MT_IMPOT->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_IMPOT");
				uelm = this.getElements("u" + infix + "_MT_IMPOT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->MT_IMPOT->caption(), $tabemp4_update->MT_IMPOT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_IMPOT");
				uelm = this.getElements("u" + infix + "_MT_IMPOT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->MT_IMPOT->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_IMPOT->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_IMPOT");
				uelm = this.getElements("u" + infix + "_PER_IMPOT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_IMPOT->caption(), $tabemp4_update->PER_IMPOT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->PRET_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_ONA");
				uelm = this.getElements("u" + infix + "_PRET_ONA");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PRET_ONA->caption(), $tabemp4_update->PRET_ONA->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_ONA");
				uelm = this.getElements("u" + infix + "_PRET_ONA");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->PRET_ONA->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_ONA");
				uelm = this.getElements("u" + infix + "_PER_ONA");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_ONA->caption(), $tabemp4_update->PER_ONA->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->RET_ASSUR->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_ASSUR");
				uelm = this.getElements("u" + infix + "_RET_ASSUR");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->RET_ASSUR->caption(), $tabemp4_update->RET_ASSUR->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_ASSUR");
				uelm = this.getElements("u" + infix + "_RET_ASSUR");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->RET_ASSUR->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_ASSUR->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_ASSUR");
				uelm = this.getElements("u" + infix + "_PER_ASSUR");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_ASSUR->caption(), $tabemp4_update->PER_ASSUR->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->PRET_SALAIRE->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_SALAIRE");
				uelm = this.getElements("u" + infix + "_PRET_SALAIRE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PRET_SALAIRE->caption(), $tabemp4_update->PRET_SALAIRE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_SALAIRE");
				uelm = this.getElements("u" + infix + "_PRET_SALAIRE");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->PRET_SALAIRE->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_SALAIRE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_SALAIRE");
				uelm = this.getElements("u" + infix + "_PER_SALAIRE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_SALAIRE->caption(), $tabemp4_update->PER_SALAIRE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_PER_SALAIRE");
				uelm = this.getElements("u" + infix + "_PER_SALAIRE");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->PER_SALAIRE->errorMessage()) ?>");
			<?php if ($tabemp4_update->RET_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_PENSION");
				uelm = this.getElements("u" + infix + "_RET_PENSION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->RET_PENSION->caption(), $tabemp4_update->RET_PENSION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_PENSION");
				uelm = this.getElements("u" + infix + "_RET_PENSION");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->RET_PENSION->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_RETPENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_RETPENSION");
				uelm = this.getElements("u" + infix + "_PER_RETPENSION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_RETPENSION->caption(), $tabemp4_update->PER_RETPENSION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->PRET_BANQUE->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_BANQUE");
				uelm = this.getElements("u" + infix + "_PRET_BANQUE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PRET_BANQUE->caption(), $tabemp4_update->PRET_BANQUE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_BANQUE");
				uelm = this.getElements("u" + infix + "_PRET_BANQUE");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->PRET_BANQUE->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_BANQUE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_BANQUE");
				uelm = this.getElements("u" + infix + "_PER_BANQUE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_BANQUE->caption(), $tabemp4_update->PER_BANQUE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_PER_BANQUE");
				uelm = this.getElements("u" + infix + "_PER_BANQUE");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->PER_BANQUE->errorMessage()) ?>");
			<?php if ($tabemp4_update->RET_AVANC->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_AVANC");
				uelm = this.getElements("u" + infix + "_RET_AVANC");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->RET_AVANC->caption(), $tabemp4_update->RET_AVANC->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_AVANC");
				uelm = this.getElements("u" + infix + "_RET_AVANC");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->RET_AVANC->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_AVANCE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_AVANCE");
				uelm = this.getElements("u" + infix + "_PER_AVANCE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_AVANCE->caption(), $tabemp4_update->PER_AVANCE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->PRET_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_PENSION");
				uelm = this.getElements("u" + infix + "_PRET_PENSION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PRET_PENSION->caption(), $tabemp4_update->PRET_PENSION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_PENSION");
				uelm = this.getElements("u" + infix + "_PRET_PENSION");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->PRET_PENSION->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_PENSION");
				uelm = this.getElements("u" + infix + "_PER_PENSION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_PENSION->caption(), $tabemp4_update->PER_PENSION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->RET_CAFET->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_CAFET");
				uelm = this.getElements("u" + infix + "_RET_CAFET");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->RET_CAFET->caption(), $tabemp4_update->RET_CAFET->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_CAFET");
				uelm = this.getElements("u" + infix + "_RET_CAFET");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->RET_CAFET->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_CAFET->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_CAFET");
				uelm = this.getElements("u" + infix + "_PER_CAFET");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_CAFET->caption(), $tabemp4_update->PER_CAFET->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->RET_CITE->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_CITE");
				uelm = this.getElements("u" + infix + "_RET_CITE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->RET_CITE->caption(), $tabemp4_update->RET_CITE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_CITE");
				uelm = this.getElements("u" + infix + "_RET_CITE");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->RET_CITE->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_CITE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_CITE");
				uelm = this.getElements("u" + infix + "_PER_CITE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_CITE->caption(), $tabemp4_update->PER_CITE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->RET_AUTRE->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_AUTRE");
				uelm = this.getElements("u" + infix + "_RET_AUTRE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->RET_AUTRE->caption(), $tabemp4_update->RET_AUTRE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_AUTRE");
				uelm = this.getElements("u" + infix + "_RET_AUTRE");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->RET_AUTRE->errorMessage()) ?>");
			<?php if ($tabemp4_update->PER_AUTRE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_AUTRE");
				uelm = this.getElements("u" + infix + "_PER_AUTRE");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->PER_AUTRE->caption(), $tabemp4_update->PER_AUTRE->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
			<?php if ($tabemp4_update->ACQ_NB_CON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_CON");
				uelm = this.getElements("u" + infix + "_ACQ_NB_CON");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACQ_NB_CON->caption(), $tabemp4_update->ACQ_NB_CON->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_CON");
				uelm = this.getElements("u" + infix + "_ACQ_NB_CON");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACQ_NB_CON->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_MT_BRUT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BRUT");
				uelm = this.getElements("u" + infix + "_ACC_MT_BRUT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_MT_BRUT->caption(), $tabemp4_update->ACC_MT_BRUT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BRUT");
				uelm = this.getElements("u" + infix + "_ACC_MT_BRUT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_MT_BRUT->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_CON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_CON");
				uelm = this.getElements("u" + infix + "_ACC_NB_CON");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_CON->caption(), $tabemp4_update->ACC_NB_CON->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_CON");
				uelm = this.getElements("u" + infix + "_ACC_NB_CON");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_CON->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_PCON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PCON");
				uelm = this.getElements("u" + infix + "_ACC_NB_PCON");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_PCON->caption(), $tabemp4_update->ACC_NB_PCON->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PCON");
				uelm = this.getElements("u" + infix + "_ACC_NB_PCON");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_PCON->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_MT_OVT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_OVT");
				uelm = this.getElements("u" + infix + "_ACC_MT_OVT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_MT_OVT->caption(), $tabemp4_update->ACC_MT_OVT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_OVT");
				uelm = this.getElements("u" + infix + "_ACC_MT_OVT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_MT_OVT->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACQ_NB_MAL->Required) { ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_MAL");
				uelm = this.getElements("u" + infix + "_ACQ_NB_MAL");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACQ_NB_MAL->caption(), $tabemp4_update->ACQ_NB_MAL->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_MAL");
				uelm = this.getElements("u" + infix + "_ACQ_NB_MAL");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACQ_NB_MAL->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_MAL->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAL");
				uelm = this.getElements("u" + infix + "_ACC_NB_MAL");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_MAL->caption(), $tabemp4_update->ACC_NB_MAL->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAL");
				uelm = this.getElements("u" + infix + "_ACC_NB_MAL");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_MAL->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_MT_CON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_CON");
				uelm = this.getElements("u" + infix + "_ACC_MT_CON");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_MT_CON->caption(), $tabemp4_update->ACC_MT_CON->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_CON");
				uelm = this.getElements("u" + infix + "_ACC_MT_CON");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_MT_CON->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_MAT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAT");
				uelm = this.getElements("u" + infix + "_ACC_NB_MAT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_MAT->caption(), $tabemp4_update->ACC_NB_MAT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAT");
				uelm = this.getElements("u" + infix + "_ACC_NB_MAT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_MAT->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_MT_BONI->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BONI");
				uelm = this.getElements("u" + infix + "_ACC_MT_BONI");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_MT_BONI->caption(), $tabemp4_update->ACC_MT_BONI->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BONI");
				uelm = this.getElements("u" + infix + "_ACC_MT_BONI");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_MT_BONI->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_PER->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PER");
				uelm = this.getElements("u" + infix + "_ACC_NB_PER");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_PER->caption(), $tabemp4_update->ACC_NB_PER->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PER");
				uelm = this.getElements("u" + infix + "_ACC_NB_PER");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_PER->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_MT_AUT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AUT");
				uelm = this.getElements("u" + infix + "_ACC_MT_AUT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_MT_AUT->caption(), $tabemp4_update->ACC_MT_AUT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AUT");
				uelm = this.getElements("u" + infix + "_ACC_MT_AUT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_MT_AUT->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_COM->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_COM");
				uelm = this.getElements("u" + infix + "_ACC_NB_COM");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_COM->caption(), $tabemp4_update->ACC_NB_COM->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_COM");
				uelm = this.getElements("u" + infix + "_ACC_NB_COM");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_COM->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_BAL_SAL->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_SAL");
				uelm = this.getElements("u" + infix + "_ACC_BAL_SAL");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_BAL_SAL->caption(), $tabemp4_update->ACC_BAL_SAL->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_SAL");
				uelm = this.getElements("u" + infix + "_ACC_BAL_SAL");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_BAL_SAL->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_BAL_BAN->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_BAN");
				uelm = this.getElements("u" + infix + "_ACC_BAL_BAN");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_BAL_BAN->caption(), $tabemp4_update->ACC_BAL_BAN->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_BAN");
				uelm = this.getElements("u" + infix + "_ACC_BAL_BAN");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_BAL_BAN->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_SUS->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_SUS");
				uelm = this.getElements("u" + infix + "_ACC_NB_SUS");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_SUS->caption(), $tabemp4_update->ACC_NB_SUS->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_SUS");
				uelm = this.getElements("u" + infix + "_ACC_NB_SUS");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_SUS->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_BAL_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_ONA");
				uelm = this.getElements("u" + infix + "_ACC_BAL_ONA");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_BAL_ONA->caption(), $tabemp4_update->ACC_BAL_ONA->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_ONA");
				uelm = this.getElements("u" + infix + "_ACC_BAL_ONA");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_BAL_ONA->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_BAL_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_PENSION");
				uelm = this.getElements("u" + infix + "_ACC_BAL_PENSION");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_BAL_PENSION->caption(), $tabemp4_update->ACC_BAL_PENSION->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_PENSION");
				uelm = this.getElements("u" + infix + "_ACC_BAL_PENSION");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_BAL_PENSION->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_ABS->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_ABS");
				uelm = this.getElements("u" + infix + "_ACC_NB_ABS");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_ABS->caption(), $tabemp4_update->ACC_NB_ABS->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_ABS");
				uelm = this.getElements("u" + infix + "_ACC_NB_ABS");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_ABS->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_MT_QZ->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_QZ");
				uelm = this.getElements("u" + infix + "_ACC_MT_QZ");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_MT_QZ->caption(), $tabemp4_update->ACC_MT_QZ->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_QZ");
				uelm = this.getElements("u" + infix + "_ACC_MT_QZ");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_MT_QZ->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_TRA->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA");
				uelm = this.getElements("u" + infix + "_ACC_NB_TRA");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_TRA->caption(), $tabemp4_update->ACC_NB_TRA->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA");
				uelm = this.getElements("u" + infix + "_ACC_NB_TRA");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_TRA->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_MT_AJST->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AJST");
				uelm = this.getElements("u" + infix + "_ACC_MT_AJST");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_MT_AJST->caption(), $tabemp4_update->ACC_MT_AJST->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AJST");
				uelm = this.getElements("u" + infix + "_ACC_MT_AJST");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_MT_AJST->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_NB_TRA_ACT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA_ACT");
				uelm = this.getElements("u" + infix + "_ACC_NB_TRA_ACT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_NB_TRA_ACT->caption(), $tabemp4_update->ACC_NB_TRA_ACT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA_ACT");
				uelm = this.getElements("u" + infix + "_ACC_NB_TRA_ACT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_NB_TRA_ACT->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC1_MT_BRUT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC1_MT_BRUT");
				uelm = this.getElements("u" + infix + "_ACC1_MT_BRUT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC1_MT_BRUT->caption(), $tabemp4_update->ACC1_MT_BRUT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC1_MT_BRUT");
				uelm = this.getElements("u" + infix + "_ACC1_MT_BRUT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC1_MT_BRUT->errorMessage()) ?>");
			<?php if ($tabemp4_update->ACC_RENDEMENT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_RENDEMENT");
				uelm = this.getElements("u" + infix + "_ACC_RENDEMENT");
				if (uelm && uelm.checked) {
					if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
						return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_update->ACC_RENDEMENT->caption(), $tabemp4_update->ACC_RENDEMENT->RequiredErrorMessage)) ?>");
				}
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_RENDEMENT");
				uelm = this.getElements("u" + infix + "_ACC_RENDEMENT");
				if (uelm && uelm.checked && elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_update->ACC_RENDEMENT->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftabemp4update.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftabemp4update.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("ftabemp4update");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $tabemp4_update->showPageHeader(); ?>
<?php
$tabemp4_update->showMessage();
?>
<form name="ftabemp4update" id="ftabemp4update" class="<?php echo $tabemp4_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tabemp4">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$tabemp4_update->IsModal ?>">
<?php foreach ($tabemp4_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_tabemp4update" class="ew-update-div"><!-- page -->
	<div class="custom-control custom-checkbox">
		<input type="checkbox" class="custom-control-input" name="u" id="u" onclick="ew.selectAll(this);"><label class="custom-control-label" for="u"><?php echo $Language->phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($tabemp4_update->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_id" id="u_id" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->id->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_id"><?php echo $tabemp4_update->id->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->id->cellAttributes() ?>>
<span id="el_tabemp4_id">
<input type="text" data-table="tabemp4" data-field="x_id" name="x_id" id="x_id" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->id->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->id->EditValue ?>"<?php echo $tabemp4_update->id->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->RN->Visible) { // RN ?>
	<div id="r_RN" class="form-group row">
		<label for="x_RN" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_RN" id="u_RN" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->RN->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_RN"><?php echo $tabemp4_update->RN->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->RN->cellAttributes() ?>>
<input type="text" data-table="tabemp4" data-field="x_RN" name="x_RN" id="x_RN" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->RN->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->RN->EditValue ?>"<?php echo $tabemp4_update->RN->editAttributes() ?>>
<input type="hidden" data-table="tabemp4" data-field="x_RN" name="o_RN" id="o_RN" value="<?php echo HtmlEncode($tabemp4_update->RN->OldValue != null ? $tabemp4_update->RN->OldValue : $tabemp4_update->RN->CurrentValue) ?>">
<?php echo $tabemp4_update->RN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->NO_EMP->Visible) { // NO_EMP ?>
	<div id="r_NO_EMP" class="form-group row">
		<label for="x_NO_EMP" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_NO_EMP" id="u_NO_EMP" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->NO_EMP->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_NO_EMP"><?php echo $tabemp4_update->NO_EMP->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->NO_EMP->cellAttributes() ?>>
<span id="el_tabemp4_NO_EMP">
<input type="text" data-table="tabemp4" data-field="x_NO_EMP" name="x_NO_EMP" id="x_NO_EMP" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->NO_EMP->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->NO_EMP->EditValue ?>"<?php echo $tabemp4_update->NO_EMP->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->NO_EMP->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->NOM_EMP->Visible) { // NOM_EMP ?>
	<div id="r_NOM_EMP" class="form-group row">
		<label for="x_NOM_EMP" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_NOM_EMP" id="u_NOM_EMP" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->NOM_EMP->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_NOM_EMP"><?php echo $tabemp4_update->NOM_EMP->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->NOM_EMP->cellAttributes() ?>>
<span id="el_tabemp4_NOM_EMP">
<input type="text" data-table="tabemp4" data-field="x_NOM_EMP" name="x_NOM_EMP" id="x_NOM_EMP" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->NOM_EMP->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->NOM_EMP->EditValue ?>"<?php echo $tabemp4_update->NOM_EMP->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->NOM_EMP->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->SEXE->Visible) { // SEXE ?>
	<div id="r_SEXE" class="form-group row">
		<label for="x_SEXE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_SEXE" id="u_SEXE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->SEXE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_SEXE"><?php echo $tabemp4_update->SEXE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->SEXE->cellAttributes() ?>>
<span id="el_tabemp4_SEXE">
<input type="text" data-table="tabemp4" data-field="x_SEXE" name="x_SEXE" id="x_SEXE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->SEXE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->SEXE->EditValue ?>"<?php echo $tabemp4_update->SEXE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->SEXE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ETAT_C->Visible) { // ETAT_C ?>
	<div id="r_ETAT_C" class="form-group row">
		<label for="x_ETAT_C" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ETAT_C" id="u_ETAT_C" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ETAT_C->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ETAT_C"><?php echo $tabemp4_update->ETAT_C->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ETAT_C->cellAttributes() ?>>
<span id="el_tabemp4_ETAT_C">
<input type="text" data-table="tabemp4" data-field="x_ETAT_C" name="x_ETAT_C" id="x_ETAT_C" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->ETAT_C->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ETAT_C->EditValue ?>"<?php echo $tabemp4_update->ETAT_C->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ETAT_C->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->DEPEND->Visible) { // DEPEND ?>
	<div id="r_DEPEND" class="form-group row">
		<label for="x_DEPEND" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_DEPEND" id="u_DEPEND" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->DEPEND->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_DEPEND"><?php echo $tabemp4_update->DEPEND->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->DEPEND->cellAttributes() ?>>
<span id="el_tabemp4_DEPEND">
<input type="text" data-table="tabemp4" data-field="x_DEPEND" name="x_DEPEND" id="x_DEPEND" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->DEPEND->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->DEPEND->EditValue ?>"<?php echo $tabemp4_update->DEPEND->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->DEPEND->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->DTE_NAIS->Visible) { // DTE_NAIS ?>
	<div id="r_DTE_NAIS" class="form-group row">
		<label for="x_DTE_NAIS" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_DTE_NAIS" id="u_DTE_NAIS" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->DTE_NAIS->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_DTE_NAIS"><?php echo $tabemp4_update->DTE_NAIS->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->DTE_NAIS->cellAttributes() ?>>
<span id="el_tabemp4_DTE_NAIS">
<input type="text" data-table="tabemp4" data-field="x_DTE_NAIS" name="x_DTE_NAIS" id="x_DTE_NAIS" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_update->DTE_NAIS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->DTE_NAIS->EditValue ?>"<?php echo $tabemp4_update->DTE_NAIS->editAttributes() ?>>
<?php if (!$tabemp4_update->DTE_NAIS->ReadOnly && !$tabemp4_update->DTE_NAIS->Disabled && !isset($tabemp4_update->DTE_NAIS->EditAttrs["readonly"]) && !isset($tabemp4_update->DTE_NAIS->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4update", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4update", "x_DTE_NAIS", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_update->DTE_NAIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->LIEU_NAIS->Visible) { // LIEU_NAIS ?>
	<div id="r_LIEU_NAIS" class="form-group row">
		<label for="x_LIEU_NAIS" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_LIEU_NAIS" id="u_LIEU_NAIS" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->LIEU_NAIS->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_LIEU_NAIS"><?php echo $tabemp4_update->LIEU_NAIS->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->LIEU_NAIS->cellAttributes() ?>>
<span id="el_tabemp4_LIEU_NAIS">
<input type="text" data-table="tabemp4" data-field="x_LIEU_NAIS" name="x_LIEU_NAIS" id="x_LIEU_NAIS" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->LIEU_NAIS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->LIEU_NAIS->EditValue ?>"<?php echo $tabemp4_update->LIEU_NAIS->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->LIEU_NAIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->NATION->Visible) { // NATION ?>
	<div id="r_NATION" class="form-group row">
		<label for="x_NATION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_NATION" id="u_NATION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->NATION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_NATION"><?php echo $tabemp4_update->NATION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->NATION->cellAttributes() ?>>
<span id="el_tabemp4_NATION">
<input type="text" data-table="tabemp4" data-field="x_NATION" name="x_NATION" id="x_NATION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->NATION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->NATION->EditValue ?>"<?php echo $tabemp4_update->NATION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->NATION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ADRESSE->Visible) { // ADRESSE ?>
	<div id="r_ADRESSE" class="form-group row">
		<label for="x_ADRESSE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ADRESSE" id="u_ADRESSE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ADRESSE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ADRESSE"><?php echo $tabemp4_update->ADRESSE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ADRESSE->cellAttributes() ?>>
<span id="el_tabemp4_ADRESSE">
<input type="text" data-table="tabemp4" data-field="x_ADRESSE" name="x_ADRESSE" id="x_ADRESSE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->ADRESSE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ADRESSE->EditValue ?>"<?php echo $tabemp4_update->ADRESSE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ADRESSE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->VILLE->Visible) { // VILLE ?>
	<div id="r_VILLE" class="form-group row">
		<label for="x_VILLE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_VILLE" id="u_VILLE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->VILLE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_VILLE"><?php echo $tabemp4_update->VILLE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->VILLE->cellAttributes() ?>>
<span id="el_tabemp4_VILLE">
<input type="text" data-table="tabemp4" data-field="x_VILLE" name="x_VILLE" id="x_VILLE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->VILLE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->VILLE->EditValue ?>"<?php echo $tabemp4_update->VILLE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->VILLE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PAYS->Visible) { // PAYS ?>
	<div id="r_PAYS" class="form-group row">
		<label for="x_PAYS" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PAYS" id="u_PAYS" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PAYS->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PAYS"><?php echo $tabemp4_update->PAYS->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PAYS->cellAttributes() ?>>
<span id="el_tabemp4_PAYS">
<input type="text" data-table="tabemp4" data-field="x_PAYS" name="x_PAYS" id="x_PAYS" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PAYS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PAYS->EditValue ?>"<?php echo $tabemp4_update->PAYS->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PAYS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->BOX->Visible) { // BOX ?>
	<div id="r_BOX" class="form-group row">
		<label for="x_BOX" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_BOX" id="u_BOX" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->BOX->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_BOX"><?php echo $tabemp4_update->BOX->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->BOX->cellAttributes() ?>>
<span id="el_tabemp4_BOX">
<input type="text" data-table="tabemp4" data-field="x_BOX" name="x_BOX" id="x_BOX" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->BOX->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->BOX->EditValue ?>"<?php echo $tabemp4_update->BOX->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->BOX->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PHONE->Visible) { // PHONE ?>
	<div id="r_PHONE" class="form-group row">
		<label for="x_PHONE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PHONE" id="u_PHONE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PHONE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PHONE"><?php echo $tabemp4_update->PHONE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PHONE->cellAttributes() ?>>
<span id="el_tabemp4_PHONE">
<input type="text" data-table="tabemp4" data-field="x_PHONE" name="x_PHONE" id="x_PHONE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PHONE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PHONE->EditValue ?>"<?php echo $tabemp4_update->PHONE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PHONE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->REFERENCE->Visible) { // REFERENCE ?>
	<div id="r_REFERENCE" class="form-group row">
		<label for="x_REFERENCE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_REFERENCE" id="u_REFERENCE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->REFERENCE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_REFERENCE"><?php echo $tabemp4_update->REFERENCE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->REFERENCE->cellAttributes() ?>>
<span id="el_tabemp4_REFERENCE">
<input type="text" data-table="tabemp4" data-field="x_REFERENCE" name="x_REFERENCE" id="x_REFERENCE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->REFERENCE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->REFERENCE->EditValue ?>"<?php echo $tabemp4_update->REFERENCE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->REFERENCE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->QUALIF->Visible) { // QUALIF ?>
	<div id="r_QUALIF" class="form-group row">
		<label for="x_QUALIF" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_QUALIF" id="u_QUALIF" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->QUALIF->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_QUALIF"><?php echo $tabemp4_update->QUALIF->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->QUALIF->cellAttributes() ?>>
<span id="el_tabemp4_QUALIF">
<input type="text" data-table="tabemp4" data-field="x_QUALIF" name="x_QUALIF" id="x_QUALIF" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->QUALIF->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->QUALIF->EditValue ?>"<?php echo $tabemp4_update->QUALIF->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->QUALIF->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->URGENCE->Visible) { // URGENCE ?>
	<div id="r_URGENCE" class="form-group row">
		<label for="x_URGENCE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_URGENCE" id="u_URGENCE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->URGENCE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_URGENCE"><?php echo $tabemp4_update->URGENCE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->URGENCE->cellAttributes() ?>>
<span id="el_tabemp4_URGENCE">
<input type="text" data-table="tabemp4" data-field="x_URGENCE" name="x_URGENCE" id="x_URGENCE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->URGENCE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->URGENCE->EditValue ?>"<?php echo $tabemp4_update->URGENCE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->URGENCE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PHONE_URG->Visible) { // PHONE_URG ?>
	<div id="r_PHONE_URG" class="form-group row">
		<label for="x_PHONE_URG" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PHONE_URG" id="u_PHONE_URG" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PHONE_URG->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PHONE_URG"><?php echo $tabemp4_update->PHONE_URG->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PHONE_URG->cellAttributes() ?>>
<span id="el_tabemp4_PHONE_URG">
<input type="text" data-table="tabemp4" data-field="x_PHONE_URG" name="x_PHONE_URG" id="x_PHONE_URG" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PHONE_URG->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PHONE_URG->EditValue ?>"<?php echo $tabemp4_update->PHONE_URG->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PHONE_URG->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->DATE_EMP->Visible) { // DATE_EMP ?>
	<div id="r_DATE_EMP" class="form-group row">
		<label for="x_DATE_EMP" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_DATE_EMP" id="u_DATE_EMP" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->DATE_EMP->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_DATE_EMP"><?php echo $tabemp4_update->DATE_EMP->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->DATE_EMP->cellAttributes() ?>>
<span id="el_tabemp4_DATE_EMP">
<input type="text" data-table="tabemp4" data-field="x_DATE_EMP" name="x_DATE_EMP" id="x_DATE_EMP" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_update->DATE_EMP->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->DATE_EMP->EditValue ?>"<?php echo $tabemp4_update->DATE_EMP->editAttributes() ?>>
<?php if (!$tabemp4_update->DATE_EMP->ReadOnly && !$tabemp4_update->DATE_EMP->Disabled && !isset($tabemp4_update->DATE_EMP->EditAttrs["readonly"]) && !isset($tabemp4_update->DATE_EMP->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4update", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4update", "x_DATE_EMP", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_update->DATE_EMP->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->SERVICE->Visible) { // SERVICE ?>
	<div id="r_SERVICE" class="form-group row">
		<label for="x_SERVICE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_SERVICE" id="u_SERVICE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->SERVICE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_SERVICE"><?php echo $tabemp4_update->SERVICE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->SERVICE->cellAttributes() ?>>
<span id="el_tabemp4_SERVICE">
<input type="text" data-table="tabemp4" data-field="x_SERVICE" name="x_SERVICE" id="x_SERVICE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->SERVICE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->SERVICE->EditValue ?>"<?php echo $tabemp4_update->SERVICE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->SERVICE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->DEPT->Visible) { // DEPT ?>
	<div id="r_DEPT" class="form-group row">
		<label for="x_DEPT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_DEPT" id="u_DEPT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->DEPT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_DEPT"><?php echo $tabemp4_update->DEPT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->DEPT->cellAttributes() ?>>
<span id="el_tabemp4_DEPT">
<input type="text" data-table="tabemp4" data-field="x_DEPT" name="x_DEPT" id="x_DEPT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->DEPT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->DEPT->EditValue ?>"<?php echo $tabemp4_update->DEPT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->DEPT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->SECTION->Visible) { // SECTION ?>
	<div id="r_SECTION" class="form-group row">
		<label for="x_SECTION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_SECTION" id="u_SECTION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->SECTION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_SECTION"><?php echo $tabemp4_update->SECTION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->SECTION->cellAttributes() ?>>
<span id="el_tabemp4_SECTION">
<input type="text" data-table="tabemp4" data-field="x_SECTION" name="x_SECTION" id="x_SECTION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->SECTION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->SECTION->EditValue ?>"<?php echo $tabemp4_update->SECTION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->SECTION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->CATEGORIE->Visible) { // CATEGORIE ?>
	<div id="r_CATEGORIE" class="form-group row">
		<label for="x_CATEGORIE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_CATEGORIE" id="u_CATEGORIE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->CATEGORIE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_CATEGORIE"><?php echo $tabemp4_update->CATEGORIE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->CATEGORIE->cellAttributes() ?>>
<span id="el_tabemp4_CATEGORIE">
<input type="text" data-table="tabemp4" data-field="x_CATEGORIE" name="x_CATEGORIE" id="x_CATEGORIE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->CATEGORIE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->CATEGORIE->EditValue ?>"<?php echo $tabemp4_update->CATEGORIE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->CATEGORIE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->FONCTION->Visible) { // FONCTION ?>
	<div id="r_FONCTION" class="form-group row">
		<label for="x_FONCTION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_FONCTION" id="u_FONCTION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->FONCTION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_FONCTION"><?php echo $tabemp4_update->FONCTION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->FONCTION->cellAttributes() ?>>
<span id="el_tabemp4_FONCTION">
<input type="text" data-table="tabemp4" data-field="x_FONCTION" name="x_FONCTION" id="x_FONCTION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->FONCTION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->FONCTION->EditValue ?>"<?php echo $tabemp4_update->FONCTION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->FONCTION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->STATUT->Visible) { // STATUT ?>
	<div id="r_STATUT" class="form-group row">
		<label for="x_STATUT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_STATUT" id="u_STATUT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->STATUT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_STATUT"><?php echo $tabemp4_update->STATUT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->STATUT->cellAttributes() ?>>
<span id="el_tabemp4_STATUT">
<input type="text" data-table="tabemp4" data-field="x_STATUT" name="x_STATUT" id="x_STATUT" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->STATUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->STATUT->EditValue ?>"<?php echo $tabemp4_update->STATUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->STATUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->STA_DEBUT->Visible) { // STA_DEBUT ?>
	<div id="r_STA_DEBUT" class="form-group row">
		<label for="x_STA_DEBUT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_STA_DEBUT" id="u_STA_DEBUT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->STA_DEBUT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_STA_DEBUT"><?php echo $tabemp4_update->STA_DEBUT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->STA_DEBUT->cellAttributes() ?>>
<span id="el_tabemp4_STA_DEBUT">
<input type="text" data-table="tabemp4" data-field="x_STA_DEBUT" name="x_STA_DEBUT" id="x_STA_DEBUT" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_update->STA_DEBUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->STA_DEBUT->EditValue ?>"<?php echo $tabemp4_update->STA_DEBUT->editAttributes() ?>>
<?php if (!$tabemp4_update->STA_DEBUT->ReadOnly && !$tabemp4_update->STA_DEBUT->Disabled && !isset($tabemp4_update->STA_DEBUT->EditAttrs["readonly"]) && !isset($tabemp4_update->STA_DEBUT->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4update", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4update", "x_STA_DEBUT", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_update->STA_DEBUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->STA_FIN->Visible) { // STA_FIN ?>
	<div id="r_STA_FIN" class="form-group row">
		<label for="x_STA_FIN" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_STA_FIN" id="u_STA_FIN" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->STA_FIN->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_STA_FIN"><?php echo $tabemp4_update->STA_FIN->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->STA_FIN->cellAttributes() ?>>
<span id="el_tabemp4_STA_FIN">
<input type="text" data-table="tabemp4" data-field="x_STA_FIN" name="x_STA_FIN" id="x_STA_FIN" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_update->STA_FIN->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->STA_FIN->EditValue ?>"<?php echo $tabemp4_update->STA_FIN->editAttributes() ?>>
<?php if (!$tabemp4_update->STA_FIN->ReadOnly && !$tabemp4_update->STA_FIN->Disabled && !isset($tabemp4_update->STA_FIN->EditAttrs["readonly"]) && !isset($tabemp4_update->STA_FIN->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4update", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4update", "x_STA_FIN", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_update->STA_FIN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->STA_MOTIF->Visible) { // STA_MOTIF ?>
	<div id="r_STA_MOTIF" class="form-group row">
		<label for="x_STA_MOTIF" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_STA_MOTIF" id="u_STA_MOTIF" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->STA_MOTIF->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_STA_MOTIF"><?php echo $tabemp4_update->STA_MOTIF->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->STA_MOTIF->cellAttributes() ?>>
<span id="el_tabemp4_STA_MOTIF">
<input type="text" data-table="tabemp4" data-field="x_STA_MOTIF" name="x_STA_MOTIF" id="x_STA_MOTIF" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->STA_MOTIF->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->STA_MOTIF->EditValue ?>"<?php echo $tabemp4_update->STA_MOTIF->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->STA_MOTIF->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->NO_NIF->Visible) { // NO_NIF ?>
	<div id="r_NO_NIF" class="form-group row">
		<label for="x_NO_NIF" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_NO_NIF" id="u_NO_NIF" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->NO_NIF->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_NO_NIF"><?php echo $tabemp4_update->NO_NIF->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->NO_NIF->cellAttributes() ?>>
<span id="el_tabemp4_NO_NIF">
<input type="text" data-table="tabemp4" data-field="x_NO_NIF" name="x_NO_NIF" id="x_NO_NIF" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->NO_NIF->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->NO_NIF->EditValue ?>"<?php echo $tabemp4_update->NO_NIF->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->NO_NIF->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->NO_ONA->Visible) { // NO_ONA ?>
	<div id="r_NO_ONA" class="form-group row">
		<label for="x_NO_ONA" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_NO_ONA" id="u_NO_ONA" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->NO_ONA->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_NO_ONA"><?php echo $tabemp4_update->NO_ONA->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->NO_ONA->cellAttributes() ?>>
<span id="el_tabemp4_NO_ONA">
<input type="text" data-table="tabemp4" data-field="x_NO_ONA" name="x_NO_ONA" id="x_NO_ONA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->NO_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->NO_ONA->EditValue ?>"<?php echo $tabemp4_update->NO_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->NO_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->LIV_TRAV->Visible) { // LIV_TRAV ?>
	<div id="r_LIV_TRAV" class="form-group row">
		<label for="x_LIV_TRAV" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_LIV_TRAV" id="u_LIV_TRAV" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->LIV_TRAV->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_LIV_TRAV"><?php echo $tabemp4_update->LIV_TRAV->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->LIV_TRAV->cellAttributes() ?>>
<span id="el_tabemp4_LIV_TRAV">
<input type="text" data-table="tabemp4" data-field="x_LIV_TRAV" name="x_LIV_TRAV" id="x_LIV_TRAV" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->LIV_TRAV->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->LIV_TRAV->EditValue ?>"<?php echo $tabemp4_update->LIV_TRAV->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->LIV_TRAV->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->MT_SALAIRE->Visible) { // MT_SALAIRE ?>
	<div id="r_MT_SALAIRE" class="form-group row">
		<label for="x_MT_SALAIRE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_MT_SALAIRE" id="u_MT_SALAIRE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->MT_SALAIRE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_MT_SALAIRE"><?php echo $tabemp4_update->MT_SALAIRE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->MT_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_MT_SALAIRE">
<input type="text" data-table="tabemp4" data-field="x_MT_SALAIRE" name="x_MT_SALAIRE" id="x_MT_SALAIRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->MT_SALAIRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->MT_SALAIRE->EditValue ?>"<?php echo $tabemp4_update->MT_SALAIRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->MT_SALAIRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->MT_FRAIS->Visible) { // MT_FRAIS ?>
	<div id="r_MT_FRAIS" class="form-group row">
		<label for="x_MT_FRAIS" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_MT_FRAIS" id="u_MT_FRAIS" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->MT_FRAIS->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_MT_FRAIS"><?php echo $tabemp4_update->MT_FRAIS->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->MT_FRAIS->cellAttributes() ?>>
<span id="el_tabemp4_MT_FRAIS">
<input type="text" data-table="tabemp4" data-field="x_MT_FRAIS" name="x_MT_FRAIS" id="x_MT_FRAIS" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->MT_FRAIS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->MT_FRAIS->EditValue ?>"<?php echo $tabemp4_update->MT_FRAIS->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->MT_FRAIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->MT_AUTRES->Visible) { // MT_AUTRES ?>
	<div id="r_MT_AUTRES" class="form-group row">
		<label for="x_MT_AUTRES" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_MT_AUTRES" id="u_MT_AUTRES" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->MT_AUTRES->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_MT_AUTRES"><?php echo $tabemp4_update->MT_AUTRES->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->MT_AUTRES->cellAttributes() ?>>
<span id="el_tabemp4_MT_AUTRES">
<input type="text" data-table="tabemp4" data-field="x_MT_AUTRES" name="x_MT_AUTRES" id="x_MT_AUTRES" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->MT_AUTRES->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->MT_AUTRES->EditValue ?>"<?php echo $tabemp4_update->MT_AUTRES->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->MT_AUTRES->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->MODE->Visible) { // MODE ?>
	<div id="r_MODE" class="form-group row">
		<label for="x_MODE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_MODE" id="u_MODE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->MODE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_MODE"><?php echo $tabemp4_update->MODE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->MODE->cellAttributes() ?>>
<span id="el_tabemp4_MODE">
<input type="text" data-table="tabemp4" data-field="x_MODE" name="x_MODE" id="x_MODE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->MODE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->MODE->EditValue ?>"<?php echo $tabemp4_update->MODE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->MODE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->TYPE->Visible) { // TYPE ?>
	<div id="r_TYPE" class="form-group row">
		<label for="x_TYPE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_TYPE" id="u_TYPE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->TYPE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_TYPE"><?php echo $tabemp4_update->TYPE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->TYPE->cellAttributes() ?>>
<span id="el_tabemp4_TYPE">
<input type="text" data-table="tabemp4" data-field="x_TYPE" name="x_TYPE" id="x_TYPE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->TYPE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->TYPE->EditValue ?>"<?php echo $tabemp4_update->TYPE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->TYPE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->MT_IMPOT->Visible) { // MT_IMPOT ?>
	<div id="r_MT_IMPOT" class="form-group row">
		<label for="x_MT_IMPOT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_MT_IMPOT" id="u_MT_IMPOT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->MT_IMPOT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_MT_IMPOT"><?php echo $tabemp4_update->MT_IMPOT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->MT_IMPOT->cellAttributes() ?>>
<span id="el_tabemp4_MT_IMPOT">
<input type="text" data-table="tabemp4" data-field="x_MT_IMPOT" name="x_MT_IMPOT" id="x_MT_IMPOT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->MT_IMPOT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->MT_IMPOT->EditValue ?>"<?php echo $tabemp4_update->MT_IMPOT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->MT_IMPOT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_IMPOT->Visible) { // PER_IMPOT ?>
	<div id="r_PER_IMPOT" class="form-group row">
		<label for="x_PER_IMPOT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_IMPOT" id="u_PER_IMPOT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_IMPOT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_IMPOT"><?php echo $tabemp4_update->PER_IMPOT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_IMPOT->cellAttributes() ?>>
<span id="el_tabemp4_PER_IMPOT">
<input type="text" data-table="tabemp4" data-field="x_PER_IMPOT" name="x_PER_IMPOT" id="x_PER_IMPOT" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_IMPOT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_IMPOT->EditValue ?>"<?php echo $tabemp4_update->PER_IMPOT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_IMPOT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PRET_ONA->Visible) { // PRET_ONA ?>
	<div id="r_PRET_ONA" class="form-group row">
		<label for="x_PRET_ONA" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PRET_ONA" id="u_PRET_ONA" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PRET_ONA->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PRET_ONA"><?php echo $tabemp4_update->PRET_ONA->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PRET_ONA->cellAttributes() ?>>
<span id="el_tabemp4_PRET_ONA">
<input type="text" data-table="tabemp4" data-field="x_PRET_ONA" name="x_PRET_ONA" id="x_PRET_ONA" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->PRET_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PRET_ONA->EditValue ?>"<?php echo $tabemp4_update->PRET_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PRET_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_ONA->Visible) { // PER_ONA ?>
	<div id="r_PER_ONA" class="form-group row">
		<label for="x_PER_ONA" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_ONA" id="u_PER_ONA" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_ONA->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_ONA"><?php echo $tabemp4_update->PER_ONA->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_ONA->cellAttributes() ?>>
<span id="el_tabemp4_PER_ONA">
<input type="text" data-table="tabemp4" data-field="x_PER_ONA" name="x_PER_ONA" id="x_PER_ONA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_ONA->EditValue ?>"<?php echo $tabemp4_update->PER_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->RET_ASSUR->Visible) { // RET_ASSUR ?>
	<div id="r_RET_ASSUR" class="form-group row">
		<label for="x_RET_ASSUR" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_RET_ASSUR" id="u_RET_ASSUR" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->RET_ASSUR->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_RET_ASSUR"><?php echo $tabemp4_update->RET_ASSUR->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->RET_ASSUR->cellAttributes() ?>>
<span id="el_tabemp4_RET_ASSUR">
<input type="text" data-table="tabemp4" data-field="x_RET_ASSUR" name="x_RET_ASSUR" id="x_RET_ASSUR" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->RET_ASSUR->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->RET_ASSUR->EditValue ?>"<?php echo $tabemp4_update->RET_ASSUR->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->RET_ASSUR->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_ASSUR->Visible) { // PER_ASSUR ?>
	<div id="r_PER_ASSUR" class="form-group row">
		<label for="x_PER_ASSUR" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_ASSUR" id="u_PER_ASSUR" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_ASSUR->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_ASSUR"><?php echo $tabemp4_update->PER_ASSUR->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_ASSUR->cellAttributes() ?>>
<span id="el_tabemp4_PER_ASSUR">
<input type="text" data-table="tabemp4" data-field="x_PER_ASSUR" name="x_PER_ASSUR" id="x_PER_ASSUR" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_ASSUR->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_ASSUR->EditValue ?>"<?php echo $tabemp4_update->PER_ASSUR->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_ASSUR->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PRET_SALAIRE->Visible) { // PRET_SALAIRE ?>
	<div id="r_PRET_SALAIRE" class="form-group row">
		<label for="x_PRET_SALAIRE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PRET_SALAIRE" id="u_PRET_SALAIRE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PRET_SALAIRE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PRET_SALAIRE"><?php echo $tabemp4_update->PRET_SALAIRE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PRET_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_PRET_SALAIRE">
<input type="text" data-table="tabemp4" data-field="x_PRET_SALAIRE" name="x_PRET_SALAIRE" id="x_PRET_SALAIRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->PRET_SALAIRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PRET_SALAIRE->EditValue ?>"<?php echo $tabemp4_update->PRET_SALAIRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PRET_SALAIRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_SALAIRE->Visible) { // PER_SALAIRE ?>
	<div id="r_PER_SALAIRE" class="form-group row">
		<label for="x_PER_SALAIRE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_SALAIRE" id="u_PER_SALAIRE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_SALAIRE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_SALAIRE"><?php echo $tabemp4_update->PER_SALAIRE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_PER_SALAIRE">
<input type="text" data-table="tabemp4" data-field="x_PER_SALAIRE" name="x_PER_SALAIRE" id="x_PER_SALAIRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_SALAIRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_SALAIRE->EditValue ?>"<?php echo $tabemp4_update->PER_SALAIRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_SALAIRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->RET_PENSION->Visible) { // RET_PENSION ?>
	<div id="r_RET_PENSION" class="form-group row">
		<label for="x_RET_PENSION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_RET_PENSION" id="u_RET_PENSION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->RET_PENSION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_RET_PENSION"><?php echo $tabemp4_update->RET_PENSION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->RET_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_RET_PENSION">
<input type="text" data-table="tabemp4" data-field="x_RET_PENSION" name="x_RET_PENSION" id="x_RET_PENSION" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->RET_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->RET_PENSION->EditValue ?>"<?php echo $tabemp4_update->RET_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->RET_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_RETPENSION->Visible) { // PER_RETPENSION ?>
	<div id="r_PER_RETPENSION" class="form-group row">
		<label for="x_PER_RETPENSION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_RETPENSION" id="u_PER_RETPENSION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_RETPENSION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_RETPENSION"><?php echo $tabemp4_update->PER_RETPENSION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_RETPENSION->cellAttributes() ?>>
<span id="el_tabemp4_PER_RETPENSION">
<input type="text" data-table="tabemp4" data-field="x_PER_RETPENSION" name="x_PER_RETPENSION" id="x_PER_RETPENSION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_RETPENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_RETPENSION->EditValue ?>"<?php echo $tabemp4_update->PER_RETPENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_RETPENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PRET_BANQUE->Visible) { // PRET_BANQUE ?>
	<div id="r_PRET_BANQUE" class="form-group row">
		<label for="x_PRET_BANQUE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PRET_BANQUE" id="u_PRET_BANQUE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PRET_BANQUE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PRET_BANQUE"><?php echo $tabemp4_update->PRET_BANQUE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PRET_BANQUE->cellAttributes() ?>>
<span id="el_tabemp4_PRET_BANQUE">
<input type="text" data-table="tabemp4" data-field="x_PRET_BANQUE" name="x_PRET_BANQUE" id="x_PRET_BANQUE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->PRET_BANQUE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PRET_BANQUE->EditValue ?>"<?php echo $tabemp4_update->PRET_BANQUE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PRET_BANQUE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_BANQUE->Visible) { // PER_BANQUE ?>
	<div id="r_PER_BANQUE" class="form-group row">
		<label for="x_PER_BANQUE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_BANQUE" id="u_PER_BANQUE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_BANQUE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_BANQUE"><?php echo $tabemp4_update->PER_BANQUE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_BANQUE->cellAttributes() ?>>
<span id="el_tabemp4_PER_BANQUE">
<input type="text" data-table="tabemp4" data-field="x_PER_BANQUE" name="x_PER_BANQUE" id="x_PER_BANQUE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_BANQUE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_BANQUE->EditValue ?>"<?php echo $tabemp4_update->PER_BANQUE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_BANQUE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->RET_AVANC->Visible) { // RET_AVANC ?>
	<div id="r_RET_AVANC" class="form-group row">
		<label for="x_RET_AVANC" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_RET_AVANC" id="u_RET_AVANC" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->RET_AVANC->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_RET_AVANC"><?php echo $tabemp4_update->RET_AVANC->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->RET_AVANC->cellAttributes() ?>>
<span id="el_tabemp4_RET_AVANC">
<input type="text" data-table="tabemp4" data-field="x_RET_AVANC" name="x_RET_AVANC" id="x_RET_AVANC" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->RET_AVANC->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->RET_AVANC->EditValue ?>"<?php echo $tabemp4_update->RET_AVANC->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->RET_AVANC->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_AVANCE->Visible) { // PER_AVANCE ?>
	<div id="r_PER_AVANCE" class="form-group row">
		<label for="x_PER_AVANCE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_AVANCE" id="u_PER_AVANCE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_AVANCE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_AVANCE"><?php echo $tabemp4_update->PER_AVANCE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_AVANCE->cellAttributes() ?>>
<span id="el_tabemp4_PER_AVANCE">
<input type="text" data-table="tabemp4" data-field="x_PER_AVANCE" name="x_PER_AVANCE" id="x_PER_AVANCE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_AVANCE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_AVANCE->EditValue ?>"<?php echo $tabemp4_update->PER_AVANCE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_AVANCE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PRET_PENSION->Visible) { // PRET_PENSION ?>
	<div id="r_PRET_PENSION" class="form-group row">
		<label for="x_PRET_PENSION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PRET_PENSION" id="u_PRET_PENSION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PRET_PENSION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PRET_PENSION"><?php echo $tabemp4_update->PRET_PENSION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PRET_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_PRET_PENSION">
<input type="text" data-table="tabemp4" data-field="x_PRET_PENSION" name="x_PRET_PENSION" id="x_PRET_PENSION" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->PRET_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PRET_PENSION->EditValue ?>"<?php echo $tabemp4_update->PRET_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PRET_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_PENSION->Visible) { // PER_PENSION ?>
	<div id="r_PER_PENSION" class="form-group row">
		<label for="x_PER_PENSION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_PENSION" id="u_PER_PENSION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_PENSION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_PENSION"><?php echo $tabemp4_update->PER_PENSION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_PER_PENSION">
<input type="text" data-table="tabemp4" data-field="x_PER_PENSION" name="x_PER_PENSION" id="x_PER_PENSION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_PENSION->EditValue ?>"<?php echo $tabemp4_update->PER_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->RET_CAFET->Visible) { // RET_CAFET ?>
	<div id="r_RET_CAFET" class="form-group row">
		<label for="x_RET_CAFET" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_RET_CAFET" id="u_RET_CAFET" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->RET_CAFET->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_RET_CAFET"><?php echo $tabemp4_update->RET_CAFET->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->RET_CAFET->cellAttributes() ?>>
<span id="el_tabemp4_RET_CAFET">
<input type="text" data-table="tabemp4" data-field="x_RET_CAFET" name="x_RET_CAFET" id="x_RET_CAFET" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->RET_CAFET->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->RET_CAFET->EditValue ?>"<?php echo $tabemp4_update->RET_CAFET->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->RET_CAFET->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_CAFET->Visible) { // PER_CAFET ?>
	<div id="r_PER_CAFET" class="form-group row">
		<label for="x_PER_CAFET" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_CAFET" id="u_PER_CAFET" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_CAFET->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_CAFET"><?php echo $tabemp4_update->PER_CAFET->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_CAFET->cellAttributes() ?>>
<span id="el_tabemp4_PER_CAFET">
<input type="text" data-table="tabemp4" data-field="x_PER_CAFET" name="x_PER_CAFET" id="x_PER_CAFET" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_CAFET->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_CAFET->EditValue ?>"<?php echo $tabemp4_update->PER_CAFET->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_CAFET->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->RET_CITE->Visible) { // RET_CITE ?>
	<div id="r_RET_CITE" class="form-group row">
		<label for="x_RET_CITE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_RET_CITE" id="u_RET_CITE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->RET_CITE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_RET_CITE"><?php echo $tabemp4_update->RET_CITE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->RET_CITE->cellAttributes() ?>>
<span id="el_tabemp4_RET_CITE">
<input type="text" data-table="tabemp4" data-field="x_RET_CITE" name="x_RET_CITE" id="x_RET_CITE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->RET_CITE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->RET_CITE->EditValue ?>"<?php echo $tabemp4_update->RET_CITE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->RET_CITE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_CITE->Visible) { // PER_CITE ?>
	<div id="r_PER_CITE" class="form-group row">
		<label for="x_PER_CITE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_CITE" id="u_PER_CITE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_CITE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_CITE"><?php echo $tabemp4_update->PER_CITE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_CITE->cellAttributes() ?>>
<span id="el_tabemp4_PER_CITE">
<input type="text" data-table="tabemp4" data-field="x_PER_CITE" name="x_PER_CITE" id="x_PER_CITE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_CITE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_CITE->EditValue ?>"<?php echo $tabemp4_update->PER_CITE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_CITE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->RET_AUTRE->Visible) { // RET_AUTRE ?>
	<div id="r_RET_AUTRE" class="form-group row">
		<label for="x_RET_AUTRE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_RET_AUTRE" id="u_RET_AUTRE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->RET_AUTRE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_RET_AUTRE"><?php echo $tabemp4_update->RET_AUTRE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->RET_AUTRE->cellAttributes() ?>>
<span id="el_tabemp4_RET_AUTRE">
<input type="text" data-table="tabemp4" data-field="x_RET_AUTRE" name="x_RET_AUTRE" id="x_RET_AUTRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->RET_AUTRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->RET_AUTRE->EditValue ?>"<?php echo $tabemp4_update->RET_AUTRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->RET_AUTRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->PER_AUTRE->Visible) { // PER_AUTRE ?>
	<div id="r_PER_AUTRE" class="form-group row">
		<label for="x_PER_AUTRE" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_PER_AUTRE" id="u_PER_AUTRE" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->PER_AUTRE->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_PER_AUTRE"><?php echo $tabemp4_update->PER_AUTRE->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->PER_AUTRE->cellAttributes() ?>>
<span id="el_tabemp4_PER_AUTRE">
<input type="text" data-table="tabemp4" data-field="x_PER_AUTRE" name="x_PER_AUTRE" id="x_PER_AUTRE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_update->PER_AUTRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->PER_AUTRE->EditValue ?>"<?php echo $tabemp4_update->PER_AUTRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->PER_AUTRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACQ_NB_CON->Visible) { // ACQ_NB_CON ?>
	<div id="r_ACQ_NB_CON" class="form-group row">
		<label for="x_ACQ_NB_CON" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACQ_NB_CON" id="u_ACQ_NB_CON" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACQ_NB_CON->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACQ_NB_CON"><?php echo $tabemp4_update->ACQ_NB_CON->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACQ_NB_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACQ_NB_CON">
<input type="text" data-table="tabemp4" data-field="x_ACQ_NB_CON" name="x_ACQ_NB_CON" id="x_ACQ_NB_CON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACQ_NB_CON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACQ_NB_CON->EditValue ?>"<?php echo $tabemp4_update->ACQ_NB_CON->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACQ_NB_CON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_MT_BRUT->Visible) { // ACC_MT_BRUT ?>
	<div id="r_ACC_MT_BRUT" class="form-group row">
		<label for="x_ACC_MT_BRUT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_MT_BRUT" id="u_ACC_MT_BRUT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_MT_BRUT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_MT_BRUT"><?php echo $tabemp4_update->ACC_MT_BRUT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_MT_BRUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_BRUT">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_BRUT" name="x_ACC_MT_BRUT" id="x_ACC_MT_BRUT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_MT_BRUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_MT_BRUT->EditValue ?>"<?php echo $tabemp4_update->ACC_MT_BRUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_MT_BRUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_CON->Visible) { // ACC_NB_CON ?>
	<div id="r_ACC_NB_CON" class="form-group row">
		<label for="x_ACC_NB_CON" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_CON" id="u_ACC_NB_CON" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_CON->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_CON"><?php echo $tabemp4_update->ACC_NB_CON->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_CON">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_CON" name="x_ACC_NB_CON" id="x_ACC_NB_CON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_CON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_CON->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_CON->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_CON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_PCON->Visible) { // ACC_NB_PCON ?>
	<div id="r_ACC_NB_PCON" class="form-group row">
		<label for="x_ACC_NB_PCON" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_PCON" id="u_ACC_NB_PCON" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_PCON->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_PCON"><?php echo $tabemp4_update->ACC_NB_PCON->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_PCON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_PCON">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_PCON" name="x_ACC_NB_PCON" id="x_ACC_NB_PCON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_PCON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_PCON->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_PCON->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_PCON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_MT_OVT->Visible) { // ACC_MT_OVT ?>
	<div id="r_ACC_MT_OVT" class="form-group row">
		<label for="x_ACC_MT_OVT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_MT_OVT" id="u_ACC_MT_OVT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_MT_OVT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_MT_OVT"><?php echo $tabemp4_update->ACC_MT_OVT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_MT_OVT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_OVT">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_OVT" name="x_ACC_MT_OVT" id="x_ACC_MT_OVT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_MT_OVT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_MT_OVT->EditValue ?>"<?php echo $tabemp4_update->ACC_MT_OVT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_MT_OVT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACQ_NB_MAL->Visible) { // ACQ_NB_MAL ?>
	<div id="r_ACQ_NB_MAL" class="form-group row">
		<label for="x_ACQ_NB_MAL" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACQ_NB_MAL" id="u_ACQ_NB_MAL" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACQ_NB_MAL->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACQ_NB_MAL"><?php echo $tabemp4_update->ACQ_NB_MAL->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACQ_NB_MAL->cellAttributes() ?>>
<span id="el_tabemp4_ACQ_NB_MAL">
<input type="text" data-table="tabemp4" data-field="x_ACQ_NB_MAL" name="x_ACQ_NB_MAL" id="x_ACQ_NB_MAL" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACQ_NB_MAL->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACQ_NB_MAL->EditValue ?>"<?php echo $tabemp4_update->ACQ_NB_MAL->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACQ_NB_MAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_MAL->Visible) { // ACC_NB_MAL ?>
	<div id="r_ACC_NB_MAL" class="form-group row">
		<label for="x_ACC_NB_MAL" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_MAL" id="u_ACC_NB_MAL" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_MAL->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_MAL"><?php echo $tabemp4_update->ACC_NB_MAL->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_MAL->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_MAL">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_MAL" name="x_ACC_NB_MAL" id="x_ACC_NB_MAL" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_MAL->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_MAL->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_MAL->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_MAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_MT_CON->Visible) { // ACC_MT_CON ?>
	<div id="r_ACC_MT_CON" class="form-group row">
		<label for="x_ACC_MT_CON" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_MT_CON" id="u_ACC_MT_CON" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_MT_CON->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_MT_CON"><?php echo $tabemp4_update->ACC_MT_CON->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_MT_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_CON">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_CON" name="x_ACC_MT_CON" id="x_ACC_MT_CON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_MT_CON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_MT_CON->EditValue ?>"<?php echo $tabemp4_update->ACC_MT_CON->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_MT_CON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_MAT->Visible) { // ACC_NB_MAT ?>
	<div id="r_ACC_NB_MAT" class="form-group row">
		<label for="x_ACC_NB_MAT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_MAT" id="u_ACC_NB_MAT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_MAT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_MAT"><?php echo $tabemp4_update->ACC_NB_MAT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_MAT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_MAT">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_MAT" name="x_ACC_NB_MAT" id="x_ACC_NB_MAT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_MAT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_MAT->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_MAT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_MAT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_MT_BONI->Visible) { // ACC_MT_BONI ?>
	<div id="r_ACC_MT_BONI" class="form-group row">
		<label for="x_ACC_MT_BONI" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_MT_BONI" id="u_ACC_MT_BONI" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_MT_BONI->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_MT_BONI"><?php echo $tabemp4_update->ACC_MT_BONI->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_MT_BONI->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_BONI">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_BONI" name="x_ACC_MT_BONI" id="x_ACC_MT_BONI" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_MT_BONI->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_MT_BONI->EditValue ?>"<?php echo $tabemp4_update->ACC_MT_BONI->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_MT_BONI->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_PER->Visible) { // ACC_NB_PER ?>
	<div id="r_ACC_NB_PER" class="form-group row">
		<label for="x_ACC_NB_PER" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_PER" id="u_ACC_NB_PER" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_PER->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_PER"><?php echo $tabemp4_update->ACC_NB_PER->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_PER->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_PER">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_PER" name="x_ACC_NB_PER" id="x_ACC_NB_PER" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_PER->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_PER->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_PER->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_PER->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_MT_AUT->Visible) { // ACC_MT_AUT ?>
	<div id="r_ACC_MT_AUT" class="form-group row">
		<label for="x_ACC_MT_AUT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_MT_AUT" id="u_ACC_MT_AUT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_MT_AUT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_MT_AUT"><?php echo $tabemp4_update->ACC_MT_AUT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_MT_AUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_AUT">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_AUT" name="x_ACC_MT_AUT" id="x_ACC_MT_AUT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_MT_AUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_MT_AUT->EditValue ?>"<?php echo $tabemp4_update->ACC_MT_AUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_MT_AUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_COM->Visible) { // ACC_NB_COM ?>
	<div id="r_ACC_NB_COM" class="form-group row">
		<label for="x_ACC_NB_COM" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_COM" id="u_ACC_NB_COM" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_COM->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_COM"><?php echo $tabemp4_update->ACC_NB_COM->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_COM->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_COM">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_COM" name="x_ACC_NB_COM" id="x_ACC_NB_COM" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_COM->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_COM->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_COM->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_COM->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_BAL_SAL->Visible) { // ACC_BAL_SAL ?>
	<div id="r_ACC_BAL_SAL" class="form-group row">
		<label for="x_ACC_BAL_SAL" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_BAL_SAL" id="u_ACC_BAL_SAL" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_BAL_SAL->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_BAL_SAL"><?php echo $tabemp4_update->ACC_BAL_SAL->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_BAL_SAL->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_SAL">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_SAL" name="x_ACC_BAL_SAL" id="x_ACC_BAL_SAL" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_BAL_SAL->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_BAL_SAL->EditValue ?>"<?php echo $tabemp4_update->ACC_BAL_SAL->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_BAL_SAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_BAL_BAN->Visible) { // ACC_BAL_BAN ?>
	<div id="r_ACC_BAL_BAN" class="form-group row">
		<label for="x_ACC_BAL_BAN" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_BAL_BAN" id="u_ACC_BAL_BAN" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_BAL_BAN->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_BAL_BAN"><?php echo $tabemp4_update->ACC_BAL_BAN->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_BAL_BAN->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_BAN">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_BAN" name="x_ACC_BAL_BAN" id="x_ACC_BAL_BAN" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_BAL_BAN->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_BAL_BAN->EditValue ?>"<?php echo $tabemp4_update->ACC_BAL_BAN->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_BAL_BAN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_SUS->Visible) { // ACC_NB_SUS ?>
	<div id="r_ACC_NB_SUS" class="form-group row">
		<label for="x_ACC_NB_SUS" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_SUS" id="u_ACC_NB_SUS" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_SUS->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_SUS"><?php echo $tabemp4_update->ACC_NB_SUS->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_SUS->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_SUS">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_SUS" name="x_ACC_NB_SUS" id="x_ACC_NB_SUS" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_SUS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_SUS->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_SUS->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_SUS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_BAL_ONA->Visible) { // ACC_BAL_ONA ?>
	<div id="r_ACC_BAL_ONA" class="form-group row">
		<label for="x_ACC_BAL_ONA" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_BAL_ONA" id="u_ACC_BAL_ONA" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_BAL_ONA->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_BAL_ONA"><?php echo $tabemp4_update->ACC_BAL_ONA->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_BAL_ONA->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_ONA">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_ONA" name="x_ACC_BAL_ONA" id="x_ACC_BAL_ONA" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_BAL_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_BAL_ONA->EditValue ?>"<?php echo $tabemp4_update->ACC_BAL_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_BAL_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_BAL_PENSION->Visible) { // ACC_BAL_PENSION ?>
	<div id="r_ACC_BAL_PENSION" class="form-group row">
		<label for="x_ACC_BAL_PENSION" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_BAL_PENSION" id="u_ACC_BAL_PENSION" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_BAL_PENSION->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_BAL_PENSION"><?php echo $tabemp4_update->ACC_BAL_PENSION->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_BAL_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_PENSION">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_PENSION" name="x_ACC_BAL_PENSION" id="x_ACC_BAL_PENSION" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_BAL_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_BAL_PENSION->EditValue ?>"<?php echo $tabemp4_update->ACC_BAL_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_BAL_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_ABS->Visible) { // ACC_NB_ABS ?>
	<div id="r_ACC_NB_ABS" class="form-group row">
		<label for="x_ACC_NB_ABS" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_ABS" id="u_ACC_NB_ABS" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_ABS->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_ABS"><?php echo $tabemp4_update->ACC_NB_ABS->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_ABS->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_ABS">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_ABS" name="x_ACC_NB_ABS" id="x_ACC_NB_ABS" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_ABS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_ABS->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_ABS->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_ABS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_MT_QZ->Visible) { // ACC_MT_QZ ?>
	<div id="r_ACC_MT_QZ" class="form-group row">
		<label for="x_ACC_MT_QZ" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_MT_QZ" id="u_ACC_MT_QZ" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_MT_QZ->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_MT_QZ"><?php echo $tabemp4_update->ACC_MT_QZ->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_MT_QZ->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_QZ">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_QZ" name="x_ACC_MT_QZ" id="x_ACC_MT_QZ" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_MT_QZ->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_MT_QZ->EditValue ?>"<?php echo $tabemp4_update->ACC_MT_QZ->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_MT_QZ->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_TRA->Visible) { // ACC_NB_TRA ?>
	<div id="r_ACC_NB_TRA" class="form-group row">
		<label for="x_ACC_NB_TRA" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_TRA" id="u_ACC_NB_TRA" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_TRA->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_TRA"><?php echo $tabemp4_update->ACC_NB_TRA->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_TRA->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_TRA">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_TRA" name="x_ACC_NB_TRA" id="x_ACC_NB_TRA" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_TRA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_TRA->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_TRA->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_TRA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_MT_AJST->Visible) { // ACC_MT_AJST ?>
	<div id="r_ACC_MT_AJST" class="form-group row">
		<label for="x_ACC_MT_AJST" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_MT_AJST" id="u_ACC_MT_AJST" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_MT_AJST->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_MT_AJST"><?php echo $tabemp4_update->ACC_MT_AJST->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_MT_AJST->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_AJST">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_AJST" name="x_ACC_MT_AJST" id="x_ACC_MT_AJST" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_MT_AJST->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_MT_AJST->EditValue ?>"<?php echo $tabemp4_update->ACC_MT_AJST->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_MT_AJST->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_NB_TRA_ACT->Visible) { // ACC_NB_TRA_ACT ?>
	<div id="r_ACC_NB_TRA_ACT" class="form-group row">
		<label for="x_ACC_NB_TRA_ACT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_NB_TRA_ACT" id="u_ACC_NB_TRA_ACT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_NB_TRA_ACT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_NB_TRA_ACT"><?php echo $tabemp4_update->ACC_NB_TRA_ACT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_NB_TRA_ACT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_TRA_ACT">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_TRA_ACT" name="x_ACC_NB_TRA_ACT" id="x_ACC_NB_TRA_ACT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_NB_TRA_ACT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_NB_TRA_ACT->EditValue ?>"<?php echo $tabemp4_update->ACC_NB_TRA_ACT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_NB_TRA_ACT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC1_MT_BRUT->Visible) { // ACC1_MT_BRUT ?>
	<div id="r_ACC1_MT_BRUT" class="form-group row">
		<label for="x_ACC1_MT_BRUT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC1_MT_BRUT" id="u_ACC1_MT_BRUT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC1_MT_BRUT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC1_MT_BRUT"><?php echo $tabemp4_update->ACC1_MT_BRUT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC1_MT_BRUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC1_MT_BRUT">
<input type="text" data-table="tabemp4" data-field="x_ACC1_MT_BRUT" name="x_ACC1_MT_BRUT" id="x_ACC1_MT_BRUT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC1_MT_BRUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC1_MT_BRUT->EditValue ?>"<?php echo $tabemp4_update->ACC1_MT_BRUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC1_MT_BRUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_update->ACC_RENDEMENT->Visible) { // ACC_RENDEMENT ?>
	<div id="r_ACC_RENDEMENT" class="form-group row">
		<label for="x_ACC_RENDEMENT" class="<?php echo $tabemp4_update->LeftColumnClass ?>"><div class="custom-control custom-checkbox">
<input type="checkbox" name="u_ACC_RENDEMENT" id="u_ACC_RENDEMENT" class="custom-control-input ew-multi-select" value="1"<?php echo $tabemp4_update->ACC_RENDEMENT->MultiUpdate == "1" ? " checked" : "" ?>>
<label class="custom-control-label" for="u_ACC_RENDEMENT"><?php echo $tabemp4_update->ACC_RENDEMENT->caption() ?></label></div></label>
		<div class="<?php echo $tabemp4_update->RightColumnClass ?>"><div <?php echo $tabemp4_update->ACC_RENDEMENT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_RENDEMENT">
<input type="text" data-table="tabemp4" data-field="x_ACC_RENDEMENT" name="x_ACC_RENDEMENT" id="x_ACC_RENDEMENT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_update->ACC_RENDEMENT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_update->ACC_RENDEMENT->EditValue ?>"<?php echo $tabemp4_update->ACC_RENDEMENT->editAttributes() ?>>
</span>
<?php echo $tabemp4_update->ACC_RENDEMENT->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$tabemp4_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $tabemp4_update->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tabemp4_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tabemp4_update->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$tabemp4_update->terminate();
?>