<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tabemp4_list = new tabemp4_list();

// Run the page
$tabemp4_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tabemp4_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$tabemp4_list->isExport()) { ?>
<script>
var ftabemp4list, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ftabemp4list = currentForm = new ew.Form("ftabemp4list", "list");
	ftabemp4list.formKeyCountName = '<?php echo $tabemp4_list->FormKeyCountName ?>';
	loadjs.done("ftabemp4list");
});
var ftabemp4listsrch;
loadjs.ready("head", function() {

	// Form object for search
	ftabemp4listsrch = currentSearchForm = new ew.Form("ftabemp4listsrch");

	// Dynamic selection lists
	// Filters

	ftabemp4listsrch.filterList = <?php echo $tabemp4_list->getFilterList() ?>;
	loadjs.done("ftabemp4listsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$tabemp4_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tabemp4_list->TotalRecords > 0 && $tabemp4_list->ExportOptions->visible()) { ?>
<?php $tabemp4_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tabemp4_list->ImportOptions->visible()) { ?>
<?php $tabemp4_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tabemp4_list->SearchOptions->visible()) { ?>
<?php $tabemp4_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tabemp4_list->FilterOptions->visible()) { ?>
<?php $tabemp4_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tabemp4_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tabemp4_list->isExport() && !$tabemp4->CurrentAction) { ?>
<form name="ftabemp4listsrch" id="ftabemp4listsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ftabemp4listsrch-search-panel" class="<?php echo $tabemp4_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tabemp4">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $tabemp4_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($tabemp4_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($tabemp4_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tabemp4_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tabemp4_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tabemp4_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tabemp4_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tabemp4_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $tabemp4_list->showPageHeader(); ?>
<?php
$tabemp4_list->showMessage();
?>
<?php if ($tabemp4_list->TotalRecords > 0 || $tabemp4->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tabemp4_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tabemp4">
<?php if (!$tabemp4_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$tabemp4_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tabemp4_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tabemp4_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftabemp4list" id="ftabemp4list" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tabemp4">
<div id="gmp_tabemp4" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($tabemp4_list->TotalRecords > 0 || $tabemp4_list->isGridEdit()) { ?>
<table id="tbl_tabemp4list" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tabemp4->RowType = ROWTYPE_HEADER;

// Render list options
$tabemp4_list->renderListOptions();

// Render list options (header, left)
$tabemp4_list->ListOptions->render("header", "left");
?>
<?php if ($tabemp4_list->id->Visible) { // id ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->id) == "") { ?>
		<th data-name="id" class="<?php echo $tabemp4_list->id->headerCellClass() ?>"><div id="elh_tabemp4_id" class="tabemp4_id"><div class="ew-table-header-caption"><?php echo $tabemp4_list->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $tabemp4_list->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->id) ?>', 1);"><div id="elh_tabemp4_id" class="tabemp4_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->id->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->id->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->RN->Visible) { // RN ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->RN) == "") { ?>
		<th data-name="RN" class="<?php echo $tabemp4_list->RN->headerCellClass() ?>"><div id="elh_tabemp4_RN" class="tabemp4_RN"><div class="ew-table-header-caption"><?php echo $tabemp4_list->RN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RN" class="<?php echo $tabemp4_list->RN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->RN) ?>', 1);"><div id="elh_tabemp4_RN" class="tabemp4_RN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->RN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->RN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->RN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->NO_EMP->Visible) { // NO_EMP ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->NO_EMP) == "") { ?>
		<th data-name="NO_EMP" class="<?php echo $tabemp4_list->NO_EMP->headerCellClass() ?>"><div id="elh_tabemp4_NO_EMP" class="tabemp4_NO_EMP"><div class="ew-table-header-caption"><?php echo $tabemp4_list->NO_EMP->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NO_EMP" class="<?php echo $tabemp4_list->NO_EMP->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->NO_EMP) ?>', 1);"><div id="elh_tabemp4_NO_EMP" class="tabemp4_NO_EMP">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->NO_EMP->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->NO_EMP->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->NO_EMP->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->NOM_EMP->Visible) { // NOM_EMP ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->NOM_EMP) == "") { ?>
		<th data-name="NOM_EMP" class="<?php echo $tabemp4_list->NOM_EMP->headerCellClass() ?>"><div id="elh_tabemp4_NOM_EMP" class="tabemp4_NOM_EMP"><div class="ew-table-header-caption"><?php echo $tabemp4_list->NOM_EMP->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NOM_EMP" class="<?php echo $tabemp4_list->NOM_EMP->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->NOM_EMP) ?>', 1);"><div id="elh_tabemp4_NOM_EMP" class="tabemp4_NOM_EMP">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->NOM_EMP->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->NOM_EMP->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->NOM_EMP->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->SEXE->Visible) { // SEXE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->SEXE) == "") { ?>
		<th data-name="SEXE" class="<?php echo $tabemp4_list->SEXE->headerCellClass() ?>"><div id="elh_tabemp4_SEXE" class="tabemp4_SEXE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->SEXE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SEXE" class="<?php echo $tabemp4_list->SEXE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->SEXE) ?>', 1);"><div id="elh_tabemp4_SEXE" class="tabemp4_SEXE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->SEXE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->SEXE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->SEXE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ETAT_C->Visible) { // ETAT_C ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ETAT_C) == "") { ?>
		<th data-name="ETAT_C" class="<?php echo $tabemp4_list->ETAT_C->headerCellClass() ?>"><div id="elh_tabemp4_ETAT_C" class="tabemp4_ETAT_C"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ETAT_C->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ETAT_C" class="<?php echo $tabemp4_list->ETAT_C->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ETAT_C) ?>', 1);"><div id="elh_tabemp4_ETAT_C" class="tabemp4_ETAT_C">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ETAT_C->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ETAT_C->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ETAT_C->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->DEPEND->Visible) { // DEPEND ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->DEPEND) == "") { ?>
		<th data-name="DEPEND" class="<?php echo $tabemp4_list->DEPEND->headerCellClass() ?>"><div id="elh_tabemp4_DEPEND" class="tabemp4_DEPEND"><div class="ew-table-header-caption"><?php echo $tabemp4_list->DEPEND->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DEPEND" class="<?php echo $tabemp4_list->DEPEND->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->DEPEND) ?>', 1);"><div id="elh_tabemp4_DEPEND" class="tabemp4_DEPEND">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->DEPEND->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->DEPEND->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->DEPEND->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->DTE_NAIS->Visible) { // DTE_NAIS ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->DTE_NAIS) == "") { ?>
		<th data-name="DTE_NAIS" class="<?php echo $tabemp4_list->DTE_NAIS->headerCellClass() ?>"><div id="elh_tabemp4_DTE_NAIS" class="tabemp4_DTE_NAIS"><div class="ew-table-header-caption"><?php echo $tabemp4_list->DTE_NAIS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DTE_NAIS" class="<?php echo $tabemp4_list->DTE_NAIS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->DTE_NAIS) ?>', 1);"><div id="elh_tabemp4_DTE_NAIS" class="tabemp4_DTE_NAIS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->DTE_NAIS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->DTE_NAIS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->DTE_NAIS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->LIEU_NAIS->Visible) { // LIEU_NAIS ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->LIEU_NAIS) == "") { ?>
		<th data-name="LIEU_NAIS" class="<?php echo $tabemp4_list->LIEU_NAIS->headerCellClass() ?>"><div id="elh_tabemp4_LIEU_NAIS" class="tabemp4_LIEU_NAIS"><div class="ew-table-header-caption"><?php echo $tabemp4_list->LIEU_NAIS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LIEU_NAIS" class="<?php echo $tabemp4_list->LIEU_NAIS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->LIEU_NAIS) ?>', 1);"><div id="elh_tabemp4_LIEU_NAIS" class="tabemp4_LIEU_NAIS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->LIEU_NAIS->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->LIEU_NAIS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->LIEU_NAIS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->NATION->Visible) { // NATION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->NATION) == "") { ?>
		<th data-name="NATION" class="<?php echo $tabemp4_list->NATION->headerCellClass() ?>"><div id="elh_tabemp4_NATION" class="tabemp4_NATION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->NATION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NATION" class="<?php echo $tabemp4_list->NATION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->NATION) ?>', 1);"><div id="elh_tabemp4_NATION" class="tabemp4_NATION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->NATION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->NATION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->NATION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ADRESSE->Visible) { // ADRESSE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ADRESSE) == "") { ?>
		<th data-name="ADRESSE" class="<?php echo $tabemp4_list->ADRESSE->headerCellClass() ?>"><div id="elh_tabemp4_ADRESSE" class="tabemp4_ADRESSE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ADRESSE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ADRESSE" class="<?php echo $tabemp4_list->ADRESSE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ADRESSE) ?>', 1);"><div id="elh_tabemp4_ADRESSE" class="tabemp4_ADRESSE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ADRESSE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ADRESSE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ADRESSE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->VILLE->Visible) { // VILLE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->VILLE) == "") { ?>
		<th data-name="VILLE" class="<?php echo $tabemp4_list->VILLE->headerCellClass() ?>"><div id="elh_tabemp4_VILLE" class="tabemp4_VILLE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->VILLE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="VILLE" class="<?php echo $tabemp4_list->VILLE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->VILLE) ?>', 1);"><div id="elh_tabemp4_VILLE" class="tabemp4_VILLE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->VILLE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->VILLE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->VILLE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PAYS->Visible) { // PAYS ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PAYS) == "") { ?>
		<th data-name="PAYS" class="<?php echo $tabemp4_list->PAYS->headerCellClass() ?>"><div id="elh_tabemp4_PAYS" class="tabemp4_PAYS"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PAYS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PAYS" class="<?php echo $tabemp4_list->PAYS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PAYS) ?>', 1);"><div id="elh_tabemp4_PAYS" class="tabemp4_PAYS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PAYS->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PAYS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PAYS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->BOX->Visible) { // BOX ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->BOX) == "") { ?>
		<th data-name="BOX" class="<?php echo $tabemp4_list->BOX->headerCellClass() ?>"><div id="elh_tabemp4_BOX" class="tabemp4_BOX"><div class="ew-table-header-caption"><?php echo $tabemp4_list->BOX->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BOX" class="<?php echo $tabemp4_list->BOX->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->BOX) ?>', 1);"><div id="elh_tabemp4_BOX" class="tabemp4_BOX">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->BOX->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->BOX->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->BOX->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PHONE->Visible) { // PHONE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PHONE) == "") { ?>
		<th data-name="PHONE" class="<?php echo $tabemp4_list->PHONE->headerCellClass() ?>"><div id="elh_tabemp4_PHONE" class="tabemp4_PHONE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PHONE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PHONE" class="<?php echo $tabemp4_list->PHONE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PHONE) ?>', 1);"><div id="elh_tabemp4_PHONE" class="tabemp4_PHONE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PHONE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PHONE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PHONE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->REFERENCE->Visible) { // REFERENCE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->REFERENCE) == "") { ?>
		<th data-name="REFERENCE" class="<?php echo $tabemp4_list->REFERENCE->headerCellClass() ?>"><div id="elh_tabemp4_REFERENCE" class="tabemp4_REFERENCE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->REFERENCE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="REFERENCE" class="<?php echo $tabemp4_list->REFERENCE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->REFERENCE) ?>', 1);"><div id="elh_tabemp4_REFERENCE" class="tabemp4_REFERENCE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->REFERENCE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->REFERENCE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->REFERENCE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->QUALIF->Visible) { // QUALIF ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->QUALIF) == "") { ?>
		<th data-name="QUALIF" class="<?php echo $tabemp4_list->QUALIF->headerCellClass() ?>"><div id="elh_tabemp4_QUALIF" class="tabemp4_QUALIF"><div class="ew-table-header-caption"><?php echo $tabemp4_list->QUALIF->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="QUALIF" class="<?php echo $tabemp4_list->QUALIF->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->QUALIF) ?>', 1);"><div id="elh_tabemp4_QUALIF" class="tabemp4_QUALIF">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->QUALIF->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->QUALIF->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->QUALIF->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->URGENCE->Visible) { // URGENCE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->URGENCE) == "") { ?>
		<th data-name="URGENCE" class="<?php echo $tabemp4_list->URGENCE->headerCellClass() ?>"><div id="elh_tabemp4_URGENCE" class="tabemp4_URGENCE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->URGENCE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="URGENCE" class="<?php echo $tabemp4_list->URGENCE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->URGENCE) ?>', 1);"><div id="elh_tabemp4_URGENCE" class="tabemp4_URGENCE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->URGENCE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->URGENCE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->URGENCE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PHONE_URG->Visible) { // PHONE_URG ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PHONE_URG) == "") { ?>
		<th data-name="PHONE_URG" class="<?php echo $tabemp4_list->PHONE_URG->headerCellClass() ?>"><div id="elh_tabemp4_PHONE_URG" class="tabemp4_PHONE_URG"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PHONE_URG->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PHONE_URG" class="<?php echo $tabemp4_list->PHONE_URG->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PHONE_URG) ?>', 1);"><div id="elh_tabemp4_PHONE_URG" class="tabemp4_PHONE_URG">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PHONE_URG->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PHONE_URG->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PHONE_URG->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->DATE_EMP->Visible) { // DATE_EMP ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->DATE_EMP) == "") { ?>
		<th data-name="DATE_EMP" class="<?php echo $tabemp4_list->DATE_EMP->headerCellClass() ?>"><div id="elh_tabemp4_DATE_EMP" class="tabemp4_DATE_EMP"><div class="ew-table-header-caption"><?php echo $tabemp4_list->DATE_EMP->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DATE_EMP" class="<?php echo $tabemp4_list->DATE_EMP->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->DATE_EMP) ?>', 1);"><div id="elh_tabemp4_DATE_EMP" class="tabemp4_DATE_EMP">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->DATE_EMP->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->DATE_EMP->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->DATE_EMP->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->SERVICE->Visible) { // SERVICE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->SERVICE) == "") { ?>
		<th data-name="SERVICE" class="<?php echo $tabemp4_list->SERVICE->headerCellClass() ?>"><div id="elh_tabemp4_SERVICE" class="tabemp4_SERVICE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->SERVICE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SERVICE" class="<?php echo $tabemp4_list->SERVICE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->SERVICE) ?>', 1);"><div id="elh_tabemp4_SERVICE" class="tabemp4_SERVICE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->SERVICE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->SERVICE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->SERVICE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->DEPT->Visible) { // DEPT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->DEPT) == "") { ?>
		<th data-name="DEPT" class="<?php echo $tabemp4_list->DEPT->headerCellClass() ?>"><div id="elh_tabemp4_DEPT" class="tabemp4_DEPT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->DEPT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DEPT" class="<?php echo $tabemp4_list->DEPT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->DEPT) ?>', 1);"><div id="elh_tabemp4_DEPT" class="tabemp4_DEPT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->DEPT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->DEPT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->DEPT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->SECTION->Visible) { // SECTION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->SECTION) == "") { ?>
		<th data-name="SECTION" class="<?php echo $tabemp4_list->SECTION->headerCellClass() ?>"><div id="elh_tabemp4_SECTION" class="tabemp4_SECTION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->SECTION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SECTION" class="<?php echo $tabemp4_list->SECTION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->SECTION) ?>', 1);"><div id="elh_tabemp4_SECTION" class="tabemp4_SECTION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->SECTION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->SECTION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->SECTION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->CATEGORIE->Visible) { // CATEGORIE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->CATEGORIE) == "") { ?>
		<th data-name="CATEGORIE" class="<?php echo $tabemp4_list->CATEGORIE->headerCellClass() ?>"><div id="elh_tabemp4_CATEGORIE" class="tabemp4_CATEGORIE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->CATEGORIE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CATEGORIE" class="<?php echo $tabemp4_list->CATEGORIE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->CATEGORIE) ?>', 1);"><div id="elh_tabemp4_CATEGORIE" class="tabemp4_CATEGORIE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->CATEGORIE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->CATEGORIE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->CATEGORIE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->FONCTION->Visible) { // FONCTION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->FONCTION) == "") { ?>
		<th data-name="FONCTION" class="<?php echo $tabemp4_list->FONCTION->headerCellClass() ?>"><div id="elh_tabemp4_FONCTION" class="tabemp4_FONCTION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->FONCTION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FONCTION" class="<?php echo $tabemp4_list->FONCTION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->FONCTION) ?>', 1);"><div id="elh_tabemp4_FONCTION" class="tabemp4_FONCTION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->FONCTION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->FONCTION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->FONCTION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->STATUT->Visible) { // STATUT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->STATUT) == "") { ?>
		<th data-name="STATUT" class="<?php echo $tabemp4_list->STATUT->headerCellClass() ?>"><div id="elh_tabemp4_STATUT" class="tabemp4_STATUT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->STATUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="STATUT" class="<?php echo $tabemp4_list->STATUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->STATUT) ?>', 1);"><div id="elh_tabemp4_STATUT" class="tabemp4_STATUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->STATUT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->STATUT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->STATUT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->STA_DEBUT->Visible) { // STA_DEBUT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->STA_DEBUT) == "") { ?>
		<th data-name="STA_DEBUT" class="<?php echo $tabemp4_list->STA_DEBUT->headerCellClass() ?>"><div id="elh_tabemp4_STA_DEBUT" class="tabemp4_STA_DEBUT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->STA_DEBUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="STA_DEBUT" class="<?php echo $tabemp4_list->STA_DEBUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->STA_DEBUT) ?>', 1);"><div id="elh_tabemp4_STA_DEBUT" class="tabemp4_STA_DEBUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->STA_DEBUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->STA_DEBUT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->STA_DEBUT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->STA_FIN->Visible) { // STA_FIN ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->STA_FIN) == "") { ?>
		<th data-name="STA_FIN" class="<?php echo $tabemp4_list->STA_FIN->headerCellClass() ?>"><div id="elh_tabemp4_STA_FIN" class="tabemp4_STA_FIN"><div class="ew-table-header-caption"><?php echo $tabemp4_list->STA_FIN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="STA_FIN" class="<?php echo $tabemp4_list->STA_FIN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->STA_FIN) ?>', 1);"><div id="elh_tabemp4_STA_FIN" class="tabemp4_STA_FIN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->STA_FIN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->STA_FIN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->STA_FIN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->STA_MOTIF->Visible) { // STA_MOTIF ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->STA_MOTIF) == "") { ?>
		<th data-name="STA_MOTIF" class="<?php echo $tabemp4_list->STA_MOTIF->headerCellClass() ?>"><div id="elh_tabemp4_STA_MOTIF" class="tabemp4_STA_MOTIF"><div class="ew-table-header-caption"><?php echo $tabemp4_list->STA_MOTIF->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="STA_MOTIF" class="<?php echo $tabemp4_list->STA_MOTIF->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->STA_MOTIF) ?>', 1);"><div id="elh_tabemp4_STA_MOTIF" class="tabemp4_STA_MOTIF">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->STA_MOTIF->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->STA_MOTIF->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->STA_MOTIF->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->NO_NIF->Visible) { // NO_NIF ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->NO_NIF) == "") { ?>
		<th data-name="NO_NIF" class="<?php echo $tabemp4_list->NO_NIF->headerCellClass() ?>"><div id="elh_tabemp4_NO_NIF" class="tabemp4_NO_NIF"><div class="ew-table-header-caption"><?php echo $tabemp4_list->NO_NIF->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NO_NIF" class="<?php echo $tabemp4_list->NO_NIF->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->NO_NIF) ?>', 1);"><div id="elh_tabemp4_NO_NIF" class="tabemp4_NO_NIF">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->NO_NIF->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->NO_NIF->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->NO_NIF->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->NO_ONA->Visible) { // NO_ONA ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->NO_ONA) == "") { ?>
		<th data-name="NO_ONA" class="<?php echo $tabemp4_list->NO_ONA->headerCellClass() ?>"><div id="elh_tabemp4_NO_ONA" class="tabemp4_NO_ONA"><div class="ew-table-header-caption"><?php echo $tabemp4_list->NO_ONA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NO_ONA" class="<?php echo $tabemp4_list->NO_ONA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->NO_ONA) ?>', 1);"><div id="elh_tabemp4_NO_ONA" class="tabemp4_NO_ONA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->NO_ONA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->NO_ONA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->NO_ONA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->LIV_TRAV->Visible) { // LIV_TRAV ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->LIV_TRAV) == "") { ?>
		<th data-name="LIV_TRAV" class="<?php echo $tabemp4_list->LIV_TRAV->headerCellClass() ?>"><div id="elh_tabemp4_LIV_TRAV" class="tabemp4_LIV_TRAV"><div class="ew-table-header-caption"><?php echo $tabemp4_list->LIV_TRAV->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LIV_TRAV" class="<?php echo $tabemp4_list->LIV_TRAV->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->LIV_TRAV) ?>', 1);"><div id="elh_tabemp4_LIV_TRAV" class="tabemp4_LIV_TRAV">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->LIV_TRAV->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->LIV_TRAV->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->LIV_TRAV->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->MT_SALAIRE->Visible) { // MT_SALAIRE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->MT_SALAIRE) == "") { ?>
		<th data-name="MT_SALAIRE" class="<?php echo $tabemp4_list->MT_SALAIRE->headerCellClass() ?>"><div id="elh_tabemp4_MT_SALAIRE" class="tabemp4_MT_SALAIRE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->MT_SALAIRE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MT_SALAIRE" class="<?php echo $tabemp4_list->MT_SALAIRE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->MT_SALAIRE) ?>', 1);"><div id="elh_tabemp4_MT_SALAIRE" class="tabemp4_MT_SALAIRE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->MT_SALAIRE->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->MT_SALAIRE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->MT_SALAIRE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->MT_FRAIS->Visible) { // MT_FRAIS ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->MT_FRAIS) == "") { ?>
		<th data-name="MT_FRAIS" class="<?php echo $tabemp4_list->MT_FRAIS->headerCellClass() ?>"><div id="elh_tabemp4_MT_FRAIS" class="tabemp4_MT_FRAIS"><div class="ew-table-header-caption"><?php echo $tabemp4_list->MT_FRAIS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MT_FRAIS" class="<?php echo $tabemp4_list->MT_FRAIS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->MT_FRAIS) ?>', 1);"><div id="elh_tabemp4_MT_FRAIS" class="tabemp4_MT_FRAIS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->MT_FRAIS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->MT_FRAIS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->MT_FRAIS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->MT_AUTRES->Visible) { // MT_AUTRES ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->MT_AUTRES) == "") { ?>
		<th data-name="MT_AUTRES" class="<?php echo $tabemp4_list->MT_AUTRES->headerCellClass() ?>"><div id="elh_tabemp4_MT_AUTRES" class="tabemp4_MT_AUTRES"><div class="ew-table-header-caption"><?php echo $tabemp4_list->MT_AUTRES->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MT_AUTRES" class="<?php echo $tabemp4_list->MT_AUTRES->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->MT_AUTRES) ?>', 1);"><div id="elh_tabemp4_MT_AUTRES" class="tabemp4_MT_AUTRES">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->MT_AUTRES->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->MT_AUTRES->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->MT_AUTRES->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->MODE->Visible) { // MODE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->MODE) == "") { ?>
		<th data-name="MODE" class="<?php echo $tabemp4_list->MODE->headerCellClass() ?>"><div id="elh_tabemp4_MODE" class="tabemp4_MODE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->MODE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MODE" class="<?php echo $tabemp4_list->MODE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->MODE) ?>', 1);"><div id="elh_tabemp4_MODE" class="tabemp4_MODE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->MODE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->MODE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->MODE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->TYPE->Visible) { // TYPE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->TYPE) == "") { ?>
		<th data-name="TYPE" class="<?php echo $tabemp4_list->TYPE->headerCellClass() ?>"><div id="elh_tabemp4_TYPE" class="tabemp4_TYPE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->TYPE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TYPE" class="<?php echo $tabemp4_list->TYPE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->TYPE) ?>', 1);"><div id="elh_tabemp4_TYPE" class="tabemp4_TYPE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->TYPE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->TYPE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->TYPE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->MT_IMPOT->Visible) { // MT_IMPOT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->MT_IMPOT) == "") { ?>
		<th data-name="MT_IMPOT" class="<?php echo $tabemp4_list->MT_IMPOT->headerCellClass() ?>"><div id="elh_tabemp4_MT_IMPOT" class="tabemp4_MT_IMPOT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->MT_IMPOT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MT_IMPOT" class="<?php echo $tabemp4_list->MT_IMPOT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->MT_IMPOT) ?>', 1);"><div id="elh_tabemp4_MT_IMPOT" class="tabemp4_MT_IMPOT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->MT_IMPOT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->MT_IMPOT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->MT_IMPOT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_IMPOT->Visible) { // PER_IMPOT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_IMPOT) == "") { ?>
		<th data-name="PER_IMPOT" class="<?php echo $tabemp4_list->PER_IMPOT->headerCellClass() ?>"><div id="elh_tabemp4_PER_IMPOT" class="tabemp4_PER_IMPOT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_IMPOT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_IMPOT" class="<?php echo $tabemp4_list->PER_IMPOT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_IMPOT) ?>', 1);"><div id="elh_tabemp4_PER_IMPOT" class="tabemp4_PER_IMPOT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_IMPOT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_IMPOT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_IMPOT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PRET_ONA->Visible) { // PRET_ONA ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PRET_ONA) == "") { ?>
		<th data-name="PRET_ONA" class="<?php echo $tabemp4_list->PRET_ONA->headerCellClass() ?>"><div id="elh_tabemp4_PRET_ONA" class="tabemp4_PRET_ONA"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_ONA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PRET_ONA" class="<?php echo $tabemp4_list->PRET_ONA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PRET_ONA) ?>', 1);"><div id="elh_tabemp4_PRET_ONA" class="tabemp4_PRET_ONA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_ONA->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PRET_ONA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PRET_ONA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_ONA->Visible) { // PER_ONA ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_ONA) == "") { ?>
		<th data-name="PER_ONA" class="<?php echo $tabemp4_list->PER_ONA->headerCellClass() ?>"><div id="elh_tabemp4_PER_ONA" class="tabemp4_PER_ONA"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_ONA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_ONA" class="<?php echo $tabemp4_list->PER_ONA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_ONA) ?>', 1);"><div id="elh_tabemp4_PER_ONA" class="tabemp4_PER_ONA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_ONA->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_ONA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_ONA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->RET_ASSUR->Visible) { // RET_ASSUR ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->RET_ASSUR) == "") { ?>
		<th data-name="RET_ASSUR" class="<?php echo $tabemp4_list->RET_ASSUR->headerCellClass() ?>"><div id="elh_tabemp4_RET_ASSUR" class="tabemp4_RET_ASSUR"><div class="ew-table-header-caption"><?php echo $tabemp4_list->RET_ASSUR->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RET_ASSUR" class="<?php echo $tabemp4_list->RET_ASSUR->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->RET_ASSUR) ?>', 1);"><div id="elh_tabemp4_RET_ASSUR" class="tabemp4_RET_ASSUR">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->RET_ASSUR->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->RET_ASSUR->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->RET_ASSUR->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_ASSUR->Visible) { // PER_ASSUR ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_ASSUR) == "") { ?>
		<th data-name="PER_ASSUR" class="<?php echo $tabemp4_list->PER_ASSUR->headerCellClass() ?>"><div id="elh_tabemp4_PER_ASSUR" class="tabemp4_PER_ASSUR"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_ASSUR->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_ASSUR" class="<?php echo $tabemp4_list->PER_ASSUR->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_ASSUR) ?>', 1);"><div id="elh_tabemp4_PER_ASSUR" class="tabemp4_PER_ASSUR">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_ASSUR->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_ASSUR->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_ASSUR->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PRET_SALAIRE->Visible) { // PRET_SALAIRE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PRET_SALAIRE) == "") { ?>
		<th data-name="PRET_SALAIRE" class="<?php echo $tabemp4_list->PRET_SALAIRE->headerCellClass() ?>"><div id="elh_tabemp4_PRET_SALAIRE" class="tabemp4_PRET_SALAIRE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_SALAIRE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PRET_SALAIRE" class="<?php echo $tabemp4_list->PRET_SALAIRE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PRET_SALAIRE) ?>', 1);"><div id="elh_tabemp4_PRET_SALAIRE" class="tabemp4_PRET_SALAIRE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_SALAIRE->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PRET_SALAIRE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PRET_SALAIRE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_SALAIRE->Visible) { // PER_SALAIRE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_SALAIRE) == "") { ?>
		<th data-name="PER_SALAIRE" class="<?php echo $tabemp4_list->PER_SALAIRE->headerCellClass() ?>"><div id="elh_tabemp4_PER_SALAIRE" class="tabemp4_PER_SALAIRE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_SALAIRE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_SALAIRE" class="<?php echo $tabemp4_list->PER_SALAIRE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_SALAIRE) ?>', 1);"><div id="elh_tabemp4_PER_SALAIRE" class="tabemp4_PER_SALAIRE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_SALAIRE->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_SALAIRE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_SALAIRE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->RET_PENSION->Visible) { // RET_PENSION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->RET_PENSION) == "") { ?>
		<th data-name="RET_PENSION" class="<?php echo $tabemp4_list->RET_PENSION->headerCellClass() ?>"><div id="elh_tabemp4_RET_PENSION" class="tabemp4_RET_PENSION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->RET_PENSION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RET_PENSION" class="<?php echo $tabemp4_list->RET_PENSION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->RET_PENSION) ?>', 1);"><div id="elh_tabemp4_RET_PENSION" class="tabemp4_RET_PENSION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->RET_PENSION->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->RET_PENSION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->RET_PENSION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_RETPENSION->Visible) { // PER_RETPENSION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_RETPENSION) == "") { ?>
		<th data-name="PER_RETPENSION" class="<?php echo $tabemp4_list->PER_RETPENSION->headerCellClass() ?>"><div id="elh_tabemp4_PER_RETPENSION" class="tabemp4_PER_RETPENSION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_RETPENSION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_RETPENSION" class="<?php echo $tabemp4_list->PER_RETPENSION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_RETPENSION) ?>', 1);"><div id="elh_tabemp4_PER_RETPENSION" class="tabemp4_PER_RETPENSION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_RETPENSION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_RETPENSION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_RETPENSION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PRET_BANQUE->Visible) { // PRET_BANQUE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PRET_BANQUE) == "") { ?>
		<th data-name="PRET_BANQUE" class="<?php echo $tabemp4_list->PRET_BANQUE->headerCellClass() ?>"><div id="elh_tabemp4_PRET_BANQUE" class="tabemp4_PRET_BANQUE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_BANQUE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PRET_BANQUE" class="<?php echo $tabemp4_list->PRET_BANQUE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PRET_BANQUE) ?>', 1);"><div id="elh_tabemp4_PRET_BANQUE" class="tabemp4_PRET_BANQUE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_BANQUE->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PRET_BANQUE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PRET_BANQUE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_BANQUE->Visible) { // PER_BANQUE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_BANQUE) == "") { ?>
		<th data-name="PER_BANQUE" class="<?php echo $tabemp4_list->PER_BANQUE->headerCellClass() ?>"><div id="elh_tabemp4_PER_BANQUE" class="tabemp4_PER_BANQUE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_BANQUE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_BANQUE" class="<?php echo $tabemp4_list->PER_BANQUE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_BANQUE) ?>', 1);"><div id="elh_tabemp4_PER_BANQUE" class="tabemp4_PER_BANQUE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_BANQUE->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_BANQUE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_BANQUE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->RET_AVANC->Visible) { // RET_AVANC ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->RET_AVANC) == "") { ?>
		<th data-name="RET_AVANC" class="<?php echo $tabemp4_list->RET_AVANC->headerCellClass() ?>"><div id="elh_tabemp4_RET_AVANC" class="tabemp4_RET_AVANC"><div class="ew-table-header-caption"><?php echo $tabemp4_list->RET_AVANC->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RET_AVANC" class="<?php echo $tabemp4_list->RET_AVANC->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->RET_AVANC) ?>', 1);"><div id="elh_tabemp4_RET_AVANC" class="tabemp4_RET_AVANC">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->RET_AVANC->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->RET_AVANC->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->RET_AVANC->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_AVANCE->Visible) { // PER_AVANCE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_AVANCE) == "") { ?>
		<th data-name="PER_AVANCE" class="<?php echo $tabemp4_list->PER_AVANCE->headerCellClass() ?>"><div id="elh_tabemp4_PER_AVANCE" class="tabemp4_PER_AVANCE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_AVANCE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_AVANCE" class="<?php echo $tabemp4_list->PER_AVANCE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_AVANCE) ?>', 1);"><div id="elh_tabemp4_PER_AVANCE" class="tabemp4_PER_AVANCE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_AVANCE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_AVANCE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_AVANCE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PRET_PENSION->Visible) { // PRET_PENSION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PRET_PENSION) == "") { ?>
		<th data-name="PRET_PENSION" class="<?php echo $tabemp4_list->PRET_PENSION->headerCellClass() ?>"><div id="elh_tabemp4_PRET_PENSION" class="tabemp4_PRET_PENSION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_PENSION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PRET_PENSION" class="<?php echo $tabemp4_list->PRET_PENSION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PRET_PENSION) ?>', 1);"><div id="elh_tabemp4_PRET_PENSION" class="tabemp4_PRET_PENSION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PRET_PENSION->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PRET_PENSION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PRET_PENSION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_PENSION->Visible) { // PER_PENSION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_PENSION) == "") { ?>
		<th data-name="PER_PENSION" class="<?php echo $tabemp4_list->PER_PENSION->headerCellClass() ?>"><div id="elh_tabemp4_PER_PENSION" class="tabemp4_PER_PENSION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_PENSION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_PENSION" class="<?php echo $tabemp4_list->PER_PENSION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_PENSION) ?>', 1);"><div id="elh_tabemp4_PER_PENSION" class="tabemp4_PER_PENSION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_PENSION->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_PENSION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_PENSION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->RET_CAFET->Visible) { // RET_CAFET ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->RET_CAFET) == "") { ?>
		<th data-name="RET_CAFET" class="<?php echo $tabemp4_list->RET_CAFET->headerCellClass() ?>"><div id="elh_tabemp4_RET_CAFET" class="tabemp4_RET_CAFET"><div class="ew-table-header-caption"><?php echo $tabemp4_list->RET_CAFET->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RET_CAFET" class="<?php echo $tabemp4_list->RET_CAFET->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->RET_CAFET) ?>', 1);"><div id="elh_tabemp4_RET_CAFET" class="tabemp4_RET_CAFET">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->RET_CAFET->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->RET_CAFET->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->RET_CAFET->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_CAFET->Visible) { // PER_CAFET ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_CAFET) == "") { ?>
		<th data-name="PER_CAFET" class="<?php echo $tabemp4_list->PER_CAFET->headerCellClass() ?>"><div id="elh_tabemp4_PER_CAFET" class="tabemp4_PER_CAFET"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_CAFET->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_CAFET" class="<?php echo $tabemp4_list->PER_CAFET->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_CAFET) ?>', 1);"><div id="elh_tabemp4_PER_CAFET" class="tabemp4_PER_CAFET">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_CAFET->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_CAFET->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_CAFET->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->RET_CITE->Visible) { // RET_CITE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->RET_CITE) == "") { ?>
		<th data-name="RET_CITE" class="<?php echo $tabemp4_list->RET_CITE->headerCellClass() ?>"><div id="elh_tabemp4_RET_CITE" class="tabemp4_RET_CITE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->RET_CITE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RET_CITE" class="<?php echo $tabemp4_list->RET_CITE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->RET_CITE) ?>', 1);"><div id="elh_tabemp4_RET_CITE" class="tabemp4_RET_CITE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->RET_CITE->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->RET_CITE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->RET_CITE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_CITE->Visible) { // PER_CITE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_CITE) == "") { ?>
		<th data-name="PER_CITE" class="<?php echo $tabemp4_list->PER_CITE->headerCellClass() ?>"><div id="elh_tabemp4_PER_CITE" class="tabemp4_PER_CITE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_CITE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_CITE" class="<?php echo $tabemp4_list->PER_CITE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_CITE) ?>', 1);"><div id="elh_tabemp4_PER_CITE" class="tabemp4_PER_CITE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_CITE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_CITE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_CITE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->RET_AUTRE->Visible) { // RET_AUTRE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->RET_AUTRE) == "") { ?>
		<th data-name="RET_AUTRE" class="<?php echo $tabemp4_list->RET_AUTRE->headerCellClass() ?>"><div id="elh_tabemp4_RET_AUTRE" class="tabemp4_RET_AUTRE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->RET_AUTRE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="RET_AUTRE" class="<?php echo $tabemp4_list->RET_AUTRE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->RET_AUTRE) ?>', 1);"><div id="elh_tabemp4_RET_AUTRE" class="tabemp4_RET_AUTRE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->RET_AUTRE->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->RET_AUTRE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->RET_AUTRE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->PER_AUTRE->Visible) { // PER_AUTRE ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->PER_AUTRE) == "") { ?>
		<th data-name="PER_AUTRE" class="<?php echo $tabemp4_list->PER_AUTRE->headerCellClass() ?>"><div id="elh_tabemp4_PER_AUTRE" class="tabemp4_PER_AUTRE"><div class="ew-table-header-caption"><?php echo $tabemp4_list->PER_AUTRE->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PER_AUTRE" class="<?php echo $tabemp4_list->PER_AUTRE->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->PER_AUTRE) ?>', 1);"><div id="elh_tabemp4_PER_AUTRE" class="tabemp4_PER_AUTRE">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->PER_AUTRE->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->PER_AUTRE->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->PER_AUTRE->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACQ_NB_CON->Visible) { // ACQ_NB_CON ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACQ_NB_CON) == "") { ?>
		<th data-name="ACQ_NB_CON" class="<?php echo $tabemp4_list->ACQ_NB_CON->headerCellClass() ?>"><div id="elh_tabemp4_ACQ_NB_CON" class="tabemp4_ACQ_NB_CON"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACQ_NB_CON->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACQ_NB_CON" class="<?php echo $tabemp4_list->ACQ_NB_CON->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACQ_NB_CON) ?>', 1);"><div id="elh_tabemp4_ACQ_NB_CON" class="tabemp4_ACQ_NB_CON">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACQ_NB_CON->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACQ_NB_CON->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACQ_NB_CON->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_MT_BRUT->Visible) { // ACC_MT_BRUT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_MT_BRUT) == "") { ?>
		<th data-name="ACC_MT_BRUT" class="<?php echo $tabemp4_list->ACC_MT_BRUT->headerCellClass() ?>"><div id="elh_tabemp4_ACC_MT_BRUT" class="tabemp4_ACC_MT_BRUT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_BRUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_MT_BRUT" class="<?php echo $tabemp4_list->ACC_MT_BRUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_MT_BRUT) ?>', 1);"><div id="elh_tabemp4_ACC_MT_BRUT" class="tabemp4_ACC_MT_BRUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_BRUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_MT_BRUT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_MT_BRUT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_CON->Visible) { // ACC_NB_CON ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_CON) == "") { ?>
		<th data-name="ACC_NB_CON" class="<?php echo $tabemp4_list->ACC_NB_CON->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_CON" class="tabemp4_ACC_NB_CON"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_CON->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_CON" class="<?php echo $tabemp4_list->ACC_NB_CON->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_CON) ?>', 1);"><div id="elh_tabemp4_ACC_NB_CON" class="tabemp4_ACC_NB_CON">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_CON->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_CON->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_CON->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_PCON->Visible) { // ACC_NB_PCON ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_PCON) == "") { ?>
		<th data-name="ACC_NB_PCON" class="<?php echo $tabemp4_list->ACC_NB_PCON->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_PCON" class="tabemp4_ACC_NB_PCON"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_PCON->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_PCON" class="<?php echo $tabemp4_list->ACC_NB_PCON->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_PCON) ?>', 1);"><div id="elh_tabemp4_ACC_NB_PCON" class="tabemp4_ACC_NB_PCON">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_PCON->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_PCON->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_PCON->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_MT_OVT->Visible) { // ACC_MT_OVT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_MT_OVT) == "") { ?>
		<th data-name="ACC_MT_OVT" class="<?php echo $tabemp4_list->ACC_MT_OVT->headerCellClass() ?>"><div id="elh_tabemp4_ACC_MT_OVT" class="tabemp4_ACC_MT_OVT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_OVT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_MT_OVT" class="<?php echo $tabemp4_list->ACC_MT_OVT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_MT_OVT) ?>', 1);"><div id="elh_tabemp4_ACC_MT_OVT" class="tabemp4_ACC_MT_OVT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_OVT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_MT_OVT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_MT_OVT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACQ_NB_MAL->Visible) { // ACQ_NB_MAL ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACQ_NB_MAL) == "") { ?>
		<th data-name="ACQ_NB_MAL" class="<?php echo $tabemp4_list->ACQ_NB_MAL->headerCellClass() ?>"><div id="elh_tabemp4_ACQ_NB_MAL" class="tabemp4_ACQ_NB_MAL"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACQ_NB_MAL->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACQ_NB_MAL" class="<?php echo $tabemp4_list->ACQ_NB_MAL->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACQ_NB_MAL) ?>', 1);"><div id="elh_tabemp4_ACQ_NB_MAL" class="tabemp4_ACQ_NB_MAL">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACQ_NB_MAL->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACQ_NB_MAL->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACQ_NB_MAL->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_MAL->Visible) { // ACC_NB_MAL ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_MAL) == "") { ?>
		<th data-name="ACC_NB_MAL" class="<?php echo $tabemp4_list->ACC_NB_MAL->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_MAL" class="tabemp4_ACC_NB_MAL"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_MAL->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_MAL" class="<?php echo $tabemp4_list->ACC_NB_MAL->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_MAL) ?>', 1);"><div id="elh_tabemp4_ACC_NB_MAL" class="tabemp4_ACC_NB_MAL">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_MAL->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_MAL->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_MAL->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_MT_CON->Visible) { // ACC_MT_CON ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_MT_CON) == "") { ?>
		<th data-name="ACC_MT_CON" class="<?php echo $tabemp4_list->ACC_MT_CON->headerCellClass() ?>"><div id="elh_tabemp4_ACC_MT_CON" class="tabemp4_ACC_MT_CON"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_CON->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_MT_CON" class="<?php echo $tabemp4_list->ACC_MT_CON->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_MT_CON) ?>', 1);"><div id="elh_tabemp4_ACC_MT_CON" class="tabemp4_ACC_MT_CON">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_CON->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_MT_CON->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_MT_CON->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_MAT->Visible) { // ACC_NB_MAT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_MAT) == "") { ?>
		<th data-name="ACC_NB_MAT" class="<?php echo $tabemp4_list->ACC_NB_MAT->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_MAT" class="tabemp4_ACC_NB_MAT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_MAT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_MAT" class="<?php echo $tabemp4_list->ACC_NB_MAT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_MAT) ?>', 1);"><div id="elh_tabemp4_ACC_NB_MAT" class="tabemp4_ACC_NB_MAT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_MAT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_MAT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_MAT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_MT_BONI->Visible) { // ACC_MT_BONI ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_MT_BONI) == "") { ?>
		<th data-name="ACC_MT_BONI" class="<?php echo $tabemp4_list->ACC_MT_BONI->headerCellClass() ?>"><div id="elh_tabemp4_ACC_MT_BONI" class="tabemp4_ACC_MT_BONI"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_BONI->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_MT_BONI" class="<?php echo $tabemp4_list->ACC_MT_BONI->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_MT_BONI) ?>', 1);"><div id="elh_tabemp4_ACC_MT_BONI" class="tabemp4_ACC_MT_BONI">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_BONI->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_MT_BONI->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_MT_BONI->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_PER->Visible) { // ACC_NB_PER ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_PER) == "") { ?>
		<th data-name="ACC_NB_PER" class="<?php echo $tabemp4_list->ACC_NB_PER->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_PER" class="tabemp4_ACC_NB_PER"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_PER->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_PER" class="<?php echo $tabemp4_list->ACC_NB_PER->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_PER) ?>', 1);"><div id="elh_tabemp4_ACC_NB_PER" class="tabemp4_ACC_NB_PER">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_PER->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_PER->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_PER->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_MT_AUT->Visible) { // ACC_MT_AUT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_MT_AUT) == "") { ?>
		<th data-name="ACC_MT_AUT" class="<?php echo $tabemp4_list->ACC_MT_AUT->headerCellClass() ?>"><div id="elh_tabemp4_ACC_MT_AUT" class="tabemp4_ACC_MT_AUT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_AUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_MT_AUT" class="<?php echo $tabemp4_list->ACC_MT_AUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_MT_AUT) ?>', 1);"><div id="elh_tabemp4_ACC_MT_AUT" class="tabemp4_ACC_MT_AUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_AUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_MT_AUT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_MT_AUT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_COM->Visible) { // ACC_NB_COM ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_COM) == "") { ?>
		<th data-name="ACC_NB_COM" class="<?php echo $tabemp4_list->ACC_NB_COM->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_COM" class="tabemp4_ACC_NB_COM"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_COM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_COM" class="<?php echo $tabemp4_list->ACC_NB_COM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_COM) ?>', 1);"><div id="elh_tabemp4_ACC_NB_COM" class="tabemp4_ACC_NB_COM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_COM->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_COM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_COM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_BAL_SAL->Visible) { // ACC_BAL_SAL ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_SAL) == "") { ?>
		<th data-name="ACC_BAL_SAL" class="<?php echo $tabemp4_list->ACC_BAL_SAL->headerCellClass() ?>"><div id="elh_tabemp4_ACC_BAL_SAL" class="tabemp4_ACC_BAL_SAL"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_SAL->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_BAL_SAL" class="<?php echo $tabemp4_list->ACC_BAL_SAL->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_SAL) ?>', 1);"><div id="elh_tabemp4_ACC_BAL_SAL" class="tabemp4_ACC_BAL_SAL">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_SAL->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_BAL_SAL->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_BAL_SAL->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_BAL_BAN->Visible) { // ACC_BAL_BAN ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_BAN) == "") { ?>
		<th data-name="ACC_BAL_BAN" class="<?php echo $tabemp4_list->ACC_BAL_BAN->headerCellClass() ?>"><div id="elh_tabemp4_ACC_BAL_BAN" class="tabemp4_ACC_BAL_BAN"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_BAN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_BAL_BAN" class="<?php echo $tabemp4_list->ACC_BAL_BAN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_BAN) ?>', 1);"><div id="elh_tabemp4_ACC_BAL_BAN" class="tabemp4_ACC_BAL_BAN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_BAN->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_BAL_BAN->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_BAL_BAN->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_SUS->Visible) { // ACC_NB_SUS ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_SUS) == "") { ?>
		<th data-name="ACC_NB_SUS" class="<?php echo $tabemp4_list->ACC_NB_SUS->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_SUS" class="tabemp4_ACC_NB_SUS"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_SUS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_SUS" class="<?php echo $tabemp4_list->ACC_NB_SUS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_SUS) ?>', 1);"><div id="elh_tabemp4_ACC_NB_SUS" class="tabemp4_ACC_NB_SUS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_SUS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_SUS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_SUS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_BAL_ONA->Visible) { // ACC_BAL_ONA ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_ONA) == "") { ?>
		<th data-name="ACC_BAL_ONA" class="<?php echo $tabemp4_list->ACC_BAL_ONA->headerCellClass() ?>"><div id="elh_tabemp4_ACC_BAL_ONA" class="tabemp4_ACC_BAL_ONA"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_ONA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_BAL_ONA" class="<?php echo $tabemp4_list->ACC_BAL_ONA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_ONA) ?>', 1);"><div id="elh_tabemp4_ACC_BAL_ONA" class="tabemp4_ACC_BAL_ONA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_ONA->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_BAL_ONA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_BAL_ONA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_BAL_PENSION->Visible) { // ACC_BAL_PENSION ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_PENSION) == "") { ?>
		<th data-name="ACC_BAL_PENSION" class="<?php echo $tabemp4_list->ACC_BAL_PENSION->headerCellClass() ?>"><div id="elh_tabemp4_ACC_BAL_PENSION" class="tabemp4_ACC_BAL_PENSION"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_PENSION->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_BAL_PENSION" class="<?php echo $tabemp4_list->ACC_BAL_PENSION->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_BAL_PENSION) ?>', 1);"><div id="elh_tabemp4_ACC_BAL_PENSION" class="tabemp4_ACC_BAL_PENSION">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_BAL_PENSION->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_BAL_PENSION->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_BAL_PENSION->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_ABS->Visible) { // ACC_NB_ABS ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_ABS) == "") { ?>
		<th data-name="ACC_NB_ABS" class="<?php echo $tabemp4_list->ACC_NB_ABS->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_ABS" class="tabemp4_ACC_NB_ABS"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_ABS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_ABS" class="<?php echo $tabemp4_list->ACC_NB_ABS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_ABS) ?>', 1);"><div id="elh_tabemp4_ACC_NB_ABS" class="tabemp4_ACC_NB_ABS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_ABS->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_ABS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_ABS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_MT_QZ->Visible) { // ACC_MT_QZ ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_MT_QZ) == "") { ?>
		<th data-name="ACC_MT_QZ" class="<?php echo $tabemp4_list->ACC_MT_QZ->headerCellClass() ?>"><div id="elh_tabemp4_ACC_MT_QZ" class="tabemp4_ACC_MT_QZ"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_QZ->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_MT_QZ" class="<?php echo $tabemp4_list->ACC_MT_QZ->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_MT_QZ) ?>', 1);"><div id="elh_tabemp4_ACC_MT_QZ" class="tabemp4_ACC_MT_QZ">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_QZ->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_MT_QZ->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_MT_QZ->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_TRA->Visible) { // ACC_NB_TRA ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_TRA) == "") { ?>
		<th data-name="ACC_NB_TRA" class="<?php echo $tabemp4_list->ACC_NB_TRA->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_TRA" class="tabemp4_ACC_NB_TRA"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_TRA->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_TRA" class="<?php echo $tabemp4_list->ACC_NB_TRA->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_TRA) ?>', 1);"><div id="elh_tabemp4_ACC_NB_TRA" class="tabemp4_ACC_NB_TRA">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_TRA->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_TRA->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_TRA->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_MT_AJST->Visible) { // ACC_MT_AJST ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_MT_AJST) == "") { ?>
		<th data-name="ACC_MT_AJST" class="<?php echo $tabemp4_list->ACC_MT_AJST->headerCellClass() ?>"><div id="elh_tabemp4_ACC_MT_AJST" class="tabemp4_ACC_MT_AJST"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_AJST->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_MT_AJST" class="<?php echo $tabemp4_list->ACC_MT_AJST->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_MT_AJST) ?>', 1);"><div id="elh_tabemp4_ACC_MT_AJST" class="tabemp4_ACC_MT_AJST">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_MT_AJST->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_MT_AJST->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_MT_AJST->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_NB_TRA_ACT->Visible) { // ACC_NB_TRA_ACT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_NB_TRA_ACT) == "") { ?>
		<th data-name="ACC_NB_TRA_ACT" class="<?php echo $tabemp4_list->ACC_NB_TRA_ACT->headerCellClass() ?>"><div id="elh_tabemp4_ACC_NB_TRA_ACT" class="tabemp4_ACC_NB_TRA_ACT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_TRA_ACT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_NB_TRA_ACT" class="<?php echo $tabemp4_list->ACC_NB_TRA_ACT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_NB_TRA_ACT) ?>', 1);"><div id="elh_tabemp4_ACC_NB_TRA_ACT" class="tabemp4_ACC_NB_TRA_ACT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_NB_TRA_ACT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_NB_TRA_ACT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_NB_TRA_ACT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC1_MT_BRUT->Visible) { // ACC1_MT_BRUT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC1_MT_BRUT) == "") { ?>
		<th data-name="ACC1_MT_BRUT" class="<?php echo $tabemp4_list->ACC1_MT_BRUT->headerCellClass() ?>"><div id="elh_tabemp4_ACC1_MT_BRUT" class="tabemp4_ACC1_MT_BRUT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC1_MT_BRUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC1_MT_BRUT" class="<?php echo $tabemp4_list->ACC1_MT_BRUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC1_MT_BRUT) ?>', 1);"><div id="elh_tabemp4_ACC1_MT_BRUT" class="tabemp4_ACC1_MT_BRUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC1_MT_BRUT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC1_MT_BRUT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC1_MT_BRUT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tabemp4_list->ACC_RENDEMENT->Visible) { // ACC_RENDEMENT ?>
	<?php if ($tabemp4_list->SortUrl($tabemp4_list->ACC_RENDEMENT) == "") { ?>
		<th data-name="ACC_RENDEMENT" class="<?php echo $tabemp4_list->ACC_RENDEMENT->headerCellClass() ?>"><div id="elh_tabemp4_ACC_RENDEMENT" class="tabemp4_ACC_RENDEMENT"><div class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_RENDEMENT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ACC_RENDEMENT" class="<?php echo $tabemp4_list->ACC_RENDEMENT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $tabemp4_list->SortUrl($tabemp4_list->ACC_RENDEMENT) ?>', 1);"><div id="elh_tabemp4_ACC_RENDEMENT" class="tabemp4_ACC_RENDEMENT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tabemp4_list->ACC_RENDEMENT->caption() ?></span><span class="ew-table-header-sort"><?php if ($tabemp4_list->ACC_RENDEMENT->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($tabemp4_list->ACC_RENDEMENT->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tabemp4_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tabemp4_list->ExportAll && $tabemp4_list->isExport()) {
	$tabemp4_list->StopRecord = $tabemp4_list->TotalRecords;
} else {

	// Set the last record to display
	if ($tabemp4_list->TotalRecords > $tabemp4_list->StartRecord + $tabemp4_list->DisplayRecords - 1)
		$tabemp4_list->StopRecord = $tabemp4_list->StartRecord + $tabemp4_list->DisplayRecords - 1;
	else
		$tabemp4_list->StopRecord = $tabemp4_list->TotalRecords;
}
$tabemp4_list->RecordCount = $tabemp4_list->StartRecord - 1;
if ($tabemp4_list->Recordset && !$tabemp4_list->Recordset->EOF) {
	$tabemp4_list->Recordset->moveFirst();
	$selectLimit = $tabemp4_list->UseSelectLimit;
	if (!$selectLimit && $tabemp4_list->StartRecord > 1)
		$tabemp4_list->Recordset->move($tabemp4_list->StartRecord - 1);
} elseif (!$tabemp4->AllowAddDeleteRow && $tabemp4_list->StopRecord == 0) {
	$tabemp4_list->StopRecord = $tabemp4->GridAddRowCount;
}

// Initialize aggregate
$tabemp4->RowType = ROWTYPE_AGGREGATEINIT;
$tabemp4->resetAttributes();
$tabemp4_list->renderRow();
while ($tabemp4_list->RecordCount < $tabemp4_list->StopRecord) {
	$tabemp4_list->RecordCount++;
	if ($tabemp4_list->RecordCount >= $tabemp4_list->StartRecord) {
		$tabemp4_list->RowCount++;

		// Set up key count
		$tabemp4_list->KeyCount = $tabemp4_list->RowIndex;

		// Init row class and style
		$tabemp4->resetAttributes();
		$tabemp4->CssClass = "";
		if ($tabemp4_list->isGridAdd()) {
		} else {
			$tabemp4_list->loadRowValues($tabemp4_list->Recordset); // Load row values
		}
		$tabemp4->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tabemp4->RowAttrs->merge(["data-rowindex" => $tabemp4_list->RowCount, "id" => "r" . $tabemp4_list->RowCount . "_tabemp4", "data-rowtype" => $tabemp4->RowType]);

		// Render row
		$tabemp4_list->renderRow();

		// Render list options
		$tabemp4_list->renderListOptions();
?>
	<tr <?php echo $tabemp4->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tabemp4_list->ListOptions->render("body", "left", $tabemp4_list->RowCount);
?>
	<?php if ($tabemp4_list->id->Visible) { // id ?>
		<td data-name="id" <?php echo $tabemp4_list->id->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_id">
<span<?php echo $tabemp4_list->id->viewAttributes() ?>><?php echo $tabemp4_list->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->RN->Visible) { // RN ?>
		<td data-name="RN" <?php echo $tabemp4_list->RN->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_RN">
<span<?php echo $tabemp4_list->RN->viewAttributes() ?>><?php echo $tabemp4_list->RN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->NO_EMP->Visible) { // NO_EMP ?>
		<td data-name="NO_EMP" <?php echo $tabemp4_list->NO_EMP->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_NO_EMP">
<span<?php echo $tabemp4_list->NO_EMP->viewAttributes() ?>><?php echo $tabemp4_list->NO_EMP->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->NOM_EMP->Visible) { // NOM_EMP ?>
		<td data-name="NOM_EMP" <?php echo $tabemp4_list->NOM_EMP->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_NOM_EMP">
<span<?php echo $tabemp4_list->NOM_EMP->viewAttributes() ?>><?php echo $tabemp4_list->NOM_EMP->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->SEXE->Visible) { // SEXE ?>
		<td data-name="SEXE" <?php echo $tabemp4_list->SEXE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_SEXE">
<span<?php echo $tabemp4_list->SEXE->viewAttributes() ?>><?php echo $tabemp4_list->SEXE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ETAT_C->Visible) { // ETAT_C ?>
		<td data-name="ETAT_C" <?php echo $tabemp4_list->ETAT_C->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ETAT_C">
<span<?php echo $tabemp4_list->ETAT_C->viewAttributes() ?>><?php echo $tabemp4_list->ETAT_C->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->DEPEND->Visible) { // DEPEND ?>
		<td data-name="DEPEND" <?php echo $tabemp4_list->DEPEND->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_DEPEND">
<span<?php echo $tabemp4_list->DEPEND->viewAttributes() ?>><?php echo $tabemp4_list->DEPEND->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->DTE_NAIS->Visible) { // DTE_NAIS ?>
		<td data-name="DTE_NAIS" <?php echo $tabemp4_list->DTE_NAIS->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_DTE_NAIS">
<span<?php echo $tabemp4_list->DTE_NAIS->viewAttributes() ?>><?php echo $tabemp4_list->DTE_NAIS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->LIEU_NAIS->Visible) { // LIEU_NAIS ?>
		<td data-name="LIEU_NAIS" <?php echo $tabemp4_list->LIEU_NAIS->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_LIEU_NAIS">
<span<?php echo $tabemp4_list->LIEU_NAIS->viewAttributes() ?>><?php echo $tabemp4_list->LIEU_NAIS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->NATION->Visible) { // NATION ?>
		<td data-name="NATION" <?php echo $tabemp4_list->NATION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_NATION">
<span<?php echo $tabemp4_list->NATION->viewAttributes() ?>><?php echo $tabemp4_list->NATION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ADRESSE->Visible) { // ADRESSE ?>
		<td data-name="ADRESSE" <?php echo $tabemp4_list->ADRESSE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ADRESSE">
<span<?php echo $tabemp4_list->ADRESSE->viewAttributes() ?>><?php echo $tabemp4_list->ADRESSE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->VILLE->Visible) { // VILLE ?>
		<td data-name="VILLE" <?php echo $tabemp4_list->VILLE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_VILLE">
<span<?php echo $tabemp4_list->VILLE->viewAttributes() ?>><?php echo $tabemp4_list->VILLE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PAYS->Visible) { // PAYS ?>
		<td data-name="PAYS" <?php echo $tabemp4_list->PAYS->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PAYS">
<span<?php echo $tabemp4_list->PAYS->viewAttributes() ?>><?php echo $tabemp4_list->PAYS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->BOX->Visible) { // BOX ?>
		<td data-name="BOX" <?php echo $tabemp4_list->BOX->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_BOX">
<span<?php echo $tabemp4_list->BOX->viewAttributes() ?>><?php echo $tabemp4_list->BOX->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PHONE->Visible) { // PHONE ?>
		<td data-name="PHONE" <?php echo $tabemp4_list->PHONE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PHONE">
<span<?php echo $tabemp4_list->PHONE->viewAttributes() ?>><?php echo $tabemp4_list->PHONE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->REFERENCE->Visible) { // REFERENCE ?>
		<td data-name="REFERENCE" <?php echo $tabemp4_list->REFERENCE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_REFERENCE">
<span<?php echo $tabemp4_list->REFERENCE->viewAttributes() ?>><?php echo $tabemp4_list->REFERENCE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->QUALIF->Visible) { // QUALIF ?>
		<td data-name="QUALIF" <?php echo $tabemp4_list->QUALIF->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_QUALIF">
<span<?php echo $tabemp4_list->QUALIF->viewAttributes() ?>><?php echo $tabemp4_list->QUALIF->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->URGENCE->Visible) { // URGENCE ?>
		<td data-name="URGENCE" <?php echo $tabemp4_list->URGENCE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_URGENCE">
<span<?php echo $tabemp4_list->URGENCE->viewAttributes() ?>><?php echo $tabemp4_list->URGENCE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PHONE_URG->Visible) { // PHONE_URG ?>
		<td data-name="PHONE_URG" <?php echo $tabemp4_list->PHONE_URG->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PHONE_URG">
<span<?php echo $tabemp4_list->PHONE_URG->viewAttributes() ?>><?php echo $tabemp4_list->PHONE_URG->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->DATE_EMP->Visible) { // DATE_EMP ?>
		<td data-name="DATE_EMP" <?php echo $tabemp4_list->DATE_EMP->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_DATE_EMP">
<span<?php echo $tabemp4_list->DATE_EMP->viewAttributes() ?>><?php echo $tabemp4_list->DATE_EMP->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->SERVICE->Visible) { // SERVICE ?>
		<td data-name="SERVICE" <?php echo $tabemp4_list->SERVICE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_SERVICE">
<span<?php echo $tabemp4_list->SERVICE->viewAttributes() ?>><?php echo $tabemp4_list->SERVICE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->DEPT->Visible) { // DEPT ?>
		<td data-name="DEPT" <?php echo $tabemp4_list->DEPT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_DEPT">
<span<?php echo $tabemp4_list->DEPT->viewAttributes() ?>><?php echo $tabemp4_list->DEPT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->SECTION->Visible) { // SECTION ?>
		<td data-name="SECTION" <?php echo $tabemp4_list->SECTION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_SECTION">
<span<?php echo $tabemp4_list->SECTION->viewAttributes() ?>><?php echo $tabemp4_list->SECTION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->CATEGORIE->Visible) { // CATEGORIE ?>
		<td data-name="CATEGORIE" <?php echo $tabemp4_list->CATEGORIE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_CATEGORIE">
<span<?php echo $tabemp4_list->CATEGORIE->viewAttributes() ?>><?php echo $tabemp4_list->CATEGORIE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->FONCTION->Visible) { // FONCTION ?>
		<td data-name="FONCTION" <?php echo $tabemp4_list->FONCTION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_FONCTION">
<span<?php echo $tabemp4_list->FONCTION->viewAttributes() ?>><?php echo $tabemp4_list->FONCTION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->STATUT->Visible) { // STATUT ?>
		<td data-name="STATUT" <?php echo $tabemp4_list->STATUT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_STATUT">
<span<?php echo $tabemp4_list->STATUT->viewAttributes() ?>><?php echo $tabemp4_list->STATUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->STA_DEBUT->Visible) { // STA_DEBUT ?>
		<td data-name="STA_DEBUT" <?php echo $tabemp4_list->STA_DEBUT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_STA_DEBUT">
<span<?php echo $tabemp4_list->STA_DEBUT->viewAttributes() ?>><?php echo $tabemp4_list->STA_DEBUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->STA_FIN->Visible) { // STA_FIN ?>
		<td data-name="STA_FIN" <?php echo $tabemp4_list->STA_FIN->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_STA_FIN">
<span<?php echo $tabemp4_list->STA_FIN->viewAttributes() ?>><?php echo $tabemp4_list->STA_FIN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->STA_MOTIF->Visible) { // STA_MOTIF ?>
		<td data-name="STA_MOTIF" <?php echo $tabemp4_list->STA_MOTIF->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_STA_MOTIF">
<span<?php echo $tabemp4_list->STA_MOTIF->viewAttributes() ?>><?php echo $tabemp4_list->STA_MOTIF->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->NO_NIF->Visible) { // NO_NIF ?>
		<td data-name="NO_NIF" <?php echo $tabemp4_list->NO_NIF->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_NO_NIF">
<span<?php echo $tabemp4_list->NO_NIF->viewAttributes() ?>><?php echo $tabemp4_list->NO_NIF->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->NO_ONA->Visible) { // NO_ONA ?>
		<td data-name="NO_ONA" <?php echo $tabemp4_list->NO_ONA->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_NO_ONA">
<span<?php echo $tabemp4_list->NO_ONA->viewAttributes() ?>><?php echo $tabemp4_list->NO_ONA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->LIV_TRAV->Visible) { // LIV_TRAV ?>
		<td data-name="LIV_TRAV" <?php echo $tabemp4_list->LIV_TRAV->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_LIV_TRAV">
<span<?php echo $tabemp4_list->LIV_TRAV->viewAttributes() ?>><?php echo $tabemp4_list->LIV_TRAV->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->MT_SALAIRE->Visible) { // MT_SALAIRE ?>
		<td data-name="MT_SALAIRE" <?php echo $tabemp4_list->MT_SALAIRE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_MT_SALAIRE">
<span<?php echo $tabemp4_list->MT_SALAIRE->viewAttributes() ?>><?php echo $tabemp4_list->MT_SALAIRE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->MT_FRAIS->Visible) { // MT_FRAIS ?>
		<td data-name="MT_FRAIS" <?php echo $tabemp4_list->MT_FRAIS->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_MT_FRAIS">
<span<?php echo $tabemp4_list->MT_FRAIS->viewAttributes() ?>><?php echo $tabemp4_list->MT_FRAIS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->MT_AUTRES->Visible) { // MT_AUTRES ?>
		<td data-name="MT_AUTRES" <?php echo $tabemp4_list->MT_AUTRES->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_MT_AUTRES">
<span<?php echo $tabemp4_list->MT_AUTRES->viewAttributes() ?>><?php echo $tabemp4_list->MT_AUTRES->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->MODE->Visible) { // MODE ?>
		<td data-name="MODE" <?php echo $tabemp4_list->MODE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_MODE">
<span<?php echo $tabemp4_list->MODE->viewAttributes() ?>><?php echo $tabemp4_list->MODE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->TYPE->Visible) { // TYPE ?>
		<td data-name="TYPE" <?php echo $tabemp4_list->TYPE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_TYPE">
<span<?php echo $tabemp4_list->TYPE->viewAttributes() ?>><?php echo $tabemp4_list->TYPE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->MT_IMPOT->Visible) { // MT_IMPOT ?>
		<td data-name="MT_IMPOT" <?php echo $tabemp4_list->MT_IMPOT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_MT_IMPOT">
<span<?php echo $tabemp4_list->MT_IMPOT->viewAttributes() ?>><?php echo $tabemp4_list->MT_IMPOT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_IMPOT->Visible) { // PER_IMPOT ?>
		<td data-name="PER_IMPOT" <?php echo $tabemp4_list->PER_IMPOT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_IMPOT">
<span<?php echo $tabemp4_list->PER_IMPOT->viewAttributes() ?>><?php echo $tabemp4_list->PER_IMPOT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PRET_ONA->Visible) { // PRET_ONA ?>
		<td data-name="PRET_ONA" <?php echo $tabemp4_list->PRET_ONA->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PRET_ONA">
<span<?php echo $tabemp4_list->PRET_ONA->viewAttributes() ?>><?php echo $tabemp4_list->PRET_ONA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_ONA->Visible) { // PER_ONA ?>
		<td data-name="PER_ONA" <?php echo $tabemp4_list->PER_ONA->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_ONA">
<span<?php echo $tabemp4_list->PER_ONA->viewAttributes() ?>><?php echo $tabemp4_list->PER_ONA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->RET_ASSUR->Visible) { // RET_ASSUR ?>
		<td data-name="RET_ASSUR" <?php echo $tabemp4_list->RET_ASSUR->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_RET_ASSUR">
<span<?php echo $tabemp4_list->RET_ASSUR->viewAttributes() ?>><?php echo $tabemp4_list->RET_ASSUR->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_ASSUR->Visible) { // PER_ASSUR ?>
		<td data-name="PER_ASSUR" <?php echo $tabemp4_list->PER_ASSUR->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_ASSUR">
<span<?php echo $tabemp4_list->PER_ASSUR->viewAttributes() ?>><?php echo $tabemp4_list->PER_ASSUR->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PRET_SALAIRE->Visible) { // PRET_SALAIRE ?>
		<td data-name="PRET_SALAIRE" <?php echo $tabemp4_list->PRET_SALAIRE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PRET_SALAIRE">
<span<?php echo $tabemp4_list->PRET_SALAIRE->viewAttributes() ?>><?php echo $tabemp4_list->PRET_SALAIRE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_SALAIRE->Visible) { // PER_SALAIRE ?>
		<td data-name="PER_SALAIRE" <?php echo $tabemp4_list->PER_SALAIRE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_SALAIRE">
<span<?php echo $tabemp4_list->PER_SALAIRE->viewAttributes() ?>><?php echo $tabemp4_list->PER_SALAIRE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->RET_PENSION->Visible) { // RET_PENSION ?>
		<td data-name="RET_PENSION" <?php echo $tabemp4_list->RET_PENSION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_RET_PENSION">
<span<?php echo $tabemp4_list->RET_PENSION->viewAttributes() ?>><?php echo $tabemp4_list->RET_PENSION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_RETPENSION->Visible) { // PER_RETPENSION ?>
		<td data-name="PER_RETPENSION" <?php echo $tabemp4_list->PER_RETPENSION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_RETPENSION">
<span<?php echo $tabemp4_list->PER_RETPENSION->viewAttributes() ?>><?php echo $tabemp4_list->PER_RETPENSION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PRET_BANQUE->Visible) { // PRET_BANQUE ?>
		<td data-name="PRET_BANQUE" <?php echo $tabemp4_list->PRET_BANQUE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PRET_BANQUE">
<span<?php echo $tabemp4_list->PRET_BANQUE->viewAttributes() ?>><?php echo $tabemp4_list->PRET_BANQUE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_BANQUE->Visible) { // PER_BANQUE ?>
		<td data-name="PER_BANQUE" <?php echo $tabemp4_list->PER_BANQUE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_BANQUE">
<span<?php echo $tabemp4_list->PER_BANQUE->viewAttributes() ?>><?php echo $tabemp4_list->PER_BANQUE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->RET_AVANC->Visible) { // RET_AVANC ?>
		<td data-name="RET_AVANC" <?php echo $tabemp4_list->RET_AVANC->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_RET_AVANC">
<span<?php echo $tabemp4_list->RET_AVANC->viewAttributes() ?>><?php echo $tabemp4_list->RET_AVANC->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_AVANCE->Visible) { // PER_AVANCE ?>
		<td data-name="PER_AVANCE" <?php echo $tabemp4_list->PER_AVANCE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_AVANCE">
<span<?php echo $tabemp4_list->PER_AVANCE->viewAttributes() ?>><?php echo $tabemp4_list->PER_AVANCE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PRET_PENSION->Visible) { // PRET_PENSION ?>
		<td data-name="PRET_PENSION" <?php echo $tabemp4_list->PRET_PENSION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PRET_PENSION">
<span<?php echo $tabemp4_list->PRET_PENSION->viewAttributes() ?>><?php echo $tabemp4_list->PRET_PENSION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_PENSION->Visible) { // PER_PENSION ?>
		<td data-name="PER_PENSION" <?php echo $tabemp4_list->PER_PENSION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_PENSION">
<span<?php echo $tabemp4_list->PER_PENSION->viewAttributes() ?>><?php echo $tabemp4_list->PER_PENSION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->RET_CAFET->Visible) { // RET_CAFET ?>
		<td data-name="RET_CAFET" <?php echo $tabemp4_list->RET_CAFET->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_RET_CAFET">
<span<?php echo $tabemp4_list->RET_CAFET->viewAttributes() ?>><?php echo $tabemp4_list->RET_CAFET->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_CAFET->Visible) { // PER_CAFET ?>
		<td data-name="PER_CAFET" <?php echo $tabemp4_list->PER_CAFET->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_CAFET">
<span<?php echo $tabemp4_list->PER_CAFET->viewAttributes() ?>><?php echo $tabemp4_list->PER_CAFET->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->RET_CITE->Visible) { // RET_CITE ?>
		<td data-name="RET_CITE" <?php echo $tabemp4_list->RET_CITE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_RET_CITE">
<span<?php echo $tabemp4_list->RET_CITE->viewAttributes() ?>><?php echo $tabemp4_list->RET_CITE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_CITE->Visible) { // PER_CITE ?>
		<td data-name="PER_CITE" <?php echo $tabemp4_list->PER_CITE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_CITE">
<span<?php echo $tabemp4_list->PER_CITE->viewAttributes() ?>><?php echo $tabemp4_list->PER_CITE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->RET_AUTRE->Visible) { // RET_AUTRE ?>
		<td data-name="RET_AUTRE" <?php echo $tabemp4_list->RET_AUTRE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_RET_AUTRE">
<span<?php echo $tabemp4_list->RET_AUTRE->viewAttributes() ?>><?php echo $tabemp4_list->RET_AUTRE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->PER_AUTRE->Visible) { // PER_AUTRE ?>
		<td data-name="PER_AUTRE" <?php echo $tabemp4_list->PER_AUTRE->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_PER_AUTRE">
<span<?php echo $tabemp4_list->PER_AUTRE->viewAttributes() ?>><?php echo $tabemp4_list->PER_AUTRE->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACQ_NB_CON->Visible) { // ACQ_NB_CON ?>
		<td data-name="ACQ_NB_CON" <?php echo $tabemp4_list->ACQ_NB_CON->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACQ_NB_CON">
<span<?php echo $tabemp4_list->ACQ_NB_CON->viewAttributes() ?>><?php echo $tabemp4_list->ACQ_NB_CON->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_MT_BRUT->Visible) { // ACC_MT_BRUT ?>
		<td data-name="ACC_MT_BRUT" <?php echo $tabemp4_list->ACC_MT_BRUT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_MT_BRUT">
<span<?php echo $tabemp4_list->ACC_MT_BRUT->viewAttributes() ?>><?php echo $tabemp4_list->ACC_MT_BRUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_CON->Visible) { // ACC_NB_CON ?>
		<td data-name="ACC_NB_CON" <?php echo $tabemp4_list->ACC_NB_CON->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_CON">
<span<?php echo $tabemp4_list->ACC_NB_CON->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_CON->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_PCON->Visible) { // ACC_NB_PCON ?>
		<td data-name="ACC_NB_PCON" <?php echo $tabemp4_list->ACC_NB_PCON->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_PCON">
<span<?php echo $tabemp4_list->ACC_NB_PCON->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_PCON->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_MT_OVT->Visible) { // ACC_MT_OVT ?>
		<td data-name="ACC_MT_OVT" <?php echo $tabemp4_list->ACC_MT_OVT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_MT_OVT">
<span<?php echo $tabemp4_list->ACC_MT_OVT->viewAttributes() ?>><?php echo $tabemp4_list->ACC_MT_OVT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACQ_NB_MAL->Visible) { // ACQ_NB_MAL ?>
		<td data-name="ACQ_NB_MAL" <?php echo $tabemp4_list->ACQ_NB_MAL->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACQ_NB_MAL">
<span<?php echo $tabemp4_list->ACQ_NB_MAL->viewAttributes() ?>><?php echo $tabemp4_list->ACQ_NB_MAL->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_MAL->Visible) { // ACC_NB_MAL ?>
		<td data-name="ACC_NB_MAL" <?php echo $tabemp4_list->ACC_NB_MAL->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_MAL">
<span<?php echo $tabemp4_list->ACC_NB_MAL->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_MAL->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_MT_CON->Visible) { // ACC_MT_CON ?>
		<td data-name="ACC_MT_CON" <?php echo $tabemp4_list->ACC_MT_CON->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_MT_CON">
<span<?php echo $tabemp4_list->ACC_MT_CON->viewAttributes() ?>><?php echo $tabemp4_list->ACC_MT_CON->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_MAT->Visible) { // ACC_NB_MAT ?>
		<td data-name="ACC_NB_MAT" <?php echo $tabemp4_list->ACC_NB_MAT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_MAT">
<span<?php echo $tabemp4_list->ACC_NB_MAT->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_MAT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_MT_BONI->Visible) { // ACC_MT_BONI ?>
		<td data-name="ACC_MT_BONI" <?php echo $tabemp4_list->ACC_MT_BONI->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_MT_BONI">
<span<?php echo $tabemp4_list->ACC_MT_BONI->viewAttributes() ?>><?php echo $tabemp4_list->ACC_MT_BONI->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_PER->Visible) { // ACC_NB_PER ?>
		<td data-name="ACC_NB_PER" <?php echo $tabemp4_list->ACC_NB_PER->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_PER">
<span<?php echo $tabemp4_list->ACC_NB_PER->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_PER->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_MT_AUT->Visible) { // ACC_MT_AUT ?>
		<td data-name="ACC_MT_AUT" <?php echo $tabemp4_list->ACC_MT_AUT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_MT_AUT">
<span<?php echo $tabemp4_list->ACC_MT_AUT->viewAttributes() ?>><?php echo $tabemp4_list->ACC_MT_AUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_COM->Visible) { // ACC_NB_COM ?>
		<td data-name="ACC_NB_COM" <?php echo $tabemp4_list->ACC_NB_COM->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_COM">
<span<?php echo $tabemp4_list->ACC_NB_COM->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_COM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_BAL_SAL->Visible) { // ACC_BAL_SAL ?>
		<td data-name="ACC_BAL_SAL" <?php echo $tabemp4_list->ACC_BAL_SAL->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_BAL_SAL">
<span<?php echo $tabemp4_list->ACC_BAL_SAL->viewAttributes() ?>><?php echo $tabemp4_list->ACC_BAL_SAL->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_BAL_BAN->Visible) { // ACC_BAL_BAN ?>
		<td data-name="ACC_BAL_BAN" <?php echo $tabemp4_list->ACC_BAL_BAN->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_BAL_BAN">
<span<?php echo $tabemp4_list->ACC_BAL_BAN->viewAttributes() ?>><?php echo $tabemp4_list->ACC_BAL_BAN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_SUS->Visible) { // ACC_NB_SUS ?>
		<td data-name="ACC_NB_SUS" <?php echo $tabemp4_list->ACC_NB_SUS->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_SUS">
<span<?php echo $tabemp4_list->ACC_NB_SUS->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_SUS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_BAL_ONA->Visible) { // ACC_BAL_ONA ?>
		<td data-name="ACC_BAL_ONA" <?php echo $tabemp4_list->ACC_BAL_ONA->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_BAL_ONA">
<span<?php echo $tabemp4_list->ACC_BAL_ONA->viewAttributes() ?>><?php echo $tabemp4_list->ACC_BAL_ONA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_BAL_PENSION->Visible) { // ACC_BAL_PENSION ?>
		<td data-name="ACC_BAL_PENSION" <?php echo $tabemp4_list->ACC_BAL_PENSION->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_BAL_PENSION">
<span<?php echo $tabemp4_list->ACC_BAL_PENSION->viewAttributes() ?>><?php echo $tabemp4_list->ACC_BAL_PENSION->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_ABS->Visible) { // ACC_NB_ABS ?>
		<td data-name="ACC_NB_ABS" <?php echo $tabemp4_list->ACC_NB_ABS->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_ABS">
<span<?php echo $tabemp4_list->ACC_NB_ABS->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_ABS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_MT_QZ->Visible) { // ACC_MT_QZ ?>
		<td data-name="ACC_MT_QZ" <?php echo $tabemp4_list->ACC_MT_QZ->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_MT_QZ">
<span<?php echo $tabemp4_list->ACC_MT_QZ->viewAttributes() ?>><?php echo $tabemp4_list->ACC_MT_QZ->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_TRA->Visible) { // ACC_NB_TRA ?>
		<td data-name="ACC_NB_TRA" <?php echo $tabemp4_list->ACC_NB_TRA->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_TRA">
<span<?php echo $tabemp4_list->ACC_NB_TRA->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_TRA->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_MT_AJST->Visible) { // ACC_MT_AJST ?>
		<td data-name="ACC_MT_AJST" <?php echo $tabemp4_list->ACC_MT_AJST->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_MT_AJST">
<span<?php echo $tabemp4_list->ACC_MT_AJST->viewAttributes() ?>><?php echo $tabemp4_list->ACC_MT_AJST->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_NB_TRA_ACT->Visible) { // ACC_NB_TRA_ACT ?>
		<td data-name="ACC_NB_TRA_ACT" <?php echo $tabemp4_list->ACC_NB_TRA_ACT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_NB_TRA_ACT">
<span<?php echo $tabemp4_list->ACC_NB_TRA_ACT->viewAttributes() ?>><?php echo $tabemp4_list->ACC_NB_TRA_ACT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC1_MT_BRUT->Visible) { // ACC1_MT_BRUT ?>
		<td data-name="ACC1_MT_BRUT" <?php echo $tabemp4_list->ACC1_MT_BRUT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC1_MT_BRUT">
<span<?php echo $tabemp4_list->ACC1_MT_BRUT->viewAttributes() ?>><?php echo $tabemp4_list->ACC1_MT_BRUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tabemp4_list->ACC_RENDEMENT->Visible) { // ACC_RENDEMENT ?>
		<td data-name="ACC_RENDEMENT" <?php echo $tabemp4_list->ACC_RENDEMENT->cellAttributes() ?>>
<span id="el<?php echo $tabemp4_list->RowCount ?>_tabemp4_ACC_RENDEMENT">
<span<?php echo $tabemp4_list->ACC_RENDEMENT->viewAttributes() ?>><?php echo $tabemp4_list->ACC_RENDEMENT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tabemp4_list->ListOptions->render("body", "right", $tabemp4_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$tabemp4_list->isGridAdd())
		$tabemp4_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$tabemp4->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tabemp4_list->Recordset)
	$tabemp4_list->Recordset->Close();
?>
<?php if (!$tabemp4_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tabemp4_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $tabemp4_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tabemp4_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tabemp4_list->TotalRecords == 0 && !$tabemp4->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tabemp4_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tabemp4_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$tabemp4_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$tabemp4_list->terminate();
?>