<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tabemp4_edit = new tabemp4_edit();

// Run the page
$tabemp4_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tabemp4_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var ftabemp4edit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	ftabemp4edit = currentForm = new ew.Form("ftabemp4edit", "edit");

	// Validate form
	ftabemp4edit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($tabemp4_edit->id->Required) { ?>
				elm = this.getElements("x" + infix + "_id");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->id->caption(), $tabemp4_edit->id->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_id");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->id->errorMessage()) ?>");
			<?php if ($tabemp4_edit->RN->Required) { ?>
				elm = this.getElements("x" + infix + "_RN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->RN->caption(), $tabemp4_edit->RN->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_RN");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->RN->errorMessage()) ?>");
			<?php if ($tabemp4_edit->NO_EMP->Required) { ?>
				elm = this.getElements("x" + infix + "_NO_EMP");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->NO_EMP->caption(), $tabemp4_edit->NO_EMP->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_NO_EMP");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->NO_EMP->errorMessage()) ?>");
			<?php if ($tabemp4_edit->NOM_EMP->Required) { ?>
				elm = this.getElements("x" + infix + "_NOM_EMP");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->NOM_EMP->caption(), $tabemp4_edit->NOM_EMP->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->SEXE->Required) { ?>
				elm = this.getElements("x" + infix + "_SEXE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->SEXE->caption(), $tabemp4_edit->SEXE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->ETAT_C->Required) { ?>
				elm = this.getElements("x" + infix + "_ETAT_C");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ETAT_C->caption(), $tabemp4_edit->ETAT_C->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->DEPEND->Required) { ?>
				elm = this.getElements("x" + infix + "_DEPEND");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->DEPEND->caption(), $tabemp4_edit->DEPEND->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_DEPEND");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->DEPEND->errorMessage()) ?>");
			<?php if ($tabemp4_edit->DTE_NAIS->Required) { ?>
				elm = this.getElements("x" + infix + "_DTE_NAIS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->DTE_NAIS->caption(), $tabemp4_edit->DTE_NAIS->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_DTE_NAIS");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->DTE_NAIS->errorMessage()) ?>");
			<?php if ($tabemp4_edit->LIEU_NAIS->Required) { ?>
				elm = this.getElements("x" + infix + "_LIEU_NAIS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->LIEU_NAIS->caption(), $tabemp4_edit->LIEU_NAIS->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->NATION->Required) { ?>
				elm = this.getElements("x" + infix + "_NATION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->NATION->caption(), $tabemp4_edit->NATION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->ADRESSE->Required) { ?>
				elm = this.getElements("x" + infix + "_ADRESSE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ADRESSE->caption(), $tabemp4_edit->ADRESSE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->VILLE->Required) { ?>
				elm = this.getElements("x" + infix + "_VILLE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->VILLE->caption(), $tabemp4_edit->VILLE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->PAYS->Required) { ?>
				elm = this.getElements("x" + infix + "_PAYS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PAYS->caption(), $tabemp4_edit->PAYS->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->BOX->Required) { ?>
				elm = this.getElements("x" + infix + "_BOX");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->BOX->caption(), $tabemp4_edit->BOX->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->PHONE->Required) { ?>
				elm = this.getElements("x" + infix + "_PHONE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PHONE->caption(), $tabemp4_edit->PHONE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->REFERENCE->Required) { ?>
				elm = this.getElements("x" + infix + "_REFERENCE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->REFERENCE->caption(), $tabemp4_edit->REFERENCE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->QUALIF->Required) { ?>
				elm = this.getElements("x" + infix + "_QUALIF");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->QUALIF->caption(), $tabemp4_edit->QUALIF->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->URGENCE->Required) { ?>
				elm = this.getElements("x" + infix + "_URGENCE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->URGENCE->caption(), $tabemp4_edit->URGENCE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->PHONE_URG->Required) { ?>
				elm = this.getElements("x" + infix + "_PHONE_URG");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PHONE_URG->caption(), $tabemp4_edit->PHONE_URG->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->DATE_EMP->Required) { ?>
				elm = this.getElements("x" + infix + "_DATE_EMP");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->DATE_EMP->caption(), $tabemp4_edit->DATE_EMP->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_DATE_EMP");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->DATE_EMP->errorMessage()) ?>");
			<?php if ($tabemp4_edit->SERVICE->Required) { ?>
				elm = this.getElements("x" + infix + "_SERVICE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->SERVICE->caption(), $tabemp4_edit->SERVICE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->DEPT->Required) { ?>
				elm = this.getElements("x" + infix + "_DEPT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->DEPT->caption(), $tabemp4_edit->DEPT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_DEPT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->DEPT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->SECTION->Required) { ?>
				elm = this.getElements("x" + infix + "_SECTION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->SECTION->caption(), $tabemp4_edit->SECTION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->CATEGORIE->Required) { ?>
				elm = this.getElements("x" + infix + "_CATEGORIE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->CATEGORIE->caption(), $tabemp4_edit->CATEGORIE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->FONCTION->Required) { ?>
				elm = this.getElements("x" + infix + "_FONCTION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->FONCTION->caption(), $tabemp4_edit->FONCTION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->STATUT->Required) { ?>
				elm = this.getElements("x" + infix + "_STATUT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->STATUT->caption(), $tabemp4_edit->STATUT->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->STA_DEBUT->Required) { ?>
				elm = this.getElements("x" + infix + "_STA_DEBUT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->STA_DEBUT->caption(), $tabemp4_edit->STA_DEBUT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_STA_DEBUT");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->STA_DEBUT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->STA_FIN->Required) { ?>
				elm = this.getElements("x" + infix + "_STA_FIN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->STA_FIN->caption(), $tabemp4_edit->STA_FIN->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_STA_FIN");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->STA_FIN->errorMessage()) ?>");
			<?php if ($tabemp4_edit->STA_MOTIF->Required) { ?>
				elm = this.getElements("x" + infix + "_STA_MOTIF");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->STA_MOTIF->caption(), $tabemp4_edit->STA_MOTIF->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->NO_NIF->Required) { ?>
				elm = this.getElements("x" + infix + "_NO_NIF");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->NO_NIF->caption(), $tabemp4_edit->NO_NIF->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_NO_NIF");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->NO_NIF->errorMessage()) ?>");
			<?php if ($tabemp4_edit->NO_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_NO_ONA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->NO_ONA->caption(), $tabemp4_edit->NO_ONA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->LIV_TRAV->Required) { ?>
				elm = this.getElements("x" + infix + "_LIV_TRAV");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->LIV_TRAV->caption(), $tabemp4_edit->LIV_TRAV->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->MT_SALAIRE->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_SALAIRE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->MT_SALAIRE->caption(), $tabemp4_edit->MT_SALAIRE->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_SALAIRE");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->MT_SALAIRE->errorMessage()) ?>");
			<?php if ($tabemp4_edit->MT_FRAIS->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_FRAIS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->MT_FRAIS->caption(), $tabemp4_edit->MT_FRAIS->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_FRAIS");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->MT_FRAIS->errorMessage()) ?>");
			<?php if ($tabemp4_edit->MT_AUTRES->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_AUTRES");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->MT_AUTRES->caption(), $tabemp4_edit->MT_AUTRES->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_AUTRES");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->MT_AUTRES->errorMessage()) ?>");
			<?php if ($tabemp4_edit->MODE->Required) { ?>
				elm = this.getElements("x" + infix + "_MODE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->MODE->caption(), $tabemp4_edit->MODE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->TYPE->Required) { ?>
				elm = this.getElements("x" + infix + "_TYPE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->TYPE->caption(), $tabemp4_edit->TYPE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->MT_IMPOT->Required) { ?>
				elm = this.getElements("x" + infix + "_MT_IMPOT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->MT_IMPOT->caption(), $tabemp4_edit->MT_IMPOT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_MT_IMPOT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->MT_IMPOT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_IMPOT->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_IMPOT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_IMPOT->caption(), $tabemp4_edit->PER_IMPOT->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->PRET_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_ONA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PRET_ONA->caption(), $tabemp4_edit->PRET_ONA->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_ONA");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->PRET_ONA->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_ONA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_ONA->caption(), $tabemp4_edit->PER_ONA->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->RET_ASSUR->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_ASSUR");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->RET_ASSUR->caption(), $tabemp4_edit->RET_ASSUR->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_ASSUR");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->RET_ASSUR->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_ASSUR->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_ASSUR");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_ASSUR->caption(), $tabemp4_edit->PER_ASSUR->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->PRET_SALAIRE->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_SALAIRE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PRET_SALAIRE->caption(), $tabemp4_edit->PRET_SALAIRE->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_SALAIRE");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->PRET_SALAIRE->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_SALAIRE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_SALAIRE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_SALAIRE->caption(), $tabemp4_edit->PER_SALAIRE->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_PER_SALAIRE");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->PER_SALAIRE->errorMessage()) ?>");
			<?php if ($tabemp4_edit->RET_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_PENSION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->RET_PENSION->caption(), $tabemp4_edit->RET_PENSION->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_PENSION");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->RET_PENSION->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_RETPENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_RETPENSION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_RETPENSION->caption(), $tabemp4_edit->PER_RETPENSION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->PRET_BANQUE->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_BANQUE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PRET_BANQUE->caption(), $tabemp4_edit->PRET_BANQUE->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_BANQUE");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->PRET_BANQUE->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_BANQUE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_BANQUE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_BANQUE->caption(), $tabemp4_edit->PER_BANQUE->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_PER_BANQUE");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->PER_BANQUE->errorMessage()) ?>");
			<?php if ($tabemp4_edit->RET_AVANC->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_AVANC");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->RET_AVANC->caption(), $tabemp4_edit->RET_AVANC->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_AVANC");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->RET_AVANC->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_AVANCE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_AVANCE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_AVANCE->caption(), $tabemp4_edit->PER_AVANCE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->PRET_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_PRET_PENSION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PRET_PENSION->caption(), $tabemp4_edit->PRET_PENSION->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_PRET_PENSION");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->PRET_PENSION->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_PENSION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_PENSION->caption(), $tabemp4_edit->PER_PENSION->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->RET_CAFET->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_CAFET");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->RET_CAFET->caption(), $tabemp4_edit->RET_CAFET->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_CAFET");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->RET_CAFET->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_CAFET->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_CAFET");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_CAFET->caption(), $tabemp4_edit->PER_CAFET->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->RET_CITE->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_CITE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->RET_CITE->caption(), $tabemp4_edit->RET_CITE->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_CITE");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->RET_CITE->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_CITE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_CITE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_CITE->caption(), $tabemp4_edit->PER_CITE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->RET_AUTRE->Required) { ?>
				elm = this.getElements("x" + infix + "_RET_AUTRE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->RET_AUTRE->caption(), $tabemp4_edit->RET_AUTRE->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_RET_AUTRE");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->RET_AUTRE->errorMessage()) ?>");
			<?php if ($tabemp4_edit->PER_AUTRE->Required) { ?>
				elm = this.getElements("x" + infix + "_PER_AUTRE");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->PER_AUTRE->caption(), $tabemp4_edit->PER_AUTRE->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($tabemp4_edit->ACQ_NB_CON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_CON");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACQ_NB_CON->caption(), $tabemp4_edit->ACQ_NB_CON->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_CON");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACQ_NB_CON->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_MT_BRUT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BRUT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_MT_BRUT->caption(), $tabemp4_edit->ACC_MT_BRUT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BRUT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_MT_BRUT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_CON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_CON");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_CON->caption(), $tabemp4_edit->ACC_NB_CON->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_CON");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_CON->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_PCON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PCON");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_PCON->caption(), $tabemp4_edit->ACC_NB_PCON->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PCON");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_PCON->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_MT_OVT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_OVT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_MT_OVT->caption(), $tabemp4_edit->ACC_MT_OVT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_OVT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_MT_OVT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACQ_NB_MAL->Required) { ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_MAL");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACQ_NB_MAL->caption(), $tabemp4_edit->ACQ_NB_MAL->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACQ_NB_MAL");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACQ_NB_MAL->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_MAL->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAL");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_MAL->caption(), $tabemp4_edit->ACC_NB_MAL->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAL");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_MAL->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_MT_CON->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_CON");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_MT_CON->caption(), $tabemp4_edit->ACC_MT_CON->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_CON");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_MT_CON->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_MAT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_MAT->caption(), $tabemp4_edit->ACC_NB_MAT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_MAT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_MAT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_MT_BONI->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BONI");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_MT_BONI->caption(), $tabemp4_edit->ACC_MT_BONI->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_BONI");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_MT_BONI->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_PER->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PER");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_PER->caption(), $tabemp4_edit->ACC_NB_PER->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_PER");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_PER->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_MT_AUT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AUT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_MT_AUT->caption(), $tabemp4_edit->ACC_MT_AUT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AUT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_MT_AUT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_COM->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_COM");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_COM->caption(), $tabemp4_edit->ACC_NB_COM->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_COM");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_COM->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_BAL_SAL->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_SAL");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_BAL_SAL->caption(), $tabemp4_edit->ACC_BAL_SAL->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_SAL");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_BAL_SAL->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_BAL_BAN->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_BAN");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_BAL_BAN->caption(), $tabemp4_edit->ACC_BAL_BAN->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_BAN");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_BAL_BAN->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_SUS->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_SUS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_SUS->caption(), $tabemp4_edit->ACC_NB_SUS->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_SUS");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_SUS->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_BAL_ONA->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_ONA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_BAL_ONA->caption(), $tabemp4_edit->ACC_BAL_ONA->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_ONA");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_BAL_ONA->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_BAL_PENSION->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_PENSION");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_BAL_PENSION->caption(), $tabemp4_edit->ACC_BAL_PENSION->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_BAL_PENSION");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_BAL_PENSION->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_ABS->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_ABS");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_ABS->caption(), $tabemp4_edit->ACC_NB_ABS->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_ABS");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_ABS->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_MT_QZ->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_QZ");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_MT_QZ->caption(), $tabemp4_edit->ACC_MT_QZ->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_QZ");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_MT_QZ->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_TRA->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_TRA->caption(), $tabemp4_edit->ACC_NB_TRA->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_TRA->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_MT_AJST->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AJST");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_MT_AJST->caption(), $tabemp4_edit->ACC_MT_AJST->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_MT_AJST");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_MT_AJST->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_NB_TRA_ACT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA_ACT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_NB_TRA_ACT->caption(), $tabemp4_edit->ACC_NB_TRA_ACT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_NB_TRA_ACT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_NB_TRA_ACT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC1_MT_BRUT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC1_MT_BRUT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC1_MT_BRUT->caption(), $tabemp4_edit->ACC1_MT_BRUT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC1_MT_BRUT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC1_MT_BRUT->errorMessage()) ?>");
			<?php if ($tabemp4_edit->ACC_RENDEMENT->Required) { ?>
				elm = this.getElements("x" + infix + "_ACC_RENDEMENT");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tabemp4_edit->ACC_RENDEMENT->caption(), $tabemp4_edit->ACC_RENDEMENT->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ACC_RENDEMENT");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($tabemp4_edit->ACC_RENDEMENT->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ftabemp4edit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ftabemp4edit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("ftabemp4edit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $tabemp4_edit->showPageHeader(); ?>
<?php
$tabemp4_edit->showMessage();
?>
<form name="ftabemp4edit" id="ftabemp4edit" class="<?php echo $tabemp4_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tabemp4">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$tabemp4_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($tabemp4_edit->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_tabemp4_id" for="x_id" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->id->caption() ?><?php echo $tabemp4_edit->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->id->cellAttributes() ?>>
<span id="el_tabemp4_id">
<input type="text" data-table="tabemp4" data-field="x_id" name="x_id" id="x_id" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->id->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->id->EditValue ?>"<?php echo $tabemp4_edit->id->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->RN->Visible) { // RN ?>
	<div id="r_RN" class="form-group row">
		<label id="elh_tabemp4_RN" for="x_RN" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->RN->caption() ?><?php echo $tabemp4_edit->RN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->RN->cellAttributes() ?>>
<input type="text" data-table="tabemp4" data-field="x_RN" name="x_RN" id="x_RN" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->RN->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->RN->EditValue ?>"<?php echo $tabemp4_edit->RN->editAttributes() ?>>
<input type="hidden" data-table="tabemp4" data-field="x_RN" name="o_RN" id="o_RN" value="<?php echo HtmlEncode($tabemp4_edit->RN->OldValue != null ? $tabemp4_edit->RN->OldValue : $tabemp4_edit->RN->CurrentValue) ?>">
<?php echo $tabemp4_edit->RN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->NO_EMP->Visible) { // NO_EMP ?>
	<div id="r_NO_EMP" class="form-group row">
		<label id="elh_tabemp4_NO_EMP" for="x_NO_EMP" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->NO_EMP->caption() ?><?php echo $tabemp4_edit->NO_EMP->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->NO_EMP->cellAttributes() ?>>
<span id="el_tabemp4_NO_EMP">
<input type="text" data-table="tabemp4" data-field="x_NO_EMP" name="x_NO_EMP" id="x_NO_EMP" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->NO_EMP->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->NO_EMP->EditValue ?>"<?php echo $tabemp4_edit->NO_EMP->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->NO_EMP->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->NOM_EMP->Visible) { // NOM_EMP ?>
	<div id="r_NOM_EMP" class="form-group row">
		<label id="elh_tabemp4_NOM_EMP" for="x_NOM_EMP" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->NOM_EMP->caption() ?><?php echo $tabemp4_edit->NOM_EMP->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->NOM_EMP->cellAttributes() ?>>
<span id="el_tabemp4_NOM_EMP">
<input type="text" data-table="tabemp4" data-field="x_NOM_EMP" name="x_NOM_EMP" id="x_NOM_EMP" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->NOM_EMP->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->NOM_EMP->EditValue ?>"<?php echo $tabemp4_edit->NOM_EMP->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->NOM_EMP->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->SEXE->Visible) { // SEXE ?>
	<div id="r_SEXE" class="form-group row">
		<label id="elh_tabemp4_SEXE" for="x_SEXE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->SEXE->caption() ?><?php echo $tabemp4_edit->SEXE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->SEXE->cellAttributes() ?>>
<span id="el_tabemp4_SEXE">
<input type="text" data-table="tabemp4" data-field="x_SEXE" name="x_SEXE" id="x_SEXE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->SEXE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->SEXE->EditValue ?>"<?php echo $tabemp4_edit->SEXE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->SEXE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ETAT_C->Visible) { // ETAT_C ?>
	<div id="r_ETAT_C" class="form-group row">
		<label id="elh_tabemp4_ETAT_C" for="x_ETAT_C" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ETAT_C->caption() ?><?php echo $tabemp4_edit->ETAT_C->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ETAT_C->cellAttributes() ?>>
<span id="el_tabemp4_ETAT_C">
<input type="text" data-table="tabemp4" data-field="x_ETAT_C" name="x_ETAT_C" id="x_ETAT_C" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->ETAT_C->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ETAT_C->EditValue ?>"<?php echo $tabemp4_edit->ETAT_C->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ETAT_C->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->DEPEND->Visible) { // DEPEND ?>
	<div id="r_DEPEND" class="form-group row">
		<label id="elh_tabemp4_DEPEND" for="x_DEPEND" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->DEPEND->caption() ?><?php echo $tabemp4_edit->DEPEND->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->DEPEND->cellAttributes() ?>>
<span id="el_tabemp4_DEPEND">
<input type="text" data-table="tabemp4" data-field="x_DEPEND" name="x_DEPEND" id="x_DEPEND" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->DEPEND->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->DEPEND->EditValue ?>"<?php echo $tabemp4_edit->DEPEND->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->DEPEND->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->DTE_NAIS->Visible) { // DTE_NAIS ?>
	<div id="r_DTE_NAIS" class="form-group row">
		<label id="elh_tabemp4_DTE_NAIS" for="x_DTE_NAIS" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->DTE_NAIS->caption() ?><?php echo $tabemp4_edit->DTE_NAIS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->DTE_NAIS->cellAttributes() ?>>
<span id="el_tabemp4_DTE_NAIS">
<input type="text" data-table="tabemp4" data-field="x_DTE_NAIS" name="x_DTE_NAIS" id="x_DTE_NAIS" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_edit->DTE_NAIS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->DTE_NAIS->EditValue ?>"<?php echo $tabemp4_edit->DTE_NAIS->editAttributes() ?>>
<?php if (!$tabemp4_edit->DTE_NAIS->ReadOnly && !$tabemp4_edit->DTE_NAIS->Disabled && !isset($tabemp4_edit->DTE_NAIS->EditAttrs["readonly"]) && !isset($tabemp4_edit->DTE_NAIS->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4edit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4edit", "x_DTE_NAIS", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_edit->DTE_NAIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->LIEU_NAIS->Visible) { // LIEU_NAIS ?>
	<div id="r_LIEU_NAIS" class="form-group row">
		<label id="elh_tabemp4_LIEU_NAIS" for="x_LIEU_NAIS" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->LIEU_NAIS->caption() ?><?php echo $tabemp4_edit->LIEU_NAIS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->LIEU_NAIS->cellAttributes() ?>>
<span id="el_tabemp4_LIEU_NAIS">
<input type="text" data-table="tabemp4" data-field="x_LIEU_NAIS" name="x_LIEU_NAIS" id="x_LIEU_NAIS" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->LIEU_NAIS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->LIEU_NAIS->EditValue ?>"<?php echo $tabemp4_edit->LIEU_NAIS->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->LIEU_NAIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->NATION->Visible) { // NATION ?>
	<div id="r_NATION" class="form-group row">
		<label id="elh_tabemp4_NATION" for="x_NATION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->NATION->caption() ?><?php echo $tabemp4_edit->NATION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->NATION->cellAttributes() ?>>
<span id="el_tabemp4_NATION">
<input type="text" data-table="tabemp4" data-field="x_NATION" name="x_NATION" id="x_NATION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->NATION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->NATION->EditValue ?>"<?php echo $tabemp4_edit->NATION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->NATION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ADRESSE->Visible) { // ADRESSE ?>
	<div id="r_ADRESSE" class="form-group row">
		<label id="elh_tabemp4_ADRESSE" for="x_ADRESSE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ADRESSE->caption() ?><?php echo $tabemp4_edit->ADRESSE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ADRESSE->cellAttributes() ?>>
<span id="el_tabemp4_ADRESSE">
<input type="text" data-table="tabemp4" data-field="x_ADRESSE" name="x_ADRESSE" id="x_ADRESSE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->ADRESSE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ADRESSE->EditValue ?>"<?php echo $tabemp4_edit->ADRESSE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ADRESSE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->VILLE->Visible) { // VILLE ?>
	<div id="r_VILLE" class="form-group row">
		<label id="elh_tabemp4_VILLE" for="x_VILLE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->VILLE->caption() ?><?php echo $tabemp4_edit->VILLE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->VILLE->cellAttributes() ?>>
<span id="el_tabemp4_VILLE">
<input type="text" data-table="tabemp4" data-field="x_VILLE" name="x_VILLE" id="x_VILLE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->VILLE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->VILLE->EditValue ?>"<?php echo $tabemp4_edit->VILLE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->VILLE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PAYS->Visible) { // PAYS ?>
	<div id="r_PAYS" class="form-group row">
		<label id="elh_tabemp4_PAYS" for="x_PAYS" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PAYS->caption() ?><?php echo $tabemp4_edit->PAYS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PAYS->cellAttributes() ?>>
<span id="el_tabemp4_PAYS">
<input type="text" data-table="tabemp4" data-field="x_PAYS" name="x_PAYS" id="x_PAYS" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PAYS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PAYS->EditValue ?>"<?php echo $tabemp4_edit->PAYS->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PAYS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->BOX->Visible) { // BOX ?>
	<div id="r_BOX" class="form-group row">
		<label id="elh_tabemp4_BOX" for="x_BOX" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->BOX->caption() ?><?php echo $tabemp4_edit->BOX->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->BOX->cellAttributes() ?>>
<span id="el_tabemp4_BOX">
<input type="text" data-table="tabemp4" data-field="x_BOX" name="x_BOX" id="x_BOX" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->BOX->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->BOX->EditValue ?>"<?php echo $tabemp4_edit->BOX->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->BOX->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PHONE->Visible) { // PHONE ?>
	<div id="r_PHONE" class="form-group row">
		<label id="elh_tabemp4_PHONE" for="x_PHONE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PHONE->caption() ?><?php echo $tabemp4_edit->PHONE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PHONE->cellAttributes() ?>>
<span id="el_tabemp4_PHONE">
<input type="text" data-table="tabemp4" data-field="x_PHONE" name="x_PHONE" id="x_PHONE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PHONE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PHONE->EditValue ?>"<?php echo $tabemp4_edit->PHONE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PHONE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->REFERENCE->Visible) { // REFERENCE ?>
	<div id="r_REFERENCE" class="form-group row">
		<label id="elh_tabemp4_REFERENCE" for="x_REFERENCE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->REFERENCE->caption() ?><?php echo $tabemp4_edit->REFERENCE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->REFERENCE->cellAttributes() ?>>
<span id="el_tabemp4_REFERENCE">
<input type="text" data-table="tabemp4" data-field="x_REFERENCE" name="x_REFERENCE" id="x_REFERENCE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->REFERENCE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->REFERENCE->EditValue ?>"<?php echo $tabemp4_edit->REFERENCE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->REFERENCE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->QUALIF->Visible) { // QUALIF ?>
	<div id="r_QUALIF" class="form-group row">
		<label id="elh_tabemp4_QUALIF" for="x_QUALIF" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->QUALIF->caption() ?><?php echo $tabemp4_edit->QUALIF->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->QUALIF->cellAttributes() ?>>
<span id="el_tabemp4_QUALIF">
<input type="text" data-table="tabemp4" data-field="x_QUALIF" name="x_QUALIF" id="x_QUALIF" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->QUALIF->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->QUALIF->EditValue ?>"<?php echo $tabemp4_edit->QUALIF->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->QUALIF->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->URGENCE->Visible) { // URGENCE ?>
	<div id="r_URGENCE" class="form-group row">
		<label id="elh_tabemp4_URGENCE" for="x_URGENCE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->URGENCE->caption() ?><?php echo $tabemp4_edit->URGENCE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->URGENCE->cellAttributes() ?>>
<span id="el_tabemp4_URGENCE">
<input type="text" data-table="tabemp4" data-field="x_URGENCE" name="x_URGENCE" id="x_URGENCE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->URGENCE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->URGENCE->EditValue ?>"<?php echo $tabemp4_edit->URGENCE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->URGENCE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PHONE_URG->Visible) { // PHONE_URG ?>
	<div id="r_PHONE_URG" class="form-group row">
		<label id="elh_tabemp4_PHONE_URG" for="x_PHONE_URG" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PHONE_URG->caption() ?><?php echo $tabemp4_edit->PHONE_URG->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PHONE_URG->cellAttributes() ?>>
<span id="el_tabemp4_PHONE_URG">
<input type="text" data-table="tabemp4" data-field="x_PHONE_URG" name="x_PHONE_URG" id="x_PHONE_URG" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PHONE_URG->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PHONE_URG->EditValue ?>"<?php echo $tabemp4_edit->PHONE_URG->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PHONE_URG->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->DATE_EMP->Visible) { // DATE_EMP ?>
	<div id="r_DATE_EMP" class="form-group row">
		<label id="elh_tabemp4_DATE_EMP" for="x_DATE_EMP" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->DATE_EMP->caption() ?><?php echo $tabemp4_edit->DATE_EMP->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->DATE_EMP->cellAttributes() ?>>
<span id="el_tabemp4_DATE_EMP">
<input type="text" data-table="tabemp4" data-field="x_DATE_EMP" name="x_DATE_EMP" id="x_DATE_EMP" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_edit->DATE_EMP->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->DATE_EMP->EditValue ?>"<?php echo $tabemp4_edit->DATE_EMP->editAttributes() ?>>
<?php if (!$tabemp4_edit->DATE_EMP->ReadOnly && !$tabemp4_edit->DATE_EMP->Disabled && !isset($tabemp4_edit->DATE_EMP->EditAttrs["readonly"]) && !isset($tabemp4_edit->DATE_EMP->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4edit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4edit", "x_DATE_EMP", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_edit->DATE_EMP->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->SERVICE->Visible) { // SERVICE ?>
	<div id="r_SERVICE" class="form-group row">
		<label id="elh_tabemp4_SERVICE" for="x_SERVICE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->SERVICE->caption() ?><?php echo $tabemp4_edit->SERVICE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->SERVICE->cellAttributes() ?>>
<span id="el_tabemp4_SERVICE">
<input type="text" data-table="tabemp4" data-field="x_SERVICE" name="x_SERVICE" id="x_SERVICE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->SERVICE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->SERVICE->EditValue ?>"<?php echo $tabemp4_edit->SERVICE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->SERVICE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->DEPT->Visible) { // DEPT ?>
	<div id="r_DEPT" class="form-group row">
		<label id="elh_tabemp4_DEPT" for="x_DEPT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->DEPT->caption() ?><?php echo $tabemp4_edit->DEPT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->DEPT->cellAttributes() ?>>
<span id="el_tabemp4_DEPT">
<input type="text" data-table="tabemp4" data-field="x_DEPT" name="x_DEPT" id="x_DEPT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->DEPT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->DEPT->EditValue ?>"<?php echo $tabemp4_edit->DEPT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->DEPT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->SECTION->Visible) { // SECTION ?>
	<div id="r_SECTION" class="form-group row">
		<label id="elh_tabemp4_SECTION" for="x_SECTION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->SECTION->caption() ?><?php echo $tabemp4_edit->SECTION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->SECTION->cellAttributes() ?>>
<span id="el_tabemp4_SECTION">
<input type="text" data-table="tabemp4" data-field="x_SECTION" name="x_SECTION" id="x_SECTION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->SECTION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->SECTION->EditValue ?>"<?php echo $tabemp4_edit->SECTION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->SECTION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->CATEGORIE->Visible) { // CATEGORIE ?>
	<div id="r_CATEGORIE" class="form-group row">
		<label id="elh_tabemp4_CATEGORIE" for="x_CATEGORIE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->CATEGORIE->caption() ?><?php echo $tabemp4_edit->CATEGORIE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->CATEGORIE->cellAttributes() ?>>
<span id="el_tabemp4_CATEGORIE">
<input type="text" data-table="tabemp4" data-field="x_CATEGORIE" name="x_CATEGORIE" id="x_CATEGORIE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->CATEGORIE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->CATEGORIE->EditValue ?>"<?php echo $tabemp4_edit->CATEGORIE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->CATEGORIE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->FONCTION->Visible) { // FONCTION ?>
	<div id="r_FONCTION" class="form-group row">
		<label id="elh_tabemp4_FONCTION" for="x_FONCTION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->FONCTION->caption() ?><?php echo $tabemp4_edit->FONCTION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->FONCTION->cellAttributes() ?>>
<span id="el_tabemp4_FONCTION">
<input type="text" data-table="tabemp4" data-field="x_FONCTION" name="x_FONCTION" id="x_FONCTION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->FONCTION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->FONCTION->EditValue ?>"<?php echo $tabemp4_edit->FONCTION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->FONCTION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->STATUT->Visible) { // STATUT ?>
	<div id="r_STATUT" class="form-group row">
		<label id="elh_tabemp4_STATUT" for="x_STATUT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->STATUT->caption() ?><?php echo $tabemp4_edit->STATUT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->STATUT->cellAttributes() ?>>
<span id="el_tabemp4_STATUT">
<input type="text" data-table="tabemp4" data-field="x_STATUT" name="x_STATUT" id="x_STATUT" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->STATUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->STATUT->EditValue ?>"<?php echo $tabemp4_edit->STATUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->STATUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->STA_DEBUT->Visible) { // STA_DEBUT ?>
	<div id="r_STA_DEBUT" class="form-group row">
		<label id="elh_tabemp4_STA_DEBUT" for="x_STA_DEBUT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->STA_DEBUT->caption() ?><?php echo $tabemp4_edit->STA_DEBUT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->STA_DEBUT->cellAttributes() ?>>
<span id="el_tabemp4_STA_DEBUT">
<input type="text" data-table="tabemp4" data-field="x_STA_DEBUT" name="x_STA_DEBUT" id="x_STA_DEBUT" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_edit->STA_DEBUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->STA_DEBUT->EditValue ?>"<?php echo $tabemp4_edit->STA_DEBUT->editAttributes() ?>>
<?php if (!$tabemp4_edit->STA_DEBUT->ReadOnly && !$tabemp4_edit->STA_DEBUT->Disabled && !isset($tabemp4_edit->STA_DEBUT->EditAttrs["readonly"]) && !isset($tabemp4_edit->STA_DEBUT->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4edit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4edit", "x_STA_DEBUT", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_edit->STA_DEBUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->STA_FIN->Visible) { // STA_FIN ?>
	<div id="r_STA_FIN" class="form-group row">
		<label id="elh_tabemp4_STA_FIN" for="x_STA_FIN" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->STA_FIN->caption() ?><?php echo $tabemp4_edit->STA_FIN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->STA_FIN->cellAttributes() ?>>
<span id="el_tabemp4_STA_FIN">
<input type="text" data-table="tabemp4" data-field="x_STA_FIN" name="x_STA_FIN" id="x_STA_FIN" maxlength="10" placeholder="<?php echo HtmlEncode($tabemp4_edit->STA_FIN->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->STA_FIN->EditValue ?>"<?php echo $tabemp4_edit->STA_FIN->editAttributes() ?>>
<?php if (!$tabemp4_edit->STA_FIN->ReadOnly && !$tabemp4_edit->STA_FIN->Disabled && !isset($tabemp4_edit->STA_FIN->EditAttrs["readonly"]) && !isset($tabemp4_edit->STA_FIN->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftabemp4edit", "datetimepicker"], function() {
	ew.createDateTimePicker("ftabemp4edit", "x_STA_FIN", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $tabemp4_edit->STA_FIN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->STA_MOTIF->Visible) { // STA_MOTIF ?>
	<div id="r_STA_MOTIF" class="form-group row">
		<label id="elh_tabemp4_STA_MOTIF" for="x_STA_MOTIF" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->STA_MOTIF->caption() ?><?php echo $tabemp4_edit->STA_MOTIF->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->STA_MOTIF->cellAttributes() ?>>
<span id="el_tabemp4_STA_MOTIF">
<input type="text" data-table="tabemp4" data-field="x_STA_MOTIF" name="x_STA_MOTIF" id="x_STA_MOTIF" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->STA_MOTIF->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->STA_MOTIF->EditValue ?>"<?php echo $tabemp4_edit->STA_MOTIF->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->STA_MOTIF->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->NO_NIF->Visible) { // NO_NIF ?>
	<div id="r_NO_NIF" class="form-group row">
		<label id="elh_tabemp4_NO_NIF" for="x_NO_NIF" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->NO_NIF->caption() ?><?php echo $tabemp4_edit->NO_NIF->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->NO_NIF->cellAttributes() ?>>
<span id="el_tabemp4_NO_NIF">
<input type="text" data-table="tabemp4" data-field="x_NO_NIF" name="x_NO_NIF" id="x_NO_NIF" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->NO_NIF->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->NO_NIF->EditValue ?>"<?php echo $tabemp4_edit->NO_NIF->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->NO_NIF->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->NO_ONA->Visible) { // NO_ONA ?>
	<div id="r_NO_ONA" class="form-group row">
		<label id="elh_tabemp4_NO_ONA" for="x_NO_ONA" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->NO_ONA->caption() ?><?php echo $tabemp4_edit->NO_ONA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->NO_ONA->cellAttributes() ?>>
<span id="el_tabemp4_NO_ONA">
<input type="text" data-table="tabemp4" data-field="x_NO_ONA" name="x_NO_ONA" id="x_NO_ONA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->NO_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->NO_ONA->EditValue ?>"<?php echo $tabemp4_edit->NO_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->NO_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->LIV_TRAV->Visible) { // LIV_TRAV ?>
	<div id="r_LIV_TRAV" class="form-group row">
		<label id="elh_tabemp4_LIV_TRAV" for="x_LIV_TRAV" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->LIV_TRAV->caption() ?><?php echo $tabemp4_edit->LIV_TRAV->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->LIV_TRAV->cellAttributes() ?>>
<span id="el_tabemp4_LIV_TRAV">
<input type="text" data-table="tabemp4" data-field="x_LIV_TRAV" name="x_LIV_TRAV" id="x_LIV_TRAV" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->LIV_TRAV->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->LIV_TRAV->EditValue ?>"<?php echo $tabemp4_edit->LIV_TRAV->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->LIV_TRAV->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->MT_SALAIRE->Visible) { // MT_SALAIRE ?>
	<div id="r_MT_SALAIRE" class="form-group row">
		<label id="elh_tabemp4_MT_SALAIRE" for="x_MT_SALAIRE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->MT_SALAIRE->caption() ?><?php echo $tabemp4_edit->MT_SALAIRE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->MT_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_MT_SALAIRE">
<input type="text" data-table="tabemp4" data-field="x_MT_SALAIRE" name="x_MT_SALAIRE" id="x_MT_SALAIRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->MT_SALAIRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->MT_SALAIRE->EditValue ?>"<?php echo $tabemp4_edit->MT_SALAIRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->MT_SALAIRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->MT_FRAIS->Visible) { // MT_FRAIS ?>
	<div id="r_MT_FRAIS" class="form-group row">
		<label id="elh_tabemp4_MT_FRAIS" for="x_MT_FRAIS" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->MT_FRAIS->caption() ?><?php echo $tabemp4_edit->MT_FRAIS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->MT_FRAIS->cellAttributes() ?>>
<span id="el_tabemp4_MT_FRAIS">
<input type="text" data-table="tabemp4" data-field="x_MT_FRAIS" name="x_MT_FRAIS" id="x_MT_FRAIS" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->MT_FRAIS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->MT_FRAIS->EditValue ?>"<?php echo $tabemp4_edit->MT_FRAIS->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->MT_FRAIS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->MT_AUTRES->Visible) { // MT_AUTRES ?>
	<div id="r_MT_AUTRES" class="form-group row">
		<label id="elh_tabemp4_MT_AUTRES" for="x_MT_AUTRES" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->MT_AUTRES->caption() ?><?php echo $tabemp4_edit->MT_AUTRES->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->MT_AUTRES->cellAttributes() ?>>
<span id="el_tabemp4_MT_AUTRES">
<input type="text" data-table="tabemp4" data-field="x_MT_AUTRES" name="x_MT_AUTRES" id="x_MT_AUTRES" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->MT_AUTRES->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->MT_AUTRES->EditValue ?>"<?php echo $tabemp4_edit->MT_AUTRES->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->MT_AUTRES->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->MODE->Visible) { // MODE ?>
	<div id="r_MODE" class="form-group row">
		<label id="elh_tabemp4_MODE" for="x_MODE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->MODE->caption() ?><?php echo $tabemp4_edit->MODE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->MODE->cellAttributes() ?>>
<span id="el_tabemp4_MODE">
<input type="text" data-table="tabemp4" data-field="x_MODE" name="x_MODE" id="x_MODE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->MODE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->MODE->EditValue ?>"<?php echo $tabemp4_edit->MODE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->MODE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->TYPE->Visible) { // TYPE ?>
	<div id="r_TYPE" class="form-group row">
		<label id="elh_tabemp4_TYPE" for="x_TYPE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->TYPE->caption() ?><?php echo $tabemp4_edit->TYPE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->TYPE->cellAttributes() ?>>
<span id="el_tabemp4_TYPE">
<input type="text" data-table="tabemp4" data-field="x_TYPE" name="x_TYPE" id="x_TYPE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->TYPE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->TYPE->EditValue ?>"<?php echo $tabemp4_edit->TYPE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->TYPE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->MT_IMPOT->Visible) { // MT_IMPOT ?>
	<div id="r_MT_IMPOT" class="form-group row">
		<label id="elh_tabemp4_MT_IMPOT" for="x_MT_IMPOT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->MT_IMPOT->caption() ?><?php echo $tabemp4_edit->MT_IMPOT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->MT_IMPOT->cellAttributes() ?>>
<span id="el_tabemp4_MT_IMPOT">
<input type="text" data-table="tabemp4" data-field="x_MT_IMPOT" name="x_MT_IMPOT" id="x_MT_IMPOT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->MT_IMPOT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->MT_IMPOT->EditValue ?>"<?php echo $tabemp4_edit->MT_IMPOT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->MT_IMPOT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_IMPOT->Visible) { // PER_IMPOT ?>
	<div id="r_PER_IMPOT" class="form-group row">
		<label id="elh_tabemp4_PER_IMPOT" for="x_PER_IMPOT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_IMPOT->caption() ?><?php echo $tabemp4_edit->PER_IMPOT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_IMPOT->cellAttributes() ?>>
<span id="el_tabemp4_PER_IMPOT">
<input type="text" data-table="tabemp4" data-field="x_PER_IMPOT" name="x_PER_IMPOT" id="x_PER_IMPOT" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_IMPOT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_IMPOT->EditValue ?>"<?php echo $tabemp4_edit->PER_IMPOT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_IMPOT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PRET_ONA->Visible) { // PRET_ONA ?>
	<div id="r_PRET_ONA" class="form-group row">
		<label id="elh_tabemp4_PRET_ONA" for="x_PRET_ONA" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PRET_ONA->caption() ?><?php echo $tabemp4_edit->PRET_ONA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PRET_ONA->cellAttributes() ?>>
<span id="el_tabemp4_PRET_ONA">
<input type="text" data-table="tabemp4" data-field="x_PRET_ONA" name="x_PRET_ONA" id="x_PRET_ONA" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->PRET_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PRET_ONA->EditValue ?>"<?php echo $tabemp4_edit->PRET_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PRET_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_ONA->Visible) { // PER_ONA ?>
	<div id="r_PER_ONA" class="form-group row">
		<label id="elh_tabemp4_PER_ONA" for="x_PER_ONA" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_ONA->caption() ?><?php echo $tabemp4_edit->PER_ONA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_ONA->cellAttributes() ?>>
<span id="el_tabemp4_PER_ONA">
<input type="text" data-table="tabemp4" data-field="x_PER_ONA" name="x_PER_ONA" id="x_PER_ONA" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_ONA->EditValue ?>"<?php echo $tabemp4_edit->PER_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->RET_ASSUR->Visible) { // RET_ASSUR ?>
	<div id="r_RET_ASSUR" class="form-group row">
		<label id="elh_tabemp4_RET_ASSUR" for="x_RET_ASSUR" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->RET_ASSUR->caption() ?><?php echo $tabemp4_edit->RET_ASSUR->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->RET_ASSUR->cellAttributes() ?>>
<span id="el_tabemp4_RET_ASSUR">
<input type="text" data-table="tabemp4" data-field="x_RET_ASSUR" name="x_RET_ASSUR" id="x_RET_ASSUR" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->RET_ASSUR->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->RET_ASSUR->EditValue ?>"<?php echo $tabemp4_edit->RET_ASSUR->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->RET_ASSUR->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_ASSUR->Visible) { // PER_ASSUR ?>
	<div id="r_PER_ASSUR" class="form-group row">
		<label id="elh_tabemp4_PER_ASSUR" for="x_PER_ASSUR" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_ASSUR->caption() ?><?php echo $tabemp4_edit->PER_ASSUR->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_ASSUR->cellAttributes() ?>>
<span id="el_tabemp4_PER_ASSUR">
<input type="text" data-table="tabemp4" data-field="x_PER_ASSUR" name="x_PER_ASSUR" id="x_PER_ASSUR" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_ASSUR->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_ASSUR->EditValue ?>"<?php echo $tabemp4_edit->PER_ASSUR->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_ASSUR->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PRET_SALAIRE->Visible) { // PRET_SALAIRE ?>
	<div id="r_PRET_SALAIRE" class="form-group row">
		<label id="elh_tabemp4_PRET_SALAIRE" for="x_PRET_SALAIRE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PRET_SALAIRE->caption() ?><?php echo $tabemp4_edit->PRET_SALAIRE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PRET_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_PRET_SALAIRE">
<input type="text" data-table="tabemp4" data-field="x_PRET_SALAIRE" name="x_PRET_SALAIRE" id="x_PRET_SALAIRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->PRET_SALAIRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PRET_SALAIRE->EditValue ?>"<?php echo $tabemp4_edit->PRET_SALAIRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PRET_SALAIRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_SALAIRE->Visible) { // PER_SALAIRE ?>
	<div id="r_PER_SALAIRE" class="form-group row">
		<label id="elh_tabemp4_PER_SALAIRE" for="x_PER_SALAIRE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_SALAIRE->caption() ?><?php echo $tabemp4_edit->PER_SALAIRE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_SALAIRE->cellAttributes() ?>>
<span id="el_tabemp4_PER_SALAIRE">
<input type="text" data-table="tabemp4" data-field="x_PER_SALAIRE" name="x_PER_SALAIRE" id="x_PER_SALAIRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_SALAIRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_SALAIRE->EditValue ?>"<?php echo $tabemp4_edit->PER_SALAIRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_SALAIRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->RET_PENSION->Visible) { // RET_PENSION ?>
	<div id="r_RET_PENSION" class="form-group row">
		<label id="elh_tabemp4_RET_PENSION" for="x_RET_PENSION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->RET_PENSION->caption() ?><?php echo $tabemp4_edit->RET_PENSION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->RET_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_RET_PENSION">
<input type="text" data-table="tabemp4" data-field="x_RET_PENSION" name="x_RET_PENSION" id="x_RET_PENSION" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->RET_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->RET_PENSION->EditValue ?>"<?php echo $tabemp4_edit->RET_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->RET_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_RETPENSION->Visible) { // PER_RETPENSION ?>
	<div id="r_PER_RETPENSION" class="form-group row">
		<label id="elh_tabemp4_PER_RETPENSION" for="x_PER_RETPENSION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_RETPENSION->caption() ?><?php echo $tabemp4_edit->PER_RETPENSION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_RETPENSION->cellAttributes() ?>>
<span id="el_tabemp4_PER_RETPENSION">
<input type="text" data-table="tabemp4" data-field="x_PER_RETPENSION" name="x_PER_RETPENSION" id="x_PER_RETPENSION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_RETPENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_RETPENSION->EditValue ?>"<?php echo $tabemp4_edit->PER_RETPENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_RETPENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PRET_BANQUE->Visible) { // PRET_BANQUE ?>
	<div id="r_PRET_BANQUE" class="form-group row">
		<label id="elh_tabemp4_PRET_BANQUE" for="x_PRET_BANQUE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PRET_BANQUE->caption() ?><?php echo $tabemp4_edit->PRET_BANQUE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PRET_BANQUE->cellAttributes() ?>>
<span id="el_tabemp4_PRET_BANQUE">
<input type="text" data-table="tabemp4" data-field="x_PRET_BANQUE" name="x_PRET_BANQUE" id="x_PRET_BANQUE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->PRET_BANQUE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PRET_BANQUE->EditValue ?>"<?php echo $tabemp4_edit->PRET_BANQUE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PRET_BANQUE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_BANQUE->Visible) { // PER_BANQUE ?>
	<div id="r_PER_BANQUE" class="form-group row">
		<label id="elh_tabemp4_PER_BANQUE" for="x_PER_BANQUE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_BANQUE->caption() ?><?php echo $tabemp4_edit->PER_BANQUE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_BANQUE->cellAttributes() ?>>
<span id="el_tabemp4_PER_BANQUE">
<input type="text" data-table="tabemp4" data-field="x_PER_BANQUE" name="x_PER_BANQUE" id="x_PER_BANQUE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_BANQUE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_BANQUE->EditValue ?>"<?php echo $tabemp4_edit->PER_BANQUE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_BANQUE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->RET_AVANC->Visible) { // RET_AVANC ?>
	<div id="r_RET_AVANC" class="form-group row">
		<label id="elh_tabemp4_RET_AVANC" for="x_RET_AVANC" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->RET_AVANC->caption() ?><?php echo $tabemp4_edit->RET_AVANC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->RET_AVANC->cellAttributes() ?>>
<span id="el_tabemp4_RET_AVANC">
<input type="text" data-table="tabemp4" data-field="x_RET_AVANC" name="x_RET_AVANC" id="x_RET_AVANC" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->RET_AVANC->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->RET_AVANC->EditValue ?>"<?php echo $tabemp4_edit->RET_AVANC->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->RET_AVANC->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_AVANCE->Visible) { // PER_AVANCE ?>
	<div id="r_PER_AVANCE" class="form-group row">
		<label id="elh_tabemp4_PER_AVANCE" for="x_PER_AVANCE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_AVANCE->caption() ?><?php echo $tabemp4_edit->PER_AVANCE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_AVANCE->cellAttributes() ?>>
<span id="el_tabemp4_PER_AVANCE">
<input type="text" data-table="tabemp4" data-field="x_PER_AVANCE" name="x_PER_AVANCE" id="x_PER_AVANCE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_AVANCE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_AVANCE->EditValue ?>"<?php echo $tabemp4_edit->PER_AVANCE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_AVANCE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PRET_PENSION->Visible) { // PRET_PENSION ?>
	<div id="r_PRET_PENSION" class="form-group row">
		<label id="elh_tabemp4_PRET_PENSION" for="x_PRET_PENSION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PRET_PENSION->caption() ?><?php echo $tabemp4_edit->PRET_PENSION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PRET_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_PRET_PENSION">
<input type="text" data-table="tabemp4" data-field="x_PRET_PENSION" name="x_PRET_PENSION" id="x_PRET_PENSION" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->PRET_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PRET_PENSION->EditValue ?>"<?php echo $tabemp4_edit->PRET_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PRET_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_PENSION->Visible) { // PER_PENSION ?>
	<div id="r_PER_PENSION" class="form-group row">
		<label id="elh_tabemp4_PER_PENSION" for="x_PER_PENSION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_PENSION->caption() ?><?php echo $tabemp4_edit->PER_PENSION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_PER_PENSION">
<input type="text" data-table="tabemp4" data-field="x_PER_PENSION" name="x_PER_PENSION" id="x_PER_PENSION" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_PENSION->EditValue ?>"<?php echo $tabemp4_edit->PER_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->RET_CAFET->Visible) { // RET_CAFET ?>
	<div id="r_RET_CAFET" class="form-group row">
		<label id="elh_tabemp4_RET_CAFET" for="x_RET_CAFET" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->RET_CAFET->caption() ?><?php echo $tabemp4_edit->RET_CAFET->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->RET_CAFET->cellAttributes() ?>>
<span id="el_tabemp4_RET_CAFET">
<input type="text" data-table="tabemp4" data-field="x_RET_CAFET" name="x_RET_CAFET" id="x_RET_CAFET" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->RET_CAFET->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->RET_CAFET->EditValue ?>"<?php echo $tabemp4_edit->RET_CAFET->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->RET_CAFET->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_CAFET->Visible) { // PER_CAFET ?>
	<div id="r_PER_CAFET" class="form-group row">
		<label id="elh_tabemp4_PER_CAFET" for="x_PER_CAFET" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_CAFET->caption() ?><?php echo $tabemp4_edit->PER_CAFET->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_CAFET->cellAttributes() ?>>
<span id="el_tabemp4_PER_CAFET">
<input type="text" data-table="tabemp4" data-field="x_PER_CAFET" name="x_PER_CAFET" id="x_PER_CAFET" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_CAFET->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_CAFET->EditValue ?>"<?php echo $tabemp4_edit->PER_CAFET->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_CAFET->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->RET_CITE->Visible) { // RET_CITE ?>
	<div id="r_RET_CITE" class="form-group row">
		<label id="elh_tabemp4_RET_CITE" for="x_RET_CITE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->RET_CITE->caption() ?><?php echo $tabemp4_edit->RET_CITE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->RET_CITE->cellAttributes() ?>>
<span id="el_tabemp4_RET_CITE">
<input type="text" data-table="tabemp4" data-field="x_RET_CITE" name="x_RET_CITE" id="x_RET_CITE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->RET_CITE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->RET_CITE->EditValue ?>"<?php echo $tabemp4_edit->RET_CITE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->RET_CITE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_CITE->Visible) { // PER_CITE ?>
	<div id="r_PER_CITE" class="form-group row">
		<label id="elh_tabemp4_PER_CITE" for="x_PER_CITE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_CITE->caption() ?><?php echo $tabemp4_edit->PER_CITE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_CITE->cellAttributes() ?>>
<span id="el_tabemp4_PER_CITE">
<input type="text" data-table="tabemp4" data-field="x_PER_CITE" name="x_PER_CITE" id="x_PER_CITE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_CITE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_CITE->EditValue ?>"<?php echo $tabemp4_edit->PER_CITE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_CITE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->RET_AUTRE->Visible) { // RET_AUTRE ?>
	<div id="r_RET_AUTRE" class="form-group row">
		<label id="elh_tabemp4_RET_AUTRE" for="x_RET_AUTRE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->RET_AUTRE->caption() ?><?php echo $tabemp4_edit->RET_AUTRE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->RET_AUTRE->cellAttributes() ?>>
<span id="el_tabemp4_RET_AUTRE">
<input type="text" data-table="tabemp4" data-field="x_RET_AUTRE" name="x_RET_AUTRE" id="x_RET_AUTRE" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->RET_AUTRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->RET_AUTRE->EditValue ?>"<?php echo $tabemp4_edit->RET_AUTRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->RET_AUTRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->PER_AUTRE->Visible) { // PER_AUTRE ?>
	<div id="r_PER_AUTRE" class="form-group row">
		<label id="elh_tabemp4_PER_AUTRE" for="x_PER_AUTRE" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->PER_AUTRE->caption() ?><?php echo $tabemp4_edit->PER_AUTRE->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->PER_AUTRE->cellAttributes() ?>>
<span id="el_tabemp4_PER_AUTRE">
<input type="text" data-table="tabemp4" data-field="x_PER_AUTRE" name="x_PER_AUTRE" id="x_PER_AUTRE" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($tabemp4_edit->PER_AUTRE->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->PER_AUTRE->EditValue ?>"<?php echo $tabemp4_edit->PER_AUTRE->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->PER_AUTRE->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACQ_NB_CON->Visible) { // ACQ_NB_CON ?>
	<div id="r_ACQ_NB_CON" class="form-group row">
		<label id="elh_tabemp4_ACQ_NB_CON" for="x_ACQ_NB_CON" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACQ_NB_CON->caption() ?><?php echo $tabemp4_edit->ACQ_NB_CON->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACQ_NB_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACQ_NB_CON">
<input type="text" data-table="tabemp4" data-field="x_ACQ_NB_CON" name="x_ACQ_NB_CON" id="x_ACQ_NB_CON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACQ_NB_CON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACQ_NB_CON->EditValue ?>"<?php echo $tabemp4_edit->ACQ_NB_CON->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACQ_NB_CON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_MT_BRUT->Visible) { // ACC_MT_BRUT ?>
	<div id="r_ACC_MT_BRUT" class="form-group row">
		<label id="elh_tabemp4_ACC_MT_BRUT" for="x_ACC_MT_BRUT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_MT_BRUT->caption() ?><?php echo $tabemp4_edit->ACC_MT_BRUT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_MT_BRUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_BRUT">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_BRUT" name="x_ACC_MT_BRUT" id="x_ACC_MT_BRUT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_MT_BRUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_MT_BRUT->EditValue ?>"<?php echo $tabemp4_edit->ACC_MT_BRUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_MT_BRUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_CON->Visible) { // ACC_NB_CON ?>
	<div id="r_ACC_NB_CON" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_CON" for="x_ACC_NB_CON" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_CON->caption() ?><?php echo $tabemp4_edit->ACC_NB_CON->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_CON">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_CON" name="x_ACC_NB_CON" id="x_ACC_NB_CON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_CON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_CON->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_CON->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_CON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_PCON->Visible) { // ACC_NB_PCON ?>
	<div id="r_ACC_NB_PCON" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_PCON" for="x_ACC_NB_PCON" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_PCON->caption() ?><?php echo $tabemp4_edit->ACC_NB_PCON->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_PCON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_PCON">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_PCON" name="x_ACC_NB_PCON" id="x_ACC_NB_PCON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_PCON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_PCON->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_PCON->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_PCON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_MT_OVT->Visible) { // ACC_MT_OVT ?>
	<div id="r_ACC_MT_OVT" class="form-group row">
		<label id="elh_tabemp4_ACC_MT_OVT" for="x_ACC_MT_OVT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_MT_OVT->caption() ?><?php echo $tabemp4_edit->ACC_MT_OVT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_MT_OVT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_OVT">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_OVT" name="x_ACC_MT_OVT" id="x_ACC_MT_OVT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_MT_OVT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_MT_OVT->EditValue ?>"<?php echo $tabemp4_edit->ACC_MT_OVT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_MT_OVT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACQ_NB_MAL->Visible) { // ACQ_NB_MAL ?>
	<div id="r_ACQ_NB_MAL" class="form-group row">
		<label id="elh_tabemp4_ACQ_NB_MAL" for="x_ACQ_NB_MAL" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACQ_NB_MAL->caption() ?><?php echo $tabemp4_edit->ACQ_NB_MAL->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACQ_NB_MAL->cellAttributes() ?>>
<span id="el_tabemp4_ACQ_NB_MAL">
<input type="text" data-table="tabemp4" data-field="x_ACQ_NB_MAL" name="x_ACQ_NB_MAL" id="x_ACQ_NB_MAL" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACQ_NB_MAL->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACQ_NB_MAL->EditValue ?>"<?php echo $tabemp4_edit->ACQ_NB_MAL->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACQ_NB_MAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_MAL->Visible) { // ACC_NB_MAL ?>
	<div id="r_ACC_NB_MAL" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_MAL" for="x_ACC_NB_MAL" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_MAL->caption() ?><?php echo $tabemp4_edit->ACC_NB_MAL->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_MAL->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_MAL">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_MAL" name="x_ACC_NB_MAL" id="x_ACC_NB_MAL" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_MAL->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_MAL->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_MAL->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_MAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_MT_CON->Visible) { // ACC_MT_CON ?>
	<div id="r_ACC_MT_CON" class="form-group row">
		<label id="elh_tabemp4_ACC_MT_CON" for="x_ACC_MT_CON" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_MT_CON->caption() ?><?php echo $tabemp4_edit->ACC_MT_CON->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_MT_CON->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_CON">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_CON" name="x_ACC_MT_CON" id="x_ACC_MT_CON" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_MT_CON->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_MT_CON->EditValue ?>"<?php echo $tabemp4_edit->ACC_MT_CON->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_MT_CON->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_MAT->Visible) { // ACC_NB_MAT ?>
	<div id="r_ACC_NB_MAT" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_MAT" for="x_ACC_NB_MAT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_MAT->caption() ?><?php echo $tabemp4_edit->ACC_NB_MAT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_MAT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_MAT">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_MAT" name="x_ACC_NB_MAT" id="x_ACC_NB_MAT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_MAT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_MAT->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_MAT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_MAT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_MT_BONI->Visible) { // ACC_MT_BONI ?>
	<div id="r_ACC_MT_BONI" class="form-group row">
		<label id="elh_tabemp4_ACC_MT_BONI" for="x_ACC_MT_BONI" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_MT_BONI->caption() ?><?php echo $tabemp4_edit->ACC_MT_BONI->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_MT_BONI->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_BONI">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_BONI" name="x_ACC_MT_BONI" id="x_ACC_MT_BONI" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_MT_BONI->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_MT_BONI->EditValue ?>"<?php echo $tabemp4_edit->ACC_MT_BONI->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_MT_BONI->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_PER->Visible) { // ACC_NB_PER ?>
	<div id="r_ACC_NB_PER" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_PER" for="x_ACC_NB_PER" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_PER->caption() ?><?php echo $tabemp4_edit->ACC_NB_PER->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_PER->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_PER">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_PER" name="x_ACC_NB_PER" id="x_ACC_NB_PER" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_PER->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_PER->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_PER->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_PER->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_MT_AUT->Visible) { // ACC_MT_AUT ?>
	<div id="r_ACC_MT_AUT" class="form-group row">
		<label id="elh_tabemp4_ACC_MT_AUT" for="x_ACC_MT_AUT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_MT_AUT->caption() ?><?php echo $tabemp4_edit->ACC_MT_AUT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_MT_AUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_AUT">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_AUT" name="x_ACC_MT_AUT" id="x_ACC_MT_AUT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_MT_AUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_MT_AUT->EditValue ?>"<?php echo $tabemp4_edit->ACC_MT_AUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_MT_AUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_COM->Visible) { // ACC_NB_COM ?>
	<div id="r_ACC_NB_COM" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_COM" for="x_ACC_NB_COM" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_COM->caption() ?><?php echo $tabemp4_edit->ACC_NB_COM->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_COM->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_COM">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_COM" name="x_ACC_NB_COM" id="x_ACC_NB_COM" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_COM->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_COM->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_COM->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_COM->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_BAL_SAL->Visible) { // ACC_BAL_SAL ?>
	<div id="r_ACC_BAL_SAL" class="form-group row">
		<label id="elh_tabemp4_ACC_BAL_SAL" for="x_ACC_BAL_SAL" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_BAL_SAL->caption() ?><?php echo $tabemp4_edit->ACC_BAL_SAL->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_BAL_SAL->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_SAL">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_SAL" name="x_ACC_BAL_SAL" id="x_ACC_BAL_SAL" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_BAL_SAL->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_BAL_SAL->EditValue ?>"<?php echo $tabemp4_edit->ACC_BAL_SAL->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_BAL_SAL->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_BAL_BAN->Visible) { // ACC_BAL_BAN ?>
	<div id="r_ACC_BAL_BAN" class="form-group row">
		<label id="elh_tabemp4_ACC_BAL_BAN" for="x_ACC_BAL_BAN" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_BAL_BAN->caption() ?><?php echo $tabemp4_edit->ACC_BAL_BAN->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_BAL_BAN->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_BAN">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_BAN" name="x_ACC_BAL_BAN" id="x_ACC_BAL_BAN" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_BAL_BAN->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_BAL_BAN->EditValue ?>"<?php echo $tabemp4_edit->ACC_BAL_BAN->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_BAL_BAN->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_SUS->Visible) { // ACC_NB_SUS ?>
	<div id="r_ACC_NB_SUS" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_SUS" for="x_ACC_NB_SUS" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_SUS->caption() ?><?php echo $tabemp4_edit->ACC_NB_SUS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_SUS->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_SUS">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_SUS" name="x_ACC_NB_SUS" id="x_ACC_NB_SUS" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_SUS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_SUS->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_SUS->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_SUS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_BAL_ONA->Visible) { // ACC_BAL_ONA ?>
	<div id="r_ACC_BAL_ONA" class="form-group row">
		<label id="elh_tabemp4_ACC_BAL_ONA" for="x_ACC_BAL_ONA" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_BAL_ONA->caption() ?><?php echo $tabemp4_edit->ACC_BAL_ONA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_BAL_ONA->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_ONA">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_ONA" name="x_ACC_BAL_ONA" id="x_ACC_BAL_ONA" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_BAL_ONA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_BAL_ONA->EditValue ?>"<?php echo $tabemp4_edit->ACC_BAL_ONA->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_BAL_ONA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_BAL_PENSION->Visible) { // ACC_BAL_PENSION ?>
	<div id="r_ACC_BAL_PENSION" class="form-group row">
		<label id="elh_tabemp4_ACC_BAL_PENSION" for="x_ACC_BAL_PENSION" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_BAL_PENSION->caption() ?><?php echo $tabemp4_edit->ACC_BAL_PENSION->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_BAL_PENSION->cellAttributes() ?>>
<span id="el_tabemp4_ACC_BAL_PENSION">
<input type="text" data-table="tabemp4" data-field="x_ACC_BAL_PENSION" name="x_ACC_BAL_PENSION" id="x_ACC_BAL_PENSION" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_BAL_PENSION->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_BAL_PENSION->EditValue ?>"<?php echo $tabemp4_edit->ACC_BAL_PENSION->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_BAL_PENSION->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_ABS->Visible) { // ACC_NB_ABS ?>
	<div id="r_ACC_NB_ABS" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_ABS" for="x_ACC_NB_ABS" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_ABS->caption() ?><?php echo $tabemp4_edit->ACC_NB_ABS->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_ABS->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_ABS">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_ABS" name="x_ACC_NB_ABS" id="x_ACC_NB_ABS" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_ABS->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_ABS->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_ABS->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_ABS->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_MT_QZ->Visible) { // ACC_MT_QZ ?>
	<div id="r_ACC_MT_QZ" class="form-group row">
		<label id="elh_tabemp4_ACC_MT_QZ" for="x_ACC_MT_QZ" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_MT_QZ->caption() ?><?php echo $tabemp4_edit->ACC_MT_QZ->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_MT_QZ->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_QZ">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_QZ" name="x_ACC_MT_QZ" id="x_ACC_MT_QZ" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_MT_QZ->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_MT_QZ->EditValue ?>"<?php echo $tabemp4_edit->ACC_MT_QZ->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_MT_QZ->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_TRA->Visible) { // ACC_NB_TRA ?>
	<div id="r_ACC_NB_TRA" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_TRA" for="x_ACC_NB_TRA" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_TRA->caption() ?><?php echo $tabemp4_edit->ACC_NB_TRA->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_TRA->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_TRA">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_TRA" name="x_ACC_NB_TRA" id="x_ACC_NB_TRA" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_TRA->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_TRA->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_TRA->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_TRA->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_MT_AJST->Visible) { // ACC_MT_AJST ?>
	<div id="r_ACC_MT_AJST" class="form-group row">
		<label id="elh_tabemp4_ACC_MT_AJST" for="x_ACC_MT_AJST" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_MT_AJST->caption() ?><?php echo $tabemp4_edit->ACC_MT_AJST->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_MT_AJST->cellAttributes() ?>>
<span id="el_tabemp4_ACC_MT_AJST">
<input type="text" data-table="tabemp4" data-field="x_ACC_MT_AJST" name="x_ACC_MT_AJST" id="x_ACC_MT_AJST" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_MT_AJST->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_MT_AJST->EditValue ?>"<?php echo $tabemp4_edit->ACC_MT_AJST->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_MT_AJST->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_NB_TRA_ACT->Visible) { // ACC_NB_TRA_ACT ?>
	<div id="r_ACC_NB_TRA_ACT" class="form-group row">
		<label id="elh_tabemp4_ACC_NB_TRA_ACT" for="x_ACC_NB_TRA_ACT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_NB_TRA_ACT->caption() ?><?php echo $tabemp4_edit->ACC_NB_TRA_ACT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_NB_TRA_ACT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_NB_TRA_ACT">
<input type="text" data-table="tabemp4" data-field="x_ACC_NB_TRA_ACT" name="x_ACC_NB_TRA_ACT" id="x_ACC_NB_TRA_ACT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_NB_TRA_ACT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_NB_TRA_ACT->EditValue ?>"<?php echo $tabemp4_edit->ACC_NB_TRA_ACT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_NB_TRA_ACT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC1_MT_BRUT->Visible) { // ACC1_MT_BRUT ?>
	<div id="r_ACC1_MT_BRUT" class="form-group row">
		<label id="elh_tabemp4_ACC1_MT_BRUT" for="x_ACC1_MT_BRUT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC1_MT_BRUT->caption() ?><?php echo $tabemp4_edit->ACC1_MT_BRUT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC1_MT_BRUT->cellAttributes() ?>>
<span id="el_tabemp4_ACC1_MT_BRUT">
<input type="text" data-table="tabemp4" data-field="x_ACC1_MT_BRUT" name="x_ACC1_MT_BRUT" id="x_ACC1_MT_BRUT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC1_MT_BRUT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC1_MT_BRUT->EditValue ?>"<?php echo $tabemp4_edit->ACC1_MT_BRUT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC1_MT_BRUT->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tabemp4_edit->ACC_RENDEMENT->Visible) { // ACC_RENDEMENT ?>
	<div id="r_ACC_RENDEMENT" class="form-group row">
		<label id="elh_tabemp4_ACC_RENDEMENT" for="x_ACC_RENDEMENT" class="<?php echo $tabemp4_edit->LeftColumnClass ?>"><?php echo $tabemp4_edit->ACC_RENDEMENT->caption() ?><?php echo $tabemp4_edit->ACC_RENDEMENT->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tabemp4_edit->RightColumnClass ?>"><div <?php echo $tabemp4_edit->ACC_RENDEMENT->cellAttributes() ?>>
<span id="el_tabemp4_ACC_RENDEMENT">
<input type="text" data-table="tabemp4" data-field="x_ACC_RENDEMENT" name="x_ACC_RENDEMENT" id="x_ACC_RENDEMENT" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($tabemp4_edit->ACC_RENDEMENT->getPlaceHolder()) ?>" value="<?php echo $tabemp4_edit->ACC_RENDEMENT->EditValue ?>"<?php echo $tabemp4_edit->ACC_RENDEMENT->editAttributes() ?>>
</span>
<?php echo $tabemp4_edit->ACC_RENDEMENT->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$tabemp4_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tabemp4_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tabemp4_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tabemp4_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$tabemp4_edit->terminate();
?>