<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$status_view = new status_view();

// Run the page
$status_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$status_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$status_view->isExport()) { ?>
<script>
var fstatusview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fstatusview = currentForm = new ew.Form("fstatusview", "view");
	loadjs.done("fstatusview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$status_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $status_view->ExportOptions->render("body") ?>
<?php $status_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $status_view->showPageHeader(); ?>
<?php
$status_view->showMessage();
?>
<?php if (!$status_view->IsModal) { ?>
<?php if (!$status_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $status_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fstatusview" id="fstatusview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="status">
<input type="hidden" name="modal" value="<?php echo (int)$status_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($status_view->idstatus->Visible) { // idstatus ?>
	<tr id="r_idstatus">
		<td class="<?php echo $status_view->TableLeftColumnClass ?>"><span id="elh_status_idstatus"><?php echo $status_view->idstatus->caption() ?></span></td>
		<td data-name="idstatus" <?php echo $status_view->idstatus->cellAttributes() ?>>
<span id="el_status_idstatus">
<span<?php echo $status_view->idstatus->viewAttributes() ?>><?php echo $status_view->idstatus->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($status_view->ident->Visible) { // ident ?>
	<tr id="r_ident">
		<td class="<?php echo $status_view->TableLeftColumnClass ?>"><span id="elh_status_ident"><?php echo $status_view->ident->caption() ?></span></td>
		<td data-name="ident" <?php echo $status_view->ident->cellAttributes() ?>>
<span id="el_status_ident">
<span<?php echo $status_view->ident->viewAttributes() ?>><?php echo $status_view->ident->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($status_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $status_view->TableLeftColumnClass ?>"><span id="elh_status_descrip"><?php echo $status_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $status_view->descrip->cellAttributes() ?>>
<span id="el_status_descrip">
<span<?php echo $status_view->descrip->viewAttributes() ?>><?php echo $status_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$status_view->IsModal) { ?>
<?php if (!$status_view->isExport()) { ?>
<?php echo $status_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$status_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$status_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$status_view->terminate();
?>