<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$status_list = new status_list();

// Run the page
$status_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$status_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$status_list->isExport()) { ?>
<script>
var fstatuslist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fstatuslist = currentForm = new ew.Form("fstatuslist", "list");
	fstatuslist.formKeyCountName = '<?php echo $status_list->FormKeyCountName ?>';
	loadjs.done("fstatuslist");
});
var fstatuslistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fstatuslistsrch = currentSearchForm = new ew.Form("fstatuslistsrch");

	// Dynamic selection lists
	// Filters

	fstatuslistsrch.filterList = <?php echo $status_list->getFilterList() ?>;
	loadjs.done("fstatuslistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$status_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($status_list->TotalRecords > 0 && $status_list->ExportOptions->visible()) { ?>
<?php $status_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($status_list->ImportOptions->visible()) { ?>
<?php $status_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($status_list->SearchOptions->visible()) { ?>
<?php $status_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($status_list->FilterOptions->visible()) { ?>
<?php $status_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$status_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$status_list->isExport() && !$status->CurrentAction) { ?>
<form name="fstatuslistsrch" id="fstatuslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fstatuslistsrch-search-panel" class="<?php echo $status_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="status">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $status_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($status_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($status_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $status_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($status_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $status_list->showPageHeader(); ?>
<?php
$status_list->showMessage();
?>
<?php if ($status_list->TotalRecords > 0 || $status->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($status_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> status">
<?php if (!$status_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$status_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $status_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fstatuslist" id="fstatuslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="status">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_status" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($status_list->TotalRecords > 0 || $status_list->isGridEdit()) { ?>
<table id="tbl_statuslist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$status->RowType = ROWTYPE_HEADER;

// Render list options
$status_list->renderListOptions();

// Render list options (header, left)
$status_list->ListOptions->render("header", "left");
?>
<?php if ($status_list->idstatus->Visible) { // idstatus ?>
	<?php if ($status_list->SortUrl($status_list->idstatus) == "") { ?>
		<th data-name="idstatus" class="<?php echo $status_list->idstatus->headerCellClass() ?>"><div id="elh_status_idstatus" class="status_idstatus"><div class="ew-table-header-caption"><?php echo $status_list->idstatus->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idstatus" class="<?php echo $status_list->idstatus->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $status_list->SortUrl($status_list->idstatus) ?>', 1);"><div id="elh_status_idstatus" class="status_idstatus">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status_list->idstatus->caption() ?></span><span class="ew-table-header-sort"><?php if ($status_list->idstatus->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($status_list->idstatus->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($status_list->ident->Visible) { // ident ?>
	<?php if ($status_list->SortUrl($status_list->ident) == "") { ?>
		<th data-name="ident" class="<?php echo $status_list->ident->headerCellClass() ?>"><div id="elh_status_ident" class="status_ident"><div class="ew-table-header-caption"><?php echo $status_list->ident->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ident" class="<?php echo $status_list->ident->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $status_list->SortUrl($status_list->ident) ?>', 1);"><div id="elh_status_ident" class="status_ident">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status_list->ident->caption() ?></span><span class="ew-table-header-sort"><?php if ($status_list->ident->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($status_list->ident->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($status_list->descrip->Visible) { // descrip ?>
	<?php if ($status_list->SortUrl($status_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $status_list->descrip->headerCellClass() ?>"><div id="elh_status_descrip" class="status_descrip"><div class="ew-table-header-caption"><?php echo $status_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $status_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $status_list->SortUrl($status_list->descrip) ?>', 1);"><div id="elh_status_descrip" class="status_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $status_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($status_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($status_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$status_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($status_list->ExportAll && $status_list->isExport()) {
	$status_list->StopRecord = $status_list->TotalRecords;
} else {

	// Set the last record to display
	if ($status_list->TotalRecords > $status_list->StartRecord + $status_list->DisplayRecords - 1)
		$status_list->StopRecord = $status_list->StartRecord + $status_list->DisplayRecords - 1;
	else
		$status_list->StopRecord = $status_list->TotalRecords;
}
$status_list->RecordCount = $status_list->StartRecord - 1;
if ($status_list->Recordset && !$status_list->Recordset->EOF) {
	$status_list->Recordset->moveFirst();
	$selectLimit = $status_list->UseSelectLimit;
	if (!$selectLimit && $status_list->StartRecord > 1)
		$status_list->Recordset->move($status_list->StartRecord - 1);
} elseif (!$status->AllowAddDeleteRow && $status_list->StopRecord == 0) {
	$status_list->StopRecord = $status->GridAddRowCount;
}

// Initialize aggregate
$status->RowType = ROWTYPE_AGGREGATEINIT;
$status->resetAttributes();
$status_list->renderRow();
while ($status_list->RecordCount < $status_list->StopRecord) {
	$status_list->RecordCount++;
	if ($status_list->RecordCount >= $status_list->StartRecord) {
		$status_list->RowCount++;

		// Set up key count
		$status_list->KeyCount = $status_list->RowIndex;

		// Init row class and style
		$status->resetAttributes();
		$status->CssClass = "";
		if ($status_list->isGridAdd()) {
		} else {
			$status_list->loadRowValues($status_list->Recordset); // Load row values
		}
		$status->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$status->RowAttrs->merge(["data-rowindex" => $status_list->RowCount, "id" => "r" . $status_list->RowCount . "_status", "data-rowtype" => $status->RowType]);

		// Render row
		$status_list->renderRow();

		// Render list options
		$status_list->renderListOptions();
?>
	<tr <?php echo $status->rowAttributes() ?>>
<?php

// Render list options (body, left)
$status_list->ListOptions->render("body", "left", $status_list->RowCount);
?>
	<?php if ($status_list->idstatus->Visible) { // idstatus ?>
		<td data-name="idstatus" <?php echo $status_list->idstatus->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCount ?>_status_idstatus">
<span<?php echo $status_list->idstatus->viewAttributes() ?>><?php echo $status_list->idstatus->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($status_list->ident->Visible) { // ident ?>
		<td data-name="ident" <?php echo $status_list->ident->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCount ?>_status_ident">
<span<?php echo $status_list->ident->viewAttributes() ?>><?php echo $status_list->ident->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($status_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $status_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $status_list->RowCount ?>_status_descrip">
<span<?php echo $status_list->descrip->viewAttributes() ?>><?php echo $status_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$status_list->ListOptions->render("body", "right", $status_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$status_list->isGridAdd())
		$status_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$status->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($status_list->Recordset)
	$status_list->Recordset->Close();
?>
<?php if (!$status_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$status_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $status_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $status_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($status_list->TotalRecords == 0 && !$status->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$status_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$status_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$status_list->terminate();
?>