<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$status_edit = new status_edit();

// Run the page
$status_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$status_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fstatusedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fstatusedit = currentForm = new ew.Form("fstatusedit", "edit");

	// Validate form
	fstatusedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($status_edit->idstatus->Required) { ?>
				elm = this.getElements("x" + infix + "_idstatus");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status_edit->idstatus->caption(), $status_edit->idstatus->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($status_edit->ident->Required) { ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status_edit->ident->caption(), $status_edit->ident->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($status_edit->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $status_edit->descrip->caption(), $status_edit->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fstatusedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fstatusedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fstatusedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $status_edit->showPageHeader(); ?>
<?php
$status_edit->showMessage();
?>
<form name="fstatusedit" id="fstatusedit" class="<?php echo $status_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="status">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$status_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($status_edit->idstatus->Visible) { // idstatus ?>
	<div id="r_idstatus" class="form-group row">
		<label id="elh_status_idstatus" class="<?php echo $status_edit->LeftColumnClass ?>"><?php echo $status_edit->idstatus->caption() ?><?php echo $status_edit->idstatus->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $status_edit->RightColumnClass ?>"><div <?php echo $status_edit->idstatus->cellAttributes() ?>>
<span id="el_status_idstatus">
<span<?php echo $status_edit->idstatus->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($status_edit->idstatus->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="status" data-field="x_idstatus" name="x_idstatus" id="x_idstatus" value="<?php echo HtmlEncode($status_edit->idstatus->CurrentValue) ?>">
<?php echo $status_edit->idstatus->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($status_edit->ident->Visible) { // ident ?>
	<div id="r_ident" class="form-group row">
		<label id="elh_status_ident" for="x_ident" class="<?php echo $status_edit->LeftColumnClass ?>"><?php echo $status_edit->ident->caption() ?><?php echo $status_edit->ident->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $status_edit->RightColumnClass ?>"><div <?php echo $status_edit->ident->cellAttributes() ?>>
<span id="el_status_ident">
<input type="text" data-table="status" data-field="x_ident" name="x_ident" id="x_ident" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($status_edit->ident->getPlaceHolder()) ?>" value="<?php echo $status_edit->ident->EditValue ?>"<?php echo $status_edit->ident->editAttributes() ?>>
</span>
<?php echo $status_edit->ident->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($status_edit->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_status_descrip" for="x_descrip" class="<?php echo $status_edit->LeftColumnClass ?>"><?php echo $status_edit->descrip->caption() ?><?php echo $status_edit->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $status_edit->RightColumnClass ?>"><div <?php echo $status_edit->descrip->cellAttributes() ?>>
<span id="el_status_descrip">
<input type="text" data-table="status" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($status_edit->descrip->getPlaceHolder()) ?>" value="<?php echo $status_edit->descrip->EditValue ?>"<?php echo $status_edit->descrip->editAttributes() ?>>
</span>
<?php echo $status_edit->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$status_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $status_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $status_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$status_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$status_edit->terminate();
?>