<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$section_view = new section_view();

// Run the page
$section_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$section_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$section_view->isExport()) { ?>
<script>
var fsectionview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fsectionview = currentForm = new ew.Form("fsectionview", "view");
	loadjs.done("fsectionview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$section_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $section_view->ExportOptions->render("body") ?>
<?php $section_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $section_view->showPageHeader(); ?>
<?php
$section_view->showMessage();
?>
<?php if (!$section_view->IsModal) { ?>
<?php if (!$section_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $section_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fsectionview" id="fsectionview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="section">
<input type="hidden" name="modal" value="<?php echo (int)$section_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($section_view->idsect->Visible) { // idsect ?>
	<tr id="r_idsect">
		<td class="<?php echo $section_view->TableLeftColumnClass ?>"><span id="elh_section_idsect"><?php echo $section_view->idsect->caption() ?></span></td>
		<td data-name="idsect" <?php echo $section_view->idsect->cellAttributes() ?>>
<span id="el_section_idsect">
<span<?php echo $section_view->idsect->viewAttributes() ?>><?php echo $section_view->idsect->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($section_view->ident->Visible) { // ident ?>
	<tr id="r_ident">
		<td class="<?php echo $section_view->TableLeftColumnClass ?>"><span id="elh_section_ident"><?php echo $section_view->ident->caption() ?></span></td>
		<td data-name="ident" <?php echo $section_view->ident->cellAttributes() ?>>
<span id="el_section_ident">
<span<?php echo $section_view->ident->viewAttributes() ?>><?php echo $section_view->ident->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($section_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $section_view->TableLeftColumnClass ?>"><span id="elh_section_descrip"><?php echo $section_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $section_view->descrip->cellAttributes() ?>>
<span id="el_section_descrip">
<span<?php echo $section_view->descrip->viewAttributes() ?>><?php echo $section_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$section_view->IsModal) { ?>
<?php if (!$section_view->isExport()) { ?>
<?php echo $section_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$section_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$section_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$section_view->terminate();
?>