<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$section_list = new section_list();

// Run the page
$section_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$section_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$section_list->isExport()) { ?>
<script>
var fsectionlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fsectionlist = currentForm = new ew.Form("fsectionlist", "list");
	fsectionlist.formKeyCountName = '<?php echo $section_list->FormKeyCountName ?>';
	loadjs.done("fsectionlist");
});
var fsectionlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fsectionlistsrch = currentSearchForm = new ew.Form("fsectionlistsrch");

	// Dynamic selection lists
	// Filters

	fsectionlistsrch.filterList = <?php echo $section_list->getFilterList() ?>;
	loadjs.done("fsectionlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$section_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($section_list->TotalRecords > 0 && $section_list->ExportOptions->visible()) { ?>
<?php $section_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($section_list->ImportOptions->visible()) { ?>
<?php $section_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($section_list->SearchOptions->visible()) { ?>
<?php $section_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($section_list->FilterOptions->visible()) { ?>
<?php $section_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$section_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$section_list->isExport() && !$section->CurrentAction) { ?>
<form name="fsectionlistsrch" id="fsectionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fsectionlistsrch-search-panel" class="<?php echo $section_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="section">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $section_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($section_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($section_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $section_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($section_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($section_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($section_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($section_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $section_list->showPageHeader(); ?>
<?php
$section_list->showMessage();
?>
<?php if ($section_list->TotalRecords > 0 || $section->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($section_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> section">
<?php if (!$section_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$section_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $section_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $section_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsectionlist" id="fsectionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="section">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_section" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($section_list->TotalRecords > 0 || $section_list->isGridEdit()) { ?>
<table id="tbl_sectionlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$section->RowType = ROWTYPE_HEADER;

// Render list options
$section_list->renderListOptions();

// Render list options (header, left)
$section_list->ListOptions->render("header", "left");
?>
<?php if ($section_list->idsect->Visible) { // idsect ?>
	<?php if ($section_list->SortUrl($section_list->idsect) == "") { ?>
		<th data-name="idsect" class="<?php echo $section_list->idsect->headerCellClass() ?>"><div id="elh_section_idsect" class="section_idsect"><div class="ew-table-header-caption"><?php echo $section_list->idsect->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idsect" class="<?php echo $section_list->idsect->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $section_list->SortUrl($section_list->idsect) ?>', 1);"><div id="elh_section_idsect" class="section_idsect">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $section_list->idsect->caption() ?></span><span class="ew-table-header-sort"><?php if ($section_list->idsect->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($section_list->idsect->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($section_list->ident->Visible) { // ident ?>
	<?php if ($section_list->SortUrl($section_list->ident) == "") { ?>
		<th data-name="ident" class="<?php echo $section_list->ident->headerCellClass() ?>"><div id="elh_section_ident" class="section_ident"><div class="ew-table-header-caption"><?php echo $section_list->ident->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ident" class="<?php echo $section_list->ident->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $section_list->SortUrl($section_list->ident) ?>', 1);"><div id="elh_section_ident" class="section_ident">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $section_list->ident->caption() ?></span><span class="ew-table-header-sort"><?php if ($section_list->ident->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($section_list->ident->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($section_list->descrip->Visible) { // descrip ?>
	<?php if ($section_list->SortUrl($section_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $section_list->descrip->headerCellClass() ?>"><div id="elh_section_descrip" class="section_descrip"><div class="ew-table-header-caption"><?php echo $section_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $section_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $section_list->SortUrl($section_list->descrip) ?>', 1);"><div id="elh_section_descrip" class="section_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $section_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($section_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($section_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$section_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($section_list->ExportAll && $section_list->isExport()) {
	$section_list->StopRecord = $section_list->TotalRecords;
} else {

	// Set the last record to display
	if ($section_list->TotalRecords > $section_list->StartRecord + $section_list->DisplayRecords - 1)
		$section_list->StopRecord = $section_list->StartRecord + $section_list->DisplayRecords - 1;
	else
		$section_list->StopRecord = $section_list->TotalRecords;
}
$section_list->RecordCount = $section_list->StartRecord - 1;
if ($section_list->Recordset && !$section_list->Recordset->EOF) {
	$section_list->Recordset->moveFirst();
	$selectLimit = $section_list->UseSelectLimit;
	if (!$selectLimit && $section_list->StartRecord > 1)
		$section_list->Recordset->move($section_list->StartRecord - 1);
} elseif (!$section->AllowAddDeleteRow && $section_list->StopRecord == 0) {
	$section_list->StopRecord = $section->GridAddRowCount;
}

// Initialize aggregate
$section->RowType = ROWTYPE_AGGREGATEINIT;
$section->resetAttributes();
$section_list->renderRow();
while ($section_list->RecordCount < $section_list->StopRecord) {
	$section_list->RecordCount++;
	if ($section_list->RecordCount >= $section_list->StartRecord) {
		$section_list->RowCount++;

		// Set up key count
		$section_list->KeyCount = $section_list->RowIndex;

		// Init row class and style
		$section->resetAttributes();
		$section->CssClass = "";
		if ($section_list->isGridAdd()) {
		} else {
			$section_list->loadRowValues($section_list->Recordset); // Load row values
		}
		$section->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$section->RowAttrs->merge(["data-rowindex" => $section_list->RowCount, "id" => "r" . $section_list->RowCount . "_section", "data-rowtype" => $section->RowType]);

		// Render row
		$section_list->renderRow();

		// Render list options
		$section_list->renderListOptions();
?>
	<tr <?php echo $section->rowAttributes() ?>>
<?php

// Render list options (body, left)
$section_list->ListOptions->render("body", "left", $section_list->RowCount);
?>
	<?php if ($section_list->idsect->Visible) { // idsect ?>
		<td data-name="idsect" <?php echo $section_list->idsect->cellAttributes() ?>>
<span id="el<?php echo $section_list->RowCount ?>_section_idsect">
<span<?php echo $section_list->idsect->viewAttributes() ?>><?php echo $section_list->idsect->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($section_list->ident->Visible) { // ident ?>
		<td data-name="ident" <?php echo $section_list->ident->cellAttributes() ?>>
<span id="el<?php echo $section_list->RowCount ?>_section_ident">
<span<?php echo $section_list->ident->viewAttributes() ?>><?php echo $section_list->ident->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($section_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $section_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $section_list->RowCount ?>_section_descrip">
<span<?php echo $section_list->descrip->viewAttributes() ?>><?php echo $section_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$section_list->ListOptions->render("body", "right", $section_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$section_list->isGridAdd())
		$section_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$section->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($section_list->Recordset)
	$section_list->Recordset->Close();
?>
<?php if (!$section_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$section_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $section_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $section_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($section_list->TotalRecords == 0 && !$section->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $section_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$section_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$section_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$section_list->terminate();
?>