<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$section_edit = new section_edit();

// Run the page
$section_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$section_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fsectionedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fsectionedit = currentForm = new ew.Form("fsectionedit", "edit");

	// Validate form
	fsectionedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($section_edit->idsect->Required) { ?>
				elm = this.getElements("x" + infix + "_idsect");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $section_edit->idsect->caption(), $section_edit->idsect->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($section_edit->ident->Required) { ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $section_edit->ident->caption(), $section_edit->ident->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($section_edit->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $section_edit->descrip->caption(), $section_edit->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fsectionedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fsectionedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fsectionedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $section_edit->showPageHeader(); ?>
<?php
$section_edit->showMessage();
?>
<form name="fsectionedit" id="fsectionedit" class="<?php echo $section_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="section">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$section_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($section_edit->idsect->Visible) { // idsect ?>
	<div id="r_idsect" class="form-group row">
		<label id="elh_section_idsect" class="<?php echo $section_edit->LeftColumnClass ?>"><?php echo $section_edit->idsect->caption() ?><?php echo $section_edit->idsect->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $section_edit->RightColumnClass ?>"><div <?php echo $section_edit->idsect->cellAttributes() ?>>
<span id="el_section_idsect">
<span<?php echo $section_edit->idsect->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($section_edit->idsect->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="section" data-field="x_idsect" name="x_idsect" id="x_idsect" value="<?php echo HtmlEncode($section_edit->idsect->CurrentValue) ?>">
<?php echo $section_edit->idsect->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($section_edit->ident->Visible) { // ident ?>
	<div id="r_ident" class="form-group row">
		<label id="elh_section_ident" for="x_ident" class="<?php echo $section_edit->LeftColumnClass ?>"><?php echo $section_edit->ident->caption() ?><?php echo $section_edit->ident->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $section_edit->RightColumnClass ?>"><div <?php echo $section_edit->ident->cellAttributes() ?>>
<span id="el_section_ident">
<input type="text" data-table="section" data-field="x_ident" name="x_ident" id="x_ident" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($section_edit->ident->getPlaceHolder()) ?>" value="<?php echo $section_edit->ident->EditValue ?>"<?php echo $section_edit->ident->editAttributes() ?>>
</span>
<?php echo $section_edit->ident->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($section_edit->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_section_descrip" for="x_descrip" class="<?php echo $section_edit->LeftColumnClass ?>"><?php echo $section_edit->descrip->caption() ?><?php echo $section_edit->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $section_edit->RightColumnClass ?>"><div <?php echo $section_edit->descrip->cellAttributes() ?>>
<span id="el_section_descrip">
<input type="text" data-table="section" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($section_edit->descrip->getPlaceHolder()) ?>" value="<?php echo $section_edit->descrip->EditValue ?>"<?php echo $section_edit->descrip->editAttributes() ?>>
</span>
<?php echo $section_edit->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$section_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $section_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $section_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$section_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$section_edit->terminate();
?>