<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$section_delete = new section_delete();

// Run the page
$section_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$section_delete->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fsectiondelete, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "delete";
	fsectiondelete = currentForm = new ew.Form("fsectiondelete", "delete");
	loadjs.done("fsectiondelete");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $section_delete->showPageHeader(); ?>
<?php
$section_delete->showMessage();
?>
<form name="fsectiondelete" id="fsectiondelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="section">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($section_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($section_delete->idsect->Visible) { // idsect ?>
		<th class="<?php echo $section_delete->idsect->headerCellClass() ?>"><span id="elh_section_idsect" class="section_idsect"><?php echo $section_delete->idsect->caption() ?></span></th>
<?php } ?>
<?php if ($section_delete->ident->Visible) { // ident ?>
		<th class="<?php echo $section_delete->ident->headerCellClass() ?>"><span id="elh_section_ident" class="section_ident"><?php echo $section_delete->ident->caption() ?></span></th>
<?php } ?>
<?php if ($section_delete->descrip->Visible) { // descrip ?>
		<th class="<?php echo $section_delete->descrip->headerCellClass() ?>"><span id="elh_section_descrip" class="section_descrip"><?php echo $section_delete->descrip->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$section_delete->RecordCount = 0;
$i = 0;
while (!$section_delete->Recordset->EOF) {
	$section_delete->RecordCount++;
	$section_delete->RowCount++;

	// Set row properties
	$section->resetAttributes();
	$section->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$section_delete->loadRowValues($section_delete->Recordset);

	// Render row
	$section_delete->renderRow();
?>
	<tr <?php echo $section->rowAttributes() ?>>
<?php if ($section_delete->idsect->Visible) { // idsect ?>
		<td <?php echo $section_delete->idsect->cellAttributes() ?>>
<span id="el<?php echo $section_delete->RowCount ?>_section_idsect" class="section_idsect">
<span<?php echo $section_delete->idsect->viewAttributes() ?>><?php echo $section_delete->idsect->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($section_delete->ident->Visible) { // ident ?>
		<td <?php echo $section_delete->ident->cellAttributes() ?>>
<span id="el<?php echo $section_delete->RowCount ?>_section_ident" class="section_ident">
<span<?php echo $section_delete->ident->viewAttributes() ?>><?php echo $section_delete->ident->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($section_delete->descrip->Visible) { // descrip ?>
		<td <?php echo $section_delete->descrip->cellAttributes() ?>>
<span id="el<?php echo $section_delete->RowCount ?>_section_descrip" class="section_descrip">
<span<?php echo $section_delete->descrip->viewAttributes() ?>><?php echo $section_delete->descrip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$section_delete->Recordset->moveNext();
}
$section_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $section_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$section_delete->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$section_delete->terminate();
?>