<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_view = new production_view();

// Run the page
$production_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$production_view->isExport()) { ?>
<script>
var fproductionview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fproductionview = currentForm = new ew.Form("fproductionview", "view");
	loadjs.done("fproductionview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$production_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $production_view->ExportOptions->render("body") ?>
<?php $production_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $production_view->showPageHeader(); ?>
<?php
$production_view->showMessage();
?>
<?php if (!$production_view->IsModal) { ?>
<?php if (!$production_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $production_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fproductionview" id="fproductionview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production">
<input type="hidden" name="modal" value="<?php echo (int)$production_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($production_view->idprod->Visible) { // idprod ?>
	<tr id="r_idprod">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_idprod"><?php echo $production_view->idprod->caption() ?></span></td>
		<td data-name="idprod" <?php echo $production_view->idprod->cellAttributes() ?>>
<span id="el_production_idprod">
<span<?php echo $production_view->idprod->viewAttributes() ?>><?php echo $production_view->idprod->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->idemp->Visible) { // idemp ?>
	<tr id="r_idemp">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_idemp"><?php echo $production_view->idemp->caption() ?></span></td>
		<td data-name="idemp" <?php echo $production_view->idemp->cellAttributes() ?>>
<span id="el_production_idemp">
<span<?php echo $production_view->idemp->viewAttributes() ?>><?php echo $production_view->idemp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->dept->Visible) { // dept ?>
	<tr id="r_dept">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_dept"><?php echo $production_view->dept->caption() ?></span></td>
		<td data-name="dept" <?php echo $production_view->dept->cellAttributes() ?>>
<span id="el_production_dept">
<span<?php echo $production_view->dept->viewAttributes() ?>><?php echo $production_view->dept->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_type"><?php echo $production_view->type->caption() ?></span></td>
		<td data-name="type" <?php echo $production_view->type->cellAttributes() ?>>
<span id="el_production_type">
<span<?php echo $production_view->type->viewAttributes() ?>><?php echo $production_view->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->idop->Visible) { // idop ?>
	<tr id="r_idop">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_idop"><?php echo $production_view->idop->caption() ?></span></td>
		<td data-name="idop" <?php echo $production_view->idop->cellAttributes() ?>>
<span id="el_production_idop">
<span<?php echo $production_view->idop->viewAttributes() ?>><?php echo $production_view->idop->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->lot->Visible) { // lot ?>
	<tr id="r_lot">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_lot"><?php echo $production_view->lot->caption() ?></span></td>
		<td data-name="lot" <?php echo $production_view->lot->cellAttributes() ?>>
<span id="el_production_lot">
<span<?php echo $production_view->lot->viewAttributes() ?>><?php echo $production_view->lot->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->dateprod->Visible) { // dateprod ?>
	<tr id="r_dateprod">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_dateprod"><?php echo $production_view->dateprod->caption() ?></span></td>
		<td data-name="dateprod" <?php echo $production_view->dateprod->cellAttributes() ?>>
<span id="el_production_dateprod">
<span<?php echo $production_view->dateprod->viewAttributes() ?>><?php echo $production_view->dateprod->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->qtyprod->Visible) { // qtyprod ?>
	<tr id="r_qtyprod">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_qtyprod"><?php echo $production_view->qtyprod->caption() ?></span></td>
		<td data-name="qtyprod" <?php echo $production_view->qtyprod->cellAttributes() ?>>
<span id="el_production_qtyprod">
<span<?php echo $production_view->qtyprod->viewAttributes() ?>><?php echo $production_view->qtyprod->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->tauxprod->Visible) { // tauxprod ?>
	<tr id="r_tauxprod">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_tauxprod"><?php echo $production_view->tauxprod->caption() ?></span></td>
		<td data-name="tauxprod" <?php echo $production_view->tauxprod->cellAttributes() ?>>
<span id="el_production_tauxprod">
<span<?php echo $production_view->tauxprod->viewAttributes() ?>><?php echo $production_view->tauxprod->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($production_view->SubTotal->Visible) { // SubTotal ?>
	<tr id="r_SubTotal">
		<td class="<?php echo $production_view->TableLeftColumnClass ?>"><span id="elh_production_SubTotal"><?php echo $production_view->SubTotal->caption() ?></span></td>
		<td data-name="SubTotal" <?php echo $production_view->SubTotal->cellAttributes() ?>>
<span id="el_production_SubTotal">
<span<?php echo $production_view->SubTotal->viewAttributes() ?>><?php echo $production_view->SubTotal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$production_view->IsModal) { ?>
<?php if (!$production_view->isExport()) { ?>
<?php echo $production_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$production_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$production_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$production_view->terminate();
?>