<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_list = new production_list();

// Run the page
$production_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$production_list->isExport()) { ?>
<script>
var fproductionlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fproductionlist = currentForm = new ew.Form("fproductionlist", "list");
	fproductionlist.formKeyCountName = '<?php echo $production_list->FormKeyCountName ?>';
	loadjs.done("fproductionlist");
});
var fproductionlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fproductionlistsrch = currentSearchForm = new ew.Form("fproductionlistsrch");

	// Validate function for search
	fproductionlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_dateprod");
		if (elm && !ew.checkEuroDate(elm.value))
			return this.onError(elm, "<?php echo JsEncode($production_list->dateprod->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fproductionlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fproductionlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fproductionlistsrch.lists["x_idemp"] = <?php echo $production_list->idemp->Lookup->toClientList($production_list) ?>;
	fproductionlistsrch.lists["x_idemp"].options = <?php echo JsonEncode($production_list->idemp->lookupOptions()) ?>;

	// Filters
	fproductionlistsrch.filterList = <?php echo $production_list->getFilterList() ?>;
	loadjs.done("fproductionlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$production_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($production_list->TotalRecords > 0 && $production_list->ExportOptions->visible()) { ?>
<?php $production_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($production_list->ImportOptions->visible()) { ?>
<?php $production_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($production_list->SearchOptions->visible()) { ?>
<?php $production_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($production_list->FilterOptions->visible()) { ?>
<?php $production_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$production_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$production_list->isExport() && !$production->CurrentAction) { ?>
<form name="fproductionlistsrch" id="fproductionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fproductionlistsrch-search-panel" class="<?php echo $production_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="production">
	<div class="ew-extended-search">
<?php

// Render search row
$production->RowType = ROWTYPE_SEARCH;
$production->resetAttributes();
$production_list->renderRow();
?>
<?php if ($production_list->idemp->Visible) { // idemp ?>
	<?php
		$production_list->SearchColumnCount++;
		if (($production_list->SearchColumnCount - 1) % $production_list->SearchFieldsPerRow == 0) {
			$production_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $production_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_idemp" class="ew-cell form-group">
		<label for="x_idemp" class="ew-search-caption ew-label"><?php echo $production_list->idemp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("=") ?>
<input type="hidden" name="z_idemp" id="z_idemp" value="=">
</span>
		<span id="el_production_idemp" class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($production_list->idemp->AdvancedSearch->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_list->idemp->AdvancedSearch->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_list->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_list->idemp->ReadOnly || $production_list->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_list->idemp->Lookup->getParamTag($production_list, "p_x_idemp") ?>
<input type="hidden" data-table="production" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_list->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $production_list->idemp->AdvancedSearch->SearchValue ?>"<?php echo $production_list->idemp->editAttributes() ?>>
</span>
	</div>
	<?php if ($production_list->SearchColumnCount % $production_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($production_list->dateprod->Visible) { // dateprod ?>
	<?php
		$production_list->SearchColumnCount++;
		if (($production_list->SearchColumnCount - 1) % $production_list->SearchFieldsPerRow == 0) {
			$production_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $production_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_dateprod" class="ew-cell form-group">
		<label for="x_dateprod" class="ew-search-caption ew-label"><?php echo $production_list->dateprod->caption() ?></label>
		<span class="ew-search-operator">
<select name="z_dateprod" id="z_dateprod" class="custom-select" onchange="ew.searchOperatorChanged(this);">
<option value="="<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator == "=" ? " selected" : "" ?>><?php echo $Language->phrase("EQUAL") ?></option>
<option value="<>"<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator == "<>" ? " selected" : "" ?>><?php echo $Language->phrase("<>") ?></option>
<option value="<"<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator == "<" ? " selected" : "" ?>><?php echo $Language->phrase("<") ?></option>
<option value="<="<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator == "<=" ? " selected" : "" ?>><?php echo $Language->phrase("<=") ?></option>
<option value=">"<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator == ">" ? " selected" : "" ?>><?php echo $Language->phrase(">") ?></option>
<option value=">="<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator == ">=" ? " selected" : "" ?>><?php echo $Language->phrase(">=") ?></option>
<option value="BETWEEN"<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator == "BETWEEN" ? " selected" : "" ?>><?php echo $Language->phrase("BETWEEN") ?></option>
</select>
</span>
		<span id="el_production_dateprod" class="ew-search-field">
<input type="text" data-table="production" data-field="x_dateprod" data-format="7" name="x_dateprod" id="x_dateprod" maxlength="10" placeholder="<?php echo HtmlEncode($production_list->dateprod->getPlaceHolder()) ?>" value="<?php echo $production_list->dateprod->EditValue ?>"<?php echo $production_list->dateprod->editAttributes() ?>>
<?php if (!$production_list->dateprod->ReadOnly && !$production_list->dateprod->Disabled && !isset($production_list->dateprod->EditAttrs["readonly"]) && !isset($production_list->dateprod->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductionlistsrch", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductionlistsrch", "x_dateprod", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond">
<div class="custom-control custom-radio custom-control-inline"><input class="custom-control-input" type="radio" id="v_dateprod_1" name="v_dateprod" value="AND"<?php if ($production_list->dateprod->AdvancedSearch->SearchCondition != "OR") echo " checked" ?>><label class="custom-control-label" for="v_dateprod_1"><?php echo $Language->phrase("AND") ?></label></div>
<div class="custom-control custom-radio custom-control-inline"><input class="custom-control-input" type="radio" id="v_dateprod_2" name="v_dateprod" value="OR"<?php if ($production_list->dateprod->AdvancedSearch->SearchCondition == "OR") echo " checked" ?>><label class="custom-control-label" for="v_dateprod_2"><?php echo $Language->phrase("OR") ?></label></div></span>
		<span class="ew-search-and d-none"><label><?php echo $Language->phrase("AND") ?></label></span>
		<span class="ew-search-operator2">
<select name="w_dateprod" id="w_dateprod" class="custom-select" onchange="ew.searchOperatorChanged(this);">
<option value="="<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator2 == "=" ? " selected" : "" ?>><?php echo $Language->phrase("EQUAL") ?></option>
<option value="<>"<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator2 == "<>" ? " selected" : "" ?>><?php echo $Language->phrase("<>") ?></option>
<option value="<"<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator2 == "<" ? " selected" : "" ?>><?php echo $Language->phrase("<") ?></option>
<option value="<="<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator2 == "<=" ? " selected" : "" ?>><?php echo $Language->phrase("<=") ?></option>
<option value=">"<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator2 == ">" ? " selected" : "" ?>><?php echo $Language->phrase(">") ?></option>
<option value=">="<?php echo $production_list->dateprod->AdvancedSearch->SearchOperator2 == ">=" ? " selected" : "" ?>><?php echo $Language->phrase(">=") ?></option>
</select>
</span>
		<span id="el2_production_dateprod" class="ew-search-field2">
<input type="text" data-table="production" data-field="x_dateprod" data-format="7" name="y_dateprod" id="y_dateprod" maxlength="10" placeholder="<?php echo HtmlEncode($production_list->dateprod->getPlaceHolder()) ?>" value="<?php echo $production_list->dateprod->EditValue2 ?>"<?php echo $production_list->dateprod->editAttributes() ?>>
<?php if (!$production_list->dateprod->ReadOnly && !$production_list->dateprod->Disabled && !isset($production_list->dateprod->EditAttrs["readonly"]) && !isset($production_list->dateprod->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductionlistsrch", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductionlistsrch", "y_dateprod", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
	</div>
	<?php if ($production_list->SearchColumnCount % $production_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($production_list->SearchColumnCount % $production_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $production_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($production_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($production_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $production_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($production_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($production_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($production_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($production_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $production_list->showPageHeader(); ?>
<?php
$production_list->showMessage();
?>
<?php if ($production_list->TotalRecords > 0 || $production->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production">
<?php if (!$production_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$production_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $production_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fproductionlist" id="fproductionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_production" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($production_list->TotalRecords > 0 || $production_list->isGridEdit()) { ?>
<table id="tbl_productionlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production->RowType = ROWTYPE_HEADER;

// Render list options
$production_list->renderListOptions();

// Render list options (header, left)
$production_list->ListOptions->render("header", "left");
?>
<?php if ($production_list->idprod->Visible) { // idprod ?>
	<?php if ($production_list->SortUrl($production_list->idprod) == "") { ?>
		<th data-name="idprod" class="<?php echo $production_list->idprod->headerCellClass() ?>"><div id="elh_production_idprod" class="production_idprod"><div class="ew-table-header-caption"><?php echo $production_list->idprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idprod" class="<?php echo $production_list->idprod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->idprod) ?>', 1);"><div id="elh_production_idprod" class="production_idprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->idprod->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->idprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->idprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->idemp->Visible) { // idemp ?>
	<?php if ($production_list->SortUrl($production_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $production_list->idemp->headerCellClass() ?>"><div id="elh_production_idemp" class="production_idemp"><div class="ew-table-header-caption"><?php echo $production_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $production_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->idemp) ?>', 1);"><div id="elh_production_idemp" class="production_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->dept->Visible) { // dept ?>
	<?php if ($production_list->SortUrl($production_list->dept) == "") { ?>
		<th data-name="dept" class="<?php echo $production_list->dept->headerCellClass() ?>"><div id="elh_production_dept" class="production_dept"><div class="ew-table-header-caption"><?php echo $production_list->dept->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dept" class="<?php echo $production_list->dept->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->dept) ?>', 1);"><div id="elh_production_dept" class="production_dept">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->dept->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->dept->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->dept->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->type->Visible) { // type ?>
	<?php if ($production_list->SortUrl($production_list->type) == "") { ?>
		<th data-name="type" class="<?php echo $production_list->type->headerCellClass() ?>"><div id="elh_production_type" class="production_type"><div class="ew-table-header-caption"><?php echo $production_list->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $production_list->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->type) ?>', 1);"><div id="elh_production_type" class="production_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->idop->Visible) { // idop ?>
	<?php if ($production_list->SortUrl($production_list->idop) == "") { ?>
		<th data-name="idop" class="<?php echo $production_list->idop->headerCellClass() ?>"><div id="elh_production_idop" class="production_idop"><div class="ew-table-header-caption"><?php echo $production_list->idop->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idop" class="<?php echo $production_list->idop->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->idop) ?>', 1);"><div id="elh_production_idop" class="production_idop">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->idop->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->idop->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->idop->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->lot->Visible) { // lot ?>
	<?php if ($production_list->SortUrl($production_list->lot) == "") { ?>
		<th data-name="lot" class="<?php echo $production_list->lot->headerCellClass() ?>"><div id="elh_production_lot" class="production_lot"><div class="ew-table-header-caption"><?php echo $production_list->lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot" class="<?php echo $production_list->lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->lot) ?>', 1);"><div id="elh_production_lot" class="production_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->lot->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->lot->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->dateprod->Visible) { // dateprod ?>
	<?php if ($production_list->SortUrl($production_list->dateprod) == "") { ?>
		<th data-name="dateprod" class="<?php echo $production_list->dateprod->headerCellClass() ?>"><div id="elh_production_dateprod" class="production_dateprod"><div class="ew-table-header-caption"><?php echo $production_list->dateprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dateprod" class="<?php echo $production_list->dateprod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->dateprod) ?>', 1);"><div id="elh_production_dateprod" class="production_dateprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->dateprod->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->dateprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->dateprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->qtyprod->Visible) { // qtyprod ?>
	<?php if ($production_list->SortUrl($production_list->qtyprod) == "") { ?>
		<th data-name="qtyprod" class="<?php echo $production_list->qtyprod->headerCellClass() ?>"><div id="elh_production_qtyprod" class="production_qtyprod"><div class="ew-table-header-caption"><?php echo $production_list->qtyprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qtyprod" class="<?php echo $production_list->qtyprod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->qtyprod) ?>', 1);"><div id="elh_production_qtyprod" class="production_qtyprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->qtyprod->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($production_list->qtyprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->qtyprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->tauxprod->Visible) { // tauxprod ?>
	<?php if ($production_list->SortUrl($production_list->tauxprod) == "") { ?>
		<th data-name="tauxprod" class="<?php echo $production_list->tauxprod->headerCellClass() ?>"><div id="elh_production_tauxprod" class="production_tauxprod"><div class="ew-table-header-caption"><?php echo $production_list->tauxprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tauxprod" class="<?php echo $production_list->tauxprod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->tauxprod) ?>', 1);"><div id="elh_production_tauxprod" class="production_tauxprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->tauxprod->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->tauxprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->tauxprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_list->SubTotal->Visible) { // SubTotal ?>
	<?php if ($production_list->SortUrl($production_list->SubTotal) == "") { ?>
		<th data-name="SubTotal" class="<?php echo $production_list->SubTotal->headerCellClass() ?>"><div id="elh_production_SubTotal" class="production_SubTotal"><div class="ew-table-header-caption"><?php echo $production_list->SubTotal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SubTotal" class="<?php echo $production_list->SubTotal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $production_list->SortUrl($production_list->SubTotal) ?>', 1);"><div id="elh_production_SubTotal" class="production_SubTotal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_list->SubTotal->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_list->SubTotal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_list->SubTotal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($production_list->ExportAll && $production_list->isExport()) {
	$production_list->StopRecord = $production_list->TotalRecords;
} else {

	// Set the last record to display
	if ($production_list->TotalRecords > $production_list->StartRecord + $production_list->DisplayRecords - 1)
		$production_list->StopRecord = $production_list->StartRecord + $production_list->DisplayRecords - 1;
	else
		$production_list->StopRecord = $production_list->TotalRecords;
}
$production_list->RecordCount = $production_list->StartRecord - 1;
if ($production_list->Recordset && !$production_list->Recordset->EOF) {
	$production_list->Recordset->moveFirst();
	$selectLimit = $production_list->UseSelectLimit;
	if (!$selectLimit && $production_list->StartRecord > 1)
		$production_list->Recordset->move($production_list->StartRecord - 1);
} elseif (!$production->AllowAddDeleteRow && $production_list->StopRecord == 0) {
	$production_list->StopRecord = $production->GridAddRowCount;
}

// Initialize aggregate
$production->RowType = ROWTYPE_AGGREGATEINIT;
$production->resetAttributes();
$production_list->renderRow();
while ($production_list->RecordCount < $production_list->StopRecord) {
	$production_list->RecordCount++;
	if ($production_list->RecordCount >= $production_list->StartRecord) {
		$production_list->RowCount++;

		// Set up key count
		$production_list->KeyCount = $production_list->RowIndex;

		// Init row class and style
		$production->resetAttributes();
		$production->CssClass = "";
		if ($production_list->isGridAdd()) {
		} else {
			$production_list->loadRowValues($production_list->Recordset); // Load row values
		}
		$production->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$production->RowAttrs->merge(["data-rowindex" => $production_list->RowCount, "id" => "r" . $production_list->RowCount . "_production", "data-rowtype" => $production->RowType]);

		// Render row
		$production_list->renderRow();

		// Render list options
		$production_list->renderListOptions();
?>
	<tr <?php echo $production->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_list->ListOptions->render("body", "left", $production_list->RowCount);
?>
	<?php if ($production_list->idprod->Visible) { // idprod ?>
		<td data-name="idprod" <?php echo $production_list->idprod->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_idprod">
<span<?php echo $production_list->idprod->viewAttributes() ?>><?php echo $production_list->idprod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $production_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_idemp">
<span<?php echo $production_list->idemp->viewAttributes() ?>><?php echo $production_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->dept->Visible) { // dept ?>
		<td data-name="dept" <?php echo $production_list->dept->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_dept">
<span<?php echo $production_list->dept->viewAttributes() ?>><?php echo $production_list->dept->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->type->Visible) { // type ?>
		<td data-name="type" <?php echo $production_list->type->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_type">
<span<?php echo $production_list->type->viewAttributes() ?>><?php echo $production_list->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->idop->Visible) { // idop ?>
		<td data-name="idop" <?php echo $production_list->idop->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_idop">
<span<?php echo $production_list->idop->viewAttributes() ?>><?php echo $production_list->idop->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->lot->Visible) { // lot ?>
		<td data-name="lot" <?php echo $production_list->lot->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_lot">
<span<?php echo $production_list->lot->viewAttributes() ?>><?php echo $production_list->lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->dateprod->Visible) { // dateprod ?>
		<td data-name="dateprod" <?php echo $production_list->dateprod->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_dateprod">
<span<?php echo $production_list->dateprod->viewAttributes() ?>><?php echo $production_list->dateprod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->qtyprod->Visible) { // qtyprod ?>
		<td data-name="qtyprod" <?php echo $production_list->qtyprod->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_qtyprod">
<span<?php echo $production_list->qtyprod->viewAttributes() ?>><?php echo $production_list->qtyprod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->tauxprod->Visible) { // tauxprod ?>
		<td data-name="tauxprod" <?php echo $production_list->tauxprod->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_tauxprod">
<span<?php echo $production_list->tauxprod->viewAttributes() ?>><?php echo $production_list->tauxprod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($production_list->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" <?php echo $production_list->SubTotal->cellAttributes() ?>>
<span id="el<?php echo $production_list->RowCount ?>_production_SubTotal">
<span<?php echo $production_list->SubTotal->viewAttributes() ?>><?php echo $production_list->SubTotal->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_list->ListOptions->render("body", "right", $production_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$production_list->isGridAdd())
		$production_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$production->RowType = ROWTYPE_AGGREGATE;
$production->resetAttributes();
$production_list->renderRow();
?>
<?php if ($production_list->TotalRecords > 0 && !$production_list->isGridAdd() && !$production_list->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$production_list->renderListOptions();

// Render list options (footer, left)
$production_list->ListOptions->render("footer", "left");
?>
	<?php if ($production_list->idprod->Visible) { // idprod ?>
		<td data-name="idprod" class="<?php echo $production_list->idprod->footerCellClass() ?>"><span id="elf_production_idprod" class="production_idprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" class="<?php echo $production_list->idemp->footerCellClass() ?>"><span id="elf_production_idemp" class="production_idemp">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $production_list->idemp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($production_list->dept->Visible) { // dept ?>
		<td data-name="dept" class="<?php echo $production_list->dept->footerCellClass() ?>"><span id="elf_production_dept" class="production_dept">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $production_list->type->footerCellClass() ?>"><span id="elf_production_type" class="production_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->idop->Visible) { // idop ?>
		<td data-name="idop" class="<?php echo $production_list->idop->footerCellClass() ?>"><span id="elf_production_idop" class="production_idop">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->lot->Visible) { // lot ?>
		<td data-name="lot" class="<?php echo $production_list->lot->footerCellClass() ?>"><span id="elf_production_lot" class="production_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->dateprod->Visible) { // dateprod ?>
		<td data-name="dateprod" class="<?php echo $production_list->dateprod->footerCellClass() ?>"><span id="elf_production_dateprod" class="production_dateprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->qtyprod->Visible) { // qtyprod ?>
		<td data-name="qtyprod" class="<?php echo $production_list->qtyprod->footerCellClass() ?>"><span id="elf_production_qtyprod" class="production_qtyprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->tauxprod->Visible) { // tauxprod ?>
		<td data-name="tauxprod" class="<?php echo $production_list->tauxprod->footerCellClass() ?>"><span id="elf_production_tauxprod" class="production_tauxprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_list->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" class="<?php echo $production_list->SubTotal->footerCellClass() ?>"><span id="elf_production_SubTotal" class="production_SubTotal">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $production_list->SubTotal->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$production_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$production->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_list->Recordset)
	$production_list->Recordset->Close();
?>
<?php if (!$production_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$production_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $production_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $production_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_list->TotalRecords == 0 && !$production->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$production_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$production_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$production_list->terminate();
?>