<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($production_grid))
	$production_grid = new production_grid();

// Run the page
$production_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_grid->Page_Render();
?>
<?php if (!$production_grid->isExport()) { ?>
<script>
var fproductiongrid, currentPageID;
loadjs.ready("head", function() {

	// Form object
	fproductiongrid = new ew.Form("fproductiongrid", "grid");
	fproductiongrid.formKeyCountName = '<?php echo $production_grid->FormKeyCountName ?>';

	// Validate form
	fproductiongrid.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($production_grid->idprod->Required) { ?>
				elm = this.getElements("x" + infix + "_idprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->idprod->caption(), $production_grid->idprod->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_grid->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->idemp->caption(), $production_grid->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_grid->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->dept->caption(), $production_grid->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_grid->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->type->caption(), $production_grid->type->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_grid->idop->Required) { ?>
				elm = this.getElements("x" + infix + "_idop");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->idop->caption(), $production_grid->idop->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_grid->lot->Required) { ?>
				elm = this.getElements("x" + infix + "_lot");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->lot->caption(), $production_grid->lot->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_lot");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_grid->lot->errorMessage()) ?>");
			<?php if ($production_grid->dateprod->Required) { ?>
				elm = this.getElements("x" + infix + "_dateprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->dateprod->caption(), $production_grid->dateprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dateprod");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_grid->dateprod->errorMessage()) ?>");
			<?php if ($production_grid->qtyprod->Required) { ?>
				elm = this.getElements("x" + infix + "_qtyprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->qtyprod->caption(), $production_grid->qtyprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_qtyprod");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_grid->qtyprod->errorMessage()) ?>");
			<?php if ($production_grid->tauxprod->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->tauxprod->caption(), $production_grid->tauxprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxprod");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_grid->tauxprod->errorMessage()) ?>");
			<?php if ($production_grid->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_grid->SubTotal->caption(), $production_grid->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_grid->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		return true;
	}

	// Check empty row
	fproductiongrid.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "dept", false)) return false;
		if (ew.valueChanged(fobj, infix, "type", false)) return false;
		if (ew.valueChanged(fobj, infix, "idop", false)) return false;
		if (ew.valueChanged(fobj, infix, "lot", false)) return false;
		if (ew.valueChanged(fobj, infix, "dateprod", false)) return false;
		if (ew.valueChanged(fobj, infix, "qtyprod", false)) return false;
		if (ew.valueChanged(fobj, infix, "tauxprod", false)) return false;
		if (ew.valueChanged(fobj, infix, "SubTotal", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fproductiongrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fproductiongrid.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fproductiongrid.lists["x_idemp"] = <?php echo $production_grid->idemp->Lookup->toClientList($production_grid) ?>;
	fproductiongrid.lists["x_idemp"].options = <?php echo JsonEncode($production_grid->idemp->lookupOptions()) ?>;
	fproductiongrid.lists["x_dept"] = <?php echo $production_grid->dept->Lookup->toClientList($production_grid) ?>;
	fproductiongrid.lists["x_dept"].options = <?php echo JsonEncode($production_grid->dept->lookupOptions()) ?>;
	fproductiongrid.lists["x_type"] = <?php echo $production_grid->type->Lookup->toClientList($production_grid) ?>;
	fproductiongrid.lists["x_type"].options = <?php echo JsonEncode($production_grid->type->lookupOptions()) ?>;
	fproductiongrid.lists["x_idop"] = <?php echo $production_grid->idop->Lookup->toClientList($production_grid) ?>;
	fproductiongrid.lists["x_idop"].options = <?php echo JsonEncode($production_grid->idop->lookupOptions()) ?>;
	loadjs.done("fproductiongrid");
});
</script>
<?php } ?>
<?php
$production_grid->renderOtherOptions();
?>
<?php if ($production_grid->TotalRecords > 0 || $production->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($production_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> production">
<?php if ($production_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $production_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fproductiongrid" class="ew-form ew-list-form form-inline">
<div id="gmp_production" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_productiongrid" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$production->RowType = ROWTYPE_HEADER;

// Render list options
$production_grid->renderListOptions();

// Render list options (header, left)
$production_grid->ListOptions->render("header", "left");
?>
<?php if ($production_grid->idprod->Visible) { // idprod ?>
	<?php if ($production_grid->SortUrl($production_grid->idprod) == "") { ?>
		<th data-name="idprod" class="<?php echo $production_grid->idprod->headerCellClass() ?>"><div id="elh_production_idprod" class="production_idprod"><div class="ew-table-header-caption"><?php echo $production_grid->idprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idprod" class="<?php echo $production_grid->idprod->headerCellClass() ?>"><div><div id="elh_production_idprod" class="production_idprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->idprod->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->idprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->idprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->idemp->Visible) { // idemp ?>
	<?php if ($production_grid->SortUrl($production_grid->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $production_grid->idemp->headerCellClass() ?>"><div id="elh_production_idemp" class="production_idemp"><div class="ew-table-header-caption"><?php echo $production_grid->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $production_grid->idemp->headerCellClass() ?>"><div><div id="elh_production_idemp" class="production_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->dept->Visible) { // dept ?>
	<?php if ($production_grid->SortUrl($production_grid->dept) == "") { ?>
		<th data-name="dept" class="<?php echo $production_grid->dept->headerCellClass() ?>"><div id="elh_production_dept" class="production_dept"><div class="ew-table-header-caption"><?php echo $production_grid->dept->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dept" class="<?php echo $production_grid->dept->headerCellClass() ?>"><div><div id="elh_production_dept" class="production_dept">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->dept->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->dept->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->dept->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->type->Visible) { // type ?>
	<?php if ($production_grid->SortUrl($production_grid->type) == "") { ?>
		<th data-name="type" class="<?php echo $production_grid->type->headerCellClass() ?>"><div id="elh_production_type" class="production_type"><div class="ew-table-header-caption"><?php echo $production_grid->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $production_grid->type->headerCellClass() ?>"><div><div id="elh_production_type" class="production_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->idop->Visible) { // idop ?>
	<?php if ($production_grid->SortUrl($production_grid->idop) == "") { ?>
		<th data-name="idop" class="<?php echo $production_grid->idop->headerCellClass() ?>"><div id="elh_production_idop" class="production_idop"><div class="ew-table-header-caption"><?php echo $production_grid->idop->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idop" class="<?php echo $production_grid->idop->headerCellClass() ?>"><div><div id="elh_production_idop" class="production_idop">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->idop->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->idop->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->idop->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->lot->Visible) { // lot ?>
	<?php if ($production_grid->SortUrl($production_grid->lot) == "") { ?>
		<th data-name="lot" class="<?php echo $production_grid->lot->headerCellClass() ?>"><div id="elh_production_lot" class="production_lot"><div class="ew-table-header-caption"><?php echo $production_grid->lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot" class="<?php echo $production_grid->lot->headerCellClass() ?>"><div><div id="elh_production_lot" class="production_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->lot->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->lot->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->dateprod->Visible) { // dateprod ?>
	<?php if ($production_grid->SortUrl($production_grid->dateprod) == "") { ?>
		<th data-name="dateprod" class="<?php echo $production_grid->dateprod->headerCellClass() ?>"><div id="elh_production_dateprod" class="production_dateprod"><div class="ew-table-header-caption"><?php echo $production_grid->dateprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dateprod" class="<?php echo $production_grid->dateprod->headerCellClass() ?>"><div><div id="elh_production_dateprod" class="production_dateprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->dateprod->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->dateprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->dateprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->qtyprod->Visible) { // qtyprod ?>
	<?php if ($production_grid->SortUrl($production_grid->qtyprod) == "") { ?>
		<th data-name="qtyprod" class="<?php echo $production_grid->qtyprod->headerCellClass() ?>"><div id="elh_production_qtyprod" class="production_qtyprod"><div class="ew-table-header-caption"><?php echo $production_grid->qtyprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qtyprod" class="<?php echo $production_grid->qtyprod->headerCellClass() ?>"><div><div id="elh_production_qtyprod" class="production_qtyprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->qtyprod->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->qtyprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->qtyprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->tauxprod->Visible) { // tauxprod ?>
	<?php if ($production_grid->SortUrl($production_grid->tauxprod) == "") { ?>
		<th data-name="tauxprod" class="<?php echo $production_grid->tauxprod->headerCellClass() ?>"><div id="elh_production_tauxprod" class="production_tauxprod"><div class="ew-table-header-caption"><?php echo $production_grid->tauxprod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tauxprod" class="<?php echo $production_grid->tauxprod->headerCellClass() ?>"><div><div id="elh_production_tauxprod" class="production_tauxprod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->tauxprod->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->tauxprod->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->tauxprod->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($production_grid->SubTotal->Visible) { // SubTotal ?>
	<?php if ($production_grid->SortUrl($production_grid->SubTotal) == "") { ?>
		<th data-name="SubTotal" class="<?php echo $production_grid->SubTotal->headerCellClass() ?>"><div id="elh_production_SubTotal" class="production_SubTotal"><div class="ew-table-header-caption"><?php echo $production_grid->SubTotal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SubTotal" class="<?php echo $production_grid->SubTotal->headerCellClass() ?>"><div><div id="elh_production_SubTotal" class="production_SubTotal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $production_grid->SubTotal->caption() ?></span><span class="ew-table-header-sort"><?php if ($production_grid->SubTotal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($production_grid->SubTotal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$production_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$production_grid->StartRecord = 1;
$production_grid->StopRecord = $production_grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($production->isConfirm() || $production_grid->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($production_grid->FormKeyCountName) && ($production_grid->isGridAdd() || $production_grid->isGridEdit() || $production->isConfirm())) {
		$production_grid->KeyCount = $CurrentForm->getValue($production_grid->FormKeyCountName);
		$production_grid->StopRecord = $production_grid->StartRecord + $production_grid->KeyCount - 1;
	}
}
$production_grid->RecordCount = $production_grid->StartRecord - 1;
if ($production_grid->Recordset && !$production_grid->Recordset->EOF) {
	$production_grid->Recordset->moveFirst();
	$selectLimit = $production_grid->UseSelectLimit;
	if (!$selectLimit && $production_grid->StartRecord > 1)
		$production_grid->Recordset->move($production_grid->StartRecord - 1);
} elseif (!$production->AllowAddDeleteRow && $production_grid->StopRecord == 0) {
	$production_grid->StopRecord = $production->GridAddRowCount;
}

// Initialize aggregate
$production->RowType = ROWTYPE_AGGREGATEINIT;
$production->resetAttributes();
$production_grid->renderRow();
if ($production_grid->isGridAdd())
	$production_grid->RowIndex = 0;
if ($production_grid->isGridEdit())
	$production_grid->RowIndex = 0;
while ($production_grid->RecordCount < $production_grid->StopRecord) {
	$production_grid->RecordCount++;
	if ($production_grid->RecordCount >= $production_grid->StartRecord) {
		$production_grid->RowCount++;
		if ($production_grid->isGridAdd() || $production_grid->isGridEdit() || $production->isConfirm()) {
			$production_grid->RowIndex++;
			$CurrentForm->Index = $production_grid->RowIndex;
			if ($CurrentForm->hasValue($production_grid->FormActionName) && ($production->isConfirm() || $production_grid->EventCancelled))
				$production_grid->RowAction = strval($CurrentForm->getValue($production_grid->FormActionName));
			elseif ($production_grid->isGridAdd())
				$production_grid->RowAction = "insert";
			else
				$production_grid->RowAction = "";
		}

		// Set up key count
		$production_grid->KeyCount = $production_grid->RowIndex;

		// Init row class and style
		$production->resetAttributes();
		$production->CssClass = "";
		if ($production_grid->isGridAdd()) {
			if ($production->CurrentMode == "copy") {
				$production_grid->loadRowValues($production_grid->Recordset); // Load row values
				$production_grid->setRecordKey($production_grid->RowOldKey, $production_grid->Recordset); // Set old record key
			} else {
				$production_grid->loadRowValues(); // Load default values
				$production_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$production_grid->loadRowValues($production_grid->Recordset); // Load row values
		}
		$production->RowType = ROWTYPE_VIEW; // Render view
		if ($production_grid->isGridAdd()) // Grid add
			$production->RowType = ROWTYPE_ADD; // Render add
		if ($production_grid->isGridAdd() && $production->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$production_grid->restoreCurrentRowFormValues($production_grid->RowIndex); // Restore form values
		if ($production_grid->isGridEdit()) { // Grid edit
			if ($production->EventCancelled)
				$production_grid->restoreCurrentRowFormValues($production_grid->RowIndex); // Restore form values
			if ($production_grid->RowAction == "insert")
				$production->RowType = ROWTYPE_ADD; // Render add
			else
				$production->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($production_grid->isGridEdit() && ($production->RowType == ROWTYPE_EDIT || $production->RowType == ROWTYPE_ADD) && $production->EventCancelled) // Update failed
			$production_grid->restoreCurrentRowFormValues($production_grid->RowIndex); // Restore form values
		if ($production->RowType == ROWTYPE_EDIT) // Edit row
			$production_grid->EditRowCount++;
		if ($production->isConfirm()) // Confirm row
			$production_grid->restoreCurrentRowFormValues($production_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$production->RowAttrs->merge(["data-rowindex" => $production_grid->RowCount, "id" => "r" . $production_grid->RowCount . "_production", "data-rowtype" => $production->RowType]);

		// Render row
		$production_grid->renderRow();

		// Render list options
		$production_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($production_grid->RowAction != "delete" && $production_grid->RowAction != "insertdelete" && !($production_grid->RowAction == "insert" && $production->isConfirm() && $production_grid->emptyRow())) {
?>
	<tr <?php echo $production->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_grid->ListOptions->render("body", "left", $production_grid->RowCount);
?>
	<?php if ($production_grid->idprod->Visible) { // idprod ?>
		<td data-name="idprod" <?php echo $production_grid->idprod->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idprod" class="form-group"></span>
<input type="hidden" data-table="production" data-field="x_idprod" name="o<?php echo $production_grid->RowIndex ?>_idprod" id="o<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idprod" class="form-group">
<span<?php echo $production_grid->idprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->idprod->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_idprod" name="x<?php echo $production_grid->RowIndex ?>_idprod" id="x<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->CurrentValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idprod">
<span<?php echo $production_grid->idprod->viewAttributes() ?>><?php echo $production_grid->idprod->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_idprod" name="x<?php echo $production_grid->RowIndex ?>_idprod" id="x<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_idprod" name="o<?php echo $production_grid->RowIndex ?>_idprod" id="o<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_idprod" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_idprod" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_idprod" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_idprod" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $production_grid->idemp->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($production_grid->idemp->getSessionValue() != "") { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idemp" class="form-group">
<span<?php echo $production_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_grid->RowIndex ?>_idemp" name="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idemp" class="form-group">
<?php $production_grid->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $production_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($production_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_grid->idemp->ReadOnly || $production_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $production_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_grid->idemp->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="production" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $production_grid->RowIndex ?>_idemp" id="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo $production_grid->idemp->CurrentValue ?>"<?php echo $production_grid->idemp->editAttributes() ?>>
</span>
<?php } ?>
<input type="hidden" data-table="production" data-field="x_idemp" name="o<?php echo $production_grid->RowIndex ?>_idemp" id="o<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($production_grid->idemp->getSessionValue() != "") { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idemp" class="form-group">
<span<?php echo $production_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_grid->RowIndex ?>_idemp" name="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idemp" class="form-group">
<?php $production_grid->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $production_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($production_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_grid->idemp->ReadOnly || $production_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $production_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_grid->idemp->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="production" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $production_grid->RowIndex ?>_idemp" id="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo $production_grid->idemp->CurrentValue ?>"<?php echo $production_grid->idemp->editAttributes() ?>>
</span>
<?php } ?>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idemp">
<span<?php echo $production_grid->idemp->viewAttributes() ?>><?php echo $production_grid->idemp->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_idemp" name="x<?php echo $production_grid->RowIndex ?>_idemp" id="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_idemp" name="o<?php echo $production_grid->RowIndex ?>_idemp" id="o<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_idemp" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_idemp" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_idemp" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_idemp" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->dept->Visible) { // dept ?>
		<td data-name="dept" <?php echo $production_grid->dept->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dept" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_dept" data-value-separator="<?php echo $production_grid->dept->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_grid->RowIndex ?>_dept" name="x<?php echo $production_grid->RowIndex ?>_dept"<?php echo $production_grid->dept->editAttributes() ?>>
			<?php echo $production_grid->dept->selectOptionListHtml("x{$production_grid->RowIndex}_dept") ?>
		</select>
</div>
<?php echo $production_grid->dept->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_dept") ?>
</span>
<input type="hidden" data-table="production" data-field="x_dept" name="o<?php echo $production_grid->RowIndex ?>_dept" id="o<?php echo $production_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($production_grid->dept->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dept" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_dept" data-value-separator="<?php echo $production_grid->dept->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_grid->RowIndex ?>_dept" name="x<?php echo $production_grid->RowIndex ?>_dept"<?php echo $production_grid->dept->editAttributes() ?>>
			<?php echo $production_grid->dept->selectOptionListHtml("x{$production_grid->RowIndex}_dept") ?>
		</select>
</div>
<?php echo $production_grid->dept->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_dept") ?>
</span>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dept">
<span<?php echo $production_grid->dept->viewAttributes() ?>><?php echo $production_grid->dept->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_dept" name="x<?php echo $production_grid->RowIndex ?>_dept" id="x<?php echo $production_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($production_grid->dept->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_dept" name="o<?php echo $production_grid->RowIndex ?>_dept" id="o<?php echo $production_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($production_grid->dept->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_dept" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_dept" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($production_grid->dept->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_dept" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_dept" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($production_grid->dept->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->type->Visible) { // type ?>
		<td data-name="type" <?php echo $production_grid->type->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_type" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_type" data-value-separator="<?php echo $production_grid->type->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_grid->RowIndex ?>_type" name="x<?php echo $production_grid->RowIndex ?>_type"<?php echo $production_grid->type->editAttributes() ?>>
			<?php echo $production_grid->type->selectOptionListHtml("x{$production_grid->RowIndex}_type") ?>
		</select>
</div>
<?php echo $production_grid->type->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_type") ?>
</span>
<input type="hidden" data-table="production" data-field="x_type" name="o<?php echo $production_grid->RowIndex ?>_type" id="o<?php echo $production_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($production_grid->type->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_type" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_type" data-value-separator="<?php echo $production_grid->type->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_grid->RowIndex ?>_type" name="x<?php echo $production_grid->RowIndex ?>_type"<?php echo $production_grid->type->editAttributes() ?>>
			<?php echo $production_grid->type->selectOptionListHtml("x{$production_grid->RowIndex}_type") ?>
		</select>
</div>
<?php echo $production_grid->type->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_type") ?>
</span>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_type">
<span<?php echo $production_grid->type->viewAttributes() ?>><?php echo $production_grid->type->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_type" name="x<?php echo $production_grid->RowIndex ?>_type" id="x<?php echo $production_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($production_grid->type->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_type" name="o<?php echo $production_grid->RowIndex ?>_type" id="o<?php echo $production_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($production_grid->type->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_type" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_type" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($production_grid->type->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_type" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_type" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($production_grid->type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->idop->Visible) { // idop ?>
		<td data-name="idop" <?php echo $production_grid->idop->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idop" class="form-group">
<?php $production_grid->idop->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $production_grid->RowIndex ?>_idop"><?php echo EmptyValue(strval($production_grid->idop->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_grid->idop->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_grid->idop->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_grid->idop->ReadOnly || $production_grid->idop->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $production_grid->RowIndex ?>_idop',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_grid->idop->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_idop") ?>
<input type="hidden" data-table="production" data-field="x_idop" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_grid->idop->displayValueSeparatorAttribute() ?>" name="x<?php echo $production_grid->RowIndex ?>_idop" id="x<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo $production_grid->idop->CurrentValue ?>"<?php echo $production_grid->idop->editAttributes() ?>>
</span>
<input type="hidden" data-table="production" data-field="x_idop" name="o<?php echo $production_grid->RowIndex ?>_idop" id="o<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo HtmlEncode($production_grid->idop->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idop" class="form-group">
<?php $production_grid->idop->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $production_grid->RowIndex ?>_idop"><?php echo EmptyValue(strval($production_grid->idop->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_grid->idop->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_grid->idop->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_grid->idop->ReadOnly || $production_grid->idop->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $production_grid->RowIndex ?>_idop',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_grid->idop->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_idop") ?>
<input type="hidden" data-table="production" data-field="x_idop" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_grid->idop->displayValueSeparatorAttribute() ?>" name="x<?php echo $production_grid->RowIndex ?>_idop" id="x<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo $production_grid->idop->CurrentValue ?>"<?php echo $production_grid->idop->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_idop">
<span<?php echo $production_grid->idop->viewAttributes() ?>><?php echo $production_grid->idop->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_idop" name="x<?php echo $production_grid->RowIndex ?>_idop" id="x<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo HtmlEncode($production_grid->idop->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_idop" name="o<?php echo $production_grid->RowIndex ?>_idop" id="o<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo HtmlEncode($production_grid->idop->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_idop" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_idop" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo HtmlEncode($production_grid->idop->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_idop" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_idop" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo HtmlEncode($production_grid->idop->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->lot->Visible) { // lot ?>
		<td data-name="lot" <?php echo $production_grid->lot->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_lot" class="form-group">
<input type="text" data-table="production" data-field="x_lot" name="x<?php echo $production_grid->RowIndex ?>_lot" id="x<?php echo $production_grid->RowIndex ?>_lot" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_grid->lot->getPlaceHolder()) ?>" value="<?php echo $production_grid->lot->EditValue ?>"<?php echo $production_grid->lot->editAttributes() ?>>
</span>
<input type="hidden" data-table="production" data-field="x_lot" name="o<?php echo $production_grid->RowIndex ?>_lot" id="o<?php echo $production_grid->RowIndex ?>_lot" value="<?php echo HtmlEncode($production_grid->lot->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_lot" class="form-group">
<input type="text" data-table="production" data-field="x_lot" name="x<?php echo $production_grid->RowIndex ?>_lot" id="x<?php echo $production_grid->RowIndex ?>_lot" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_grid->lot->getPlaceHolder()) ?>" value="<?php echo $production_grid->lot->EditValue ?>"<?php echo $production_grid->lot->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_lot">
<span<?php echo $production_grid->lot->viewAttributes() ?>><?php echo $production_grid->lot->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_lot" name="x<?php echo $production_grid->RowIndex ?>_lot" id="x<?php echo $production_grid->RowIndex ?>_lot" value="<?php echo HtmlEncode($production_grid->lot->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_lot" name="o<?php echo $production_grid->RowIndex ?>_lot" id="o<?php echo $production_grid->RowIndex ?>_lot" value="<?php echo HtmlEncode($production_grid->lot->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_lot" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_lot" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_lot" value="<?php echo HtmlEncode($production_grid->lot->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_lot" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_lot" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_lot" value="<?php echo HtmlEncode($production_grid->lot->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->dateprod->Visible) { // dateprod ?>
		<td data-name="dateprod" <?php echo $production_grid->dateprod->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($production_grid->dateprod->getSessionValue() != "") { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dateprod" class="form-group">
<span<?php echo $production_grid->dateprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->dateprod->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_grid->RowIndex ?>_dateprod" name="x<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode(FormatDateTime($production_grid->dateprod->CurrentValue, 7)) ?>">
<?php } else { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dateprod" class="form-group">
<input type="text" data-table="production" data-field="x_dateprod" data-format="7" name="x<?php echo $production_grid->RowIndex ?>_dateprod" id="x<?php echo $production_grid->RowIndex ?>_dateprod" maxlength="10" placeholder="<?php echo HtmlEncode($production_grid->dateprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->dateprod->EditValue ?>"<?php echo $production_grid->dateprod->editAttributes() ?>>
<?php if (!$production_grid->dateprod->ReadOnly && !$production_grid->dateprod->Disabled && !isset($production_grid->dateprod->EditAttrs["readonly"]) && !isset($production_grid->dateprod->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductiongrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductiongrid", "x<?php echo $production_grid->RowIndex ?>_dateprod", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="production" data-field="x_dateprod" name="o<?php echo $production_grid->RowIndex ?>_dateprod" id="o<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode($production_grid->dateprod->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($production_grid->dateprod->getSessionValue() != "") { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dateprod" class="form-group">
<span<?php echo $production_grid->dateprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->dateprod->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_grid->RowIndex ?>_dateprod" name="x<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode(FormatDateTime($production_grid->dateprod->CurrentValue, 7)) ?>">
<?php } else { ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dateprod" class="form-group">
<input type="text" data-table="production" data-field="x_dateprod" data-format="7" name="x<?php echo $production_grid->RowIndex ?>_dateprod" id="x<?php echo $production_grid->RowIndex ?>_dateprod" maxlength="10" placeholder="<?php echo HtmlEncode($production_grid->dateprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->dateprod->EditValue ?>"<?php echo $production_grid->dateprod->editAttributes() ?>>
<?php if (!$production_grid->dateprod->ReadOnly && !$production_grid->dateprod->Disabled && !isset($production_grid->dateprod->EditAttrs["readonly"]) && !isset($production_grid->dateprod->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductiongrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductiongrid", "x<?php echo $production_grid->RowIndex ?>_dateprod", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_dateprod">
<span<?php echo $production_grid->dateprod->viewAttributes() ?>><?php echo $production_grid->dateprod->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_dateprod" name="x<?php echo $production_grid->RowIndex ?>_dateprod" id="x<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode($production_grid->dateprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_dateprod" name="o<?php echo $production_grid->RowIndex ?>_dateprod" id="o<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode($production_grid->dateprod->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_dateprod" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_dateprod" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode($production_grid->dateprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_dateprod" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_dateprod" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode($production_grid->dateprod->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->qtyprod->Visible) { // qtyprod ?>
		<td data-name="qtyprod" <?php echo $production_grid->qtyprod->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_qtyprod" class="form-group">
<input type="text" data-table="production" data-field="x_qtyprod" name="x<?php echo $production_grid->RowIndex ?>_qtyprod" id="x<?php echo $production_grid->RowIndex ?>_qtyprod" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_grid->qtyprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->qtyprod->EditValue ?>"<?php echo $production_grid->qtyprod->editAttributes() ?>>
</span>
<input type="hidden" data-table="production" data-field="x_qtyprod" name="o<?php echo $production_grid->RowIndex ?>_qtyprod" id="o<?php echo $production_grid->RowIndex ?>_qtyprod" value="<?php echo HtmlEncode($production_grid->qtyprod->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_qtyprod" class="form-group">
<input type="text" data-table="production" data-field="x_qtyprod" name="x<?php echo $production_grid->RowIndex ?>_qtyprod" id="x<?php echo $production_grid->RowIndex ?>_qtyprod" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_grid->qtyprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->qtyprod->EditValue ?>"<?php echo $production_grid->qtyprod->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_qtyprod">
<span<?php echo $production_grid->qtyprod->viewAttributes() ?>><?php echo $production_grid->qtyprod->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_qtyprod" name="x<?php echo $production_grid->RowIndex ?>_qtyprod" id="x<?php echo $production_grid->RowIndex ?>_qtyprod" value="<?php echo HtmlEncode($production_grid->qtyprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_qtyprod" name="o<?php echo $production_grid->RowIndex ?>_qtyprod" id="o<?php echo $production_grid->RowIndex ?>_qtyprod" value="<?php echo HtmlEncode($production_grid->qtyprod->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_qtyprod" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_qtyprod" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_qtyprod" value="<?php echo HtmlEncode($production_grid->qtyprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_qtyprod" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_qtyprod" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_qtyprod" value="<?php echo HtmlEncode($production_grid->qtyprod->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->tauxprod->Visible) { // tauxprod ?>
		<td data-name="tauxprod" <?php echo $production_grid->tauxprod->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_tauxprod" class="form-group">
<input type="text" data-table="production" data-field="x_tauxprod" name="x<?php echo $production_grid->RowIndex ?>_tauxprod" id="x<?php echo $production_grid->RowIndex ?>_tauxprod" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_grid->tauxprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->tauxprod->EditValue ?>"<?php echo $production_grid->tauxprod->editAttributes() ?>>
</span>
<input type="hidden" data-table="production" data-field="x_tauxprod" name="o<?php echo $production_grid->RowIndex ?>_tauxprod" id="o<?php echo $production_grid->RowIndex ?>_tauxprod" value="<?php echo HtmlEncode($production_grid->tauxprod->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_tauxprod" class="form-group">
<input type="text" data-table="production" data-field="x_tauxprod" name="x<?php echo $production_grid->RowIndex ?>_tauxprod" id="x<?php echo $production_grid->RowIndex ?>_tauxprod" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_grid->tauxprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->tauxprod->EditValue ?>"<?php echo $production_grid->tauxprod->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_tauxprod">
<span<?php echo $production_grid->tauxprod->viewAttributes() ?>><?php echo $production_grid->tauxprod->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_tauxprod" name="x<?php echo $production_grid->RowIndex ?>_tauxprod" id="x<?php echo $production_grid->RowIndex ?>_tauxprod" value="<?php echo HtmlEncode($production_grid->tauxprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_tauxprod" name="o<?php echo $production_grid->RowIndex ?>_tauxprod" id="o<?php echo $production_grid->RowIndex ?>_tauxprod" value="<?php echo HtmlEncode($production_grid->tauxprod->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_tauxprod" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_tauxprod" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_tauxprod" value="<?php echo HtmlEncode($production_grid->tauxprod->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_tauxprod" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_tauxprod" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_tauxprod" value="<?php echo HtmlEncode($production_grid->tauxprod->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($production_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" <?php echo $production_grid->SubTotal->cellAttributes() ?>>
<?php if ($production->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_SubTotal" class="form-group">
<input type="text" data-table="production" data-field="x_SubTotal" name="x<?php echo $production_grid->RowIndex ?>_SubTotal" id="x<?php echo $production_grid->RowIndex ?>_SubTotal" size="30" maxlength="23" placeholder="<?php echo HtmlEncode($production_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $production_grid->SubTotal->EditValue ?>"<?php echo $production_grid->SubTotal->editAttributes() ?>>
</span>
<input type="hidden" data-table="production" data-field="x_SubTotal" name="o<?php echo $production_grid->RowIndex ?>_SubTotal" id="o<?php echo $production_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($production_grid->SubTotal->OldValue) ?>">
<?php } ?>
<?php if ($production->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_SubTotal" class="form-group">
<input type="text" data-table="production" data-field="x_SubTotal" name="x<?php echo $production_grid->RowIndex ?>_SubTotal" id="x<?php echo $production_grid->RowIndex ?>_SubTotal" size="30" maxlength="23" placeholder="<?php echo HtmlEncode($production_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $production_grid->SubTotal->EditValue ?>"<?php echo $production_grid->SubTotal->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($production->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $production_grid->RowCount ?>_production_SubTotal">
<span<?php echo $production_grid->SubTotal->viewAttributes() ?>><?php echo $production_grid->SubTotal->getViewValue() ?></span>
</span>
<?php if (!$production->isConfirm()) { ?>
<input type="hidden" data-table="production" data-field="x_SubTotal" name="x<?php echo $production_grid->RowIndex ?>_SubTotal" id="x<?php echo $production_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($production_grid->SubTotal->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_SubTotal" name="o<?php echo $production_grid->RowIndex ?>_SubTotal" id="o<?php echo $production_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($production_grid->SubTotal->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="production" data-field="x_SubTotal" name="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_SubTotal" id="fproductiongrid$x<?php echo $production_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($production_grid->SubTotal->FormValue) ?>">
<input type="hidden" data-table="production" data-field="x_SubTotal" name="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_SubTotal" id="fproductiongrid$o<?php echo $production_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($production_grid->SubTotal->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_grid->ListOptions->render("body", "right", $production_grid->RowCount);
?>
	</tr>
<?php if ($production->RowType == ROWTYPE_ADD || $production->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fproductiongrid", "load"], function() {
	fproductiongrid.updateLists(<?php echo $production_grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$production_grid->isGridAdd() || $production->CurrentMode == "copy")
		if (!$production_grid->Recordset->EOF)
			$production_grid->Recordset->moveNext();
}
?>
<?php
	if ($production->CurrentMode == "add" || $production->CurrentMode == "copy" || $production->CurrentMode == "edit") {
		$production_grid->RowIndex = '$rowindex$';
		$production_grid->loadRowValues();

		// Set row properties
		$production->resetAttributes();
		$production->RowAttrs->merge(["data-rowindex" => $production_grid->RowIndex, "id" => "r0_production", "data-rowtype" => ROWTYPE_ADD]);
		$production->RowAttrs->appendClass("ew-template");
		$production->RowType = ROWTYPE_ADD;

		// Render row
		$production_grid->renderRow();

		// Render list options
		$production_grid->renderListOptions();
		$production_grid->StartRowCount = 0;
?>
	<tr <?php echo $production->rowAttributes() ?>>
<?php

// Render list options (body, left)
$production_grid->ListOptions->render("body", "left", $production_grid->RowIndex);
?>
	<?php if ($production_grid->idprod->Visible) { // idprod ?>
		<td data-name="idprod">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_idprod" class="form-group production_idprod"></span>
<?php } else { ?>
<span id="el$rowindex$_production_idprod" class="form-group production_idprod">
<span<?php echo $production_grid->idprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->idprod->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_idprod" name="x<?php echo $production_grid->RowIndex ?>_idprod" id="x<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_idprod" name="o<?php echo $production_grid->RowIndex ?>_idprod" id="o<?php echo $production_grid->RowIndex ?>_idprod" value="<?php echo HtmlEncode($production_grid->idprod->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<?php if (!$production->isConfirm()) { ?>
<?php if ($production_grid->idemp->getSessionValue() != "") { ?>
<span id="el$rowindex$_production_idemp" class="form-group production_idemp">
<span<?php echo $production_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_grid->RowIndex ?>_idemp" name="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_production_idemp" class="form-group production_idemp">
<?php $production_grid->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $production_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($production_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_grid->idemp->ReadOnly || $production_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $production_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_grid->idemp->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="production" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $production_grid->RowIndex ?>_idemp" id="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo $production_grid->idemp->CurrentValue ?>"<?php echo $production_grid->idemp->editAttributes() ?>>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_production_idemp" class="form-group production_idemp">
<span<?php echo $production_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_idemp" name="x<?php echo $production_grid->RowIndex ?>_idemp" id="x<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_idemp" name="o<?php echo $production_grid->RowIndex ?>_idemp" id="o<?php echo $production_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($production_grid->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->dept->Visible) { // dept ?>
		<td data-name="dept">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_dept" class="form-group production_dept">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_dept" data-value-separator="<?php echo $production_grid->dept->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_grid->RowIndex ?>_dept" name="x<?php echo $production_grid->RowIndex ?>_dept"<?php echo $production_grid->dept->editAttributes() ?>>
			<?php echo $production_grid->dept->selectOptionListHtml("x{$production_grid->RowIndex}_dept") ?>
		</select>
</div>
<?php echo $production_grid->dept->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_dept") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_dept" class="form-group production_dept">
<span<?php echo $production_grid->dept->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->dept->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_dept" name="x<?php echo $production_grid->RowIndex ?>_dept" id="x<?php echo $production_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($production_grid->dept->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_dept" name="o<?php echo $production_grid->RowIndex ?>_dept" id="o<?php echo $production_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($production_grid->dept->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->type->Visible) { // type ?>
		<td data-name="type">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_type" class="form-group production_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_type" data-value-separator="<?php echo $production_grid->type->displayValueSeparatorAttribute() ?>" id="x<?php echo $production_grid->RowIndex ?>_type" name="x<?php echo $production_grid->RowIndex ?>_type"<?php echo $production_grid->type->editAttributes() ?>>
			<?php echo $production_grid->type->selectOptionListHtml("x{$production_grid->RowIndex}_type") ?>
		</select>
</div>
<?php echo $production_grid->type->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_type") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_type" class="form-group production_type">
<span<?php echo $production_grid->type->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->type->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_type" name="x<?php echo $production_grid->RowIndex ?>_type" id="x<?php echo $production_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($production_grid->type->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_type" name="o<?php echo $production_grid->RowIndex ?>_type" id="o<?php echo $production_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($production_grid->type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->idop->Visible) { // idop ?>
		<td data-name="idop">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_idop" class="form-group production_idop">
<?php $production_grid->idop->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $production_grid->RowIndex ?>_idop"><?php echo EmptyValue(strval($production_grid->idop->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_grid->idop->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_grid->idop->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_grid->idop->ReadOnly || $production_grid->idop->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $production_grid->RowIndex ?>_idop',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_grid->idop->Lookup->getParamTag($production_grid, "p_x" . $production_grid->RowIndex . "_idop") ?>
<input type="hidden" data-table="production" data-field="x_idop" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_grid->idop->displayValueSeparatorAttribute() ?>" name="x<?php echo $production_grid->RowIndex ?>_idop" id="x<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo $production_grid->idop->CurrentValue ?>"<?php echo $production_grid->idop->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_idop" class="form-group production_idop">
<span<?php echo $production_grid->idop->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->idop->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_idop" name="x<?php echo $production_grid->RowIndex ?>_idop" id="x<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo HtmlEncode($production_grid->idop->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_idop" name="o<?php echo $production_grid->RowIndex ?>_idop" id="o<?php echo $production_grid->RowIndex ?>_idop" value="<?php echo HtmlEncode($production_grid->idop->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->lot->Visible) { // lot ?>
		<td data-name="lot">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_lot" class="form-group production_lot">
<input type="text" data-table="production" data-field="x_lot" name="x<?php echo $production_grid->RowIndex ?>_lot" id="x<?php echo $production_grid->RowIndex ?>_lot" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_grid->lot->getPlaceHolder()) ?>" value="<?php echo $production_grid->lot->EditValue ?>"<?php echo $production_grid->lot->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_lot" class="form-group production_lot">
<span<?php echo $production_grid->lot->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->lot->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_lot" name="x<?php echo $production_grid->RowIndex ?>_lot" id="x<?php echo $production_grid->RowIndex ?>_lot" value="<?php echo HtmlEncode($production_grid->lot->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_lot" name="o<?php echo $production_grid->RowIndex ?>_lot" id="o<?php echo $production_grid->RowIndex ?>_lot" value="<?php echo HtmlEncode($production_grid->lot->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->dateprod->Visible) { // dateprod ?>
		<td data-name="dateprod">
<?php if (!$production->isConfirm()) { ?>
<?php if ($production_grid->dateprod->getSessionValue() != "") { ?>
<span id="el$rowindex$_production_dateprod" class="form-group production_dateprod">
<span<?php echo $production_grid->dateprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->dateprod->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $production_grid->RowIndex ?>_dateprod" name="x<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode(FormatDateTime($production_grid->dateprod->CurrentValue, 7)) ?>">
<?php } else { ?>
<span id="el$rowindex$_production_dateprod" class="form-group production_dateprod">
<input type="text" data-table="production" data-field="x_dateprod" data-format="7" name="x<?php echo $production_grid->RowIndex ?>_dateprod" id="x<?php echo $production_grid->RowIndex ?>_dateprod" maxlength="10" placeholder="<?php echo HtmlEncode($production_grid->dateprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->dateprod->EditValue ?>"<?php echo $production_grid->dateprod->editAttributes() ?>>
<?php if (!$production_grid->dateprod->ReadOnly && !$production_grid->dateprod->Disabled && !isset($production_grid->dateprod->EditAttrs["readonly"]) && !isset($production_grid->dateprod->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductiongrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductiongrid", "x<?php echo $production_grid->RowIndex ?>_dateprod", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_production_dateprod" class="form-group production_dateprod">
<span<?php echo $production_grid->dateprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->dateprod->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_dateprod" name="x<?php echo $production_grid->RowIndex ?>_dateprod" id="x<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode($production_grid->dateprod->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_dateprod" name="o<?php echo $production_grid->RowIndex ?>_dateprod" id="o<?php echo $production_grid->RowIndex ?>_dateprod" value="<?php echo HtmlEncode($production_grid->dateprod->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->qtyprod->Visible) { // qtyprod ?>
		<td data-name="qtyprod">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_qtyprod" class="form-group production_qtyprod">
<input type="text" data-table="production" data-field="x_qtyprod" name="x<?php echo $production_grid->RowIndex ?>_qtyprod" id="x<?php echo $production_grid->RowIndex ?>_qtyprod" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_grid->qtyprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->qtyprod->EditValue ?>"<?php echo $production_grid->qtyprod->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_qtyprod" class="form-group production_qtyprod">
<span<?php echo $production_grid->qtyprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->qtyprod->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_qtyprod" name="x<?php echo $production_grid->RowIndex ?>_qtyprod" id="x<?php echo $production_grid->RowIndex ?>_qtyprod" value="<?php echo HtmlEncode($production_grid->qtyprod->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_qtyprod" name="o<?php echo $production_grid->RowIndex ?>_qtyprod" id="o<?php echo $production_grid->RowIndex ?>_qtyprod" value="<?php echo HtmlEncode($production_grid->qtyprod->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->tauxprod->Visible) { // tauxprod ?>
		<td data-name="tauxprod">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_tauxprod" class="form-group production_tauxprod">
<input type="text" data-table="production" data-field="x_tauxprod" name="x<?php echo $production_grid->RowIndex ?>_tauxprod" id="x<?php echo $production_grid->RowIndex ?>_tauxprod" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_grid->tauxprod->getPlaceHolder()) ?>" value="<?php echo $production_grid->tauxprod->EditValue ?>"<?php echo $production_grid->tauxprod->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_tauxprod" class="form-group production_tauxprod">
<span<?php echo $production_grid->tauxprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->tauxprod->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_tauxprod" name="x<?php echo $production_grid->RowIndex ?>_tauxprod" id="x<?php echo $production_grid->RowIndex ?>_tauxprod" value="<?php echo HtmlEncode($production_grid->tauxprod->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_tauxprod" name="o<?php echo $production_grid->RowIndex ?>_tauxprod" id="o<?php echo $production_grid->RowIndex ?>_tauxprod" value="<?php echo HtmlEncode($production_grid->tauxprod->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($production_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal">
<?php if (!$production->isConfirm()) { ?>
<span id="el$rowindex$_production_SubTotal" class="form-group production_SubTotal">
<input type="text" data-table="production" data-field="x_SubTotal" name="x<?php echo $production_grid->RowIndex ?>_SubTotal" id="x<?php echo $production_grid->RowIndex ?>_SubTotal" size="30" maxlength="23" placeholder="<?php echo HtmlEncode($production_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $production_grid->SubTotal->EditValue ?>"<?php echo $production_grid->SubTotal->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_production_SubTotal" class="form-group production_SubTotal">
<span<?php echo $production_grid->SubTotal->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_grid->SubTotal->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_SubTotal" name="x<?php echo $production_grid->RowIndex ?>_SubTotal" id="x<?php echo $production_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($production_grid->SubTotal->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="production" data-field="x_SubTotal" name="o<?php echo $production_grid->RowIndex ?>_SubTotal" id="o<?php echo $production_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($production_grid->SubTotal->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$production_grid->ListOptions->render("body", "right", $production_grid->RowIndex);
?>
<script>
loadjs.ready(["fproductiongrid", "load"], function() {
	fproductiongrid.updateLists(<?php echo $production_grid->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
<?php

// Render aggregate row
$production->RowType = ROWTYPE_AGGREGATE;
$production->resetAttributes();
$production_grid->renderRow();
?>
<?php if ($production_grid->TotalRecords > 0 && $production->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$production_grid->renderListOptions();

// Render list options (footer, left)
$production_grid->ListOptions->render("footer", "left");
?>
	<?php if ($production_grid->idprod->Visible) { // idprod ?>
		<td data-name="idprod" class="<?php echo $production_grid->idprod->footerCellClass() ?>"><span id="elf_production_idprod" class="production_idprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" class="<?php echo $production_grid->idemp->footerCellClass() ?>"><span id="elf_production_idemp" class="production_idemp">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $production_grid->idemp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($production_grid->dept->Visible) { // dept ?>
		<td data-name="dept" class="<?php echo $production_grid->dept->footerCellClass() ?>"><span id="elf_production_dept" class="production_dept">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $production_grid->type->footerCellClass() ?>"><span id="elf_production_type" class="production_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->idop->Visible) { // idop ?>
		<td data-name="idop" class="<?php echo $production_grid->idop->footerCellClass() ?>"><span id="elf_production_idop" class="production_idop">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->lot->Visible) { // lot ?>
		<td data-name="lot" class="<?php echo $production_grid->lot->footerCellClass() ?>"><span id="elf_production_lot" class="production_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->dateprod->Visible) { // dateprod ?>
		<td data-name="dateprod" class="<?php echo $production_grid->dateprod->footerCellClass() ?>"><span id="elf_production_dateprod" class="production_dateprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->qtyprod->Visible) { // qtyprod ?>
		<td data-name="qtyprod" class="<?php echo $production_grid->qtyprod->footerCellClass() ?>"><span id="elf_production_qtyprod" class="production_qtyprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->tauxprod->Visible) { // tauxprod ?>
		<td data-name="tauxprod" class="<?php echo $production_grid->tauxprod->footerCellClass() ?>"><span id="elf_production_tauxprod" class="production_tauxprod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($production_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" class="<?php echo $production_grid->SubTotal->footerCellClass() ?>"><span id="elf_production_SubTotal" class="production_SubTotal">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $production_grid->SubTotal->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$production_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($production->CurrentMode == "add" || $production->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $production_grid->FormKeyCountName ?>" id="<?php echo $production_grid->FormKeyCountName ?>" value="<?php echo $production_grid->KeyCount ?>">
<?php echo $production_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($production->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $production_grid->FormKeyCountName ?>" id="<?php echo $production_grid->FormKeyCountName ?>" value="<?php echo $production_grid->KeyCount ?>">
<?php echo $production_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($production->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fproductiongrid">
</div><!-- /.ew-list-form -->
<?php

// Close recordset
if ($production_grid->Recordset)
	$production_grid->Recordset->Close();
?>
<?php if ($production_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $production_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($production_grid->TotalRecords == 0 && !$production->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $production_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$production_grid->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php
$production_grid->terminate();
?>