<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_edit = new production_edit();

// Run the page
$production_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fproductionedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fproductionedit = currentForm = new ew.Form("fproductionedit", "edit");

	// Validate form
	fproductionedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($production_edit->idprod->Required) { ?>
				elm = this.getElements("x" + infix + "_idprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->idprod->caption(), $production_edit->idprod->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->idemp->caption(), $production_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_edit->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->dept->caption(), $production_edit->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_edit->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->type->caption(), $production_edit->type->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_edit->idop->Required) { ?>
				elm = this.getElements("x" + infix + "_idop");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->idop->caption(), $production_edit->idop->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_edit->lot->Required) { ?>
				elm = this.getElements("x" + infix + "_lot");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->lot->caption(), $production_edit->lot->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_lot");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_edit->lot->errorMessage()) ?>");
			<?php if ($production_edit->dateprod->Required) { ?>
				elm = this.getElements("x" + infix + "_dateprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->dateprod->caption(), $production_edit->dateprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dateprod");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_edit->dateprod->errorMessage()) ?>");
			<?php if ($production_edit->qtyprod->Required) { ?>
				elm = this.getElements("x" + infix + "_qtyprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->qtyprod->caption(), $production_edit->qtyprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_qtyprod");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_edit->qtyprod->errorMessage()) ?>");
			<?php if ($production_edit->tauxprod->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->tauxprod->caption(), $production_edit->tauxprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxprod");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_edit->tauxprod->errorMessage()) ?>");
			<?php if ($production_edit->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_edit->SubTotal->caption(), $production_edit->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_edit->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fproductionedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fproductionedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fproductionedit.lists["x_idemp"] = <?php echo $production_edit->idemp->Lookup->toClientList($production_edit) ?>;
	fproductionedit.lists["x_idemp"].options = <?php echo JsonEncode($production_edit->idemp->lookupOptions()) ?>;
	fproductionedit.lists["x_dept"] = <?php echo $production_edit->dept->Lookup->toClientList($production_edit) ?>;
	fproductionedit.lists["x_dept"].options = <?php echo JsonEncode($production_edit->dept->lookupOptions()) ?>;
	fproductionedit.lists["x_type"] = <?php echo $production_edit->type->Lookup->toClientList($production_edit) ?>;
	fproductionedit.lists["x_type"].options = <?php echo JsonEncode($production_edit->type->lookupOptions()) ?>;
	fproductionedit.lists["x_idop"] = <?php echo $production_edit->idop->Lookup->toClientList($production_edit) ?>;
	fproductionedit.lists["x_idop"].options = <?php echo JsonEncode($production_edit->idop->lookupOptions()) ?>;
	loadjs.done("fproductionedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $production_edit->showPageHeader(); ?>
<?php
$production_edit->showMessage();
?>
<form name="fproductionedit" id="fproductionedit" class="<?php echo $production_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$production_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($production_edit->idprod->Visible) { // idprod ?>
	<div id="r_idprod" class="form-group row">
		<label id="elh_production_idprod" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->idprod->caption() ?><?php echo $production_edit->idprod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->idprod->cellAttributes() ?>>
<span id="el_production_idprod">
<span<?php echo $production_edit->idprod->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($production_edit->idprod->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="production" data-field="x_idprod" name="x_idprod" id="x_idprod" value="<?php echo HtmlEncode($production_edit->idprod->CurrentValue) ?>">
<?php echo $production_edit->idprod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_production_idemp" for="x_idemp" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->idemp->caption() ?><?php echo $production_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->idemp->cellAttributes() ?>>
<span id="el_production_idemp">
<?php $production_edit->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($production_edit->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_edit->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_edit->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_edit->idemp->ReadOnly || $production_edit->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_edit->idemp->Lookup->getParamTag($production_edit, "p_x_idemp") ?>
<input type="hidden" data-table="production" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_edit->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $production_edit->idemp->CurrentValue ?>"<?php echo $production_edit->idemp->editAttributes() ?>>
</span>
<?php echo $production_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->dept->Visible) { // dept ?>
	<div id="r_dept" class="form-group row">
		<label id="elh_production_dept" for="x_dept" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->dept->caption() ?><?php echo $production_edit->dept->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->dept->cellAttributes() ?>>
<span id="el_production_dept">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_dept" data-value-separator="<?php echo $production_edit->dept->displayValueSeparatorAttribute() ?>" id="x_dept" name="x_dept"<?php echo $production_edit->dept->editAttributes() ?>>
			<?php echo $production_edit->dept->selectOptionListHtml("x_dept") ?>
		</select>
</div>
<?php echo $production_edit->dept->Lookup->getParamTag($production_edit, "p_x_dept") ?>
</span>
<?php echo $production_edit->dept->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_production_type" for="x_type" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->type->caption() ?><?php echo $production_edit->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->type->cellAttributes() ?>>
<span id="el_production_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_type" data-value-separator="<?php echo $production_edit->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $production_edit->type->editAttributes() ?>>
			<?php echo $production_edit->type->selectOptionListHtml("x_type") ?>
		</select>
</div>
<?php echo $production_edit->type->Lookup->getParamTag($production_edit, "p_x_type") ?>
</span>
<?php echo $production_edit->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->idop->Visible) { // idop ?>
	<div id="r_idop" class="form-group row">
		<label id="elh_production_idop" for="x_idop" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->idop->caption() ?><?php echo $production_edit->idop->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->idop->cellAttributes() ?>>
<span id="el_production_idop">
<?php $production_edit->idop->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idop"><?php echo EmptyValue(strval($production_edit->idop->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_edit->idop->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_edit->idop->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_edit->idop->ReadOnly || $production_edit->idop->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idop',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_edit->idop->Lookup->getParamTag($production_edit, "p_x_idop") ?>
<input type="hidden" data-table="production" data-field="x_idop" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_edit->idop->displayValueSeparatorAttribute() ?>" name="x_idop" id="x_idop" value="<?php echo $production_edit->idop->CurrentValue ?>"<?php echo $production_edit->idop->editAttributes() ?>>
</span>
<?php echo $production_edit->idop->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->lot->Visible) { // lot ?>
	<div id="r_lot" class="form-group row">
		<label id="elh_production_lot" for="x_lot" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->lot->caption() ?><?php echo $production_edit->lot->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->lot->cellAttributes() ?>>
<span id="el_production_lot">
<input type="text" data-table="production" data-field="x_lot" name="x_lot" id="x_lot" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_edit->lot->getPlaceHolder()) ?>" value="<?php echo $production_edit->lot->EditValue ?>"<?php echo $production_edit->lot->editAttributes() ?>>
</span>
<?php echo $production_edit->lot->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->dateprod->Visible) { // dateprod ?>
	<div id="r_dateprod" class="form-group row">
		<label id="elh_production_dateprod" for="x_dateprod" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->dateprod->caption() ?><?php echo $production_edit->dateprod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->dateprod->cellAttributes() ?>>
<span id="el_production_dateprod">
<input type="text" data-table="production" data-field="x_dateprod" data-format="7" name="x_dateprod" id="x_dateprod" maxlength="10" placeholder="<?php echo HtmlEncode($production_edit->dateprod->getPlaceHolder()) ?>" value="<?php echo $production_edit->dateprod->EditValue ?>"<?php echo $production_edit->dateprod->editAttributes() ?>>
<?php if (!$production_edit->dateprod->ReadOnly && !$production_edit->dateprod->Disabled && !isset($production_edit->dateprod->EditAttrs["readonly"]) && !isset($production_edit->dateprod->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductionedit", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductionedit", "x_dateprod", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $production_edit->dateprod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->qtyprod->Visible) { // qtyprod ?>
	<div id="r_qtyprod" class="form-group row">
		<label id="elh_production_qtyprod" for="x_qtyprod" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->qtyprod->caption() ?><?php echo $production_edit->qtyprod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->qtyprod->cellAttributes() ?>>
<span id="el_production_qtyprod">
<input type="text" data-table="production" data-field="x_qtyprod" name="x_qtyprod" id="x_qtyprod" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_edit->qtyprod->getPlaceHolder()) ?>" value="<?php echo $production_edit->qtyprod->EditValue ?>"<?php echo $production_edit->qtyprod->editAttributes() ?>>
</span>
<?php echo $production_edit->qtyprod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->tauxprod->Visible) { // tauxprod ?>
	<div id="r_tauxprod" class="form-group row">
		<label id="elh_production_tauxprod" for="x_tauxprod" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->tauxprod->caption() ?><?php echo $production_edit->tauxprod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->tauxprod->cellAttributes() ?>>
<span id="el_production_tauxprod">
<input type="text" data-table="production" data-field="x_tauxprod" name="x_tauxprod" id="x_tauxprod" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_edit->tauxprod->getPlaceHolder()) ?>" value="<?php echo $production_edit->tauxprod->EditValue ?>"<?php echo $production_edit->tauxprod->editAttributes() ?>>
</span>
<?php echo $production_edit->tauxprod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_edit->SubTotal->Visible) { // SubTotal ?>
	<div id="r_SubTotal" class="form-group row">
		<label id="elh_production_SubTotal" for="x_SubTotal" class="<?php echo $production_edit->LeftColumnClass ?>"><?php echo $production_edit->SubTotal->caption() ?><?php echo $production_edit->SubTotal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_edit->RightColumnClass ?>"><div <?php echo $production_edit->SubTotal->cellAttributes() ?>>
<span id="el_production_SubTotal">
<input type="text" data-table="production" data-field="x_SubTotal" name="x_SubTotal" id="x_SubTotal" size="30" maxlength="23" placeholder="<?php echo HtmlEncode($production_edit->SubTotal->getPlaceHolder()) ?>" value="<?php echo $production_edit->SubTotal->EditValue ?>"<?php echo $production_edit->SubTotal->editAttributes() ?>>
</span>
<?php echo $production_edit->SubTotal->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$production_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

	$(".ew-edit-div").addClass("row row-cols-2");
});
</script>
<?php include_once "footer.php"; ?>
<?php
$production_edit->terminate();
?>