<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_delete = new production_delete();

// Run the page
$production_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_delete->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fproductiondelete, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "delete";
	fproductiondelete = currentForm = new ew.Form("fproductiondelete", "delete");
	loadjs.done("fproductiondelete");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $production_delete->showPageHeader(); ?>
<?php
$production_delete->showMessage();
?>
<form name="fproductiondelete" id="fproductiondelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($production_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($production_delete->idprod->Visible) { // idprod ?>
		<th class="<?php echo $production_delete->idprod->headerCellClass() ?>"><span id="elh_production_idprod" class="production_idprod"><?php echo $production_delete->idprod->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->idemp->Visible) { // idemp ?>
		<th class="<?php echo $production_delete->idemp->headerCellClass() ?>"><span id="elh_production_idemp" class="production_idemp"><?php echo $production_delete->idemp->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->dept->Visible) { // dept ?>
		<th class="<?php echo $production_delete->dept->headerCellClass() ?>"><span id="elh_production_dept" class="production_dept"><?php echo $production_delete->dept->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->type->Visible) { // type ?>
		<th class="<?php echo $production_delete->type->headerCellClass() ?>"><span id="elh_production_type" class="production_type"><?php echo $production_delete->type->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->idop->Visible) { // idop ?>
		<th class="<?php echo $production_delete->idop->headerCellClass() ?>"><span id="elh_production_idop" class="production_idop"><?php echo $production_delete->idop->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->lot->Visible) { // lot ?>
		<th class="<?php echo $production_delete->lot->headerCellClass() ?>"><span id="elh_production_lot" class="production_lot"><?php echo $production_delete->lot->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->dateprod->Visible) { // dateprod ?>
		<th class="<?php echo $production_delete->dateprod->headerCellClass() ?>"><span id="elh_production_dateprod" class="production_dateprod"><?php echo $production_delete->dateprod->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->qtyprod->Visible) { // qtyprod ?>
		<th class="<?php echo $production_delete->qtyprod->headerCellClass() ?>"><span id="elh_production_qtyprod" class="production_qtyprod"><?php echo $production_delete->qtyprod->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->tauxprod->Visible) { // tauxprod ?>
		<th class="<?php echo $production_delete->tauxprod->headerCellClass() ?>"><span id="elh_production_tauxprod" class="production_tauxprod"><?php echo $production_delete->tauxprod->caption() ?></span></th>
<?php } ?>
<?php if ($production_delete->SubTotal->Visible) { // SubTotal ?>
		<th class="<?php echo $production_delete->SubTotal->headerCellClass() ?>"><span id="elh_production_SubTotal" class="production_SubTotal"><?php echo $production_delete->SubTotal->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$production_delete->RecordCount = 0;
$i = 0;
while (!$production_delete->Recordset->EOF) {
	$production_delete->RecordCount++;
	$production_delete->RowCount++;

	// Set row properties
	$production->resetAttributes();
	$production->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$production_delete->loadRowValues($production_delete->Recordset);

	// Render row
	$production_delete->renderRow();
?>
	<tr <?php echo $production->rowAttributes() ?>>
<?php if ($production_delete->idprod->Visible) { // idprod ?>
		<td <?php echo $production_delete->idprod->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_idprod" class="production_idprod">
<span<?php echo $production_delete->idprod->viewAttributes() ?>><?php echo $production_delete->idprod->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->idemp->Visible) { // idemp ?>
		<td <?php echo $production_delete->idemp->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_idemp" class="production_idemp">
<span<?php echo $production_delete->idemp->viewAttributes() ?>><?php echo $production_delete->idemp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->dept->Visible) { // dept ?>
		<td <?php echo $production_delete->dept->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_dept" class="production_dept">
<span<?php echo $production_delete->dept->viewAttributes() ?>><?php echo $production_delete->dept->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->type->Visible) { // type ?>
		<td <?php echo $production_delete->type->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_type" class="production_type">
<span<?php echo $production_delete->type->viewAttributes() ?>><?php echo $production_delete->type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->idop->Visible) { // idop ?>
		<td <?php echo $production_delete->idop->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_idop" class="production_idop">
<span<?php echo $production_delete->idop->viewAttributes() ?>><?php echo $production_delete->idop->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->lot->Visible) { // lot ?>
		<td <?php echo $production_delete->lot->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_lot" class="production_lot">
<span<?php echo $production_delete->lot->viewAttributes() ?>><?php echo $production_delete->lot->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->dateprod->Visible) { // dateprod ?>
		<td <?php echo $production_delete->dateprod->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_dateprod" class="production_dateprod">
<span<?php echo $production_delete->dateprod->viewAttributes() ?>><?php echo $production_delete->dateprod->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->qtyprod->Visible) { // qtyprod ?>
		<td <?php echo $production_delete->qtyprod->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_qtyprod" class="production_qtyprod">
<span<?php echo $production_delete->qtyprod->viewAttributes() ?>><?php echo $production_delete->qtyprod->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->tauxprod->Visible) { // tauxprod ?>
		<td <?php echo $production_delete->tauxprod->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_tauxprod" class="production_tauxprod">
<span<?php echo $production_delete->tauxprod->viewAttributes() ?>><?php echo $production_delete->tauxprod->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($production_delete->SubTotal->Visible) { // SubTotal ?>
		<td <?php echo $production_delete->SubTotal->cellAttributes() ?>>
<span id="el<?php echo $production_delete->RowCount ?>_production_SubTotal" class="production_SubTotal">
<span<?php echo $production_delete->SubTotal->viewAttributes() ?>><?php echo $production_delete->SubTotal->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$production_delete->Recordset->moveNext();
}
$production_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$production_delete->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$production_delete->terminate();
?>